/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube.configpanel;

import java.awt.Component;
import java.util.EventListener;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.swing.exttable.ExtTableHeaderRenderer;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.swing.exttable.columns.ExtCheckColumn;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.appwork.utils.CounterMap;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.NewTheme;
import org.jdownloader.plugins.components.youtube.VariantIDStorable;
import org.jdownloader.plugins.components.youtube.configpanel.YoutubeVariantCollection;
import org.jdownloader.settings.staticreferences.CFG_YOUTUBE;

public class CollectionsTableModel
extends ExtTableModel<YoutubeVariantCollection>
implements GenericConfigEventListener<Object> {
    private CounterMap<String> enabledMap;

    public CollectionsTableModel() {
        super("YoutubeLinkTableModel");
        CFG_YOUTUBE.COLLECTIONS.getEventSender().addListener((EventListener)((Object)this), true);
    }

    protected void initColumns() {
        this.addColumn((ExtColumn)new EnabledColumn(_GUI.T.lit_enabled()){

            @Override
            protected void setBooleanValue(boolean value, YoutubeVariantCollection object) {
                super.setBooleanValue(value, object);
                CollectionsTableModel.this.save();
            }
        });
        this.addColumn((ExtColumn)new AutoResizingTextColumn(_GUI.T.lit_name()){

            @Override
            public boolean isAutoWidthEnabled() {
                return false;
            }

            public boolean isEditable(YoutubeVariantCollection obj) {
                return true;
            }

            @Override
            public boolean isEnabled(YoutubeVariantCollection obj) {
                return CollectionsTableModel.this.getEnabledCount(obj) > 0 && obj.isEnabled();
            }

            protected void setStringValue(String value, YoutubeVariantCollection object) {
                object.setName(value);
                CollectionsTableModel.this.save();
            }

            public String getStringValue(YoutubeVariantCollection value) {
                return value.getName();
            }
        });
        this.addColumn((ExtColumn)new AutoResizingTextColumn(_GUI.T.youtube_collection_size()){

            @Override
            public boolean isAutoWidthEnabled() {
                return true;
            }

            @Override
            public boolean isEnabled(YoutubeVariantCollection obj) {
                return CollectionsTableModel.this.getEnabledCount(obj) > 0 && obj.isEnabled();
            }

            public String getStringValue(YoutubeVariantCollection value) {
                int i = CollectionsTableModel.this.getEnabledCount(value);
                if (value.getVariants() == null) {
                    return i + "";
                }
                return i + "/" + value.getVariants().size();
            }
        });
    }

    public void load() {
        this.onConfigValueModified(null, null);
    }

    protected void save() {
        CFG_YOUTUBE.CFG.setCollections(this.getTableData());
    }

    public void onConfigValidatorError(KeyHandler<Object> keyHandler, Object invalidValue, ValidationException validateException) {
    }

    public void onConfigValueModified(KeyHandler<Object> keyHandler, Object newValue) {
        new EDTRunner(){

            protected void runInEDT() {
                CollectionsTableModel.this._fireTableStructureChanged(YoutubeVariantCollection.load(), true);
            }
        };
    }

    public void onEnabledMapUpdate(CounterMap<String> enabledMap) {
        this.enabledMap = enabledMap;
        this.getTable().repaint();
    }

    protected int getEnabledCount(YoutubeVariantCollection value) {
        int i = 0;
        if (this.enabledMap == null) {
            return 0;
        }
        if (value.getGroupingID() != null) {
            return this.enabledMap.getInt((Object)value.getGroupingID());
        }
        if (value.getVariants() != null) {
            for (VariantIDStorable v : value.getVariants()) {
                int vi = this.enabledMap.getInt((Object)v.createUniqueID());
                i += vi;
            }
        }
        return i;
    }

    private class EnabledColumn
    extends ExtCheckColumn<YoutubeVariantCollection> {
        private EnabledColumn(String string) {
            super(string);
            this.setRowSorter((ExtDefaultRowSorter)new ExtDefaultRowSorter<YoutubeVariantCollection>(){

                public int compare(YoutubeVariantCollection o1, YoutubeVariantCollection o2) {
                    boolean b2;
                    boolean b1 = EnabledColumn.this.getBooleanValue(o1);
                    int ret = b1 == (b2 = EnabledColumn.this.getBooleanValue(o2)) ? 0 : (this.getSortOrderIdentifier() == "ASC" ? (b1 && !b2 ? -1 : 1) : (!b1 && b2 ? -1 : 1));
                    return ret;
                }
            });
        }

        public ExtTableHeaderRenderer getHeaderRenderer(JTableHeader jTableHeader) {
            ExtTableHeaderRenderer ret = new ExtTableHeaderRenderer((ExtColumn)this, jTableHeader){
                private final Icon ok;
                private static final long serialVersionUID = 3224931991570756349L;
                {
                    this.ok = NewTheme.I().getIcon("ok", 14);
                }

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    this.setIcon(this.ok);
                    this.setHorizontalAlignment(0);
                    this.setText(null);
                    return this;
                }
            };
            return ret;
        }

        public int getMaxWidth() {
            return 30;
        }

        public boolean isEditable(YoutubeVariantCollection obj) {
            return true;
        }

        protected boolean getBooleanValue(YoutubeVariantCollection value) {
            return value.isEnabled();
        }

        protected void setBooleanValue(boolean value, YoutubeVariantCollection object) {
            object.setEnabled(value);
        }
    }

    private abstract class AutoResizingIntColumn
    extends ExtTextColumn<YoutubeVariantCollection> {
        private AutoResizingIntColumn(String name) {
            super(name);
            this.rendererField.setHorizontalAlignment(4);
            this.setRowSorter((ExtDefaultRowSorter)new ExtDefaultRowSorter<YoutubeVariantCollection>(){

                public int compare(YoutubeVariantCollection o1, YoutubeVariantCollection o2) {
                    int _1 = AutoResizingIntColumn.this.getInt(o1);
                    int _2 = AutoResizingIntColumn.this.getInt(o2);
                    int ret = this.getSortOrderIdentifier() == "ASC" ? (_1 == _2 ? 0 : (_1 < _2 ? -1 : 1)) : (_1 == _2 ? 0 : (_1 > _2 ? -1 : 1));
                    return ret;
                }
            });
        }

        public boolean isEnabled(YoutubeVariantCollection obj) {
            return obj.isEnabled();
        }

        public abstract int getInt(YoutubeVariantCollection var1);

        public String getStringValue(YoutubeVariantCollection value) {
            int i = this.getInt(value);
            if (i <= 0) {
                return "";
            }
            return i + "";
        }

        protected String getTooltipText(YoutubeVariantCollection obj) {
            return null;
        }

        public boolean isAutoWidthEnabled() {
            return true;
        }

        protected boolean isDefaultResizable() {
            return true;
        }

        public boolean isResizable() {
            return true;
        }

        public int getDefaultWidth() {
            return this.calculateMinimumHeaderWidth();
        }

        public int getMinWidth() {
            return this.calculateMinimumHeaderWidth();
        }

        protected int adjustWidth(int w) {
            return Math.max(w, this.calculateMinimumHeaderWidth());
        }
    }

    private abstract class AutoResizingTextColumn
    extends ExtTextColumn<YoutubeVariantCollection> {
        private AutoResizingTextColumn(String name) {
            super(name);
            this.setRowSorter((ExtDefaultRowSorter)new ExtDefaultRowSorter<YoutubeVariantCollection>(){

                public int compare(YoutubeVariantCollection o1, YoutubeVariantCollection o2) {
                    String o1s = AutoResizingTextColumn.this.getStringValue(o1);
                    String o2s = AutoResizingTextColumn.this.getStringValue(o2);
                    if (o1s == null) {
                        o1s = "";
                    }
                    if (o2s == null) {
                        o2s = "";
                    }
                    if (this.getSortOrderIdentifier() == "ASC") {
                        int ret = o1s.compareToIgnoreCase(o2s);
                        return ret;
                    }
                    int ret = o2s.compareToIgnoreCase(o1s);
                    return ret;
                }
            });
        }

        public boolean isEnabled(YoutubeVariantCollection obj) {
            return obj.isEnabled();
        }

        protected boolean isDefaultResizable() {
            return true;
        }

        protected String getTooltipText(YoutubeVariantCollection obj) {
            return null;
        }

        public boolean isResizable() {
            return true;
        }

        public boolean isAutoWidthEnabled() {
            return true;
        }

        public int getDefaultWidth() {
            return this.calculateMinimumHeaderWidth();
        }

        public int getMinWidth() {
            return this.calculateMinimumHeaderWidth();
        }

        protected int adjustWidth(int w) {
            return Math.max(w, this.calculateMinimumHeaderWidth());
        }
    }
}

