/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube.configpanel;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import jd.gui.swing.jdgui.AlternateHighlighter;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtComponentRowHighlighter;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.swing.exttable.ExtTableHeaderRenderer;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.swing.exttable.columns.ExtCheckColumn;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.CounterMap;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.controlling.ffmpeg.AbstractFFmpegBinary;
import org.jdownloader.controlling.ffmpeg.FFmpeg;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.NewTheme;
import org.jdownloader.logging.LogController;
import org.jdownloader.plugins.components.youtube.VariantIDStorable;
import org.jdownloader.plugins.components.youtube.configpanel.AbstractVariantWrapper;
import org.jdownloader.plugins.components.youtube.configpanel.VariantsMapTable;
import org.jdownloader.plugins.components.youtube.itag.AudioBitrate;
import org.jdownloader.plugins.components.youtube.itag.AudioType;
import org.jdownloader.plugins.components.youtube.itag.VideoResolution;
import org.jdownloader.plugins.components.youtube.itag.YoutubeITAG;
import org.jdownloader.plugins.components.youtube.variants.AudioInterface;
import org.jdownloader.plugins.components.youtube.variants.ImageVariant;
import org.jdownloader.plugins.components.youtube.variants.SubtitleVariant;
import org.jdownloader.plugins.components.youtube.variants.VariantBase;
import org.jdownloader.plugins.components.youtube.variants.VideoInterface;
import org.jdownloader.plugins.components.youtube.variants.VideoVariant;
import org.jdownloader.plugins.components.youtube.variants.YoutubeSubtitleStorable;
import org.jdownloader.plugins.components.youtube.variants.generics.GenericVideoInfo;
import org.jdownloader.settings.staticreferences.CFG_YOUTUBE;
import org.jdownloader.translate._JDT;
import org.jdownloader.updatev2.gui.LAFOptions;

public class VariantsMapTableModel
extends ExtTableModel<AbstractVariantWrapper>
implements GenericConfigEventListener<Object> {
    protected ArrayList<AbstractVariantWrapper> all;
    private ExtTextColumn<AbstractVariantWrapper> mergeIDColumn;
    private HashMap<AbstractVariantWrapper, Integer> alternateMergeIDMap;
    private AutoResizingTextColumn videoCodecColumn;
    private AutoResizingIntColumn fpsColumn;
    private AutoResizingIntColumn heightColumn;
    private AutoResizingIntColumn widthColumn;
    protected boolean hasImage;
    protected boolean hasVideo;
    protected boolean hasSubtitle;
    protected AutoResizingTextColumn typeColumn;
    protected boolean hasAudio;
    protected AutoResizingTextColumn projectionColumn;
    protected AutoResizingTextColumn audioCodecColumn;
    protected AutoResizingIntColumn audioBitrateColumn;
    protected boolean hasAudioSpatial;
    protected boolean hasDescription;
    private final Set<AbstractFFmpegBinary.FLAG> supportedFlags;

    protected static int globalCompare(int ret, AbstractVariantWrapper o1, AbstractVariantWrapper o2, boolean b) {
        if (ret != 0) {
            return ret;
        }
        if (!b) {
            AbstractVariantWrapper tmp = o1;
            o1 = o2;
            o2 = tmp;
        }
        if ((ret = o1.variant.getGroup().compareTo(o2.variant.getGroup())) != 0) {
            return ret;
        }
        ret = CompareUtils.compareComparable((Comparable)((Object)o1.getProjection()), (Comparable)((Object)o2.getProjection()));
        if (ret != 0) {
            return ret;
        }
        ret = o1.variant.getContainer().compareTo(o2.variant.getContainer());
        if (ret != 0) {
            return ret;
        }
        ret = CompareUtils.compareInt((int)o1.getHeight(), (int)o2.getHeight());
        if (ret != 0) {
            return ret;
        }
        ret = CompareUtils.compareInt((int)o1.getWidth(), (int)o2.getWidth());
        if (ret != 0) {
            return ret;
        }
        ret = CompareUtils.compareInt((int)o1.getFramerate(), (int)o2.getFramerate());
        if (ret != 0) {
            return ret;
        }
        ret = o1.getVideoCodec().compareToIgnoreCase(o2.getVideoCodec());
        if (ret != 0) {
            return ret;
        }
        ret = o1.getAudioCodec().compareToIgnoreCase(o2.getAudioCodec());
        if (ret != 0) {
            return ret;
        }
        ret = CompareUtils.compareInt((int)o1.getAudioBitrate(), (int)o2.getAudioBitrate());
        if (ret != 0) {
            return ret;
        }
        return ret;
    }

    public VariantsMapTableModel(ArrayList<AbstractVariantWrapper> sorted) {
        this("VariantsMapTableModel", sorted);
    }

    public VariantsMapTableModel(String id, ArrayList<AbstractVariantWrapper> sorted) {
        super(id);
        this.all = sorted;
        this.initListeners();
        LogSource logger = LogController.CL(true);
        FFmpeg ffmpeg = new FFmpeg(null, (LogInterface)logger){
            final /* synthetic */ LogInterface val$logger;
            {
                this.val$logger = logInterface;
                super(br);
            }

            @Override
            public LogInterface getLogger() {
                return this.val$logger;
            }
        };
        this.supportedFlags = ffmpeg.isAvailable() && ffmpeg.isCompatible() ? ffmpeg.getSupportedFlags() : null;
        this.initHighLighter();
    }

    protected void initHighLighter() {
        final AlternateHighlighter alternate = new AlternateHighlighter(LAFOptions.getInstance().getColorForTableAlternateRowForeground(), LAFOptions.getInstance().getColorForTableAlternateRowBackground(), null);
        this.addExtComponentRowHighlighter((ExtComponentRowHighlighter)new ExtComponentRowHighlighter<AbstractVariantWrapper>(null, Color.BLACK, null){

            protected Color getBackground(Color current) {
                return LAFOptions.getInstance().getColorForTablePackageRowBackground();
            }

            public boolean accept(ExtColumn<AbstractVariantWrapper> column, AbstractVariantWrapper value, boolean selected, boolean focus, int row) {
                if (VariantsMapTableModel.this.alternateMergeIDMap == null || VariantsMapTableModel.this.alternateMergeIDMap.get(value) == null) {
                    return alternate.accept(column, (Object)value, selected, focus, row);
                }
                return (Integer)VariantsMapTableModel.this.alternateMergeIDMap.get(value) % 2 == 0;
            }
        });
        if (this.supportedFlags != null) {
            this.addExtComponentRowHighlighter((ExtComponentRowHighlighter)new ExtComponentRowHighlighter<AbstractVariantWrapper>(Color.RED, null, null){
                final boolean isOpusSupported;
                final boolean isVorbisSupported;
                final boolean isAV1Supported;
                {
                    this.isOpusSupported = VariantsMapTableModel.this.supportedFlags.contains((Object)AbstractFFmpegBinary.FLAG.OPUS);
                    this.isVorbisSupported = VariantsMapTableModel.this.supportedFlags.contains((Object)AbstractFFmpegBinary.FLAG.VORBIS);
                    this.isAV1Supported = VariantsMapTableModel.this.supportedFlags.contains((Object)AbstractFFmpegBinary.FLAG.AV1);
                }

                protected Color getBackground(Color current) {
                    return LAFOptions.getInstance().getColorForTablePackageRowBackground();
                }

                public boolean accept(ExtColumn<AbstractVariantWrapper> column, AbstractVariantWrapper value, boolean selected, boolean focus, int row) {
                    if (StringUtils.endsWithCaseInsensitive((String)"AV1", (String)value.getVideoCodec())) {
                        return !this.isAV1Supported;
                    }
                    if (StringUtils.equalsIgnoreCase((String)"Opus", (String)value.getAudioCodec())) {
                        return !this.isOpusSupported;
                    }
                    if (StringUtils.equalsIgnoreCase((String)"Vorbis", (String)value.getAudioCodec())) {
                        return !this.isVorbisSupported;
                    }
                    return false;
                }
            });
        }
    }

    protected void initListeners() {
        CFG_YOUTUBE.BLACKLISTED_AUDIO_BITRATES.getEventSender().addListener((EventListener)((Object)this), true);
        CFG_YOUTUBE.BLACKLISTED_AUDIO_CODECS.getEventSender().addListener((EventListener)((Object)this), true);
        CFG_YOUTUBE.BLACKLISTED_FILE_CONTAINERS.getEventSender().addListener((EventListener)((Object)this), true);
        CFG_YOUTUBE.BLACKLISTED_GROUPS.getEventSender().addListener((EventListener)((Object)this), true);
        CFG_YOUTUBE.BLACKLISTED_PROJECTIONS.getEventSender().addListener((EventListener)((Object)this), true);
        CFG_YOUTUBE.BLACKLISTED_RESOLUTIONS.getEventSender().addListener((EventListener)((Object)this), true);
        CFG_YOUTUBE.BLACKLISTED_VIDEO_CODECS.getEventSender().addListener((EventListener)((Object)this), true);
        CFG_YOUTUBE.BLACKLISTED_VIDEO_FRAMERATES.getEventSender().addListener((EventListener)((Object)this), true);
        CFG_YOUTUBE.DISABLED_VARIANTS.getEventSender().addListener((EventListener)((Object)this), true);
        this.onConfigValueModified(null, null);
    }

    protected void initColumns() {
        this.addCheckBoxColumn();
        this.addTypeColumn();
        this.addLanguageColumn();
        this.addFileTypeColumn();
        this.projectionColumn = new AutoResizingTextColumn(_GUI.T.YOUTUBE_CONFIG_PANEL_TABLE_PROJECTION()){

            public String getStringValue(AbstractVariantWrapper value) {
                String audioProjection = "";
                if (value.variant instanceof AudioInterface) {
                    switch (((AudioInterface)((Object)value.variant)).getAudioCodec()) {
                        case AAC_SPATIAL: 
                        case VORBIS_SPATIAL: 
                        case OPUS_SPATIAL: {
                            audioProjection = _JDT.T.youtube_spatial();
                        }
                    }
                }
                if (value.variant instanceof VideoVariant) {
                    switch (((GenericVideoInfo)((VideoVariant)value.variant).getGenericInfo()).getProjection()) {
                        case NORMAL: {
                            return audioProjection;
                        }
                    }
                    if (StringUtils.isNotEmpty((String)audioProjection)) {
                        return ((GenericVideoInfo)((VideoVariant)value.variant).getGenericInfo()).getProjection().getLabel() + " " + audioProjection;
                    }
                    return ((GenericVideoInfo)((VideoVariant)value.variant).getGenericInfo()).getProjection().getLabel();
                }
                return audioProjection;
            }
        };
        this.addColumn((ExtColumn)this.projectionColumn);
        this.addWidthColumn();
        this.addHeightColumn();
        this.addFPSColumn();
        this.addVideoCodecColumn();
        this.audioCodecColumn = new AutoResizingTextColumn(_GUI.T.YOUTUBE_CONFIG_PANEL_TABLE_AUDIO_CODEC()){

            public String getStringValue(AbstractVariantWrapper value) {
                if (value.variant instanceof AudioInterface) {
                    return ((AudioInterface)((Object)value.variant)).getAudioCodec().getLabel();
                }
                return "";
            }

            @Override
            protected String getTooltipText(AbstractVariantWrapper value) {
                if (value.variant instanceof AudioInterface) {
                    AudioInterface variant = (AudioInterface)((Object)value.variant);
                    return this.getStringValue(value) + "(" + variant.getAudioITAG().getITAG() + ")";
                }
                return "";
            }
        };
        this.addColumn((ExtColumn)this.audioCodecColumn);
        this.audioBitrateColumn = new AutoResizingIntColumn(_GUI.T.YOUTUBE_CONFIG_PANEL_TABLE_AUDIO_BITRATE()){

            @Override
            public String getStringValue(AbstractVariantWrapper value) {
                String v = super.getStringValue(value);
                if (StringUtils.isEmpty((String)v)) {
                    return "";
                }
                return v + " kbit/s";
            }

            @Override
            protected String getTooltipText(AbstractVariantWrapper value) {
                if (value.variant instanceof AudioInterface) {
                    AudioInterface variant = (AudioInterface)((Object)value.variant);
                    return this.getStringValue(value) + "(" + variant.getAudioITAG().getITAG() + ")";
                }
                return "";
            }

            @Override
            public int getInt(AbstractVariantWrapper value) {
                if (value.variant instanceof AudioInterface) {
                    AudioInterface variant = (AudioInterface)((Object)value.variant);
                    AudioBitrate bitRate = variant.getAudioBitrate();
                    return bitRate.getKbit();
                }
                return -1;
            }
        };
        this.addColumn((ExtColumn)this.audioBitrateColumn);
        this.addGroupingColumn();
        this.addContainerColumn();
    }

    protected void addContainerColumn() {
        this.addColumn((ExtColumn)new AutoResizingTextColumn(_GUI.T.YOUTUBE_CONFIG_PANEL_TABLE_CONTAINER()){

            public boolean isDefaultVisible() {
                return false;
            }

            public String getStringValue(AbstractVariantWrapper value) {
                String container;
                YoutubeITAG itag;
                ArrayList<String> rawContainer = new ArrayList<String>();
                if (value.variant instanceof VideoInterface) {
                    itag = value.variant.getiTagVideo();
                    rawContainer.add(itag.getRawContainer().name() + "(" + itag.getITAG() + ")");
                }
                if (value.variant instanceof AudioInterface && !rawContainer.contains(container = (itag = value.variant.getiTagAudioOrVideoItagEquivalent()).getRawContainer().name() + "(" + itag.getITAG() + ")")) {
                    rawContainer.add(container);
                }
                if (value.variant.getBaseVariant().getiTagData() != null && !rawContainer.contains(container = (itag = value.variant.getBaseVariant().getiTagData()).getRawContainer().name() + "(" + itag.getITAG() + ")")) {
                    rawContainer.add(container);
                }
                return ((Object)rawContainer).toString();
            }
        });
    }

    protected void addGroupingColumn() {
        this.mergeIDColumn = new AutoResizingTextColumn(_GUI.T.YOUTUBE_CONFIG_PANEL_TABLE_GROUPING()){
            {
                this.rendererField.setHorizontalAlignment(2);
            }

            @Override
            protected String getTooltipText(AbstractVariantWrapper obj) {
                return obj.variant.createAdvancedName();
            }

            public boolean isDefaultVisible() {
                return false;
            }

            public String getStringValue(AbstractVariantWrapper value) {
                return value.variant._getName(null);
            }
        };
        this.addColumn((ExtColumn)this.mergeIDColumn);
    }

    protected void addVideoCodecColumn() {
        this.videoCodecColumn = new AutoResizingTextColumn(_GUI.T.YOUTUBE_CONFIG_PANEL_TABLE_VIDEO_CODEC()){

            public String getStringValue(AbstractVariantWrapper value) {
                if (value.variant instanceof VideoVariant) {
                    return ((VideoVariant)value.variant).getVideoCodec().getLabel();
                }
                return "";
            }

            @Override
            protected String getTooltipText(AbstractVariantWrapper value) {
                if (value.variant instanceof VideoInterface) {
                    VideoInterface variant = (VideoInterface)((Object)value.variant);
                    return this.getStringValue(value) + "(" + variant.getVideoITAG().getITAG() + ")";
                }
                return "";
            }
        };
        this.addColumn((ExtColumn)this.videoCodecColumn);
    }

    protected void addFPSColumn() {
        this.fpsColumn = new AutoResizingIntColumn(_GUI.T.YOUTUBE_CONFIG_PANEL_TABLE_FPS()){

            @Override
            public int getInt(AbstractVariantWrapper value) {
                if (value.variant instanceof VideoVariant) {
                    return ((VideoVariant)value.variant).getVideoFrameRate();
                }
                return -1;
            }

            @Override
            protected String getTooltipText(AbstractVariantWrapper value) {
                if (value.variant instanceof VideoInterface) {
                    VideoInterface variant = (VideoInterface)((Object)value.variant);
                    return this.getStringValue(value) + "(" + variant.getVideoITAG().getITAG() + ")";
                }
                return "";
            }
        };
        this.addColumn((ExtColumn)this.fpsColumn);
    }

    protected void addHeightColumn() {
        this.heightColumn = new AutoResizingIntColumn(_GUI.T.YOUTUBE_CONFIG_PANEL_TABLE_HEIGHT()){

            @Override
            public String getStringValue(AbstractVariantWrapper value) {
                if (value.variant instanceof ImageVariant && value.variant.getBaseVariant() == VariantBase.IMAGE_MAX) {
                    return "~" + ((ImageVariant)value.variant).getHeight();
                }
                return super.getStringValue(value);
            }

            @Override
            public int getInt(AbstractVariantWrapper value) {
                return value.getHeight();
            }
        };
        this.addColumn((ExtColumn)this.heightColumn);
    }

    protected void addWidthColumn() {
        this.widthColumn = new AutoResizingIntColumn(_GUI.T.YOUTUBE_CONFIG_PANEL_TABLE_WIDTH()){

            public boolean isDefaultVisible() {
                return false;
            }

            @Override
            public String getStringValue(AbstractVariantWrapper value) {
                if (value.variant instanceof ImageVariant && value.variant.getBaseVariant() == VariantBase.IMAGE_MAX) {
                    return ">480";
                }
                return super.getStringValue(value);
            }

            @Override
            public int getInt(AbstractVariantWrapper value) {
                return value.getWidth();
            }
        };
        this.addColumn((ExtColumn)this.widthColumn);
    }

    protected void addFileTypeColumn() {
        this.addColumn((ExtColumn)new AutoResizingTextColumn(_GUI.T.YOUTUBE_CONFIG_PANEL_TABLE_FILETYPE()){

            public String getStringValue(AbstractVariantWrapper value) {
                return value.variant.getContainer().getLabel();
            }
        });
    }

    protected void addLanguageColumn() {
        this.addColumn((ExtColumn)new AutoResizingTextColumn(_GUI.T.YOUTUBE_CONFIG_PANEL_TABLE_LANGUAGE()){

            public String getStringValue(AbstractVariantWrapper value) {
                Locale locale = value.getLanguageLocale();
                if (locale == null) {
                    return "";
                }
                String displayName = locale.getDisplayName();
                AudioType audioType = value.getAudioType();
                if (audioType == null) {
                    return displayName;
                }
                return displayName + " (" + audioType.getLabel() + ")";
            }
        });
    }

    protected void addTypeColumn() {
        this.typeColumn = new AutoResizingTextColumn(_GUI.T.YOUTUBE_CONFIG_PANEL_TABLE_TYPE()){

            @Override
            public boolean isAutoWidthEnabled() {
                return true;
            }

            @Override
            protected String getTooltipText(AbstractVariantWrapper obj) {
                return obj.variant.createAdvancedName();
            }

            public String getStringValue(AbstractVariantWrapper value) {
                switch (value.variant.getGroup()) {
                    case DESCRIPTION: {
                        return _GUI.T.lit_desciption();
                    }
                    case IMAGE: 
                    case IMAGE_PLAYLIST_COVER: {
                        return _GUI.T.YOUTUBE_CONFIG_PANEL_TABLE_IMAGES(value.variant.getFileNameQualityTag());
                    }
                    case SUBTITLES: {
                        if (((YoutubeSubtitleStorable)((SubtitleVariant)value.variant).getGenericInfo())._getLocale() == null) break;
                        return value.variant._getName(null);
                    }
                }
                AudioType audioType = value.getAudioType();
                if (audioType == null) {
                    return value.variant.getGroup().getLabel();
                }
                return value.variant.getGroup().getLabel() + " (" + audioType.getLabel() + ")";
            }
        };
        this.addColumn((ExtColumn)this.typeColumn);
    }

    protected void addCheckBoxColumn() {
        this.addColumn((ExtColumn)new EnabledColumn(_GUI.T.lit_enabled()){

            @Override
            protected void setBooleanValue(boolean value, AbstractVariantWrapper object) {
                super.setBooleanValue(value, object);
                VariantsMapTableModel.this.updateEnabledMap();
            }
        });
    }

    public ExtTextColumn<AbstractVariantWrapper> getMergeIDColumn() {
        return this.mergeIDColumn;
    }

    public void onConfigValidatorError(KeyHandler<Object> keyHandler, Object invalidValue, ValidationException validateException) {
    }

    public void _fireTableStructureChanged(List<AbstractVariantWrapper> newtableData, boolean refreshSort) {
        if (this.getTable() == null) {
            super._fireTableStructureChanged(newtableData, refreshSort);
            return;
        }
        this.filter(newtableData);
        HashMap<AbstractVariantWrapper, Integer> map = new HashMap<AbstractVariantWrapper, Integer>();
        int i = 0;
        AbstractVariantWrapper last = null;
        ExtColumn sc = this.getSortColumn();
        if (sc != null && sc instanceof ExtTextColumn) {
            ExtTextColumn txtCol = (ExtTextColumn)sc;
            Collections.sort(newtableData, txtCol.getRowSorter());
            for (AbstractVariantWrapper e : newtableData) {
                if (last == null || !StringUtils.equals((String)txtCol.getStringValue(last), (String)txtCol.getStringValue((Object)e))) {
                    ++i;
                    last = e;
                }
                map.put(e, i);
            }
        }
        this.onStructureChanged(newtableData);
        this.alternateMergeIDMap = map;
        super._fireTableStructureChanged(newtableData, refreshSort);
        this.updateEnabledMap();
    }

    protected void onStructureChanged(List<AbstractVariantWrapper> newtableData) {
        this.hasDescription = false;
        this.hasImage = false;
        this.hasVideo = false;
        this.hasAudio = false;
        this.hasAudioSpatial = false;
        this.hasSubtitle = false;
        for (AbstractVariantWrapper e : newtableData) {
            switch (e.variant.getGroup()) {
                case AUDIO: {
                    this.hasAudio = true;
                    break;
                }
                case DESCRIPTION: {
                    this.hasDescription = true;
                    break;
                }
                case IMAGE: 
                case IMAGE_PLAYLIST_COVER: {
                    this.hasImage = true;
                    break;
                }
                case SUBTITLES: {
                    this.hasSubtitle = true;
                    break;
                }
                case VIDEO: {
                    this.hasVideo = true;
                }
            }
            if (!(e.variant instanceof AudioInterface)) continue;
            this.hasAudio = true;
            switch (((AudioInterface)((Object)e.variant)).getAudioCodec()) {
                case AAC_SPATIAL: 
                case VORBIS_SPATIAL: 
                case OPUS_SPATIAL: {
                    this.hasAudioSpatial = true;
                }
            }
        }
        if (this.heightColumn != null) {
            this.setColumnVisible((ExtColumn)this.heightColumn, this.hasVideo || this.hasImage);
        }
        if (this.widthColumn != null) {
            this.setColumnVisible((ExtColumn)this.widthColumn, this.hasVideo || this.hasImage);
        }
        if (this.fpsColumn != null) {
            this.setColumnVisible((ExtColumn)this.fpsColumn, this.hasVideo);
        }
        if (this.videoCodecColumn != null) {
            this.setColumnVisible((ExtColumn)this.videoCodecColumn, this.hasVideo);
        }
        if (this.projectionColumn != null) {
            this.setColumnVisible((ExtColumn)this.projectionColumn, this.hasVideo || this.hasAudioSpatial);
        }
        if (this.audioBitrateColumn != null) {
            this.setColumnVisible((ExtColumn)this.audioBitrateColumn, this.hasAudio);
        }
        if (this.audioCodecColumn != null) {
            this.setColumnVisible((ExtColumn)this.audioCodecColumn, this.hasAudio);
        }
    }

    protected void filter(List<AbstractVariantWrapper> newtableData) {
        HashSet<Object> blacklisted = new HashSet<Object>();
        for (Object o : this.list(CFG_YOUTUBE.CFG.getBlacklistedAudioBitrates())) {
            if (o == null) continue;
            blacklisted.add(o);
        }
        for (Object o : this.list(CFG_YOUTUBE.CFG.getBlacklistedAudioCodecs())) {
            if (o == null) continue;
            blacklisted.add(o);
        }
        for (Object o : this.list(CFG_YOUTUBE.CFG.getBlacklistedFileContainers())) {
            if (o == null) continue;
            blacklisted.add(o);
        }
        for (Object o : this.list(CFG_YOUTUBE.CFG.getBlacklistedGroups())) {
            if (o == null) continue;
            blacklisted.add(o);
        }
        for (Object o : this.list(CFG_YOUTUBE.CFG.getBlacklistedProjections())) {
            if (o == null) continue;
            blacklisted.add(o);
        }
        for (Object o : this.list(CFG_YOUTUBE.CFG.getBlacklistedResolutions())) {
            if (o == null) continue;
            blacklisted.add(o);
        }
        for (Object o : this.list(CFG_YOUTUBE.CFG.getBlacklistedVideoCodecs())) {
            if (o == null) continue;
            blacklisted.add(o);
        }
        for (Object o : this.list(CFG_YOUTUBE.CFG.getBlacklistedVideoFramerates())) {
            if (o == null) continue;
            blacklisted.add(o);
        }
        Iterator<AbstractVariantWrapper> it = newtableData.iterator();
        while (it.hasNext()) {
            AbstractVariantWrapper next = it.next();
            if (blacklisted.contains((Object)next.variant.getGroup())) {
                it.remove();
                continue;
            }
            if (blacklisted.contains((Object)next.variant.getContainer())) {
                it.remove();
                continue;
            }
            if (next.variant instanceof AudioInterface) {
                if (blacklisted.contains((Object)((AudioInterface)((Object)next.variant)).getAudioBitrate())) {
                    it.remove();
                    continue;
                }
                if (blacklisted.contains((Object)((AudioInterface)((Object)next.variant)).getAudioCodec())) {
                    it.remove();
                    continue;
                }
            }
            if (next.variant instanceof VideoVariant) {
                if (blacklisted.contains((Object)((VideoVariant)next.variant).getVideoCodec())) {
                    it.remove();
                    continue;
                }
                if (blacklisted.contains((Object)((VideoVariant)next.variant).getVideoResolution())) {
                    it.remove();
                    continue;
                }
                if (blacklisted.contains((Object)((VideoVariant)next.variant).getiTagVideo().getVideoFrameRate())) {
                    it.remove();
                    continue;
                }
                if (blacklisted.contains((Object)((VideoVariant)next.variant).getProjection())) {
                    it.remove();
                    continue;
                }
            }
            if (!(next.variant instanceof ImageVariant) || !blacklisted.contains((Object)VideoResolution.getByHeight(((ImageVariant)next.variant).getHeight()))) continue;
            it.remove();
        }
    }

    public void updateEnabledMap() {
        CounterMap enabledMap = new CounterMap();
        for (AbstractVariantWrapper e : this.getTableData()) {
            if (!e.isEnabled()) continue;
            enabledMap.increment((Object)e.getVariableIDStorable().createUniqueID());
            enabledMap.increment((Object)e.variant.getStandardGroupingID());
            enabledMap.increment((Object)e.variant.getContainer().name());
        }
        if (this.getTable() != null) {
            ((VariantsMapTable)this.getTable()).onEnabledMapUpdate((CounterMap<String>)enabledMap);
        }
    }

    public void onEnabledMapUpdate(HashSet<String> enabledMap) {
    }

    protected List<Object> list(List<?> list) {
        if (list == null) {
            return new ArrayList<Object>();
        }
        return list;
    }

    public void onConfigValueModified(KeyHandler<Object> keyHandler, Object newValue) {
        if (keyHandler == CFG_YOUTUBE.DISABLED_VARIANTS || keyHandler == null) {
            List<VariantIDStorable> disabled = CFG_YOUTUBE.CFG.getDisabledVariants();
            HashSet<String> ids = new HashSet<String>();
            if (disabled != null) {
                for (VariantIDStorable be : disabled) {
                    ids.add(be.createUniqueID());
                }
            }
            Iterator<Object> iterator = this.all.iterator();
            while (iterator.hasNext()) {
                AbstractVariantWrapper s;
                s.setEnabled(!ids.contains((s = (AbstractVariantWrapper)iterator.next()).getVariableIDStorable().createUniqueID()));
            }
        }
        this._fireTableStructureChanged(new ArrayList<AbstractVariantWrapper>(this.all), true);
    }

    public void load() {
        this.onConfigValueModified(null, null);
    }

    public void save() {
        ArrayList<VariantIDStorable> lst = new ArrayList<VariantIDStorable>();
        for (AbstractVariantWrapper s : this.all) {
            if (s.isEnabled()) continue;
            lst.add(s.getVariableIDStorable());
        }
        CFG_YOUTUBE.CFG.setDisabledVariants(lst);
    }

    public abstract class AutoResizingIntColumn
    extends ExtTextColumn<AbstractVariantWrapper> {
        public AutoResizingIntColumn(String name) {
            super(name);
            this.rendererField.setHorizontalAlignment(4);
            this.setRowSorter((ExtDefaultRowSorter)new ExtDefaultRowSorter<AbstractVariantWrapper>(){

                public int compare(AbstractVariantWrapper o1, AbstractVariantWrapper o2) {
                    int _1 = AutoResizingIntColumn.this.getInt(o1);
                    int _2 = AutoResizingIntColumn.this.getInt(o2);
                    int ret = this.getSortOrderIdentifier() == "ASC" ? (_1 == _2 ? 0 : (_1 < _2 ? -1 : 1)) : (_1 == _2 ? 0 : (_1 > _2 ? -1 : 1));
                    return VariantsMapTableModel.globalCompare(ret, o1, o2, this.getSortOrderIdentifier() == "ASC");
                }
            });
        }

        public boolean isEnabled(AbstractVariantWrapper obj) {
            return obj.isEnabled();
        }

        public abstract int getInt(AbstractVariantWrapper var1);

        public String getStringValue(AbstractVariantWrapper value) {
            int i = this.getInt(value);
            if (i <= 0) {
                return "";
            }
            return i + "";
        }

        protected String getTooltipText(AbstractVariantWrapper obj) {
            return obj.variant.createAdvancedName();
        }

        public boolean isAutoWidthEnabled() {
            return false;
        }

        protected boolean isDefaultResizable() {
            return true;
        }

        public boolean isResizable() {
            return true;
        }

        public int getDefaultWidth() {
            return 0;
        }

        protected int adjustWidth(int w) {
            return Math.max(w, this.calculateMinimumHeaderWidth());
        }
    }

    public abstract class AutoResizingTextColumn
    extends ExtTextColumn<AbstractVariantWrapper> {
        public AutoResizingTextColumn(String name) {
            super(name);
            this.rendererField.setHorizontalAlignment(4);
            this.setRowSorter((ExtDefaultRowSorter)new ExtDefaultRowSorter<AbstractVariantWrapper>(){

                public int compare(AbstractVariantWrapper o1, AbstractVariantWrapper o2) {
                    String o1s = AutoResizingTextColumn.this.getStringValue(o1);
                    String o2s = AutoResizingTextColumn.this.getStringValue(o2);
                    if (o1s == null) {
                        o1s = "";
                    }
                    if (o2s == null) {
                        o2s = "";
                    }
                    if (this.getSortOrderIdentifier() == "ASC") {
                        int ret = o1s.compareToIgnoreCase(o2s);
                        return VariantsMapTableModel.globalCompare(ret, o1, o2, this.getSortOrderIdentifier() == "ASC");
                    }
                    int ret = o2s.compareToIgnoreCase(o1s);
                    return VariantsMapTableModel.globalCompare(ret, o1, o2, this.getSortOrderIdentifier() == "ASC");
                }
            });
        }

        public boolean isEnabled(AbstractVariantWrapper obj) {
            return obj.isEnabled();
        }

        protected boolean isDefaultResizable() {
            return true;
        }

        protected String getTooltipText(AbstractVariantWrapper obj) {
            return obj.variant.createAdvancedName();
        }

        public boolean isResizable() {
            return true;
        }

        public boolean isAutoWidthEnabled() {
            return false;
        }

        public int getDefaultWidth() {
            return 0;
        }

        protected int adjustWidth(int w) {
            return Math.max(w, this.calculateMinimumHeaderWidth());
        }
    }

    private class EnabledColumn
    extends ExtCheckColumn<AbstractVariantWrapper> {
        private EnabledColumn(String string) {
            super(string);
            this.setRowSorter((ExtDefaultRowSorter)new ExtDefaultRowSorter<AbstractVariantWrapper>(){

                public int compare(AbstractVariantWrapper o1, AbstractVariantWrapper o2) {
                    boolean b2;
                    boolean b1 = EnabledColumn.this.getBooleanValue(o1);
                    int ret = b1 == (b2 = EnabledColumn.this.getBooleanValue(o2)) ? 0 : (this.getSortOrderIdentifier() == "ASC" ? (b1 && !b2 ? -1 : 1) : (!b1 && b2 ? -1 : 1));
                    return VariantsMapTableModel.globalCompare(ret, o1, o2, this.getSortOrderIdentifier() == "ASC");
                }
            });
        }

        public ExtTableHeaderRenderer getHeaderRenderer(JTableHeader jTableHeader) {
            ExtTableHeaderRenderer ret = new ExtTableHeaderRenderer((ExtColumn)this, jTableHeader){
                private final Icon ok;
                private static final long serialVersionUID = 3224931991570756349L;
                {
                    this.ok = NewTheme.I().getIcon("ok", 14);
                }

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    this.setIcon(this.ok);
                    this.setHorizontalAlignment(0);
                    this.setText(null);
                    return this;
                }
            };
            return ret;
        }

        public int getMaxWidth() {
            return 30;
        }

        public boolean isEditable(AbstractVariantWrapper obj) {
            return true;
        }

        protected boolean getBooleanValue(AbstractVariantWrapper value) {
            return value.isEnabled();
        }

        protected void setBooleanValue(boolean value, AbstractVariantWrapper object) {
            object.setEnabled(value);
        }
    }
}

