/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube.configpanel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.appwork.storage.Storable;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.utils.StringUtils;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.plugins.components.youtube.Projection;
import org.jdownloader.plugins.components.youtube.VariantIDStorable;
import org.jdownloader.plugins.components.youtube.variants.FileContainer;
import org.jdownloader.plugins.components.youtube.variants.VariantGroup;
import org.jdownloader.settings.staticreferences.CFG_YOUTUBE;

public class YoutubeVariantCollection
implements Storable {
    private boolean enabled;
    private String groupingID;
    private String name;
    private List<VariantIDStorable> variants;
    private List<VariantIDStorable> dropdown;

    public YoutubeVariantCollection() {
    }

    public String getGroupingID() {
        return this.groupingID;
    }

    public void setGroupingID(String groupingID) {
        this.groupingID = groupingID;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<VariantIDStorable> getVariants() {
        return this.variants;
    }

    public void setVariants(List<VariantIDStorable> variants) {
        this.variants = variants;
    }

    public List<VariantIDStorable> getDropdown() {
        return this.dropdown;
    }

    public void setDropdown(List<VariantIDStorable> dropdown) {
        this.dropdown = dropdown;
    }

    public YoutubeVariantCollection(String name, List<VariantIDStorable> variants) {
        this.enabled = true;
        this.name = name;
        this.variants = variants;
    }

    public YoutubeVariantCollection(String name, String id) {
        this.enabled = true;
        this.name = name;
        this.groupingID = id;
    }

    public static List<YoutubeVariantCollection> load() {
        List<YoutubeVariantCollection> links = CFG_YOUTUBE.CFG.getCollections();
        ArrayList<YoutubeVariantCollection> ret = new ArrayList<YoutubeVariantCollection>();
        HashSet<String> groupIds = new HashSet<String>();
        if (links != null) {
            for (YoutubeVariantCollection l : links) {
                if (l == null) continue;
                ret.add(l);
                if (!StringUtils.isNotEmpty((String)l.getGroupingID())) continue;
                groupIds.add(l.getGroupingID());
            }
        }
        for (YoutubeVariantCollection g : YoutubeVariantCollection.getDefaults()) {
            if (!groupIds.add(g.getGroupingID())) continue;
            ret.add(g);
        }
        return ret;
    }

    public HashSet<String> createUniqueIDSet() {
        HashSet<String> ret = new HashSet<String>();
        if (this.variants != null) {
            for (VariantIDStorable v : this.variants) {
                ret.add(v.createUniqueID());
            }
        }
        return ret;
    }

    public HashSet<String> createUniqueIDSetForDropDownList() {
        HashSet<String> ret = new HashSet<String>();
        if (this.dropdown != null) {
            for (VariantIDStorable v : this.dropdown) {
                ret.add(v.createUniqueID());
            }
        }
        return ret;
    }

    public static List<YoutubeVariantCollection> getDefaults() {
        String id;
        ArrayList<YoutubeVariantCollection> ret = new ArrayList<YoutubeVariantCollection>();
        block3: for (VariantGroup variantGroup : VariantGroup.values()) {
            switch (variantGroup) {
                case VIDEO: {
                    for (Projection p : Projection.values()) {
                        String id2 = variantGroup.name() + "_" + p.name();
                        ret.add(0, new YoutubeVariantCollection(_GUI.T.Youtube_bestcollection(p, variantGroup), id2));
                    }
                    continue block3;
                }
                default: {
                    id = variantGroup.name();
                    ret.add(0, new YoutubeVariantCollection(_GUI.T.Youtube_bestcollection_2(variantGroup), id));
                }
            }
        }
        for (Enum enum_ : FileContainer.values()) {
            id = enum_.name();
            YoutubeVariantCollection l = new YoutubeVariantCollection(_GUI.T.Youtube_bestcollection_2((LabelInterface)enum_), id);
            ret.add(l);
            l.setEnabled(false);
        }
        return ret;
    }
}

