/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube.configpanel;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import jd.gui.swing.jdgui.JDGui;
import jd.plugins.PluginConfigPanelNG;
import net.miginfocom.swing.MigLayout;
import org.appwork.storage.config.annotations.IntegerInterface;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.storage.config.handler.BooleanKeyHandler;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.storage.config.handler.ObjectKeyHandler;
import org.appwork.swing.components.CheckBoxIcon;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtTableHeaderRenderer;
import org.appwork.swing.exttable.columns.ExtCheckColumn;
import org.appwork.utils.StringUtils;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.dimensor.DialogDimensor;
import org.appwork.utils.swing.dialog.dimensor.RememberLastDialogDimension;
import org.appwork.utils.swing.dialog.locator.DialogLocator;
import org.appwork.utils.swing.dialog.locator.RememberRelativeDialogLocator;
import org.jdownloader.actions.AppAction;
import org.jdownloader.controlling.linkcrawler.LinkVariant;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.NewTheme;
import org.jdownloader.plugins.components.youtube.Projection;
import org.jdownloader.plugins.components.youtube.VariantIDStorable;
import org.jdownloader.plugins.components.youtube.choosevariantdialog.CustomVariantsMapTable;
import org.jdownloader.plugins.components.youtube.choosevariantdialog.CustomVariantsMapTableModel;
import org.jdownloader.plugins.components.youtube.choosevariantdialog.Filter;
import org.jdownloader.plugins.components.youtube.configpanel.AbstractVariantWrapper;
import org.jdownloader.plugins.components.youtube.configpanel.EnumMultiComboBox;
import org.jdownloader.plugins.components.youtube.configpanel.YoutubeVariantCollection;
import org.jdownloader.plugins.components.youtube.itag.AudioBitrate;
import org.jdownloader.plugins.components.youtube.itag.AudioCodec;
import org.jdownloader.plugins.components.youtube.itag.VideoCodec;
import org.jdownloader.plugins.components.youtube.itag.VideoFrameRate;
import org.jdownloader.plugins.components.youtube.itag.VideoResolution;
import org.jdownloader.plugins.components.youtube.variants.AbstractVariant;
import org.jdownloader.plugins.components.youtube.variants.AudioInterface;
import org.jdownloader.plugins.components.youtube.variants.FileContainer;
import org.jdownloader.plugins.components.youtube.variants.ImageVariant;
import org.jdownloader.plugins.components.youtube.variants.VariantGroup;
import org.jdownloader.plugins.components.youtube.variants.VideoVariant;
import org.jdownloader.settings.staticreferences.CFG_YOUTUBE;

public class YoutubeVariantsListChooser
extends AbstractDialog<Object>
implements KeyListener,
ListSelectionListener,
MouseListener {
    protected CustomVariantsMapTable table;
    protected AbstractVariantWrapper selectedVariant;
    private HashSet<VariantGroup> allowedGroups;
    private HashSet<FileContainer> allowedFileTypes;
    private HashSet<Projection> allowedProjections;
    private HashSet<VideoResolution> allowedResolutions;
    private HashSet<VideoFrameRate> allowedFps;
    private HashSet<VideoCodec> allowedVCodec;
    private HashSet<AudioCodec> allowedACodec;
    protected HashSet<AudioBitrate> allowedABitrate;
    protected ArrayList<AbstractVariantWrapper> variantWrapperList;
    private List<AbstractVariant> variants;
    private YoutubeVariantCollection collection;
    private HashSet<AbstractVariantWrapper> defaultSelection;
    private HashSet<AbstractVariantWrapper> selection;

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    protected int getPreferredHeight() {
        return 600;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }

    protected int getPreferredWidth() {
        return 800;
    }

    public Dialog.ModalityType getModalityType() {
        return Dialog.ModalityType.MODELESS;
    }

    public YoutubeVariantsListChooser(YoutubeVariantCollection collection) {
        super(256, _GUI.T.youtube_choose_quick_selection_dropdown_table(collection.getName()), null, _GUI.T.lit_save(), null);
        String id;
        this.setDimensor((DialogDimensor)new RememberLastDialogDimension("YoutubeVariantsListChooser"));
        this.setLocator((DialogLocator)new RememberRelativeDialogLocator("YoutubeVariantsListChooser", (Window)JDGui.getInstance().getMainFrame()));
        this.collection = collection;
        this.initVariants();
        this.defaultSelection = new HashSet();
        HashSet<String> idSet = collection.createUniqueIDSet();
        for (AbstractVariantWrapper v : this.variantWrapperList) {
            id = v.getVariableIDStorable().createUniqueID();
            if (idSet.contains(id)) {
                this.defaultSelection.add(v);
                continue;
            }
            if (StringUtils.equals((String)v.getVariableIDStorable().getContainer(), (String)collection.getGroupingID())) {
                this.defaultSelection.add(v);
                continue;
            }
            if (!StringUtils.equals((String)v.getVariableIDStorable().createGroupingID(), (String)collection.getGroupingID())) continue;
            this.defaultSelection.add(v);
        }
        this.selection = new HashSet();
        if (collection.getDropdown() != null && collection.getDropdown().size() > 0) {
            idSet = collection.createUniqueIDSetForDropDownList();
            for (AbstractVariantWrapper v : this.variantWrapperList) {
                id = v.getVariableIDStorable().createUniqueID();
                if (!idSet.contains(id)) continue;
                this.selection.add(v);
            }
        }
        if (this.selection.size() == 0) {
            this.selection.addAll(this.defaultSelection);
        }
    }

    public List<VariantIDStorable> getSelection() {
        HashSet<AbstractVariantWrapper> checkChanges = new HashSet<AbstractVariantWrapper>(this.defaultSelection);
        if (this.defaultSelection.size() == this.selection.size()) {
            checkChanges.removeAll(this.selection);
            if (checkChanges.size() == 0) {
                return null;
            }
        }
        ArrayList<VariantIDStorable> ret = new ArrayList<VariantIDStorable>();
        for (AbstractVariantWrapper s : this.selection) {
            ret.add(new VariantIDStorable(s.variant));
        }
        return ret;
    }

    protected void initVariants() {
        ArrayList<String> dupe = new ArrayList<String>();
        this.variants = new ArrayList<AbstractVariant>(AbstractVariant.listVariants());
        Collections.sort(this.variants);
        this.variantWrapperList = new ArrayList();
        this.allowedGroups = new HashSet();
        this.allowedFileTypes = new HashSet();
        this.allowedProjections = new HashSet();
        this.allowedResolutions = new HashSet();
        this.allowedFps = new HashSet();
        this.allowedVCodec = new HashSet();
        this.allowedACodec = new HashSet();
        this.allowedABitrate = new HashSet();
        this.allowedGroups.addAll(Arrays.asList(VariantGroup.values()));
        for (AbstractVariant vi : this.variants) {
            VariantIDStorable stor;
            if (!this.allowedGroups.contains((Object)vi.getGroup()) || !dupe.add((stor = new VariantIDStorable(vi)).createUniqueID())) continue;
            AbstractVariantWrapper avw = new AbstractVariantWrapper(vi);
            this.variantWrapperList.add(avw);
            this.allowedFileTypes.add(vi.getContainer());
            if (vi instanceof VideoVariant) {
                VideoVariant vVar = (VideoVariant)vi;
                this.allowedProjections.add(vVar.getProjection());
                this.allowedResolutions.add(vVar.getVideoResolution());
                this.allowedFps.add(vVar.getiTagVideo().getVideoFrameRate());
                this.allowedVCodec.add(vVar.getVideoCodec());
            }
            if (vi instanceof AudioInterface) {
                AudioInterface aVar = (AudioInterface)((Object)vi);
                this.allowedABitrate.add(aVar.getAudioBitrate());
                this.allowedACodec.add(aVar.getAudioCodec());
            }
            if (!(vi instanceof ImageVariant)) continue;
            ImageVariant iVar = (ImageVariant)vi;
            this.allowedResolutions.add(VideoResolution.getByHeight(iVar.getHeight()));
        }
    }

    public CustomVariantsMapTable getTable() {
        return this.table;
    }

    public JComponent layoutDialogContent() {
        PluginConfigPanelNG ret = new PluginConfigPanelNG(){

            @Override
            public void reset() {
            }

            @Override
            public void save() {
            }

            @Override
            public void updateContents() {
            }
        };
        int height = new JLabel((String)"Test").getPreferredSize().height;
        ret.setLayout((LayoutManager)new MigLayout("ins 0, wrap 2", "[][grow,fill]", "[]"));
        CustomVariantsMapTableModel model = this.createTableModel();
        this.table = this.createTable(model);
        this.table.getSelectionModel().setSelectionMode(2);
        ret.addDescriptionPlain(this.getDescriptionText());
        this.addFilter(ret);
        this.table.load();
        JScrollPane sp = new JScrollPane((Component)((Object)this.table));
        ret.add(sp, "pushx,growx,spanx,pushy,growy");
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.addKeyListener(this);
        this.table.addMouseListener(this);
        this.getDialog().setMinimumSize(new Dimension(200, 200));
        return ret;
    }

    protected CustomVariantsMapTable createTable(CustomVariantsMapTableModel model) {
        return new CustomVariantsMapTable(model){

            @Override
            protected JPopupMenu onContextMenu(JPopupMenu popup, AbstractVariantWrapper contextObject, final List<AbstractVariantWrapper> s, ExtColumn<AbstractVariantWrapper> column, MouseEvent mouseEvent) {
                popup = new JPopupMenu();
                popup.add((Action)((Object)new AppAction(){
                    {
                        this.setSmallIcon((Icon)new CheckBoxIcon(true));
                        this.setName(_GUI.T.lit_enable());
                    }

                    public void actionPerformed(ActionEvent e) {
                        for (AbstractVariantWrapper w : s) {
                            YoutubeVariantsListChooser.this.selection.add(w);
                        }
                        YoutubeVariantsListChooser.this.table.getModel().refreshSort();
                    }
                }));
                popup.add((Action)((Object)new AppAction(){
                    {
                        this.setSmallIcon((Icon)new CheckBoxIcon(false));
                        this.setName(_GUI.T.lit_disable());
                    }

                    public void actionPerformed(ActionEvent e) {
                        for (AbstractVariantWrapper w : s) {
                            YoutubeVariantsListChooser.this.selection.remove(w);
                        }
                        YoutubeVariantsListChooser.this.table.getModel().refreshSort();
                    }
                }));
                return popup;
            }
        };
    }

    protected CustomVariantsMapTableModel createTableModel() {
        return new CustomVariantsMapTableModel(this.variantWrapperList, null){

            @Override
            protected void initColumns() {
                this.addColumn((ExtColumn)new ExtCheckColumn<AbstractVariantWrapper>(""){

                    public ExtTableHeaderRenderer getHeaderRenderer(JTableHeader jTableHeader) {
                        ExtTableHeaderRenderer ret = new ExtTableHeaderRenderer((ExtColumn)this, jTableHeader){
                            private final Icon ok;
                            {
                                this.ok = NewTheme.I().getIcon("ok", 14);
                            }

                            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                                this.setIcon(this.ok);
                                this.setHorizontalAlignment(0);
                                this.setText(null);
                                return this;
                            }
                        };
                        return ret;
                    }

                    public int getMaxWidth() {
                        return 30;
                    }

                    public boolean isEditable(AbstractVariantWrapper obj) {
                        return true;
                    }

                    protected boolean getBooleanValue(AbstractVariantWrapper value) {
                        return YoutubeVariantsListChooser.this.selection.contains(value);
                    }

                    protected void setBooleanValue(boolean value, AbstractVariantWrapper object) {
                        if (value) {
                            YoutubeVariantsListChooser.this.selection.add(object);
                        } else {
                            YoutubeVariantsListChooser.this.selection.remove(object);
                        }
                        YoutubeVariantsListChooser.this.table.getModel().refreshSort();
                    }
                });
                super.initColumns();
            }
        };
    }

    protected String getDescriptionText() {
        return _GUI.T.youtube_choose_dropdown_list();
    }

    private void addFilter(PluginConfigPanelNG ret) {
        ArrayList<VariantGroup> groups = new ArrayList<VariantGroup>(this.allowedGroups);
        Collections.sort(groups, LabelInterface.COMPARATOR_ASC);
        CustEnumMultiComboBox<VariantGroup> typeSel = new CustEnumMultiComboBox<VariantGroup>(VariantGroup.values(), groups, CFG_YOUTUBE.CHOOSE_VARIANT_DIALOG_BLACKLISTED_GROUPS);
        ArrayList<FileContainer> container = new ArrayList<FileContainer>(this.allowedFileTypes);
        Collections.sort(container, LabelInterface.COMPARATOR_ASC);
        CustEnumMultiComboBox<FileContainer> containerSel = new CustEnumMultiComboBox<FileContainer>(FileContainer.values(), container, CFG_YOUTUBE.CHOOSE_VARIANT_DIALOG_BLACKLISTED_FILE_CONTAINERS){

            protected String getLabel(int i, FileContainer sc) {
                return sc.getTooltip();
            }
        };
        ArrayList<Projection> projections = new ArrayList<Projection>(this.allowedProjections);
        Collections.sort(projections, LabelInterface.COMPARATOR_ASC);
        CustEnumMultiComboBox<Projection> projectionSelect = new CustEnumMultiComboBox<Projection>(Projection.values(), projections, CFG_YOUTUBE.CHOOSE_VARIANT_DIALOG_BLACKLISTED_PROJECTIONS){

            protected String getLabel(int i, Projection sc) {
                return sc.getTooltip();
            }
        };
        ArrayList<VideoResolution> heights = new ArrayList<VideoResolution>(this.allowedResolutions);
        Collections.sort(heights, IntegerInterface.COMPARATOR_DESC);
        CustEnumMultiComboBox<VideoResolution> resolutionSelect = new CustEnumMultiComboBox<VideoResolution>(VideoResolution.values(), heights, CFG_YOUTUBE.CHOOSE_VARIANT_DIALOG_BLACKLISTED_RESOLUTIONS);
        ArrayList<VideoFrameRate> fpss = new ArrayList<VideoFrameRate>(this.allowedFps);
        Collections.sort(fpss, IntegerInterface.COMPARATOR_DESC);
        CustEnumMultiComboBox<VideoFrameRate> fpsSelect = new CustEnumMultiComboBox<VideoFrameRate>(VideoFrameRate.values(), fpss, CFG_YOUTUBE.CHOOSE_VARIANT_DIALOG_BLACKLISTED_VIDEO_FRAMERATES);
        ArrayList<VideoCodec> videoCodecs = new ArrayList<VideoCodec>(this.allowedVCodec);
        Collections.sort(videoCodecs, LabelInterface.COMPARATOR_ASC);
        CustEnumMultiComboBox<VideoCodec> vcodec = new CustEnumMultiComboBox<VideoCodec>(VideoCodec.values(), videoCodecs, CFG_YOUTUBE.CHOOSE_VARIANT_DIALOG_BLACKLISTED_VIDEO_CODECS){

            protected String getLabel(int i, VideoCodec sc) {
                return sc.getTooltip();
            }
        };
        ArrayList<AudioCodec> audioCodecs = new ArrayList<AudioCodec>(this.allowedACodec);
        Collections.sort(audioCodecs, LabelInterface.COMPARATOR_ASC);
        CustEnumMultiComboBox<AudioCodec> acodec = new CustEnumMultiComboBox<AudioCodec>(AudioCodec.values(), audioCodecs, CFG_YOUTUBE.CHOOSE_VARIANT_DIALOG_BLACKLISTED_AUDIO_CODECS){

            protected String getLabel(int i, AudioCodec sc) {
                return sc.getTooltip();
            }
        };
        ArrayList<AudioBitrate> bitrates = new ArrayList<AudioBitrate>(this.allowedABitrate);
        Collections.sort(bitrates, IntegerInterface.COMPARATOR_DESC);
        CustEnumMultiComboBox<AudioBitrate> aBitrate = new CustEnumMultiComboBox<AudioBitrate>(AudioBitrate.values(), bitrates, CFG_YOUTUBE.CHOOSE_VARIANT_DIALOG_BLACKLISTED_AUDIO_BITRATES);
        typeSel.setShrinkedMode(true);
        containerSel.setShrinkedMode(true);
        projectionSelect.setShrinkedMode(true);
        resolutionSelect.setShrinkedMode(true);
        fpsSelect.setShrinkedMode(true);
        vcodec.setShrinkedMode(true);
        acodec.setShrinkedMode(true);
        aBitrate.setShrinkedMode(true);
        if (typeSel.getValues().size() > 1) {
            this.table.addFilter(typeSel);
            ret.addPair(_GUI.T.YOUTUBE_CONFIG_PANEL_TABLE_TYPE(), (BooleanKeyHandler)null, typeSel);
        }
        if (containerSel.getValues().size() > 1) {
            this.table.addFilter(containerSel);
            ret.addPair(_GUI.T.YOUTUBE_CONFIG_PANEL_TABLE_FILETYPE(), (BooleanKeyHandler)null, containerSel);
        }
        if (projectionSelect.getValues().size() > 1) {
            this.table.addFilter(projectionSelect);
            ret.addPair(_GUI.T.YOUTUBE_CONFIG_PANEL_TABLE_PROJECTION(), (BooleanKeyHandler)null, projectionSelect);
        }
        if (resolutionSelect.getValues().size() > 1) {
            this.table.addFilter(resolutionSelect);
            ret.addPair(_GUI.T.YOUTUBE_CONFIG_PANEL_TABLE_RESOLUTION(), (BooleanKeyHandler)null, resolutionSelect);
        }
        if (fpsSelect.getValues().size() > 1) {
            this.table.addFilter(fpsSelect);
            ret.addPair(_GUI.T.YOUTUBE_CONFIG_PANEL_TABLE_FPS(), (BooleanKeyHandler)null, fpsSelect);
        }
        if (vcodec.getValues().size() > 1) {
            this.table.addFilter(vcodec);
            ret.addPair(_GUI.T.YOUTUBE_CONFIG_PANEL_TABLE_VIDEO_CODEC(), (BooleanKeyHandler)null, vcodec);
        }
        if (acodec.getValues().size() > 1) {
            this.table.addFilter(acodec);
            ret.addPair(_GUI.T.YOUTUBE_CONFIG_PANEL_TABLE_AUDIO_CODEC(), (BooleanKeyHandler)null, acodec);
        }
        if (aBitrate.getValues().size() > 1) {
            this.table.addFilter(aBitrate);
            ret.addPair(_GUI.T.YOUTUBE_CONFIG_PANEL_TABLE_AUDIO_BITRATE(), (BooleanKeyHandler)null, aBitrate);
        }
    }

    protected void packed() {
        super.packed();
    }

    protected void initFocus(JComponent focus) {
        super.initFocus(focus);
        this.table.requestFocus();
    }

    public List<LinkVariant> getVariants() {
        List wrapper = this.table.getModel().getSelectedObjects();
        ArrayList<LinkVariant> ret = new ArrayList<LinkVariant>();
        for (AbstractVariantWrapper w : wrapper) {
            ret.add(w.variant);
        }
        return ret;
    }

    public LinkVariant getVariant() {
        if (this.selectedVariant == null) {
            return null;
        }
        return this.selectedVariant.variant;
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10 && this.selectedVariant != null) {
            this.okButton.doClick();
        }
    }

    protected Object createReturnValue() {
        return null;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private class CustEnumMultiComboBox<T>
    extends EnumMultiComboBox<T>
    implements Filter {
        private T[] allValues;
        private HashSet<T> set;

        public CustEnumMultiComboBox(T[] allValues, List<T> values, ObjectKeyHandler keyHandler) {
            super(values, keyHandler, true);
            this.set = new HashSet();
            this.allValues = allValues;
            this.set.addAll(values);
            this.onConfigValueModified(null, null);
        }

        @Override
        public void onConfigValueModified(KeyHandler<Object> keyHandler, Object newValue) {
            if (this.allValues == null) {
                return;
            }
            super.onConfigValueModified(keyHandler, newValue);
        }

        @Override
        protected void loadValuesFromKeyHandler() {
            ArrayList selected = new ArrayList(this.getValues());
            List blacklisted = (List)this.keyHandler.getValue();
            if (blacklisted != null) {
                selected.removeAll(blacklisted);
            }
            this.setSelectedItems(selected);
        }

        @Override
        protected void saveValuesToKeyHandler() {
            List selected = this.getSelectedItems();
            ArrayList<T> all = new ArrayList<T>(Arrays.asList(this.allValues));
            all.removeAll(selected);
            this.keyHandler.setValue(all);
        }

        @Override
        public void onChanged() {
            this.set = new HashSet(this.selectedItems);
            super.onChanged();
        }

        @Override
        public boolean isBlacklisted(AbstractVariant variant) {
            if (this.allValues[0] instanceof VariantGroup) {
                return !this.set.contains((Object)variant.getGroup());
            }
            if (this.allValues[0] instanceof FileContainer) {
                return !this.set.contains((Object)variant.getContainer());
            }
            if (variant instanceof AudioInterface) {
                if (this.allValues[0] instanceof AudioCodec) {
                    return !this.set.contains((Object)((AudioInterface)((Object)variant)).getAudioCodec());
                }
                if (this.allValues[0] instanceof AudioBitrate) {
                    return !this.set.contains((Object)((AudioInterface)((Object)variant)).getAudioBitrate());
                }
            }
            if (variant instanceof VideoVariant) {
                if (this.allValues[0] instanceof VideoCodec) {
                    return !this.set.contains((Object)((VideoVariant)variant).getVideoCodec());
                }
                if (this.allValues[0] instanceof VideoFrameRate) {
                    return !this.set.contains((Object)((VideoVariant)variant).getiTagVideo().getVideoFrameRate());
                }
                if (this.allValues[0] instanceof Projection) {
                    return !this.set.contains((Object)((VideoVariant)variant).getProjection());
                }
                if (this.allValues[0] instanceof VideoResolution) {
                    return !this.set.contains((Object)((VideoVariant)variant).getVideoResolution());
                }
            }
            if (variant instanceof ImageVariant && this.allValues[0] instanceof VideoResolution) {
                return !this.set.contains((Object)VideoResolution.getByHeight(((ImageVariant)variant).getHeight()));
            }
            return false;
        }
    }
}

