/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube.converter;

import java.io.File;
import jd.plugins.DownloadLink;
import jd.plugins.PluginException;
import jd.plugins.PluginForHost;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.controlling.ffmpeg.FFMpegProgress;
import org.jdownloader.controlling.ffmpeg.FFmpeg;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.logging.LogController;
import org.jdownloader.plugins.components.youtube.ExternalToolRequired;
import org.jdownloader.plugins.components.youtube.converter.YoutubeConverter;

public class YoutubeConverterFLVToAACAudio
implements YoutubeConverter,
ExternalToolRequired {
    private static final YoutubeConverterFLVToAACAudio INSTANCE = new YoutubeConverterFLVToAACAudio();
    private LogSource logger = LogController.getInstance().getLogger(YoutubeConverterFLVToAACAudio.class.getName());

    public static YoutubeConverterFLVToAACAudio getInstance() {
        return INSTANCE;
    }

    private YoutubeConverterFLVToAACAudio() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(DownloadLink downloadLink, PluginForHost plugin) throws Exception {
        FFMpegProgress set = new FFMpegProgress();
        try {
            downloadLink.addPluginProgress(set);
            File file = new File(downloadLink.getFileOutput());
            plugin.checkFFmpeg(downloadLink, _GUI.T.YoutubeDash_handleDownload_youtube_dash());
            FFmpeg ffmpeg = plugin.getFFmpeg(null, downloadLink);
            File finalFile = downloadLink.getDownloadLinkController().getFileOutput(false, true);
            if (!ffmpeg.demuxAAC(set, finalFile.getAbsolutePath(), file.getAbsolutePath())) {
                throw new PluginException(0x400000, _GUI.T.YoutubeDash_handleFree_error_());
            }
            file.delete();
            downloadLink.setDownloadSize(finalFile.length());
            downloadLink.setDownloadCurrent(finalFile.length());
            try {
                downloadLink.setInternalTmpFilenameAppend(null);
                downloadLink.setInternalTmpFilename(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        finally {
            downloadLink.removePluginProgress(set);
        }
    }
}

