/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube.converter;

import java.io.File;
import jd.plugins.DownloadLink;
import jd.plugins.PluginException;
import jd.plugins.PluginForHost;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.controlling.ffmpeg.FFMpegProgress;
import org.jdownloader.controlling.ffmpeg.FFmpeg;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.logging.LogController;
import org.jdownloader.plugins.components.youtube.ExternalToolRequired;
import org.jdownloader.plugins.components.youtube.converter.AbstractDemuxToAudioConverter;

public class YoutubeConverterFLVToM4AAudio
extends AbstractDemuxToAudioConverter
implements ExternalToolRequired {
    private static final YoutubeConverterFLVToM4AAudio INSTANCE = new YoutubeConverterFLVToM4AAudio();
    private final LogSource logger = LogController.getInstance().getLogger(YoutubeConverterFLVToM4AAudio.class.getName());

    public static YoutubeConverterFLVToM4AAudio getInstance() {
        return INSTANCE;
    }

    private YoutubeConverterFLVToM4AAudio() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(DownloadLink downloadLink, PluginForHost plugin) throws Exception {
        FFMpegProgress set = new FFMpegProgress();
        try {
            downloadLink.addPluginProgress(set);
            File file = new File(downloadLink.getFileOutput());
            plugin.checkFFmpeg(downloadLink, _GUI.T.YoutubeDash_handleDownload_youtube_dash());
            FFmpeg ffmpeg = plugin.getFFmpeg(null, downloadLink);
            File finalFile = downloadLink.getDownloadLinkController().getFileOutput(false, true);
            if (!ffmpeg.demuxM4a(set, finalFile.getAbsolutePath(), file.getAbsolutePath())) {
                throw new PluginException(0x400000, _GUI.T.YoutubeDash_handleFree_error_());
            }
            file.delete();
            downloadLink.setVerifiedFileSize(finalFile.length());
            downloadLink.setDownloadCurrent(finalFile.length());
            try {
                downloadLink.setInternalTmpFilenameAppend(null);
                downloadLink.setInternalTmpFilename(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        finally {
            downloadLink.removePluginProgress(set);
        }
    }
}

