/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube.variants;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import jd.config.Property;
import jd.http.Request;
import jd.plugins.DownloadLink;
import jd.plugins.PluginForHost;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.SimpleMapper;
import org.appwork.storage.simplejson.JSonFactory;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.extmanager.Log;
import org.appwork.utils.parser.UrlQuery;
import org.jdownloader.controlling.linkcrawler.LinkVariant;
import org.jdownloader.plugins.components.youtube.Projection;
import org.jdownloader.plugins.components.youtube.YT_STATICS;
import org.jdownloader.plugins.components.youtube.YoutubeClipData;
import org.jdownloader.plugins.components.youtube.YoutubeHelper;
import org.jdownloader.plugins.components.youtube.YoutubeStreamData;
import org.jdownloader.plugins.components.youtube.itag.QualitySortIdentifier;
import org.jdownloader.plugins.components.youtube.itag.YoutubeITAG;
import org.jdownloader.plugins.components.youtube.variants.AudioInterface;
import org.jdownloader.plugins.components.youtube.variants.AudioVariant;
import org.jdownloader.plugins.components.youtube.variants.DescriptionVariant;
import org.jdownloader.plugins.components.youtube.variants.DownloadType;
import org.jdownloader.plugins.components.youtube.variants.FileContainer;
import org.jdownloader.plugins.components.youtube.variants.ImagePlaylistCoverVariant;
import org.jdownloader.plugins.components.youtube.variants.ImageVariant;
import org.jdownloader.plugins.components.youtube.variants.SubtitleVariant;
import org.jdownloader.plugins.components.youtube.variants.VariantBase;
import org.jdownloader.plugins.components.youtube.variants.VariantGroup;
import org.jdownloader.plugins.components.youtube.variants.VariantInfo;
import org.jdownloader.plugins.components.youtube.variants.VideoVariant;
import org.jdownloader.plugins.components.youtube.variants.YoutubeBasicVariantStorable;
import org.jdownloader.plugins.components.youtube.variants.YoutubeSubtitleStorable;
import org.jdownloader.plugins.components.youtube.variants.generics.AbstractGenericVariantInfo;
import org.jdownloader.plugins.components.youtube.variants.generics.GenericVideoInfo;

public abstract class AbstractVariant<Data extends AbstractGenericVariantInfo>
implements LinkVariant,
Comparable {
    private static ArrayList<AbstractVariant> VARIANTS_LIST;
    protected final VariantBase baseVariant;
    private Data genericInfo;
    private VariantInfo variantInfo;
    private volatile String storableString = null;
    private static final SimpleMapper MAPPER;

    public String toString() {
        return this.baseVariant.toString();
    }

    public int compareTo(Object o) {
        if (!(o instanceof AbstractVariant)) {
            return -1;
        }
        AbstractVariant o1 = this;
        AbstractVariant o2 = (AbstractVariant)o;
        for (QualitySortIdentifier q : YT_STATICS.SORTIDS) {
            int ret = q.compare(o1, o2);
            if (ret == 0) continue;
            return ret;
        }
        return 0;
    }

    public static AbstractVariant get(String ytv) {
        try {
            AbstractVariant ret;
            VariantBase base;
            if (ytv != null && ytv.matches("[A-Z0-9_]+") && (base = VariantBase.get(ytv)) != null) {
                AbstractVariant ret2;
                switch (base.getGroup()) {
                    case AUDIO: {
                        ret2 = new AudioVariant(base);
                        ret2.setJson("{}");
                        break;
                    }
                    case DESCRIPTION: {
                        ret2 = new DescriptionVariant();
                        ret2.setJson("null");
                        break;
                    }
                    case IMAGE: {
                        ret2 = new ImageVariant(base);
                        ret2.setJson("{}");
                        break;
                    }
                    case IMAGE_PLAYLIST_COVER: {
                        ret2 = new ImagePlaylistCoverVariant(base);
                        ret2.setJson("{}");
                        break;
                    }
                    case SUBTITLES: {
                        ret2 = new SubtitleVariant();
                        ret2.setJson("{}");
                        break;
                    }
                    case VIDEO: {
                        ret2 = new VideoVariant(base);
                        ret2.setJson("{}");
                        break;
                    }
                    default: {
                        ret2 = null;
                    }
                }
                return ret2;
            }
            if (ytv == null) {
                return null;
            }
            if (!ytv.contains("{")) {
                return null;
            }
            YoutubeBasicVariantStorable storable = (YoutubeBasicVariantStorable)JSonStorage.restoreFromString((String)ytv, YoutubeBasicVariantStorable.TYPE);
            VariantBase base2 = null;
            try {
                base2 = VariantBase.valueOf(storable.getId());
            }
            catch (Throwable e) {
                try {
                    base2 = VariantBase.COMPATIBILITY_MAP.get(storable.getId());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (base2 == null) {
                return null;
            }
            switch (base2.getGroup()) {
                case AUDIO: {
                    ret = new AudioVariant(base2);
                    break;
                }
                case DESCRIPTION: {
                    ret = new DescriptionVariant();
                    break;
                }
                case IMAGE: {
                    ret = new ImageVariant(base2);
                    break;
                }
                case IMAGE_PLAYLIST_COVER: {
                    ret = new ImagePlaylistCoverVariant(base2);
                    break;
                }
                case SUBTITLES: {
                    ret = new SubtitleVariant();
                    break;
                }
                case VIDEO: {
                    ret = new VideoVariant(base2);
                    break;
                }
                default: {
                    ret = null;
                }
            }
            if (ret != null) {
                ret.setJson(storable.getData());
                return ret;
            }
            return null;
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
            return null;
        }
    }

    public abstract void setJson(String var1);

    protected AbstractVariant(VariantBase v) {
        this.baseVariant = v;
    }

    @Override
    public String _getUniqueId() {
        VariantBase variantBase = this.getBaseVariant();
        if (variantBase != null) {
            return variantBase._getUniqueId();
        }
        throw new WTFException();
    }

    public String createAdvancedName() {
        return this.getBaseVariant().name().replace("_DASH", "").replace("_HLS", "").replace("HLS_", "").replace("_3D", "").replaceAll("_\\d+$", "").replace("_", ", ");
    }

    @Override
    public String _getTooltipDescription(Object caller) {
        return this.createAdvancedName();
    }

    public FileContainer getContainer() {
        return this.getBaseVariant().getContainer();
    }

    public YoutubeITAG getiTagVideo() {
        return this.baseVariant.getiTagVideo();
    }

    public YoutubeITAG getiTagAudioOrVideoItagEquivalent() {
        if (this.baseVariant.getiTagAudio() != null) {
            return this.baseVariant.getiTagAudio();
        }
        return this.baseVariant.getiTagVideo();
    }

    public YoutubeITAG getiTagData() {
        return this.baseVariant.getiTagData();
    }

    public VariantBase getBaseVariant() {
        return this.baseVariant;
    }

    public String getVariantDetails() {
        YoutubeITAG data;
        YoutubeITAG audio;
        YoutubeITAG video;
        StringBuilder sb = new StringBuilder();
        sb.append(this.toString());
        sb.append("[");
        FileContainer container = this.getContainer();
        if (container != null) {
            sb.append("%Container:").append(container.name());
        }
        if ((video = this.getiTagVideo()) != null) {
            sb.append("%Video:").append(video.name()).append("(").append(video.getITAG()).append(")");
        }
        if ((audio = this.getiTagAudioOrVideoItagEquivalent()) != null) {
            sb.append("%Audio:").append(audio.name()).append("(").append(audio.getITAG()).append(")");
        }
        if ((data = this.getiTagData()) != null) {
            sb.append("%Data:").append(data.name()).append("(").append(data.getITAG()).append(")");
        }
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        return this._getUniqueId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractVariant) {
            AbstractVariant var = (AbstractVariant)obj;
            return obj == this || var.getBaseVariant() == this.getBaseVariant() && StringUtils.equals((String)this._getUniqueId(), (String)var._getUniqueId());
        }
        return false;
    }

    public abstract String getTypeId();

    public DownloadType getType() {
        return this.baseVariant.getType();
    }

    public VariantGroup getGroup() {
        return this.baseVariant.getGroup();
    }

    public void convert(DownloadLink downloadLink, PluginForHost plugin) throws Exception {
        this.baseVariant.convert(downloadLink, plugin);
    }

    public abstract String getFileNameQualityTag();

    public String modifyFileName(String formattedFilename, DownloadLink link) {
        return formattedFilename;
    }

    public boolean hasConverter(DownloadLink downloadLink) {
        return this.baseVariant.hasConverter(downloadLink);
    }

    public List<File> listProcessFiles(DownloadLink link) {
        return this.baseVariant.listProcessFiles(link);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStorableString() {
        String ret = this.storableString;
        if (ret == null) {
            AbstractVariant abstractVariant = this;
            synchronized (abstractVariant) {
                YoutubeBasicVariantStorable storable = new YoutubeBasicVariantStorable();
                storable.setId(this.getBaseVariant().name());
                storable.setData(MAPPER.objectToString(this.getGenericInfo()));
                ret = MAPPER.objectToString((Object)storable);
                this.storableString = Property.dedupeString(ret);
            }
        }
        return ret;
    }

    public static AbstractVariant get(DownloadLink downloadLink) {
        return AbstractVariant.get(downloadLink, true);
    }

    public static AbstractVariant get(DownloadLink downloadLink, boolean storeTempProperty) {
        String old;
        Object tmp;
        Object object = tmp = downloadLink.hasTempProperties() ? downloadLink.getTempProperties().getProperty("YT_VARIANT", null) : null;
        if (tmp != null && tmp instanceof AbstractVariant) {
            return (AbstractVariant)tmp;
        }
        AbstractVariant ret = AbstractVariant.get(downloadLink.getStringProperty("YT_VARIANT"));
        if (ret instanceof SubtitleVariant && (old = downloadLink.getStringProperty("YT_SUBTITLE_CODE")) != null) {
            if (old.length() == 2) {
                ((YoutubeSubtitleStorable)((SubtitleVariant)ret).getGenericInfo()).setLanguage(old);
                downloadLink.removeProperty("YT_SUBTITLE_CODE");
                YoutubeHelper.writeVariantToDownloadLink(downloadLink, ret);
            } else {
                try {
                    UrlQuery q = Request.parseQuery((String)old);
                    ((YoutubeSubtitleStorable)((SubtitleVariant)ret).getGenericInfo()).setBase(null);
                    ((YoutubeSubtitleStorable)((SubtitleVariant)ret).getGenericInfo()).setLanguage(q.get("lng"));
                    ((YoutubeSubtitleStorable)((SubtitleVariant)ret).getGenericInfo()).setSourceLanguage(q.get("src"));
                    ((YoutubeSubtitleStorable)((SubtitleVariant)ret).getGenericInfo()).setKind(q.get("kind"));
                    downloadLink.removeProperty("YT_SUBTITLE_CODE");
                    YoutubeHelper.writeVariantToDownloadLink(downloadLink, ret);
                }
                catch (Throwable e) {
                    throw new WTFException(e);
                }
            }
        }
        if (ret != null && storeTempProperty) {
            downloadLink.getTempProperties().setProperty("YT_VARIANT", ret);
        }
        return ret;
    }

    public abstract String getFileNamePattern(DownloadLink var1);

    public void setGenericInfo(Data genericInfo) {
        this.storableString = null;
        this.genericInfo = genericInfo;
    }

    public Data getGenericInfo() {
        return this.genericInfo;
    }

    public static AbstractVariant get(VariantBase base) {
        return AbstractVariant.get(base, null, null, null, null);
    }

    public static AbstractVariant get(VariantBase base, YoutubeClipData vid, List<YoutubeStreamData> audio, List<YoutubeStreamData> video, List<YoutubeStreamData> data) {
        AbstractVariant v = AbstractVariant.get(base.name());
        if (v != null) {
            v.fill(vid, audio, video, data);
            return v;
        }
        return null;
    }

    protected abstract void fill(YoutubeClipData var1, List<YoutubeStreamData> var2, List<YoutubeStreamData> var3, List<YoutubeStreamData> var4);

    private static String dupeid(AbstractVariant var) {
        StringBuilder sb = new StringBuilder();
        sb.append(var.getGroup().name()).append("_");
        sb.append(var.getContainer().name()).append("_");
        if (var instanceof VideoVariant) {
            VideoVariant vvar = (VideoVariant)var;
            sb.append(vvar.getProjection().name()).append("_");
            sb.append(vvar.getVideoResolution().name()).append("_");
            sb.append(vvar.getVideoCodec().name()).append("_");
            sb.append(vvar.getiTagVideo().getVideoFrameRate().name()).append("_");
        }
        if (var instanceof AudioInterface) {
            AudioInterface avar = (AudioInterface)((Object)var);
            sb.append(avar.getAudioBitrate().name()).append("_");
            sb.append(avar.getAudioCodec().name()).append("_");
            String audioid = avar.getAudioId();
            if (audioid != null) {
                sb.append(avar).append("_");
            }
        }
        if (var instanceof ImageVariant) {
            sb.append(var.getBaseVariant().name()).append("_");
        }
        if (var instanceof DescriptionVariant) {
            sb.append(var.getBaseVariant().name()).append("_");
        }
        if (var instanceof SubtitleVariant) {
            sb.append(var.getBaseVariant().name()).append("_");
        }
        return sb.toString();
    }

    public static List<AbstractVariant> listVariants() {
        if (VARIANTS_LIST != null) {
            return Collections.unmodifiableList(VARIANTS_LIST);
        }
        ArrayList<AbstractVariant> sorted = new ArrayList<AbstractVariant>();
        HashSet<String> dupes = new HashSet<String>();
        for (VariantBase b : VariantBase.values()) {
            AbstractVariant var = AbstractVariant.get(b);
            if (var == null) continue;
            if (dupes.add(AbstractVariant.dupeid(var))) {
                sorted.add(var);
            }
            if (!(var instanceof VideoVariant) || ((GenericVideoInfo)((VideoVariant)var).getGenericInfo()).getProjection() != Projection.NORMAL) continue;
            var = AbstractVariant.get(b);
            ((GenericVideoInfo)((VideoVariant)var).getGenericInfo()).setProjection(Projection.ANAGLYPH_3D);
            if (dupes.add(AbstractVariant.dupeid(var))) {
                sorted.add(var);
            }
            var = AbstractVariant.get(b);
            ((GenericVideoInfo)((VideoVariant)var).getGenericInfo()).setProjection(Projection.SPHERICAL);
            if (dupes.add(AbstractVariant.dupeid(var))) {
                sorted.add(var);
            }
            var = AbstractVariant.get(b);
            ((GenericVideoInfo)((VideoVariant)var).getGenericInfo()).setProjection(Projection.SPHERICAL_3D);
            if (!dupes.add(AbstractVariant.dupeid(var))) continue;
            sorted.add(var);
        }
        VARIANTS_LIST = sorted;
        return Collections.unmodifiableList(sorted);
    }

    public String getStandardGroupingID() {
        return this.getGroup().name();
    }

    public void setVariantInfo(VariantInfo variantInfo) {
        this.variantInfo = variantInfo;
    }

    public VariantInfo getVariantInfo() {
        return this.variantInfo;
    }

    static {
        MAPPER = new SimpleMapper(){

            protected JSonFactory newJsonFactory(String jsonString) {
                return new JSonFactory(jsonString){

                    protected String dedupeString(String string) {
                        return string;
                    }
                };
            }

            protected void initMapper() {
            }

            public boolean isPrettyPrintEnabled() {
                return false;
            }
        };
    }
}

