/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube.variants;

import jd.plugins.DownloadLink;
import org.appwork.exceptions.WTFException;
import org.appwork.utils.StringUtils;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.plugins.components.youtube.YoutubeConfig;
import org.jdownloader.plugins.components.youtube.variants.ImageVariant;
import org.jdownloader.plugins.components.youtube.variants.VariantBase;
import org.jdownloader.plugins.config.PluginJsonConfig;

public class ImagePlaylistCoverVariant
extends ImageVariant {
    public ImagePlaylistCoverVariant(VariantBase base) {
        super(base);
    }

    @Override
    public int getWidth() {
        switch (this.getBaseVariant()) {
            case PLAYLIST_COVER_HQ: {
                return 480;
            }
            case PLAYLIST_COVER_LQ: {
                return 120;
            }
            case PLAYLIST_COVER_MAX: {
                return 1280;
            }
            case PLAYLIST_COVER_MQ: {
                return 320;
            }
        }
        throw new WTFException("Unsupported:" + (Object)((Object)this.getBaseVariant()));
    }

    @Override
    public String getFileNamePattern(DownloadLink link) {
        YoutubeConfig cfg = PluginJsonConfig.get(YoutubeConfig.class);
        String playlistID = link.getStringProperty("YT_PLAYLIST_ID");
        String pattern = playlistID != null ? cfg.getPackagePatternForPlaylists() : cfg.getPackagePatternForChannelPackages();
        if (!StringUtils.endsWithCaseInsensitive((String)pattern, (String)".*EXT*")) {
            pattern = pattern + ".*EXT*";
        }
        return pattern;
    }

    @Override
    public String _getName(Object caller) {
        return _GUI.T.Youtube_covervariant_name(this.getBaseVariant().getiTagData().getImageQuality().getLocaleName());
    }

    @Override
    public String getFileNameQualityTag() {
        return this.getBaseVariant().getiTagData().getImageQuality().getLocaleTag();
    }

    @Override
    public int getHeight() {
        switch (this.getBaseVariant()) {
            case PLAYLIST_COVER_HQ: {
                return 360;
            }
            case PLAYLIST_COVER_LQ: {
                return 90;
            }
            case PLAYLIST_COVER_MAX: {
                return 720;
            }
            case PLAYLIST_COVER_MQ: {
                return 180;
            }
        }
        throw new WTFException("Unsupported:" + (Object)((Object)this.getBaseVariant()));
    }
}

