/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube.variants;

import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import jd.plugins.DownloadLink;
import org.appwork.storage.JSonStorage;
import org.appwork.utils.StringUtils;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.plugins.components.youtube.YoutubeClipData;
import org.jdownloader.plugins.components.youtube.YoutubeConfig;
import org.jdownloader.plugins.components.youtube.YoutubeStreamData;
import org.jdownloader.plugins.components.youtube.variants.AbstractVariant;
import org.jdownloader.plugins.components.youtube.variants.VariantBase;
import org.jdownloader.plugins.components.youtube.variants.YoutubeSubtitleStorable;
import org.jdownloader.plugins.components.youtube.variants.generics.AbstractGenericVariantInfo;
import org.jdownloader.plugins.config.PluginJsonConfig;

public class SubtitleVariant
extends AbstractVariant<YoutubeSubtitleStorable> {
    public SubtitleVariant(YoutubeSubtitleStorable si) {
        this();
        this.setGenericInfo(si);
    }

    public SubtitleVariant() {
        super(VariantBase.SUBTITLES);
    }

    @Override
    public String _getUniqueId() {
        return ((YoutubeSubtitleStorable)this.getGenericInfo())._getUniqueId();
    }

    @Override
    public String createAdvancedName() {
        String ret = "SUBTITLE " + (((YoutubeSubtitleStorable)this.getGenericInfo())._getLocale() == null ? ((YoutubeSubtitleStorable)this.getGenericInfo()).getLanguage() : ((YoutubeSubtitleStorable)this.getGenericInfo())._getLocale().getDisplayName(Locale.ENGLISH));
        if (StringUtils.isNotEmpty((String)((YoutubeSubtitleStorable)this.getGenericInfo()).getKind())) {
            ret = ret + ", Kind " + ((YoutubeSubtitleStorable)this.getGenericInfo()).getKind();
        }
        if (StringUtils.isNotEmpty((String)((YoutubeSubtitleStorable)this.getGenericInfo()).getSourceLanguage())) {
            ret = ret + ", Source " + ((YoutubeSubtitleStorable)this.getGenericInfo()).getSourceLanguage();
        }
        return ret;
    }

    @Override
    public void setJson(String jsonString) {
        this.setGenericInfo((AbstractGenericVariantInfo)JSonStorage.restoreFromString((String)jsonString, YoutubeSubtitleStorable.TYPE));
    }

    @Override
    protected void fill(YoutubeClipData vid, List<YoutubeStreamData> audio, List<YoutubeStreamData> video, List<YoutubeStreamData> data) {
    }

    @Override
    public Icon _getIcon(Object caller) {
        return this.getGroup().getIcon(18);
    }

    @Override
    public String toString() {
        return this._getName(null);
    }

    @Override
    public String getFileNamePattern(DownloadLink downloadLink) {
        return PluginJsonConfig.get(YoutubeConfig.class).getSubtitleFilenamePattern();
    }

    @Override
    public String _getName(Object caller) {
        if (this.getGenericInfo() == null || StringUtils.isEmpty((String)((YoutubeSubtitleStorable)this.getGenericInfo()).getLanguage())) {
            return _GUI.T.YoutubeBasicVariant_getLabel_subtitles();
        }
        StringBuilder sb = new StringBuilder();
        if (((YoutubeSubtitleStorable)this.getGenericInfo())._isTranslated()) {
            sb.append(_GUI.T.lit_translated());
        }
        if (((YoutubeSubtitleStorable)this.getGenericInfo())._isSpeechToText()) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(_GUI.T.lit_speedtotext());
        }
        Locale locale = ((YoutubeSubtitleStorable)this.getGenericInfo())._getLocale();
        if (sb.length() == 0) {
            return _GUI.T.YoutubeDash_getName_subtitles_(locale == null ? ((YoutubeSubtitleStorable)this.getGenericInfo()).getLanguage() : locale.getDisplayName());
        }
        return _GUI.T.YoutubeDash_getName_subtitles_annotated(locale == null ? ((YoutubeSubtitleStorable)this.getGenericInfo()).getLanguage() : locale.getDisplayName(), sb.toString());
    }

    public String getDisplayLanguage() {
        Locale locale = ((YoutubeSubtitleStorable)this.getGenericInfo())._getLocale();
        if (locale != null) {
            return locale.getDisplayLanguage();
        }
        return null;
    }

    @Override
    public String getFileNameQualityTag() {
        return this.getDisplayLanguage();
    }

    @Override
    public String getTypeId() {
        return this._getUniqueId();
    }

    public String getLanguageCode() {
        Locale locale = ((YoutubeSubtitleStorable)this.getGenericInfo())._getLocale();
        if (locale != null) {
            return locale.getLanguage();
        }
        return null;
    }
}

