/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube.variants;

import org.jdownloader.plugins.components.youtube.StreamCollection;
import org.jdownloader.plugins.components.youtube.YoutubeStreamData;
import org.jdownloader.plugins.components.youtube.variants.AbstractVariant;

public class VariantInfo
implements Comparable<VariantInfo> {
    private final AbstractVariant variant;
    final StreamCollection audioStream;
    final StreamCollection videoStream;
    public String special = "";
    final StreamCollection dataStreams;

    public StreamCollection getAudioStreams() {
        return this.audioStream;
    }

    public StreamCollection getVideoStreams() {
        return this.videoStream;
    }

    public StreamCollection getDataStreams() {
        return this.dataStreams;
    }

    public String toString() {
        return this.variant.toString();
    }

    public boolean isValid() {
        if (this.variant == null) {
            return false;
        }
        if (this.variant.getBaseVariant() == null) {
            return false;
        }
        if (this.variant.getBaseVariant().getiTagAudio() != null && (this.audioStream == null || this.audioStream.size() == 0)) {
            return false;
        }
        if (this.variant.getBaseVariant().getiTagVideo() != null && (this.videoStream == null || this.videoStream.size() == 0)) {
            return false;
        }
        return this.variant.getBaseVariant().getiTagData() == null || this.dataStreams != null && this.dataStreams.size() != 0;
    }

    public VariantInfo(AbstractVariant v, StreamCollection audio, StreamCollection video, StreamCollection data) {
        this.variant = v;
        this.audioStream = audio;
        this.videoStream = video;
        this.dataStreams = data;
        v.setVariantInfo(this);
    }

    public AbstractVariant getVariant() {
        return this.variant;
    }

    @Override
    public int compareTo(VariantInfo o) {
        return this.variant.compareTo(o.variant);
    }

    public boolean hasDefaultSegmentsStream() {
        StreamCollection audio = this.getAudioStreams();
        if (audio != null && audio.size() > 0 && ((YoutubeStreamData)audio.get(0)).getSegments() != null) {
            return true;
        }
        StreamCollection video = this.getVideoStreams();
        return video != null && video.size() > 0 && ((YoutubeStreamData)video.get(0)).getSegments() != null;
    }
}

