/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube.variants;

import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import jd.plugins.DownloadLink;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.utils.DebugMode;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.extmanager.Log;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.plugins.components.youtube.Projection;
import org.jdownloader.plugins.components.youtube.YoutubeClipData;
import org.jdownloader.plugins.components.youtube.YoutubeConfig;
import org.jdownloader.plugins.components.youtube.YoutubeStreamData;
import org.jdownloader.plugins.components.youtube.itag.AudioBitrate;
import org.jdownloader.plugins.components.youtube.itag.AudioCodec;
import org.jdownloader.plugins.components.youtube.itag.AudioType;
import org.jdownloader.plugins.components.youtube.itag.VideoCodec;
import org.jdownloader.plugins.components.youtube.itag.VideoResolution;
import org.jdownloader.plugins.components.youtube.itag.YoutubeITAG;
import org.jdownloader.plugins.components.youtube.variants.AbstractVariant;
import org.jdownloader.plugins.components.youtube.variants.AudioInterface;
import org.jdownloader.plugins.components.youtube.variants.AudioVariant;
import org.jdownloader.plugins.components.youtube.variants.VariantBase;
import org.jdownloader.plugins.components.youtube.variants.VideoInterface;
import org.jdownloader.plugins.components.youtube.variants.generics.AbstractGenericVariantInfo;
import org.jdownloader.plugins.components.youtube.variants.generics.GenericVideoInfo;
import org.jdownloader.plugins.config.PluginJsonConfig;
import org.jdownloader.translate._JDT;

public class VideoVariant
extends AbstractVariant<GenericVideoInfo>
implements VideoInterface,
AudioInterface {
    protected String uniqueIDString = null;
    private static final Icon VIDEO = new AbstractIcon("video", 16);
    private static final String TYPE_ID_PATTERN = PluginJsonConfig.get(YoutubeConfig.class).getVariantNamePatternVideo();

    public VideoVariant(VariantBase base) {
        super(base);
    }

    @Override
    public String createAdvancedName() {
        switch (this.getProjection()) {
            case SPHERICAL: {
                return "360\u00b0 VR, " + super.createAdvancedName();
            }
            case ANAGLYPH_3D: {
                return "3D, " + super.createAdvancedName();
            }
            case SPHERICAL_3D: {
                return "360\u00b0 VR, 3D, " + super.createAdvancedName();
            }
        }
        return super.createAdvancedName();
    }

    @Override
    public void setJson(String jsonString) {
        this.setGenericInfo((AbstractGenericVariantInfo)JSonStorage.restoreFromString((String)jsonString, (TypeRef)new TypeRef<GenericVideoInfo>(){}));
    }

    @Override
    public synchronized String _getUniqueId() {
        if (this.uniqueIDString == null) {
            this.uniqueIDString = super._getUniqueId();
            String aId = ((GenericVideoInfo)this.getGenericInfo()).getaId();
            if (aId != null) {
                this.uniqueIDString = this.uniqueIDString + ".aid" + aId;
            }
            if (((GenericVideoInfo)this.getGenericInfo()).isDrc()) {
                this.uniqueIDString = this.uniqueIDString + ".drc";
            }
        }
        return this.uniqueIDString;
    }

    @Override
    public String _getName(Object caller) {
        String id = TYPE_ID_PATTERN;
        id = id.replace("*CONTAINER*", this.getBaseVariant().getContainer().name() + "");
        id = id.replace("*HEIGHT*", this.getVideoHeight() + "");
        id = id.replace("*FPS*", this.getVideoFrameRate() + "");
        id = id.replace("*AUDIO_CODEC*", this.getAudioCodec().getLabel() + "");
        id = id.replace("*VIDEO_CODEC*", (Object)((Object)this.getVideoCodec()) + "");
        id = id.replace("*AUDIO_BITRATE*", this.getAudioBitrate().getKbit() + "");
        id = id.replace("*LNG*", StringUtils.valueOrEmpty((String)AudioVariant.getAudioIdForPattern(this)));
        switch (this.getProjection()) {
            case SPHERICAL: {
                id = id.replace("*360*", "[360\u00b0]");
                id = id.replace("*3D*", "");
                break;
            }
            case ANAGLYPH_3D: {
                id = id.replace("*3D*", "[3D]");
                id = id.replace("*360*", "");
                break;
            }
            case SPHERICAL_3D: {
                id = id.replace("*3D*", "[3D]");
                id = id.replace("*360*", "[360\u00b0]");
                break;
            }
            default: {
                id = id.replace("*360*", "");
                id = id.replace("*3D*", "");
            }
        }
        switch (this.getiTagAudioOrVideoItagEquivalent().getAudioCodec()) {
            case AAC_SPATIAL: 
            case VORBIS_SPATIAL: 
            case OPUS_SPATIAL: {
                id = id.replace("*SPATIAL*", _JDT.T.YOUTUBE_surround());
                break;
            }
            default: {
                id = id.replace("*SPATIAL*", "");
            }
        }
        id = id.trim().replace(" - ", "-").replaceAll("[ ]+", " ");
        return id.trim();
    }

    @Override
    public String getTypeId() {
        String id = TYPE_ID_PATTERN;
        id = id.replace("*CONTAINER*", this.getBaseVariant().getContainer().name() + "");
        id = id.replace("*HEIGHT*", this.getVideoHeight() + "");
        id = id.replace("*FPS*", this.getVideoFrameRate() + "");
        id = id.replace("*AUDIO_CODEC*", (Object)((Object)this.getAudioCodec()) + "");
        id = id.replace("*VIDEO_CODEC*", (Object)((Object)this.getVideoCodec()) + "");
        id = id.replace("*AUDIO_BITRATE*", this.getAudioBitrate().getKbit() + "");
        id = id.replace("*LNG*", StringUtils.valueOrEmpty((String)this.getAudioId()));
        switch (this.getProjection()) {
            case SPHERICAL: {
                id = id.replace("*360*", "360\u00b0");
                id = id.replace("*3D*", "");
                break;
            }
            case ANAGLYPH_3D: {
                id = id.replace("*3D*", "3D");
                id = id.replace("*360*", "");
                break;
            }
            case SPHERICAL_3D: {
                id = id.replace("*3D*", "3D");
                id = id.replace("*360*", "360\u00b0");
                break;
            }
            default: {
                id = id.replace("*360*", "");
                id = id.replace("*3D*", "");
            }
        }
        switch (this.getiTagAudioOrVideoItagEquivalent().getAudioCodec()) {
            case AAC_SPATIAL: 
            case VORBIS_SPATIAL: 
            case OPUS_SPATIAL: {
                id = id.replace("*SURROUND*", "Spatial");
                break;
            }
            default: {
                id = id.replace("*SURROUND*", "");
            }
        }
        id = id.trim().replaceAll("\\s+", "_").toUpperCase(Locale.ENGLISH);
        return id;
    }

    public Projection getProjection() {
        return ((GenericVideoInfo)this.getGenericInfo()).getProjection();
    }

    @Override
    protected void fill(YoutubeClipData vid, List<YoutubeStreamData> audio, List<YoutubeStreamData> video, List<YoutubeStreamData> data) {
        if (vid != null) {
            ((GenericVideoInfo)this.getGenericInfo()).setProjection(vid.getProjection());
        }
        if (this.getBaseVariant().name().contains("_3D")) {
            ((GenericVideoInfo)this.getGenericInfo()).setProjection(Projection.ANAGLYPH_3D);
        }
        if (video != null) {
            for (YoutubeStreamData stream : video) {
                if (DebugMode.TRUE_IN_IDE_ELSE_FALSE && video.size() > 1) {
                    DebugMode.debugger();
                }
                if (stream.getHeight() > 0) {
                    ((GenericVideoInfo)this.getGenericInfo()).setHeight(stream.getHeight());
                }
                if (stream.getWidth() > 0) {
                    ((GenericVideoInfo)this.getGenericInfo()).setWidth(stream.getWidth());
                }
                if (stream.getFps() == null) continue;
                try {
                    int intf = Integer.parseInt(new Regex(stream.getFps(), "(\\d+)").getMatch(0));
                    ((GenericVideoInfo)this.getGenericInfo()).setFps(intf);
                }
                catch (Throwable e) {
                    Log.log((Throwable)e);
                }
            }
        }
        if (audio != null && vid != null) {
            for (YoutubeStreamData a : audio) {
                if (DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
                    if (audio.size() > 1) {
                        DebugMode.debugger();
                    } else if (((GenericVideoInfo)this.getGenericInfo()).getaId() != null && !StringUtils.equals((String)((GenericVideoInfo)this.getGenericInfo()).getaId(), (String)a.getLngId())) {
                        DebugMode.debugger();
                    } else if (((GenericVideoInfo)this.getGenericInfo()).isDrc() != a.isDrc()) {
                        DebugMode.debugger();
                    }
                }
                ((GenericVideoInfo)this.getGenericInfo()).setaId(a.getLngId());
                ((GenericVideoInfo)this.getGenericInfo()).setDrc(a.isDrc());
                if (a.getBitrate() <= 0 || vid.duration <= 0 || a.getContentLength() <= 0L) continue;
                long abr = 8L * a.getContentLength() / (1024L * (long)vid.duration / 1000L);
                ((GenericVideoInfo)this.getGenericInfo()).setaBitrate((int)abr);
                break;
            }
        }
    }

    @Override
    public int getVideoHeight() {
        int height = ((GenericVideoInfo)this.getGenericInfo()).getHeight();
        if (height < 3) {
            height = this.getiTagVideo().getVideoResolution().getHeight();
        }
        return height;
    }

    @Override
    public int getVideoFrameRate() {
        int fps = ((GenericVideoInfo)this.getGenericInfo()).getFps();
        if (fps < 3) {
            fps = (int)Math.ceil(this.getiTagVideo().getVideoFrameRate().getFps());
        }
        return fps;
    }

    @Override
    public Icon _getIcon(Object caller) {
        return VIDEO;
    }

    @Override
    public String getStandardGroupingID() {
        return this.getGroup().name() + "_" + this.getProjection().name();
    }

    @Override
    public String getFileNamePattern(DownloadLink downloadLink) {
        return PluginJsonConfig.get(YoutubeConfig.class).getVideoFilenamePattern();
    }

    @Override
    public String getFileNameQualityTag() {
        switch (this.getProjection()) {
            case SPHERICAL: {
                return this.getVideoHeight() + "p " + this.getVideoFrameRate() + "fps 360VR";
            }
            case ANAGLYPH_3D: {
                return this.getVideoHeight() + "p " + this.getVideoFrameRate() + "fps 3D";
            }
            case SPHERICAL_3D: {
                return this.getVideoHeight() + "p " + this.getVideoFrameRate() + "fps 360VR 3D";
            }
        }
        return this.getVideoHeight() + "p " + this.getVideoFrameRate() + "fps";
    }

    @Override
    public AudioCodec getAudioCodec() {
        return this.getiTagAudioOrVideoItagEquivalent().getAudioCodec();
    }

    @Override
    public AudioBitrate getAudioBitrate() {
        int bitRate = ((GenericVideoInfo)this.getGenericInfo()).getaBitrate();
        if (bitRate > 0) {
            return AudioBitrate.getByInt(bitRate);
        }
        return this.getiTagAudioOrVideoItagEquivalent().getAudioBitrate();
    }

    @Override
    public VideoCodec getVideoCodec() {
        YoutubeITAG itag = this.getiTagVideo();
        if (itag == null) {
            return null;
        }
        return itag.getVideoCodec();
    }

    @Override
    public VideoResolution getVideoResolution() {
        YoutubeITAG itag = this.getiTagVideo();
        if (itag == null) {
            return null;
        }
        return itag.getVideoResolution();
    }

    @Override
    public int getVideoWidth() {
        int width = ((GenericVideoInfo)this.getGenericInfo()).getWidth();
        if (width < 3) {
            width = this.getiTagVideo().getVideoResolution().getWidth();
        }
        return width;
    }

    @Override
    public YoutubeITAG getAudioITAG() {
        return this.getiTagAudioOrVideoItagEquivalent();
    }

    @Override
    public YoutubeITAG getVideoITAG() {
        return this.getiTagVideo();
    }

    @Override
    public String getAudioId() {
        return ((GenericVideoInfo)this.getGenericInfo()).getaId();
    }

    @Override
    public boolean isDrc() {
        return ((GenericVideoInfo)this.getGenericInfo()).isDrc();
    }

    @Override
    public AudioType getAudioType() {
        return AudioType.getAudioType(this);
    }

    @Override
    public Locale getAudioLocale() {
        return ((GenericVideoInfo)this.getGenericInfo())._getLocale();
    }
}

