/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube.variants;

import java.util.Locale;
import org.appwork.storage.Storable;
import org.appwork.storage.TypeRef;
import org.appwork.txtresource.TranslationFactory;
import org.appwork.utils.StringUtils;
import org.appwork.utils.encoding.URLEncode;
import org.jdownloader.plugins.components.youtube.variants.generics.AbstractGenericVariantInfo;

public class YoutubeSubtitleStorable
extends AbstractGenericVariantInfo
implements Storable {
    public static final TypeRef<YoutubeSubtitleStorable> TYPE = new TypeRef<YoutubeSubtitleStorable>(YoutubeSubtitleStorable.class){};
    private String language;
    private Locale locale;
    private int multi = -1;
    private String sourceLanguage;
    private String kind;
    private String base;
    private String fullUrl;
    private String name;

    public YoutubeSubtitleStorable() {
    }

    public boolean _isTranslated() {
        return StringUtils.isNotEmpty((String)this.sourceLanguage);
    }

    public int getMulti() {
        return this.multi;
    }

    public void setMulti(int multi) {
        this.multi = multi;
    }

    public Locale _getLocale() {
        return this.locale;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
        this.locale = TranslationFactory.stringToLocale((String)language);
    }

    public String getSourceLanguage() {
        return this.sourceLanguage;
    }

    public void setSourceLanguage(String sourceLanguage) {
        this.sourceLanguage = sourceLanguage;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public String getFullUrl() {
        return this.fullUrl;
    }

    public void setFullUrl(String fullUrl) {
        this.fullUrl = fullUrl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StringUtils.isEmpty((String)name) ? null : name;
    }

    public YoutubeSubtitleStorable(String base, String name, String language, String source, String kind) {
        this.base = base;
        this.setLanguage(language);
        this.sourceLanguage = source;
        this.kind = kind;
        this.name = name;
    }

    public String _getUrl() {
        String ret = this.getFullUrl();
        if (ret != null) {
            return ret;
        }
        StringBuilder url = new StringBuilder();
        url.append(this.base);
        if (StringUtils.isNotEmpty((String)this.sourceLanguage)) {
            url.append("&lang=").append(this.encode(this.sourceLanguage));
        }
        url.append("&lang=").append(this.encode(this.language));
        if (StringUtils.isNotEmpty((String)this.kind)) {
            url.append("&kind=").append(this.encode(this.kind));
        }
        if (StringUtils.isNotEmpty((String)this.name)) {
            url.append("&name=").append(this.encode(this.name));
        }
        return url.toString();
    }

    private String encode(String kind2) {
        return URLEncode.encodeRFC2396((String)kind2);
    }

    public String getKind() {
        return this.kind;
    }

    public String _getUniqueId() {
        if (this.language == null) {
            return null;
        }
        StringBuilder url = new StringBuilder();
        url.append("&lng=").append(this.encode(this.language));
        if (StringUtils.isNotEmpty((String)this.sourceLanguage)) {
            url.append("&src=").append(this.encode(this.sourceLanguage));
        }
        if (StringUtils.isNotEmpty((String)this.kind)) {
            url.append("&kind=").append(this.encode(this.kind));
        }
        if (StringUtils.isNotEmpty((String)this.name)) {
            url.append("&name=").append(this.encode(this.name));
        }
        return url.toString();
    }

    public boolean _isSpeechToText() {
        return this.kind != null && "asr".equalsIgnoreCase(this.kind);
    }
}

