/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.controller;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import jd.plugins.DecrypterPlugin;
import jd.plugins.HostPlugin;
import jd.plugins.Plugin;
import jd.plugins.PluginDependencies;
import jd.plugins.PluginForDecrypt;
import jd.plugins.PluginForHost;
import org.appwork.utils.DebugMode;
import org.appwork.utils.JVMVersion;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.plugins.controller.LazyPlugin;
import org.jdownloader.plugins.controller.LazyPluginClass;
import org.jdownloader.plugins.controller.PluginClassLoader;
import org.jdownloader.plugins.controller.PluginInfo;
import org.jdownloader.plugins.controller.PluginScannerFiles;
import org.jdownloader.plugins.controller.PluginScannerNIO;

public abstract class PluginController<T extends Plugin> {
    protected static final HashSet<String> IGNORELIST = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] getFileHashBytes(InputStream is, MessageDigest md, byte[] mdCache) throws IOException {
        try {
            md.reset();
            int n = 0;
            while ((n = is.read(mdCache)) >= 0) {
                if (n <= 0) continue;
                md.update(mdCache, 0, n);
            }
            byte[] byArray = md.digest();
            return byArray;
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable throwable) {}
        }
    }

    protected CHECK_RESULT checkForChanges(Map<Object, List<String>> dependenciesCache, PluginClassLoader.PluginClassLoaderChild classLoader, LazyPluginClass lazyPluginClass, long lastFileModification) throws Exception {
        if (lazyPluginClass.getLastModified() != lastFileModification) {
            return CHECK_RESULT.FAILED_LASTMODIFIED;
        }
        if (lazyPluginClass.getDependencies() != null) {
            if (dependenciesCache.containsKey(lazyPluginClass.getDependencies())) {
                return CHECK_RESULT.SUCCESSFUL_DEPENDENCIES;
            }
            Iterator<String> it = lazyPluginClass.getDependencies().iterator();
            while (it.hasNext()) {
                String revision;
                String className = it.next();
                Class<?> checkClazz = classLoader.loadClass(className);
                HostPlugin hostPlugin = checkClazz.getAnnotation(HostPlugin.class);
                if (hostPlugin != null) {
                    revision = hostPlugin.revision();
                } else {
                    DecrypterPlugin decrypterPlugin = checkClazz.getAnnotation(DecrypterPlugin.class);
                    if (decrypterPlugin != null) {
                        revision = decrypterPlugin.revision();
                    } else {
                        return CHECK_RESULT.FAILED_DEPENDENCIES;
                    }
                }
                if (StringUtils.equals((String)revision, (String)it.next())) continue;
                return CHECK_RESULT.FAILED_DEPENDENCIES;
            }
            dependenciesCache.put(lazyPluginClass.getDependencies(), lazyPluginClass.getDependencies());
            return CHECK_RESULT.SUCCESSFUL_DEPENDENCIES;
        }
        return CHECK_RESULT.SUCCESSFUL;
    }

    protected static byte[] getFileHashBytes(File arg, MessageDigest md, byte[] mdCache) throws IOException {
        if (arg == null || !arg.isFile()) {
            return null;
        }
        FileInputStream fis = new FileInputStream(arg);
        return PluginController.getFileHashBytes(fis, md, mdCache);
    }

    protected LinkedHashMap<Class<?>, String> getClassHierarchy(LinkedHashMap<Class<?>, String> dependencies, Class<? extends Plugin> clazz) {
        boolean hierarchyStart;
        if (dependencies == null) {
            hierarchyStart = true;
            dependencies = new LinkedHashMap();
        } else {
            hierarchyStart = false;
        }
        for (Class<? extends Plugin> currentClazz = clazz; currentClazz != null && !PluginForHost.class.equals(currentClazz) && !PluginForDecrypt.class.equals(currentClazz); currentClazz = currentClazz.getSuperclass()) {
            DecrypterPlugin decryptPlugin;
            if (dependencies.containsKey(currentClazz)) continue;
            HostPlugin hostPlugin = PluginForHost.class.isAssignableFrom(currentClazz) ? currentClazz.getAnnotation(HostPlugin.class) : null;
            DecrypterPlugin decrypterPlugin = decryptPlugin = PluginForDecrypt.class.isAssignableFrom(currentClazz) ? currentClazz.getAnnotation(DecrypterPlugin.class) : null;
            if (hostPlugin != null) {
                dependencies.put(currentClazz, hostPlugin.revision());
            } else if (decryptPlugin != null) {
                dependencies.put(currentClazz, decryptPlugin.revision());
            } else {
                dependencies.put(currentClazz, null);
            }
            PluginDependencies pluginDependencies = currentClazz.getAnnotation(PluginDependencies.class);
            if (pluginDependencies == null) continue;
            for (Class<? extends Plugin> dependency : pluginDependencies.dependencies()) {
                if (dependencies.containsKey(dependency)) continue;
                this.getClassHierarchy(dependencies, dependency);
            }
        }
        if (hierarchyStart) {
            dependencies.remove(clazz);
        }
        return dependencies;
    }

    protected List<String> getClassDependencies(Map<Object, List<String>> dependenciesCache, Class<? extends Plugin> clazz) throws Exception {
        LinkedHashMap<Class<?>, String> clazzHierarchy = this.getClassHierarchy(null, clazz);
        List<String> dependencies = new ArrayList<String>();
        for (Map.Entry<Class<?>, String> dependency : clazzHierarchy.entrySet()) {
            if (dependency.getValue() == null) continue;
            dependencies.add(dependency.getKey().getName());
            dependencies.add(dependency.getValue());
        }
        if (dependencies.size() > 0) {
            if (dependenciesCache.containsKey(dependencies)) {
                dependencies = dependenciesCache.get(dependencies);
            } else {
                dependenciesCache.put(dependencies, dependencies);
            }
        }
        if (dependencies.size() > 0) {
            return dependencies;
        }
        return null;
    }

    protected abstract PluginClassInfo<T> getPluginClassInfo(Map<Object, List<String>> var1, Class<T> var2) throws Exception;

    protected abstract String getPluginPath();

    protected List<PluginInfo<T>> scan(LogSource logger, List<? extends LazyPlugin<T>> pluginCache, AtomicLong lastFolderModification) throws Exception {
        if (DebugMode.TRUE_IN_IDE_ELSE_FALSE && lastFolderModification != null) {
            lastFolderModification.set(-1L);
        }
        if (JVMVersion.isMinimum((long)JVMVersion.JAVA_1_7)) {
            return new PluginScannerNIO(this).scan(logger, this.getPluginPath(), pluginCache, lastFolderModification);
        }
        return new PluginScannerFiles(this).scan(logger, this.getPluginPath(), pluginCache, lastFolderModification);
    }

    static {
        IGNORELIST.add("YoutubeDashConfigPanel");
        IGNORELIST.add("YoutubeHelper");
        IGNORELIST.add("K2SApi");
        IGNORELIST.add("antiDDoSForDecrypt");
        IGNORELIST.add("antiDDoSForHost");
    }

    public static enum CHECK_RESULT {
        FAILED_LASTMODIFIED,
        FAILED_DEPENDENCIES,
        SUCCESSFUL_DEPENDENCIES,
        SUCCESSFUL;


        public static boolean isSuccessFul(CHECK_RESULT result) {
            switch (result) {
                case SUCCESSFUL: 
                case SUCCESSFUL_DEPENDENCIES: {
                    return true;
                }
            }
            return false;
        }
    }

    public static class PluginClassInfo<T extends Plugin> {
        public byte[] sha256;
        public int interfaceVersion = -1;
        public long revision = -1L;
        public List<String> dependencies = null;
        public Class<T> clazz;
    }
}

