/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.controller;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import jd.SecondLevelLaunch;
import jd.plugins.Plugin;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.UniqueAlltimeID;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.plugins.controller.LazyPlugin;
import org.jdownloader.plugins.controller.LazyPluginClass;
import org.jdownloader.plugins.controller.PluginClassLoader;
import org.jdownloader.plugins.controller.PluginController;
import org.jdownloader.plugins.controller.PluginInfo;

public class PluginScannerNIO<T extends Plugin> {
    private static final boolean isJava16orOlder = Application.getJavaVersion() <= Application.JAVA16;
    private final PluginController<T> pluginController;

    protected PluginController<T> getPluginController() {
        return this.pluginController;
    }

    public PluginScannerNIO(PluginController<T> pluginController) {
        this.pluginController = pluginController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PluginInfo<T>> scan(LogSource logger, String hosterpath, List<? extends LazyPlugin<T>> pluginCache, AtomicLong lastFolderModification) throws Exception, OutOfMemoryError {
        DirectoryStream<Path> stream = null;
        ArrayList ret = new ArrayList();
        long timeStamp = System.currentTimeMillis();
        HashMap<Object, List<String>> dependenciesCache = new HashMap<Object, List<String>>();
        try {
            ArrayList<PluginInfo<T>> arrayList;
            long lastFolderModifiedScanStop;
            HashMap<String, ArrayList<LazyPlugin<T>>> lazyPluginClassMap;
            long lastFolderModifiedCheck = lastFolderModification != null ? lastFolderModification.get() : -1L;
            Path folder = Application.getRootByClass(SecondLevelLaunch.class, (String)hosterpath).toPath();
            long lastFolderModifiedScanStart = Files.readAttributes(folder, BasicFileAttributes.class, new LinkOption[0]).lastModifiedTime().toMillis();
            if (pluginCache == null || pluginCache.size() == 0 || lastFolderModifiedCheck <= 0L) {
                logger.info("@PluginController(NIO): no plugin cache available|LastModified:" + lastFolderModifiedCheck);
            } else {
                boolean lastModifiedTimestampUnchanged;
                boolean bl = lastModifiedTimestampUnchanged = lastFolderModifiedScanStart == lastFolderModifiedCheck;
                if (lastModifiedTimestampUnchanged) {
                    try {
                        long l;
                        String uniqueID;
                        File file;
                        do {
                            uniqueID = UniqueAlltimeID.create();
                        } while ((file = new File(folder.toFile(), uniqueID)).exists());
                        IO.secureWrite((File)file, (String)uniqueID, (IO.SYNC)IO.SYNC.META_AND_DATA);
                        if (!file.delete()) {
                            file.deleteOnExit();
                        }
                        if ((l = Files.readAttributes(folder, BasicFileAttributes.class, new LinkOption[0]).lastModifiedTime().toMillis()) == lastFolderModifiedScanStart) {
                            logger.info("@PluginController(NIO): lastModified timestamp change test: failed");
                            lastModifiedTimestampUnchanged = false;
                        } else {
                            logger.info("@PluginController(NIO): lastModified timestamp change test: successful");
                            lastFolderModifiedScanStart = l;
                        }
                    }
                    catch (IOException e) {
                        logger.exception("@PluginController(NIO): lastModified timestamp change test: error", (Throwable)e);
                        lastModifiedTimestampUnchanged = false;
                    }
                }
                if (lastModifiedTimestampUnchanged) {
                    for (LazyPlugin<T> lazyPlugin : pluginCache) {
                        PluginInfo<T> pluginInfo = new PluginInfo<T>(lazyPlugin.getLazyPluginClass(), lazyPlugin);
                        ret.add(pluginInfo);
                    }
                    logger.info("@PluginController(NIO): plugin cache valid|Size:" + pluginCache.size() + "|LastModified:" + lastFolderModifiedScanStart);
                    if (lastFolderModification != null) {
                        lastFolderModification.set(lastFolderModifiedScanStart);
                    }
                    ArrayList e = ret;
                    return e;
                }
                logger.info("@PluginController(NIO): plugin cache invalid|Size:" + pluginCache.size() + "|LastModified:" + lastFolderModifiedScanStart);
            }
            String pkg = hosterpath.replace("/", ".");
            if (pluginCache != null && pluginCache.size() > 0) {
                lazyPluginClassMap = new HashMap<String, ArrayList<LazyPlugin<T>>>();
                for (LazyPlugin<T> lazyPlugin : pluginCache) {
                    ArrayList<LazyPlugin<T>> list = (ArrayList<LazyPlugin<T>>)lazyPluginClassMap.get(lazyPlugin.getLazyPluginClass().getClassName());
                    if (list == null) {
                        list = new ArrayList<LazyPlugin<T>>();
                        lazyPluginClassMap.put(lazyPlugin.getLazyPluginClass().getClassName(), list);
                    }
                    list.add(lazyPlugin);
                }
            } else {
                lazyPluginClassMap = null;
            }
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] byArray = new byte[Short.MAX_VALUE];
            PluginClassLoader.PluginClassLoaderChild cl = null;
            stream = Files.newDirectoryStream(folder, "*.class");
            for (Path path : stream) {
                try {
                    LazyPluginClass lazyPluginClass;
                    List lazyPlugins;
                    String pathFileName = path.getFileName().toString();
                    String className = pathFileName.substring(0, pathFileName.length() - 6);
                    if (className.indexOf("$") >= 0 || PluginController.IGNORELIST.contains(className)) continue;
                    if (cl == null || isJava16orOlder) {
                        cl = PluginClassLoader.getInstance().getChild();
                        cl.setMapStaticFields(false);
                    }
                    BasicFileAttributes pathAttr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                    long lastFileModification = pathAttr.lastModifiedTime().toMillis();
                    if (lazyPluginClassMap != null && (lazyPlugins = (List)lazyPluginClassMap.get(className)) != null && lazyPlugins.size() > 0) {
                        lazyPluginClass = ((LazyPlugin)lazyPlugins.get(0)).getLazyPluginClass();
                        try {
                            if (lazyPluginClass != null && PluginController.CHECK_RESULT.isSuccessFul(this.getPluginController().checkForChanges(dependenciesCache, cl, lazyPluginClass, lastFileModification))) {
                                for (LazyPlugin lazyPlugin : lazyPlugins) {
                                    PluginInfo pluginInfo = new PluginInfo(lazyPluginClass, lazyPlugin);
                                    ret.add(pluginInfo);
                                }
                                continue;
                            }
                        }
                        catch (Throwable e) {
                            logger.exception("Failed: " + className, e);
                        }
                    }
                    PluginController.PluginClassInfo<T> pluginClassInfo = null;
                    try {
                        Class<?> pluginClass = cl.loadClass(pkg + "." + className);
                        if (Modifier.isAbstract(pluginClass.getModifiers()) || !Plugin.class.isAssignableFrom(pluginClass) || (pluginClassInfo = this.getPluginController().getPluginClassInfo(dependenciesCache, pluginClass)) == null) continue;
                        pluginClassInfo.sha256 = PluginController.getFileHashBytes(path.toFile(), messageDigest, byArray);
                    }
                    catch (OutOfMemoryError e) {
                        logger.exception("Failed: " + className, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        logger.exception("Failed: " + className, e);
                        continue;
                    }
                    lazyPluginClass = new LazyPluginClass(className, pluginClassInfo.sha256, lastFileModification, pluginClassInfo.interfaceVersion, pluginClassInfo.revision, pluginClassInfo.dependencies);
                    PluginInfo pluginInfo = new PluginInfo(lazyPluginClass, pluginClassInfo.clazz);
                    ret.add(pluginInfo);
                }
                catch (OutOfMemoryError e) {
                    logger.exception("Failed: " + path, (Throwable)e);
                    throw e;
                }
                catch (Throwable e) {
                    logger.exception("Failed: " + path, e);
                }
            }
            if (stream != null) {
                stream.close();
            }
            if (lastFolderModifiedScanStart != (lastFolderModifiedScanStop = Files.readAttributes(folder, BasicFileAttributes.class, new LinkOption[0]).lastModifiedTime().toMillis())) {
                logger.info("@PluginController(NIO): folder modification during scan detected!LastModified:" + lastFolderModifiedScanStart + "!=" + lastFolderModifiedScanStop);
                Thread.sleep(1000L);
                arrayList = this.scan(logger, hosterpath, pluginCache, lastFolderModification);
                return arrayList;
            }
            if (lastFolderModification != null) {
                lastFolderModification.set(lastFolderModifiedScanStop);
            }
            arrayList = ret;
            return arrayList;
        }
        finally {
            logger.info("@PluginController(NIO): scan took " + (System.currentTimeMillis() - timeStamp) + "ms for " + ret.size());
            if (stream != null) {
                stream.close();
            }
        }
    }
}

