/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.controller.crawler;

import jd.plugins.PluginForDecrypt;
import org.jdownloader.DomainInfo;
import org.jdownloader.plugins.controller.LazyPlugin;
import org.jdownloader.plugins.controller.LazyPluginClass;
import org.jdownloader.plugins.controller.PluginClassLoader;
import org.jdownloader.plugins.controller.UpdateRequiredClassNotFoundException;

public class LazyCrawlerPlugin
extends LazyPlugin<PluginForDecrypt> {
    private volatile long decrypts = 0L;
    private volatile long decryptsRuntime = 0L;
    private volatile long averageRuntime = 0L;
    private volatile long pluginUsage = 0L;
    private int maxConcurrentInstances = Integer.MAX_VALUE;
    private boolean hasConfig = false;
    private String configInterface = null;
    private String[] sitesSupported = null;

    public LazyCrawlerPlugin(LazyPluginClass lazyPluginClass, String pattern, String displayName, Class<PluginForDecrypt> pluginClass, PluginClassLoader.PluginClassLoaderChild classLoaderChild) {
        super(lazyPluginClass, pattern, displayName, pluginClass, classLoaderChild);
    }

    public long getPluginUsage() {
        return this.decrypts + this.pluginUsage;
    }

    public void setPluginUsage(long pluginUsage) {
        this.pluginUsage = Math.max(0L, pluginUsage);
    }

    public boolean isHasConfig() {
        return this.hasConfig;
    }

    public String getHost() {
        return this.getDisplayName();
    }

    @Override
    protected void setFeatures(LazyPlugin.FEATURE[] features) {
        super.setFeatures(features);
    }

    @Override
    public String getClassName() {
        return "jd.plugins.decrypter.".concat(this.getLazyPluginClass().getClassName());
    }

    protected void setHasConfig(boolean hasConfig) {
        this.hasConfig = hasConfig;
    }

    public String getConfigInterface() {
        return this.configInterface;
    }

    public void setConfigInterface(String configInterface) {
        this.configInterface = configInterface;
    }

    public long getAverageCrawlRuntime() {
        return this.averageRuntime;
    }

    public String[] getSitesSupported() {
        String[] sitesSupported = this.sitesSupported;
        if (sitesSupported != null) {
            return sitesSupported;
        }
        return new String[]{this.getHost()};
    }

    protected void setSitesSupported(String[] sitesSupported) {
        this.sitesSupported = sitesSupported == null || sitesSupported.length == 0 ? null : (sitesSupported.length == 1 && this.getHost().equals(sitesSupported[0]) ? null : sitesSupported);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCrawlRuntime(long r) {
        LazyCrawlerPlugin lazyCrawlerPlugin = this;
        synchronized (lazyCrawlerPlugin) {
            ++this.decrypts;
            if (r >= 0L) {
                this.decryptsRuntime += r;
            }
            this.averageRuntime = this.decryptsRuntime / this.decrypts;
        }
    }

    @Override
    public DomainInfo getDomainInfo() {
        return DomainInfo.getInstance(this.getHost());
    }

    @Override
    public PluginForDecrypt newInstance(PluginClassLoader.PluginClassLoaderChild classLoader) throws UpdateRequiredClassNotFoundException {
        try {
            PluginForDecrypt ret = (PluginForDecrypt)super.newInstance(classLoader);
            ret.setLazyC(this);
            return ret;
        }
        catch (UpdateRequiredClassNotFoundException e) {
            this.setHasConfig(false);
            throw e;
        }
    }

    @Override
    public PluginForDecrypt getPrototype(PluginClassLoader.PluginClassLoaderChild classLoader) throws UpdateRequiredClassNotFoundException {
        try {
            PluginForDecrypt ret = (PluginForDecrypt)super.getPrototype(classLoader);
            ret.setLazyC(this);
            return ret;
        }
        catch (UpdateRequiredClassNotFoundException e) {
            this.setHasConfig(false);
            throw e;
        }
    }

    public int getMaxConcurrentInstances() {
        return this.maxConcurrentInstances;
    }

    public void setMaxConcurrentInstances(int maxConcurrentInstances) {
        this.maxConcurrentInstances = Math.max(1, maxConcurrentInstances);
    }

    @Override
    public PluginForDecrypt getPrototype(PluginClassLoader.PluginClassLoaderChild classLoader, boolean fallBackPlugin) throws UpdateRequiredClassNotFoundException {
        return this.getPrototype(classLoader);
    }

    @Override
    public PluginForDecrypt newInstance(PluginClassLoader.PluginClassLoaderChild classLoader, boolean fallBackPlugin) throws UpdateRequiredClassNotFoundException {
        return this.newInstance(classLoader);
    }
}

