/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.controller.host;

import jd.plugins.PluginForHost;
import org.jdownloader.DomainInfo;
import org.jdownloader.plugins.controller.LazyPlugin;
import org.jdownloader.plugins.controller.LazyPluginClass;
import org.jdownloader.plugins.controller.PluginClassLoader;
import org.jdownloader.plugins.controller.UpdateRequiredClassNotFoundException;
import org.jdownloader.plugins.controller.host.HostPluginController;

public class LazyHostPlugin
extends LazyPlugin<PluginForHost> {
    private String premiumUrl;
    private volatile byte properties = 0;
    private volatile long parsesLifetime = 0L;
    private volatile long parses = 0L;
    private volatile long parsesRuntime = 0L;
    private volatile long averageRuntime = 0L;
    private String[] sitesSupported = null;
    private String configInterface = null;

    public boolean isFallbackPlugin() {
        return "UpdateRequired".equalsIgnoreCase(this.getDisplayName());
    }

    public boolean isOfflinePlugin() {
        return this.getClassName().endsWith("r.Offline");
    }

    public long getPluginUsage() {
        return this.parsesLifetime + this.parses;
    }

    public void setPluginUsage(long pluginUsage) {
        this.parsesLifetime = Math.max(0L, pluginUsage);
    }

    public long getAverageParseRuntime() {
        return this.averageRuntime;
    }

    @Override
    protected void setFeatures(LazyPlugin.FEATURE[] features) {
        super.setFeatures(features);
    }

    public synchronized void updateParseRuntime(long r) {
        ++this.parses;
        if (r >= 0L) {
            this.parsesRuntime += r;
        }
        this.averageRuntime = this.parsesRuntime / this.parses;
    }

    @Override
    public String getClassName() {
        return "jd.plugins.hoster.".concat(this.getLazyPluginClass().getClassName());
    }

    public boolean isHasConfig() {
        return this.getProperty(PROPERTY.CONFIG);
    }

    protected void setHasConfig(boolean hasConfig) {
        this.setProperty(hasConfig, PROPERTY.CONFIG);
    }

    public String[] getSitesSupported() {
        String[] sitesSupported = this.sitesSupported;
        if (sitesSupported != null) {
            return sitesSupported;
        }
        return new String[]{this.getHost()};
    }

    protected void setSitesSupported(String[] sitesSupported) {
        this.sitesSupported = sitesSupported == null || sitesSupported.length == 0 ? null : (sitesSupported.length == 1 && this.getHost().equals(sitesSupported[0]) ? null : sitesSupported);
    }

    protected final synchronized void setProperty(boolean b, PROPERTY property) {
        this.properties = b ? (byte)(this.properties | 1 << property.ordinal()) : (byte)(this.properties & ~(1 << property.ordinal()));
    }

    protected final boolean getProperty(PROPERTY property) {
        return (this.properties & 1 << property.ordinal()) != 0;
    }

    public String getHost() {
        return this.getDisplayName();
    }

    public String getPremiumUrl() {
        return this.premiumUrl;
    }

    protected void setPremiumUrl(String premiumUrl) {
        this.premiumUrl = premiumUrl;
    }

    public boolean isPremium() {
        return this.getProperty(PROPERTY.PREMIUM);
    }

    protected void setPremium(boolean premium) {
        this.setProperty(premium, PROPERTY.PREMIUM);
    }

    public boolean isHasPremiumConfig() {
        return this.getProperty(PROPERTY.PREMIUM_CONFIG);
    }

    protected void setHasPremiumConfig(boolean premium) {
        this.setProperty(premium, PROPERTY.PREMIUM_CONFIG);
    }

    @Override
    public DomainInfo getDomainInfo() {
        return DomainInfo.getInstance(this.getHost());
    }

    public LazyHostPlugin(LazyPluginClass lazyPluginClass, String pattern, String displayName, Class<PluginForHost> pluginClass, PluginClassLoader.PluginClassLoaderChild classLoaderChild) {
        super(lazyPluginClass, pattern, displayName, pluginClass, classLoaderChild);
    }

    public String getConfigInterface() {
        return this.configInterface;
    }

    public void setConfigInterface(String configInterface) {
        this.configInterface = configInterface;
    }

    public void setHasAllowHandle(boolean hasAllowHandle) {
        this.setProperty(hasAllowHandle, PROPERTY.ALLOW);
    }

    public boolean isHasAllowHandle() {
        return this.getProperty(PROPERTY.ALLOW);
    }

    public void setHasRewrite(boolean hasRewrite) {
        this.setProperty(hasRewrite, PROPERTY.REWRITE);
    }

    public boolean isHasRewrite() {
        return this.getProperty(PROPERTY.REWRITE);
    }

    @Override
    public PluginForHost newInstance(PluginClassLoader.PluginClassLoaderChild classLoader, boolean fallBackPlugin) throws UpdateRequiredClassNotFoundException {
        try {
            PluginForHost ret = (PluginForHost)super.newInstance(classLoader);
            ret.setLazyP(this);
            return ret;
        }
        catch (UpdateRequiredClassNotFoundException e) {
            PluginForHost ret;
            LazyHostPlugin lFallBackPlugin = this.getFallBackPlugin();
            if (lFallBackPlugin != null && lFallBackPlugin != this && fallBackPlugin && (ret = lFallBackPlugin.newInstance(classLoader, fallBackPlugin)) != null) {
                ret.setLazyP(lFallBackPlugin);
                return ret;
            }
            throw e;
        }
    }

    @Override
    public PluginForHost newInstance(PluginClassLoader.PluginClassLoaderChild classLoader) throws UpdateRequiredClassNotFoundException {
        return this.newInstance(classLoader, true);
    }

    private LazyHostPlugin getFallBackPlugin() {
        if ("UpdateRequired".equalsIgnoreCase(this.getDisplayName())) {
            return null;
        }
        return HostPluginController.getInstance().getFallBackPlugin();
    }

    @Override
    public PluginForHost getPrototype(PluginClassLoader.PluginClassLoaderChild classLoader, boolean fallBackPlugin) throws UpdateRequiredClassNotFoundException {
        try {
            PluginForHost ret = (PluginForHost)super.getPrototype(classLoader);
            ret.setLazyP(this);
            return ret;
        }
        catch (UpdateRequiredClassNotFoundException e) {
            PluginForHost ret;
            LazyHostPlugin lFallBackPlugin = this.getFallBackPlugin();
            if (lFallBackPlugin != null && lFallBackPlugin != this && fallBackPlugin && (ret = lFallBackPlugin.getPrototype(classLoader, fallBackPlugin)) != null) {
                ret.setLazyP(lFallBackPlugin);
                return ret;
            }
            throw e;
        }
    }

    @Override
    public PluginForHost getPrototype(PluginClassLoader.PluginClassLoaderChild classLoader) throws UpdateRequiredClassNotFoundException {
        return this.getPrototype(classLoader, true);
    }

    private static enum PROPERTY {
        CONFIG,
        PREMIUM,
        PREMIUM_CONFIG,
        REWRITE,
        ALLOW;

    }
}

