/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.controller.host;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import jd.plugins.Account;
import jd.plugins.DownloadLink;
import jd.plugins.PluginForHost;
import org.appwork.utils.StringUtils;
import org.appwork.utils.UniqueAlltimeID;
import org.appwork.utils.logging2.LogInterface;
import org.jdownloader.logging.LogController;
import org.jdownloader.plugins.controller.LazyPlugin;
import org.jdownloader.plugins.controller.UpdateRequiredClassNotFoundException;
import org.jdownloader.plugins.controller.host.HostPluginController;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;

public class PluginFinder {
    private final HashMap<String, PluginForHost> pluginCaches = new HashMap();
    private Map<String, Object> hostMappings = new HashMap<String, Object>();
    private static volatile List<LazyHostPlugin> ASSIGN_PLUGINS = new ArrayList<LazyHostPlugin>();
    private static volatile Map<String, Object> HOST_MAPPINGS = new ConcurrentHashMap<String, Object>();
    private static final Set<String> BROKEN_PLUGINS = new HashSet<String>();
    private static final AtomicLong PLUGINSLASTMODIFICATION = new AtomicLong(-1L);
    private final LogInterface logger;
    private static final Object NULL = new Object();

    public PluginFinder() {
        this(null);
    }

    public PluginFinder(LogInterface logger) {
        this.logger = logger == null ? LogController.CL(true) : logger;
        this.updateCache();
    }

    public LogInterface getLogger() {
        return this.logger;
    }

    public List<LazyHostPlugin> listAssignPlugins() {
        return ASSIGN_PLUGINS;
    }

    protected synchronized void updateAssignPluginsCache() {
        ArrayList<LazyHostPlugin> ret = new ArrayList<LazyHostPlugin>();
        for (LazyHostPlugin lazyHostPlugin : HostPluginController.getInstance().list()) {
            if (!lazyHostPlugin.hasFeature(LazyPlugin.FEATURE.ASSIGN_PLUGIN)) continue;
            ret.add(lazyHostPlugin);
        }
        ASSIGN_PLUGINS = ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void blacklistBrokenPlugins() {
        Set<String> set = BROKEN_PLUGINS;
        synchronized (set) {
            String assignHost;
            BROKEN_PLUGINS.clear();
            String checkDomain = UniqueAlltimeID.create() + ".com";
            while ((assignHost = this.assignHost(checkDomain)) != null) {
                PluginForHost plugin = this.pluginCaches.get(assignHost);
                if (plugin != null) {
                    LazyHostPlugin lazyP = plugin.getLazyP();
                    this.logger.severe("Please fix rewriteHost in HostPlugin:" + lazyP);
                    BROKEN_PLUGINS.add(lazyP.toString());
                    continue;
                }
                this.logger.severe("Please fix rewriteHost in HostPlugin:" + assignHost);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCache() {
        AtomicLong atomicLong = PLUGINSLASTMODIFICATION;
        synchronized (atomicLong) {
            long lastmodification = HostPluginController.getInstance().getLastModification();
            if (PLUGINSLASTMODIFICATION.get() != lastmodification) {
                try {
                    HOST_MAPPINGS = new ConcurrentHashMap<String, Object>();
                    this.hostMappings = HOST_MAPPINGS;
                    this.updateAssignPluginsCache();
                    this.blacklistBrokenPlugins();
                }
                finally {
                    PLUGINSLASTMODIFICATION.set(lastmodification);
                }
            }
            this.hostMappings = HOST_MAPPINGS;
        }
    }

    public synchronized String assignHost(String host) {
        LazyHostPlugin ret = this._assignHost(host);
        if (ret != null) {
            return ret.getHost();
        }
        return null;
    }

    public synchronized PluginForHost getPlugin(LazyHostPlugin lazyPlugin) throws UpdateRequiredClassNotFoundException {
        PluginForHost plugin = this.pluginCaches.get(lazyPlugin.getHost());
        if (plugin == null) {
            plugin = lazyPlugin.getPrototype(null);
            this.pluginCaches.put(lazyPlugin.getHost(), plugin);
        }
        return plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized LazyHostPlugin _assignHost(String host) {
        if (host == null) {
            return null;
        }
        if (!this.hostMappings.containsKey(host)) {
            LazyHostPlugin lazyPlugin = HostPluginController.getInstance().get(host);
            if (lazyPlugin != null) {
                if (!lazyPlugin.isHasRewrite()) {
                    this.hostMappings.put(host, lazyPlugin);
                    return lazyPlugin;
                }
                try {
                    PluginForHost plugin = this.getPlugin(lazyPlugin);
                    String rewriteHost = plugin.rewriteHost(host);
                    if (StringUtils.equalsIgnoreCase((String)rewriteHost, (String)host)) {
                        this.hostMappings.put(host, lazyPlugin);
                        return lazyPlugin;
                    }
                    if (StringUtils.isNotEmpty((String)rewriteHost)) {
                        return this._assignHost(rewriteHost);
                    }
                }
                catch (Throwable e) {
                    this.logger.log(e);
                }
            }
            for (LazyHostPlugin lazyHostPlugin : HostPluginController.getInstance().list()) {
                if (!lazyHostPlugin.isHasRewrite()) continue;
                Set<String> set = BROKEN_PLUGINS;
                synchronized (set) {
                    if (BROKEN_PLUGINS.contains(lazyHostPlugin.toString())) {
                        continue;
                    }
                }
                try {
                    PluginForHost plugin = this.getPlugin(lazyHostPlugin);
                    String rewriteHost = plugin.rewriteHost(host);
                    if (StringUtils.equalsIgnoreCase((String)rewriteHost, (String)host)) {
                        this.hostMappings.put(host, lazyHostPlugin);
                        return lazyHostPlugin;
                    }
                    if (!StringUtils.isNotEmpty((String)rewriteHost)) continue;
                    return this._assignHost(rewriteHost);
                }
                catch (Throwable e) {
                    this.logger.log(e);
                }
            }
            this.hostMappings.put(host, NULL);
            this.logger.severe("Could not assign any host for: " + host);
            return null;
        }
        Object ret = this.hostMappings.get(host);
        if (ret instanceof LazyHostPlugin) {
            return (LazyHostPlugin)ret;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginForHost assign(DownloadLink link, PluginForHost pluginForHost) {
        LogInterface previousLogger = LogController.setRebirthLogger(this.logger);
        try {
            PluginForHost assigned = pluginForHost.assignPlugin(this, link);
            if (assigned != null) {
                try {
                    assigned.onPluginAssigned(link);
                }
                catch (Throwable e) {
                    this.logger.log(e);
                }
                PluginForHost pluginForHost2 = assigned;
                return pluginForHost2;
            }
            PluginForHost pluginForHost3 = null;
            return pluginForHost3;
        }
        catch (Throwable e) {
            this.logger.log(e);
            PluginForHost pluginForHost4 = null;
            return pluginForHost4;
        }
        finally {
            LogController.setRebirthLogger(previousLogger);
        }
    }

    public synchronized PluginForHost assignPlugin(DownloadLink link, boolean assignPlugin) {
        String host;
        LazyHostPlugin lazyHostPlugin = this._assignHost(link.getHost());
        if (lazyHostPlugin != null) {
            PluginForHost pluginForHost;
            host = lazyHostPlugin.getHost();
            if (this.pluginCaches.containsKey(host) && (pluginForHost = this.pluginCaches.get(host)) != null && (!assignPlugin || (pluginForHost = this.assign(link, pluginForHost)) != null)) {
                return pluginForHost;
            }
            try {
                pluginForHost = this.getPlugin(lazyHostPlugin);
                if (!assignPlugin || (pluginForHost = this.assign(link, pluginForHost)) != null) {
                    return pluginForHost;
                }
            }
            catch (Throwable e) {
                this.logger.log(e);
            }
        }
        host = link.getHost();
        try {
            LazyHostPlugin fallBackPlugin = HostPluginController.getInstance().getFallBackPlugin();
            if (fallBackPlugin != null) {
                this.logger.severe("Assign fallBackPlugin for: " + link.getHost() + ">" + host + "=" + link.getName());
                PluginForHost pluginForHost = this.getPlugin(fallBackPlugin);
                if (!assignPlugin || (pluginForHost = this.assign(link, pluginForHost)) != null) {
                    return pluginForHost;
                }
            }
        }
        catch (Throwable e) {
            this.logger.log(e);
        }
        this.logger.severe("Could not assign any plugin for link: " + link.getHost() + ">" + host + "=" + link.getName());
        return null;
    }

    public synchronized PluginForHost assignPlugin(Account acc, boolean assignPlugin) {
        block10: {
            LazyHostPlugin lazyHostPlugin = this._assignHost(acc.getHoster());
            if (lazyHostPlugin != null) {
                PluginForHost pluginForHost;
                String host = lazyHostPlugin.getHost();
                if (this.pluginCaches.containsKey(host) && (pluginForHost = this.pluginCaches.get(host)) != null && (pluginForHost.isPremiumEnabled() || pluginForHost.getLazyP().isOfflinePlugin())) {
                    try {
                        if (!assignPlugin || pluginForHost.assignPlugin(acc)) {
                            return pluginForHost;
                        }
                    }
                    catch (Throwable e) {
                        this.logger.log(e);
                    }
                }
                try {
                    if (lazyHostPlugin == null || !lazyHostPlugin.isPremium() && !lazyHostPlugin.isOfflinePlugin()) break block10;
                    pluginForHost = this.getPlugin(lazyHostPlugin);
                    try {
                        if (!assignPlugin || pluginForHost.assignPlugin(acc)) {
                            return pluginForHost;
                        }
                    }
                    catch (Throwable e) {
                        this.logger.log(e);
                    }
                }
                catch (Throwable e) {
                    this.logger.log(e);
                }
            }
        }
        this.logger.severe("Could not assign any plugin for account: " + acc.getHoster() + "|" + acc.getUser());
        return null;
    }
}

