/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.premium;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jd.plugins.PluginForHost;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtTextArea;
import org.appwork.utils.images.IconIO;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.jdownloader.DomainInfo;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.NewTheme;
import org.jdownloader.plugins.controller.UpdateRequiredClassNotFoundException;
import org.jdownloader.plugins.controller.host.HostPluginController;
import org.jdownloader.premium.BuyAndAddPremiumAccount;

public class PremiumInfoDialog
extends AbstractDialog<Object> {
    private final DomainInfo info;
    private final String id;

    public PremiumInfoDialog(DomainInfo hosterInfo, String title, String id) {
        super(0, title, null, _GUI.T.PremiumInfoDialog_layoutDialogContent_interested(), _GUI.T.literall_no_thanks());
        this.info = hosterInfo;
        this.id = id;
    }

    protected Object createReturnValue() {
        return null;
    }

    protected void setReturnmask(boolean b) {
        super.setReturnmask(b);
        if (b) {
            this.dispose();
            BuyAndAddPremiumAccount buyAndAddPremiumAccount = new BuyAndAddPremiumAccount(this.info, this.id);
            buyAndAddPremiumAccount.getOpenURLAction().actionPerformed(null);
            buyAndAddPremiumAccount.show();
        }
    }

    protected boolean isResizable() {
        return true;
    }

    protected void layoutDialog() {
        final Image back = NewTheme.I().hasIcon("fav/footer." + this.info.getTld()) ? NewTheme.I().getImage("fav/footer." + this.info.getTld(), -1) : null;
        super.layoutDialog();
        this.getDialog().setContentPane((Container)new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g;
                if (back != null) {
                    double faktor = Math.max((double)back.getWidth(null) / (double)this.getWidth(), (double)back.getHeight(null) / (double)this.getHeight());
                    int width = Math.max((int)((double)back.getWidth(null) / faktor), 1);
                    int height = Math.max((int)((double)back.getHeight(null) / faktor), 1);
                    g2.drawImage(back, 0, this.getHeight() - height, width, this.getHeight(), 0, 0, back.getWidth(null), back.getHeight(null), this.getBackground(), null);
                }
            }
        });
    }

    public JComponent layoutDialogContent() {
        JComponent plgPanel;
        PluginForHost plg = null;
        try {
            plg = HostPluginController.getInstance().get(this.info.getTld()).getPrototype(null);
        }
        catch (UpdateRequiredClassNotFoundException e) {
            LoggerFactory.getDefaultLogger().log((Throwable)e);
        }
        if (plg != null && (plgPanel = plg.layoutPremiumInfoPanel(this)) != null) {
            return plgPanel;
        }
        MigPanel ret = new MigPanel("ins 0,wrap 2", "[][grow,fill]", "[]");
        ret.setOpaque(false);
        this.getDialog().setIconImage((Image)IconIO.toBufferedImage((Icon)this.info.getFavIcon()));
        ExtTextArea explain = new ExtTextArea();
        explain.setLabelMode(true);
        explain.setText(this.getDescription(this.info));
        int h = explain.getPreferredSize().height;
        Icon icon = this.info.getIcon(h);
        if (icon != null) {
            ret.add((Component)new JLabel(icon), (Object)"aligny top,gapright 10");
        }
        ret.add((Component)explain, (Object)"spanx");
        JLabel lbl = new JLabel(_GUI.T.PremiumInfoDialog_layoutDialogContent_advantages_header());
        ret.add((Component)SwingUtils.toBold((JLabel)lbl), (Object)"spanx,pushx,growx");
        ret.add(this.createAdvantages(), (Object)("spanx,gapleft " + (h - 24) + ", gaptop 10"));
        return ret;
    }

    protected String getDescription(DomainInfo info2) {
        return _GUI.T.PremiumInfoDialog_layoutDialogContent_explain(this.info.getTld());
    }

    private Component createAdvantages() {
        MigPanel advantages = new MigPanel("ins 0,wrap 2", "[]13[grow,fill]", "[]0[]0[]0[]0[]0[]0[]0[]0");
        advantages.setOpaque(false);
        advantages.add((Component)new JLabel(new AbstractIcon("speed", 24)));
        advantages.add((Component)new JLabel(_GUI.T.PremiumFeature_speed_()));
        advantages.add((Component)new JLabel(new AbstractIcon("batch", 24)));
        advantages.add((Component)new JLabel(_GUI.T.PremiumFeature_bandwidth_()));
        advantages.add((Component)new JLabel(new AbstractIcon("paralell", 24)));
        advantages.add((Component)new JLabel(_GUI.T.PremiumFeature_parallel_()));
        advantages.add((Component)new JLabel(new AbstractIcon("resume", 24)));
        advantages.add((Component)new JLabel(_GUI.T.PremiumFeature_resume_()));
        advantages.add((Component)new JLabel(new AbstractIcon("chunks", 24)));
        advantages.add((Component)new JLabel(_GUI.T.PremiumFeature_chunkload_()));
        advantages.add((Component)new JLabel(new AbstractIcon("wait", 24)));
        advantages.add((Component)new JLabel(_GUI.T.PremiumFeature_noWaittime_()));
        return advantages;
    }
}

