/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.scripting;

import java.util.concurrent.ConcurrentHashMap;
import org.appwork.utils.StringUtils;
import org.jdownloader.logging.LogController;
import org.jdownloader.scripting.JSShutterDelegate;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrapFactory;

public class JSRhinoPermissionRestricter {
    public static final ConcurrentHashMap<Thread, Boolean> TRUSTED_THREAD = new ConcurrentHashMap();
    public static final ConcurrentHashMap<Thread, JSShutterDelegate> THREAD_JSSHUTTER = new ConcurrentHashMap();

    public static void init() {
        try {
            ContextFactory.initGlobal((ContextFactory)new SandboxContextFactory());
            try {
                try {
                    Context cx = ContextFactory.getGlobal().enterContext();
                    cx.evaluateString((Scriptable)cx.initStandardObjects(), "java.lang.System.out.println('TEST')", "<cmd>", 1, null);
                }
                finally {
                    Context.exit();
                }
                throw new SecurityException("Could not install the sun.org.mozilla.javascript.internal Sandbox!");
            }
            catch (SandboxException e) {
                if (!StringUtils.startsWithCaseInsensitive((String)e.getMessage(), (String)"Security Violation:org")) {
                    throw e;
                }
            }
        }
        catch (Throwable e) {
            LogController.CL().log(e);
        }
    }

    public static class SandboxNativeJavaObject
    extends NativeJavaObject {
        private static final long serialVersionUID = -2783084485265910840L;

        public SandboxNativeJavaObject(Scriptable scope, Object javaObject, Class<?> staticType) {
            super(scope, javaObject, staticType);
        }

        public Object get(String name, Scriptable start) {
            if (name.equals("getClass")) {
                LogController.CL().severe("JS Security Exception:" + name + "|" + start);
                return NOT_FOUND;
            }
            return super.get(name, start);
        }
    }

    public static class SandboxWrapFactory
    extends WrapFactory {
        public Scriptable wrapAsJavaObject(Context cx, Scriptable scope, Object javaObject, Class staticType) {
            if (javaObject instanceof EcmaError) {
                LogController.CL().log((Throwable)((Exception)javaObject));
            }
            return new SandboxNativeJavaObject(scope, javaObject, staticType);
        }
    }

    public static class SandboxContextFactory
    extends ContextFactory {
        protected void observeInstructionCount(Context cx, int instructionCount) {
        }

        protected Object doTopCall(Callable callable, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            return super.doTopCall(callable, cx, scope, thisObj, args);
        }

        protected Context makeContext() {
            final MyContext cx = new MyContext();
            cx.setWrapFactory(new SandboxWrapFactory());
            cx.setClassShutter(new ClassShutter(){

                public boolean visibleToScripts(String className) {
                    JSShutterDelegate jsShutter;
                    Thread thread = Thread.currentThread();
                    boolean threadTrusted = TRUSTED_THREAD.containsKey(thread);
                    Boolean jsShutterResult = null;
                    if (thread instanceof JSShutterDelegate) {
                        jsShutterResult = ((JSShutterDelegate)((Object)thread)).isClassVisibleToScript(threadTrusted, className) ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    }
                    if ((jsShutter = THREAD_JSSHUTTER.get(thread)) != null) {
                        jsShutterResult = jsShutter.isClassVisibleToScript(threadTrusted, className) ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    }
                    if (jsShutterResult != null) {
                        return jsShutterResult;
                    }
                    if (threadTrusted) {
                        LogController.CL().severe("Trusted Thread Loads: " + className + "|Thread:" + thread);
                        return true;
                    }
                    if (className.startsWith("adapter")) {
                        return true;
                    }
                    if (className.startsWith("org.mozilla.javascript.ConsString")) {
                        return true;
                    }
                    if (className.startsWith("org.mozilla.javascript.JavaScriptException")) {
                        return true;
                    }
                    if (className.startsWith("org.mozilla.javascript.EvaluatorException")) {
                        return true;
                    }
                    if (className.equals("org.mozilla.javascript.EcmaError")) {
                        LogController.CL().severe("Javascript error occured");
                        return true;
                    }
                    throw new SandboxException(cx, thread, className, "Security Violation:" + className + "|Thread:" + thread);
                }
            });
            return cx;
        }

        public static class MyContext
        extends Context {
            private volatile long startTime = -1L;
        }
    }

    public static class SandboxException
    extends RuntimeException {
        private final Context cx;
        private final Thread thread;
        private final String className;

        public Context getContext() {
            return this.cx;
        }

        public Thread getThread() {
            return this.thread;
        }

        public String getClassName() {
            return this.className;
        }

        public SandboxException(Context cx, Thread thread, String className, String message) {
            super(message);
            this.cx = cx;
            this.thread = thread;
            this.className = className;
        }
    }
}

