/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.settings;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JFrame;
import jd.gui.swing.jdgui.JDownloaderMainFrame;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.storage.Storable;
import org.appwork.storage.TypeRef;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.SwingUtils;

public class FrameStatus
implements Storable {
    public static final TypeRef<FrameStatus> TYPE_REF = new TypeRef<FrameStatus>(){};
    private ExtendedState extendedState = ExtendedState.NORMAL;
    private int width = -1;
    private int height = -1;
    private int x = -1;
    private boolean visible = true;
    private int y = -1;
    private boolean silentShutdown = false;
    private String screenID = null;
    private boolean locationSet = false;
    private boolean focus = true;
    private boolean active = false;
    private long createTime = System.currentTimeMillis();

    public ExtendedState getExtendedState() {
        return this.extendedState;
    }

    public void setExtendedState(ExtendedState extendedState) {
        this.extendedState = extendedState;
    }

    public FrameStatus clone() {
        FrameStatus ret = new FrameStatus();
        ret.active = this.active;
        ret.createTime = this.createTime;
        ret.extendedState = this.extendedState;
        ret.focus = this.focus;
        ret.height = this.height;
        ret.locationSet = this.locationSet;
        ret.screenID = this.screenID;
        ret.silentShutdown = this.silentShutdown;
        ret.visible = this.visible;
        ret.width = this.width;
        ret.x = this.x;
        ret.y = this.y;
        return ret;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public boolean isLocationSet() {
        return this.locationSet;
    }

    public void setLocationSet(boolean locationSet) {
        this.locationSet = locationSet;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public boolean isSilentShutdown() {
        return this.silentShutdown;
    }

    public void setSilentShutdown(boolean silentShutdown) {
        this.silentShutdown = silentShutdown;
    }

    public boolean isFocus() {
        return this.focus;
    }

    public void setFocus(boolean focus) {
        this.focus = focus;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public long _getCreateTime() {
        return this.createTime;
    }

    public static FrameStatus create(JFrame mainFrame, FrameStatus ret) {
        if (ret == null) {
            ret = new FrameStatus();
        }
        try {
            ret.setScreenID(mainFrame.getGraphicsConfiguration().getDevice().getIDstring());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        Rectangle jdBounds = FrameStatus.fetchBoundsFromEDT(mainFrame);
        if (jdBounds == null) {
            return null;
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screens = ge.getScreenDevices();
        Rectangle jdRectange = new Rectangle(jdBounds);
        boolean isok = false;
        for (GraphicsDevice screen : screens) {
            Rectangle bounds = SwingUtils.getUsableScreenBounds((GraphicsDevice)screen);
            jdRectange.height = 30;
            Rectangle inter = jdRectange.intersection(bounds);
            if (inter.width <= 50 || inter.height < 16) continue;
            isok = true;
            break;
        }
        if (isok) {
            if (jdBounds.width > 100 || ret.width < 100) {
                ret.width = jdBounds.width;
            }
            if (jdBounds.height > 100 || ret.height < 100) {
                ret.height = jdBounds.height;
            }
            ret.x = jdBounds.x;
            ret.y = jdBounds.y;
            ret.locationSet = true;
        }
        ret.visible = mainFrame.isVisible();
        ShutdownRequest requ = ShutdownController.getInstance().getShutdownRequest();
        ret.silentShutdown = requ != null && requ.isSilent();
        ret.focus = mainFrame.hasFocus();
        ret.active = mainFrame.isActive();
        ExtendedState ext = ExtendedState.get(mainFrame);
        if (ext != null) {
            ret.extendedState = ext;
        }
        return ret;
    }

    private static Rectangle fetchBoundsFromEDT(final JFrame mainFrame) {
        return (Rectangle)new EDTHelper<Rectangle>(){

            public Rectangle edtRun() {
                try {
                    FrameStatus fs;
                    if (!mainFrame.isShowing() && !(mainFrame instanceof JDownloaderMainFrame)) {
                        return null;
                    }
                    if (!mainFrame.isShowing() && mainFrame instanceof JDownloaderMainFrame) {
                        FrameStatus fs2 = ((JDownloaderMainFrame)mainFrame).getLatestFrameStatus();
                        if (fs2 == null || !fs2.isVisible()) {
                            return null;
                        }
                        return new Rectangle(fs2.x, fs2.y, fs2.width, fs2.height);
                    }
                    Rectangle ret = new Rectangle();
                    ret.width = 30;
                    ret.height = 30;
                    if (mainFrame.getExtendedState() == 0) {
                        ret.width = mainFrame.getSize().width;
                        ret.height = mainFrame.getSize().height;
                    } else if (mainFrame instanceof JDownloaderMainFrame && (fs = ((JDownloaderMainFrame)mainFrame).getLatestFrameStatus()) != null && fs.isVisible()) {
                        ret.width = fs.width;
                        ret.height = fs.height;
                    }
                    if (mainFrame.isShowing() && mainFrame.getExtendedState() == 0) {
                        Point location = mainFrame.getLocationOnScreen();
                        ret.x = location.x;
                        ret.y = location.y;
                    } else if (mainFrame instanceof JDownloaderMainFrame && (fs = ((JDownloaderMainFrame)mainFrame).getLatestNormalState()) != null && fs.isVisible()) {
                        ret.x = fs.x;
                        ret.y = fs.y;
                    }
                    return ret;
                }
                catch (Exception e) {
                    return null;
                }
            }
        }.getReturnValue();
    }

    public String getScreenID() {
        return this.screenID;
    }

    public void setScreenID(String screenID) {
        this.screenID = screenID;
    }

    public static enum ExtendedState {
        NORMAL(0),
        ICONIFIED(1),
        MAXIMIZED_BOTH(6);

        private int id;

        private ExtendedState(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static ExtendedState get(JFrame mainFrame) {
            int actualState = mainFrame.getExtendedState();
            for (ExtendedState es : ExtendedState.values()) {
                if (es == NORMAL || (actualState & es.getId()) != es.getId()) continue;
                return es;
            }
            return NORMAL;
        }
    }
}

