/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.settings;

import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.KnownFolders;
import com.sun.jna.platform.win32.Shell32Util;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import jd.controlling.downloadcontroller.DownloadLinkCandidateSelector;
import jd.controlling.linkcollector.LinknameCleaner;
import org.appwork.storage.config.ConfigInterface;
import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.AbstractCustomValueGetter;
import org.appwork.storage.config.annotations.CustomValueGetter;
import org.appwork.storage.config.annotations.DefaultBooleanValue;
import org.appwork.storage.config.annotations.DefaultEnumValue;
import org.appwork.storage.config.annotations.DefaultFactory;
import org.appwork.storage.config.annotations.DefaultIntValue;
import org.appwork.storage.config.annotations.DefaultJsonObject;
import org.appwork.storage.config.annotations.DefaultLongValue;
import org.appwork.storage.config.annotations.DefaultOnNull;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.storage.config.annotations.RequiresRestart;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.appwork.storage.config.annotations.ValidatorFactory;
import org.appwork.storage.config.defaults.AbstractDefaultFactory;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.StringUtils;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.os.hardware.HardwareType;
import org.appwork.utils.os.hardware.HardwareTypeInterface;
import org.jdownloader.controlling.domainrules.DomainRule;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.settings.AutoDownloadStartOption;
import org.jdownloader.settings.CleanAfterDownloadAction;
import org.jdownloader.settings.DelayWriteMode;
import org.jdownloader.settings.IfFileExistsAction;
import org.jdownloader.settings.MirrorDetectionDecision;
import org.jdownloader.settings.UrlDisplayEntry;
import org.jdownloader.settings.UrlDisplayType;

public interface GeneralSettings
extends ConfigInterface {
    public static final int SOFT_MAX_DOWNLOADS = 20;
    public static final int HARD_MAX_DOWNLOADS = 40;

    @DefaultIntValue(value=10)
    @AboutConfig
    @SpinnerValidator(min=0L, max=120L)
    @DescriptionForConfigEntry(value="AutoStart Downloads will show a Countdown Dialog after Startup. Set the countdown time to 0 to remove this dialog. @see showCountdownonAutoStartDownloads")
    public int getAutoStartCountdownSeconds();

    public AutoDownloadStartOption getAutoStartDownloadOption();

    public String[] getBrowserCommandLine();

    @AboutConfig
    @DefaultEnumValue(value="AUTO")
    @DescriptionForConfigEntry(value="Delay writes to disk of background tasks")
    @RequiresRestart(value="A JDownloader Restart is Required")
    public DelayWriteMode getDelayWriteMode();

    public void setDelayWriteMode(DelayWriteMode var1);

    @AboutConfig
    @DefaultEnumValue(value="NEVER")
    @DescriptionForConfigEntry(value="Configure when finished links/packages should be automatically removed from downloadlist.")
    public CleanAfterDownloadAction getCleanupAfterDownloadAction();

    @AboutConfig
    @DefaultEnumValue(value="AUTO")
    public MirrorDetectionDecision getMirrorDetectionDecision();

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="Mirrordetection works caseinsensitive on filename")
    @RequiresRestart(value="A JDownloader Restart is Required")
    public boolean isForceMirrorDetectionCaseInsensitive();

    public void setForceMirrorDetectionCaseInsensitive(boolean var1);

    @AboutConfig
    @DefaultIntValue(value=10000)
    @SpinnerValidator(min=1L, max=10000L)
    @DescriptionForConfigEntry(value="Filesize must be x equal to be a mirror. 10000 = 100%")
    public int getMirrorDetectionFileSizeEquality();

    public void setMirrorDetectionFileSizeEquality(int var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Mirrordetection enforces verified filesizes!")
    public boolean isForceMirrorDetectionFileSizeCheck();

    public void setForceMirrorDetectionFileSizeCheck(boolean var1);

    public void setMirrorDetectionDecision(MirrorDetectionDecision var1);

    @AboutConfig
    @DefaultFactory(value=DefaultDownloadFolder.class)
    @CustomValueGetter(value=CustomDownloadFolderGetter.class)
    public String getDefaultDownloadFolder();

    @AboutConfig
    @DefaultLongValue(value=300000L)
    @DescriptionForConfigEntry(value="Waittime in ms if a Download HashCheck Failed")
    public long getDownloadHashCheckFailedRetryWaittime();

    @AboutConfig
    @DescriptionForConfigEntry(value="Download Speed limit in bytes.")
    @DefaultIntValue(value=51200)
    @SpinnerValidator(min=1L, max=0x7FFFFFFFL)
    public int getDownloadSpeedLimit();

    @AboutConfig
    @DescriptionForConfigEntry(value="If >0, JD will start additional downloads when total speed is below this value. unit is byte/s")
    @DefaultIntValue(value=0)
    @SpinnerValidator(min=0L, max=0x7FFFFFFFL)
    public int getAutoMaxDownloadsSpeedLimit();

    public void setAutoMaxDownloadsSpeedLimit(int var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="see AutoMaxDownloadsSpeedLimit, if >0, JD will auto start max x downloads.")
    @DefaultIntValue(value=5)
    @SpinnerValidator(min=0L, max=40L)
    public int getAutoMaxDownloadsSpeedLimitMaxDownloads();

    public void setAutoMaxDownloadsSpeedLimitMaxDownloads(int var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="see AutoMaxDownloadsSpeedLimit, minimum delay to wait after last started download. Unit is milliseconds.")
    @DefaultIntValue(value=10000)
    @SpinnerValidator(min=0L, max=0x7FFFFFFFL)
    public int getAutoMaxDownloadsSpeedLimitMinDelay();

    public void setAutoMaxDownloadsSpeedLimitMinDelay(int var1);

    @AboutConfig
    @DefaultLongValue(value=1800000L)
    @DescriptionForConfigEntry(value="Waittime in ms if a download temp unavailable failed")
    public long getDownloadTempUnavailableRetryWaittime();

    @AboutConfig
    @DefaultLongValue(value=3600000L)
    @DescriptionForConfigEntry(value="Waittime in ms if a download host unavailable failed")
    public long getDownloadHostUnavailableRetryWaittime();

    public void setDownloadHostUnavailableRetryWaittime(long var1);

    @AboutConfig
    @DefaultLongValue(value=900000L)
    public long getProxyHostBanTimeout();

    public void setProxyHostBanTimeout(long var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="flush download buffers after x ms")
    @DefaultIntValue(value=120000)
    public int getFlushBufferTimeout();

    @AboutConfig
    @DescriptionForConfigEntry(value="flush download buffers when x % full")
    @DefaultIntValue(value=80)
    @SpinnerValidator(min=1L, max=100L)
    public int getFlushBufferLevel();

    public void setFlushBufferLevel(int var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Force Jdownloader to always keep a certain amount of MB Diskspace free")
    @DefaultIntValue(value=128)
    @SpinnerValidator(min=0L, max=0x7FFFFFFFL)
    public int getForcedFreeSpaceOnDisk();

    @AboutConfig
    @DefaultEnumValue(value="ASK_FOR_EACH_FILE")
    public IfFileExistsAction getIfFileExistsAction();

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Allow unsafe filenames for file exists check")
    public boolean isAllowUnsafeFileNameForFileExistsCheck();

    public void setAllowUnsafeFileNameForFileExistsCheck(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="Allow cleanup of existing files")
    public boolean getCleanupFileExists();

    public void setCleanupFileExists(boolean var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="max buffer size for write operations in kb")
    @SpinnerValidator(min=100L, max=100480L)
    @DefaultIntValue(value=500)
    public int getMaxBufferSize();

    @AboutConfig
    @DescriptionForConfigEntry(value="http://jdownloader.org/knowledge/wiki/glossary/chunkload")
    @SpinnerValidator(min=1L, max=20L)
    @DefaultIntValue(value=1)
    public int getMaxChunksPerFile();

    @AboutConfig
    @DescriptionForConfigEntry(value="How often a Plugin restarts a download if download failed")
    @DefaultIntValue(value=3)
    @RequiresRestart(value="A JDownloader Restart is Required")
    public int getMaxPluginRetries();

    @AboutConfig
    @DescriptionForConfigEntry(value="How many downloads should JDownloader attempt to download at once? Global max limit is 20.")
    @SpinnerValidator(min=1L, max=20L)
    @DefaultIntValue(value=3)
    public int getMaxSimultaneDownloads();

    @AboutConfig
    @DescriptionForConfigEntry(value="How many downloads more than getMaxSimultaneDownloads should JDownloader download at once when forced?")
    @SpinnerValidator(min=1L, max=40L)
    @DefaultIntValue(value=5)
    public int getMaxForcedDownloads();

    public void setMaxForcedDownloads(int var1);

    @AboutConfig
    @DefaultIntValue(value=1)
    @SpinnerValidator(min=1L, max=40L)
    public int getMaxSimultaneDownloadsPerHost();

    @AboutConfig
    @DescriptionForConfigEntry(value="Pause Speed. in Pause Mode we limit speed to this value to keep connections open, but use hardly bandwidth")
    @DefaultIntValue(value=10240)
    @SpinnerValidator(min=0L, max=0x7FFFFFFFL)
    public int getPauseSpeed();

    @AboutConfig
    @DescriptionForConfigEntry(value="Penaltytime before a retry if JDownloader lost connection")
    @DefaultIntValue(value=300000)
    public int getWaittimeOnConnectionLoss();

    @AboutConfig
    @DescriptionForConfigEntry(value="Keep max X old lists on disk (DownloadList,Linkgrabber)")
    @DefaultIntValue(value=5)
    @SpinnerValidator(min=0L, max=20L)
    public int getKeepXOldLists();

    public void setKeepXOldLists(int var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Allows the user to copy single(!) 'protected' URLs which is not possible by default. This applies e.g. to URLs added via Click and Load or DLC containers.  See: https://support.jdownloader.org/Knowledgebase/Article/View/copy-view-added-urls")
    @DefaultBooleanValue(value=false)
    public boolean isCopySingleRealURL();

    public void setCopySingleRealURL(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isAutoOpenContainerAfterDownload();

    @AboutConfig
    @DescriptionForConfigEntry(value="If enabled, packagenames will be cleaned up of superfluous . and _ characters, and replaced with spaces. Plugins can override this setting. The setting 'FilenameReplaceMap' will still be active if you disable this setting!")
    @RequiresRestart(value="A JDownloader Restart is Required")
    @DefaultBooleanValue(value=false)
    public boolean isCleanUpPackagenames();

    public void setCleanUpPackagenames(boolean var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Returns mapping of common invalid characters as regular expression to be replaced inside filenames. This is used to try to avoid invalid download paths due to forbidden characters in filenames. Any characters which are invalid for file paths and remain after execution of these replacements will be removed by a generic replacement handling with underscores.")
    @DefaultJsonObject(value="{\":\":\";\",\"\\\\|\":\"\u00a6\",\"<\":\"[\",\">\":\"]\",\"/\":\"\u2044\",\"\\\\\\\\\":\"\u2216\",\"\\\\*\":\"#\",\"\\\\?\":\"\u00bf\",\"\\\"\":\"'\"}")
    @DefaultOnNull
    @ValidatorFactory(value=LinknameCleaner.ReplaceMapValidator.class)
    public Map<String, String> getFilenameReplaceMap();

    public void setFilenameReplaceMap(Map<String, String> var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Returns map of regular expressions which will be used to shorten filenames that are too long for the users' filesystem. Feel free to let this replace dots since the replacements of this map will not be applied to the file extension.")
    @DefaultJsonObject(value="{}")
    @DefaultOnNull
    @ValidatorFactory(value=LinknameCleaner.ReplaceMapValidator.class)
    public Map<String, String> getFilenameTooLongRegexReplaceMap();

    public void setFilenameTooLongRegexReplaceMap(Map<String, String> var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Returns mapping of common invalid characters as regular expression to be replaced inside package names. This is used to try to avoid invalid download paths due to forbidden characters in package names. Any characters which are invalid for file paths and remain after execution of these replacements will be removed by a generic replacement handling with underscores.")
    @DefaultJsonObject(value="{\":\":\";\",\"\\\\|\":\"\u00a6\",\"<\":\"[\",\">\":\"]\",\"/\":\"\u2044\",\"\\\\\\\\\":\"\u2216\",\"\\\\*\":\"#\",\"\\\\?\":\"\u00bf\",\"\\\"\":\"'\"}")
    @DefaultOnNull
    @ValidatorFactory(value=LinknameCleaner.ReplaceMapValidator.class)
    public Map<String, String> getPackagenameReplaceMap();

    public void setPackagenameReplaceMap(Map<String, String> var1);

    public boolean isClosedWithRunningDownloads();

    public boolean isConvertRelativePathsJDRoot();

    @AboutConfig
    public boolean isDownloadSpeedLimitEnabled();

    @AboutConfig
    @DescriptionForConfigEntry(value="Remember Speed Limiter enabled/disabled setting after restart. Note: not associated with pause mode.")
    @DefaultBooleanValue(value=true)
    public boolean isDownloadSpeedLimitRememberedEnabled();

    @AboutConfig
    @DescriptionForConfigEntry(value="Enables permanent RegEx search in bottom search bar in LinkGrabber and Downloadlist.")
    @DefaultBooleanValue(value=false)
    public boolean isFilterRegex();

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isHashCheckEnabled();

    @AboutConfig
    @SpinnerValidator(min=1L, max=20L)
    @RequiresRestart(value="A JDownloader Restart is Required")
    @DefaultIntValue(value=1)
    @DescriptionForConfigEntry(value="Allow up to x concurrent Download HashChecks")
    public int getMaxConcurrentHashChecks();

    @AboutConfig
    @DescriptionForConfigEntry(value="Retry when SFV/SRC check fails?")
    @DefaultBooleanValue(value=false)
    public boolean isHashRetryEnabled();

    @AboutConfig
    @DefaultBooleanValue(value=false)
    public boolean isMaxDownloadsPerHostEnabled();

    public boolean isShowCountdownonAutoStartDownloads();

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="Use available Accounts?")
    public boolean isUseAvailableAccounts();

    @AboutConfig
    @DefaultBooleanValue(value=false)
    public boolean isUseOriginalLastModified();

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isAutoSortChildrenEnabled();

    public void setAutoSortChildrenEnabled(boolean var1);

    public void setAutoOpenContainerAfterDownload(boolean var1);

    public void setAutoStartCountdownSeconds(int var1);

    @AboutConfig
    @DefaultEnumValue(value="ONLY_IF_EXIT_WITH_RUNNING_DOWNLOADS")
    public void setAutoStartDownloadOption(AutoDownloadStartOption var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="CommandLine to open a link in a browser. Use %s as wildcard for the url")
    public void setBrowserCommandLine(String[] var1);

    public void setCleanupAfterDownloadAction(CleanAfterDownloadAction var1);

    @DescriptionForConfigEntry(value="Is true, if jdownloader got closed with running downloads.")
    @DefaultBooleanValue(value=false)
    public void setClosedWithRunningDownloads(boolean var1);

    @DefaultBooleanValue(value=true)
    @AboutConfig
    @RequiresRestart(value="A JDownloader Restart is Required")
    @DescriptionForConfigEntry(value="Correct paths relative to JDownloader root")
    public void setConvertRelativePathsJDRoot(boolean var1);

    public void setDefaultDownloadFolder(String var1);

    public void setDownloadHashCheckFailedRetryWaittime(long var1);

    public void setDownloadSpeedLimit(int var1);

    public void setDownloadSpeedLimitEnabled(boolean var1);

    public void setDownloadSpeedLimitRememberedEnabled(boolean var1);

    public void setDownloadTempUnavailableRetryWaittime(long var1);

    public void setFilterRegex(boolean var1);

    public void setFlushBufferTimeout(int var1);

    public void setForcedFreeSpaceOnDisk(int var1);

    public void setHashCheckEnabled(boolean var1);

    public void setMaxConcurrentHashChecks(int var1);

    public void setHashRetryEnabled(boolean var1);

    public void setIfFileExistsAction(IfFileExistsAction var1);

    public void setMaxBufferSize(int var1);

    public void setMaxChunksPerFile(int var1);

    public void setMaxDownloadsPerHostEnabled(boolean var1);

    public void setMaxPluginRetries(int var1);

    public void setMaxSimultaneDownloads(int var1);

    public void setMaxSimultaneDownloadsPerHost(int var1);

    public void setPauseSpeed(int var1);

    @DefaultBooleanValue(value=true)
    @AboutConfig
    @DescriptionForConfigEntry(value="@see AutoStartCountdownSeconds")
    public void setShowCountdownonAutoStartDownloads(boolean var1);

    public void setUseAvailableAccounts(boolean var1);

    public void setUseOriginalLastModified(boolean var1);

    public void setWaittimeOnConnectionLoss(int var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Should JDownloader check free available diskspace before download starts?")
    @DefaultBooleanValue(value=true)
    public boolean isFreeSpaceCheckEnabled();

    public void setFreeSpaceCheckEnabled(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="Disable this option if you do not want to see the filename in a captchadialog")
    public boolean isShowFileNameInCaptchaDialogEnabled();

    public void setShowFileNameInCaptchaDialogEnabled(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="If Enabled, JDownloader will save the linkgrabber list when you exit jd, and restore it on next startup")
    public boolean isSaveLinkgrabberListEnabled();

    public void setSaveLinkgrabberListEnabled(boolean var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="When should JD create the final download directory?")
    @DefaultEnumValue(value="ON_DOWNLOAD_START")
    public CreateFolderTrigger getCreateFolderTrigger();

    public void setCreateFolderTrigger(CreateFolderTrigger var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isDeleteEmptySubFoldersAfterDeletingDownloadedFilesEnabled();

    public void setDeleteEmptySubFoldersAfterDeletingDownloadedFilesEnabled(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isSambaPrefetchEnabled();

    public void setSambaPrefetchEnabled(boolean var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Set a list of hostplugin names to ignore")
    @DefaultJsonObject(value="[]")
    public String[] getCrawlerHostPluginBlacklist();

    public void setCrawlerHostPluginBlacklist(String[] var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Set a list of crawlerplugin names to ignore")
    @DefaultJsonObject(value="[]")
    public String[] getCrawlerCrawlerPluginBlacklist();

    public void setCrawlerCrawlerPluginBlacklist(String[] var1);

    @AboutConfig
    @DefaultEnumValue(value="SKIP_FILE")
    public OnSkipDueToAlreadyExistsAction getOnSkipDueToAlreadyExistsAction();

    public void setOnSkipDueToAlreadyExistsAction(OnSkipDueToAlreadyExistsAction var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="If you experience tiny(betweeen 0 and 2 seconds) 'lags' when while working with JDownloader, try to disable this feature.")
    @DefaultBooleanValue(value=true)
    public boolean isWindowsJNAIdleDetectorEnabled();

    public void setWindowsJNAIdleDetectorEnabled(boolean var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Load balance free downloads over all possible connections")
    @DefaultEnumValue(value="DISABLED")
    public DownloadLinkCandidateSelector.ProxyBalanceMode getFreeProxyBalanceMode();

    public void setFreeProxyBalanceMode(DownloadLinkCandidateSelector.ProxyBalanceMode var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Setup Rules by Domain. Let us know if you use this feature and require a nicer User Interface. Description of maxChunks: -X = up to X chunks, 0 = unlimited chunks (according to global setting), > 1 = forced chunks e.g. 3 -> Force 3 chunks. Plugins' max chunks limits cannot be overridden with these rules!")
    @DefaultJsonObject(value="[{\"accountPattern\":\"myUsername\",\"domainPattern\":\".*jdownloader\\\\.org\",\"maxSimultanDownloads\":20,\"maxChunks\":0,\"allowToExceedTheGlobalLimit\":false,\"filenamePattern\":\"\\\\.png$\",\"enabled\":false}]")
    public ArrayList<DomainRule> getDomainRules();

    public void setDomainRules(ArrayList<DomainRule> var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Choose which type URLs will be used for 'Copy URL, Browser URL, Tables and Settings'. Valid fields: CONTAINER, CONTENT, CUSTOM, ORIGIN, REFERRER")
    public UrlDisplayEntry[] getUrlOrder();

    public void setUrlOrder(UrlDisplayEntry[] var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    public boolean isUseUrlOrderForMyJD();

    public void setUseUrlOrderForMyJD(boolean var1);

    @Deprecated
    public UrlDisplayType[] getUrlDisplayOrder();

    @Deprecated
    public void setUrlDisplayOrder(UrlDisplayType[] var1);

    @AboutConfig
    @DefaultLongValue(value=3600000L)
    @DescriptionForConfigEntry(value="[ms] Define how long an account should stay disabled if a \"temporarily disabled event\" occures (Like Download Quota reached)")
    public long getAccountTemporarilyDisabledDefaultTimeout();

    public void setAccountTemporarilyDisabledDefaultTimeout(long var1);

    @AboutConfig
    @RequiresRestart(value="A JDownloader Restart is Required")
    @DefaultIntValue(value=25)
    @DescriptionForConfigEntry(value="How many entries are allowed to be in the download destination quick selection. Set this to 0 to disable download destination history.")
    public int getDownloadDestinationHistoryLength();

    public void setDownloadDestinationHistoryLength(int var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="If the Download Destination of a packages changes (Merge packages, changed destination,...) JD will try to move or rename already downloaded files.")
    public boolean isMoveFilesIfDownloadDestinationChangesEnabled();

    public void setMoveFilesIfDownloadDestinationChangesEnabled(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="If the Download Destination of a packages changes (Merge packages, changed destination,...) JD will try to move or rename already downloaded files.")
    public boolean isRenameFilesIfDownloadLinkNameChangesEnabled();

    public void setRenameFilesIfDownloadLinkNameChangesEnabled(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="If Enabled, the linkgrabber will detect links that are already in the downloadlist")
    @RequiresRestart(value="A JDownloader Restart is Required")
    public boolean isDupeManagerEnabled();

    public void setDupeManagerEnabled(boolean var1);

    @AboutConfig
    @DefaultIntValue(value=10)
    @DescriptionForConfigEntry(value="How many history entries will be kept in the download links")
    public int getMaxDownloadLinkHistoryEntries();

    public void setMaxDownloadLinkHistoryEntries(int var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @RequiresRestart(value="A JDownloader Restart is Required")
    @DescriptionForConfigEntry(value="Enable shared memory state info.")
    public boolean isSharedMemoryStateEnabled();

    public void setSharedMemoryStateEnabled(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @RequiresRestart(value="A JDownloader Restart is Required")
    @DescriptionForConfigEntry(value="Prefer BouncyCastle for TLS")
    public boolean isPreferBouncyCastleForTLS();

    public void setPreferBouncyCastleForTLS(boolean var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Timeout for network problems")
    @SpinnerValidator(min=0L, max=1000000L)
    @DefaultIntValue(value=15000)
    @RequiresRestart(value="A JDownloader Restart is Required")
    @Deprecated
    public int getNetworkIssuesTimeout();

    public void setNetworkIssuesTimeout(int var1);

    @AboutConfig
    @DefaultLongValue(value=600000L)
    @DescriptionForConfigEntry(value="Waittime in ms if a Download had unknown IOException")
    @Deprecated
    public long getDownloadUnknownIOExceptionWaittime();

    public void setDownloadUnknownIOExceptionWaittime(long var1);

    public static enum OnSkipDueToAlreadyExistsAction implements LabelInterface
    {
        SKIP_FILE{

            public String getLabel() {
                return _GUI.T.OnSkipDueToAlreadyExistsAction_skip_file();
            }
        }
        ,
        SET_FILE_TO_SUCCESSFUL{

            public String getLabel() {
                return _GUI.T.OnSkipDueToAlreadyExistsAction_mark_successful();
            }
        }
        ,
        SET_FILE_TO_SUCCESSFUL_MIRROR{

            public String getLabel() {
                return _GUI.T.OnSkipDueToAlreadyExistsAction_mark_successful_mirror();
            }
        };

    }

    public static enum CreateFolderTrigger implements LabelInterface
    {
        ON_DOWNLOAD_START{

            public String getLabel() {
                return "When the download is attempted to be started";
            }
        }
        ,
        ON_LINKS_ADDED{

            public String getLabel() {
                return "When the links are added to the downloadlist";
            }
        };

    }

    public static class CustomDownloadFolderGetter
    extends AbstractCustomValueGetter<String> {
        String defaultFolder = null;

        public String getValue(KeyHandler<String> keyHandler, String value) {
            if (StringUtils.isEmpty((String)value)) {
                if (this.defaultFolder != null) {
                    return this.defaultFolder;
                }
                this.defaultFolder = new DefaultDownloadFolder().getDefaultValue((KeyHandler)keyHandler);
                return this.defaultFolder;
            }
            return value;
        }
    }

    public static class DefaultDownloadFolder
    extends AbstractDefaultFactory<String> {
        public String getDefaultValue(KeyHandler<String> keyHandler) {
            if (CrossSystem.isWindows()) {
                try {
                    String ret = Shell32Util.getKnownFolderPath((Guid.GUID)KnownFolders.FOLDERID_Downloads);
                    if (CrossSystem.isAbsolutePath((String)ret) && new File(ret).isDirectory()) {
                        return ret;
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            } else if (CrossSystem.isLinux()) {
                try {
                    HardwareTypeInterface hardwareType = HardwareType.getHardware();
                    if (hardwareType != null && HardwareTypeInterface.ID.SYNOLOGY.equals((Object)hardwareType.getHardwareType())) {
                        File folder;
                        String[] defaultFolders;
                        File root;
                        int volume;
                        for (volume = 1; volume <= 4; ++volume) {
                            root = new File("/volume" + volume);
                            if (!root.isDirectory()) continue;
                            for (String defaultFolder : defaultFolders = new String[]{"@download", "public"}) {
                                folder = new File(root, defaultFolder);
                                if (!folder.isDirectory()) continue;
                                return defaultFolder.toString();
                            }
                        }
                        for (volume = 1; volume <= 4; ++volume) {
                            root = new File("/volumeUSB" + volume);
                            if (!root.isDirectory()) continue;
                            for (String defaultFolder : defaultFolders = new String[]{"@download", "public"}) {
                                folder = new File(root, defaultFolder);
                                if (!folder.isDirectory()) continue;
                                return defaultFolder.toString();
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            return CrossSystem.getDefaultDownloadDirectory();
        }
    }
}

