/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.settings.advanced;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import jd.controlling.downloadcontroller.DownloadControllerConfig;
import jd.controlling.faviconcontroller.FavIconsConfig;
import jd.controlling.linkchecker.LinkCheckerConfig;
import jd.controlling.linkcrawler.LinkCrawlerConfig;
import org.appwork.storage.StorableValidatorIgnoresMissingSetter;
import org.appwork.storage.config.ConfigInterface;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DevConfig;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.Application;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.DefaultEvent;
import org.appwork.utils.logging2.LogConfig;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.swing.dialog.ExtFileSystemViewSettings;
import org.jdownloader.controlling.ffmpeg.FFmpegSetup;
import org.jdownloader.controlling.hosterrule.HosterRuleController;
import org.jdownloader.gui.notify.gui.CFG_BUBBLE;
import org.jdownloader.gui.shortcuts.ShortcutSettings;
import org.jdownloader.logging.LogController;
import org.jdownloader.plugins.components.containers.ContainerConfig;
import org.jdownloader.plugins.config.PluginJsonConfig;
import org.jdownloader.plugins.controller.PluginClassLoader;
import org.jdownloader.plugins.controller.crawler.CrawlerPluginController;
import org.jdownloader.plugins.controller.crawler.LazyCrawlerPlugin;
import org.jdownloader.plugins.controller.host.HostPluginController;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;
import org.jdownloader.settings.AccountSettings;
import org.jdownloader.settings.SoundSettings;
import org.jdownloader.settings.advanced.AdvancedConfigEntry;
import org.jdownloader.settings.advanced.AdvancedConfigEvent;
import org.jdownloader.settings.advanced.AdvancedConfigEventSender;
import org.jdownloader.settings.staticreferences.CFG_API;
import org.jdownloader.settings.staticreferences.CFG_CAPTCHA;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;
import org.jdownloader.settings.staticreferences.CFG_GUI;
import org.jdownloader.settings.staticreferences.CFG_LINKCOLLECTOR;
import org.jdownloader.settings.staticreferences.CFG_LINKFILTER;
import org.jdownloader.settings.staticreferences.CFG_LINKGRABBER;
import org.jdownloader.settings.staticreferences.CFG_MYJD;
import org.jdownloader.settings.staticreferences.CFG_PACKAGIZER;
import org.jdownloader.settings.staticreferences.CFG_RECONNECT;
import org.jdownloader.settings.staticreferences.CFG_SILENTMODE;
import org.jdownloader.updatev2.InternetConnectionSettings;
import org.jdownloader.updatev2.LastChanceSettings;
import org.jdownloader.updatev2.UpdateSettings;
import org.jdownloader.updatev2.gui.LAFOptions;

public class AdvancedConfigManager {
    private static final AdvancedConfigManager INSTANCE = new AdvancedConfigManager();
    private final Set<AdvancedConfigEntry> configInterfaces = new CopyOnWriteArraySet<AdvancedConfigEntry>();
    private final AdvancedConfigEventSender eventSender = new AdvancedConfigEventSender();
    private final LogSource logger = LogController.getInstance().getLogger(AdvancedConfigManager.class.getName());
    private final WeakHashMap<ConfigInterface, Object> knownInterfaces = new WeakHashMap();

    public static AdvancedConfigManager getInstance() {
        return INSTANCE;
    }

    private AdvancedConfigManager() {
        this.register(CFG_GENERAL.CFG);
        this.register(CFG_LINKFILTER.CFG);
        this.register(JsonConfig.create((String)"cfg/org.jdownloader.settings.InternetConnectionSettings", InternetConnectionSettings.class));
        this.register(CFG_MYJD.CFG);
        this.register(JsonConfig.create(AccountSettings.class));
        this.register(CFG_GUI.CFG);
        this.register(JsonConfig.create(LinkCheckerConfig.class));
        this.register(JsonConfig.create(LinkCrawlerConfig.class));
        this.register(JsonConfig.create(DownloadControllerConfig.class));
        this.register(CFG_LINKGRABBER.CFG);
        this.register(CFG_LINKCOLLECTOR.CFG);
        this.register(CFG_RECONNECT.CFG);
        this.register(CFG_API.CFG);
        this.register(CFG_PACKAGIZER.CFG);
        this.register(JsonConfig.create(FFmpegSetup.class));
        this.register(JsonConfig.create(LogConfig.class));
        this.register(JsonConfig.create(ShortcutSettings.class));
        this.register(JsonConfig.create(UpdateSettings.class));
        this.register(JsonConfig.create(LastChanceSettings.class));
        this.register(JsonConfig.create(ExtFileSystemViewSettings.class));
        this.register(JsonConfig.create(FavIconsConfig.class));
        this.register(JsonConfig.create(SoundSettings.class));
        this.register(JsonConfig.create(ContainerConfig.class));
        this.register(CFG_BUBBLE.CFG);
        this.register(CFG_CAPTCHA.CFG);
        this.register(CFG_SILENTMODE.CFG);
        if (!Application.isHeadless()) {
            try {
                this.register((ConfigInterface)LAFOptions.getInstance().getCfg());
            }
            catch (Exception e) {
                this.logger.log((Throwable)e);
            }
        }
    }

    public AdvancedConfigEventSender getEventSender() {
        return this.eventSender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ConfigInterface cf) {
        AdvancedConfigManager advancedConfigManager = this;
        synchronized (advancedConfigManager) {
            if (this.knownInterfaces.put(cf, this) != null) {
                return;
            }
        }
        this.logger.info("Register " + cf._getStorageHandler().getConfigInterface());
        for (KeyHandler m : cf._getStorageHandler().getKeyHandler()) {
            AdvancedConfigEntry configEntry = this.toConfigEntry(m, cf);
            if (configEntry == null) continue;
            this.configInterfaces.add(configEntry);
        }
        this.eventSender.fireEvent((DefaultEvent)new AdvancedConfigEvent(this, AdvancedConfigEvent.Types.UPDATED, cf));
    }

    private AdvancedConfigEntry toConfigEntry(KeyHandler<?> m, ConfigInterface cf) {
        if (!(m.getAnnotation(AboutConfig.class) == null || m.getAnnotation(DevConfig.class) != null && Application.isJared(null))) {
            if (m.getGetMethod() == null) {
                throw new RuntimeException("Getter for " + m.getKey() + " missing");
            }
            if (m.getSetMethod() == null && m.getAnnotation(StorableValidatorIgnoresMissingSetter.class) == null) {
                throw new RuntimeException("Setter for " + m.getKey() + " missing");
            }
            return new AdvancedConfigEntry(cf, m);
        }
        return null;
    }

    public List<AdvancedConfigEntry> listPluginsInterfaces() {
        AdvancedConfigEntry configEntry;
        Object cf;
        String ifName;
        HashSet<String> configInterfaces = new HashSet<String>();
        ArrayList<AdvancedConfigEntry> ret = new ArrayList<AdvancedConfigEntry>();
        PluginClassLoader.PluginClassLoaderChild pluginClassLoader = PluginClassLoader.getInstance().getChild();
        for (LazyHostPlugin hplg : HostPluginController.getInstance().list()) {
            ifName = hplg.getConfigInterface();
            if (!StringUtils.isNotEmpty((String)ifName) || !configInterfaces.add(ifName)) continue;
            try {
                cf = PluginJsonConfig.get(hplg, pluginClassLoader.loadClass(ifName));
                for (KeyHandler m : cf._getStorageHandler().getKeyHandler()) {
                    configEntry = this.toConfigEntry((KeyHandler<?>)m, (ConfigInterface)cf);
                    if (configEntry == null) continue;
                    ret.add(configEntry);
                }
            }
            catch (Throwable e) {
                this.logger.log(e);
            }
        }
        for (LazyCrawlerPlugin cplg : CrawlerPluginController.getInstance().list()) {
            ifName = cplg.getConfigInterface();
            if (!StringUtils.isNotEmpty((String)ifName) || !configInterfaces.add(ifName)) continue;
            try {
                cf = PluginJsonConfig.get(cplg, pluginClassLoader.loadClass(ifName));
                for (KeyHandler m : cf._getStorageHandler().getKeyHandler()) {
                    configEntry = this.toConfigEntry((KeyHandler<?>)m, (ConfigInterface)cf);
                    if (configEntry == null) continue;
                    ret.add(configEntry);
                }
            }
            catch (Throwable e) {
                this.logger.log(e);
            }
        }
        return ret;
    }

    public List<AdvancedConfigEntry> list() {
        ArrayList<AdvancedConfigEntry> ret = new ArrayList<AdvancedConfigEntry>(this.configInterfaces);
        ret.addAll(this.listPluginsInterfaces());
        return ret;
    }

    static {
        HosterRuleController.getInstance();
    }
}

