/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.settings.staticreferences;

import java.io.File;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.handler.BooleanKeyHandler;
import org.appwork.storage.config.handler.EnumKeyHandler;
import org.appwork.storage.config.handler.ListHandler;
import org.appwork.storage.config.handler.StorageHandler;
import org.appwork.storage.config.handler.StringKeyHandler;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.jdownloader.api.myjdownloader.MyJDownloaderSettings;
import org.jdownloader.logging.LogController;

public class CFG_MYJD {
    public static final MyJDownloaderSettings CFG = CFG_MYJD.initializeMyJDownloaderSettings();
    public static final StorageHandler<MyJDownloaderSettings> SH = CFG._getStorageHandler();
    public static final EnumKeyHandler LATEST_ERROR = (EnumKeyHandler)SH.getKeyHandler("LatestError", EnumKeyHandler.class);
    public static final StringKeyHandler UNIQUE_DEVICE_ID = (StringKeyHandler)SH.getKeyHandler("UniqueDeviceID", StringKeyHandler.class);
    public static final StringKeyHandler SERVER_HOST = (StringKeyHandler)SH.getKeyHandler("ServerHost", StringKeyHandler.class);
    public static final BooleanKeyHandler AUTO_CONNECT_ENABLED = (BooleanKeyHandler)SH.getKeyHandler("AutoConnectEnabledV2", BooleanKeyHandler.class);
    public static final StringKeyHandler PASSWORD = (StringKeyHandler)SH.getKeyHandler("Password", StringKeyHandler.class);
    public static final ListHandler<int[]> DEVICE_CONNECT_PORTS = (ListHandler)SH.getKeyHandler("DeviceConnectPorts", ListHandler.class);
    public static final StringKeyHandler DEVICE_NAME = (StringKeyHandler)SH.getKeyHandler("DeviceName", StringKeyHandler.class);
    public static final StringKeyHandler EMAIL = (StringKeyHandler)SH.getKeyHandler("Email", StringKeyHandler.class);

    private static final MyJDownloaderSettings initializeMyJDownloaderSettings() {
        MyJDownloaderSettings ret = (MyJDownloaderSettings)JsonConfig.create(MyJDownloaderSettings.class);
        try {
            StorageHandler sh;
            File file;
            if ((StringUtils.isEmpty((String)ret.getEmail()) || StringUtils.isEmpty((String)ret.getPassword())) && (file = new File((sh = ret._getStorageHandler()).getPath().getAbsolutePath() + ".json")).exists()) {
                String fileContent = IO.readFileToString((File)file).trim();
                String password = new Regex(fileContent, "\"password\"\\s*:\\s*\"(.*?)(\"(,\\s*\"|\\s*\\}$))").getMatch(0);
                String email = new Regex(fileContent, "\"email\"\\s*:\\s*\"(.*?)(\"(,\\s*\"|\\s*\\}$))").getMatch(0);
                if (email == null) {
                    email = new Regex(fileContent, "\"username\"\\s*:\\s*\"(.*?)(\"(,\\s*\"|\\s*\\}$))").getMatch(0);
                }
                if (StringUtils.isAllNotEmpty((String[])new String[]{password, email})) {
                    LogController.CL().info("Rescued 'MyJDownloader logins' from broken-/false escaped-json!");
                    ret.setEmail(email);
                    ret.setPassword(password);
                }
            }
        }
        catch (Throwable e) {
            LogController.CL().log(e);
        }
        return ret;
    }
}

