/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.startup;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.security.Security;
import jd.SecondLevelLaunch;
import jd.gui.swing.laf.LookAndFeelController;
import org.appwork.loggingv3.LogV3;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.JsonSerializer;
import org.appwork.storage.SimpleMapper;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.simplejson.JSonFactory;
import org.appwork.txtresource.TranslationFactory;
import org.appwork.utils.Application;
import org.appwork.utils.DebugMode;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogSourceRedirector;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.LAFManagerInterface;
import org.jdownloader.extensions.ExtensionController;
import org.jdownloader.myjdownloader.client.json.JSonHandler;
import org.jdownloader.myjdownloader.client.json.JsonFactoryInterface;
import org.jdownloader.myjdownloader.client.json.MyJDJsonMapper;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.startup.ParameterHandler;

public class Main {
    public static ParameterHandler PARAMETER_HANDLER = null;

    public static void checkLanguageSwitch(String[] args) {
        try {
            File language = Application.getResource((String)"cfg/language.json");
            String lng = null;
            if (language.isFile()) {
                lng = (String)JSonStorage.restoreFrom((File)language, (boolean)true, (byte[])JSonStorage.KEY, (TypeRef)TypeRef.STRING, (Object)TranslationFactory.getDesiredLanguage());
            }
            if (StringUtils.isEmpty(lng)) {
                lng = TranslationFactory.getDesiredLanguage();
            }
            TranslationFactory.setDesiredLanguage((String)lng);
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].equalsIgnoreCase("-translatortest")) continue;
                TranslationFactory.setDesiredLanguage((String)args[i + 1]);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void copySVNtoHome() {
        block9: {
            try {
                File svnEntriesFile;
                if ((Application.isJared(null) || Application.getRessourceURL((String)"org/jdownloader/update/JDUpdateClient.class") != null) && System.getProperty("copysvn") == null) break block9;
                File workspace = new File(Main.class.getResource("/").toURI()).getParentFile();
                if (workspace.getName().equals("JDownloaderUpdater")) {
                    workspace = new File(workspace.getParentFile(), "JDownloader");
                }
                if (!(svnEntriesFile = new File(workspace, ".svn/entries")).exists()) break block9;
                long lastMod = svnEntriesFile.lastModified();
                try {
                    lastMod = Long.parseLong(Regex.getLines((String)IO.readFileToString((File)svnEntriesFile))[3].trim());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                long lastUpdate = -1L;
                File lastSvnUpdateFile = Application.getResource((String)"dev/lastSvnUpdate");
                if (lastSvnUpdateFile.exists()) {
                    try {
                        lastUpdate = Long.parseLong(IO.readFileToString((File)lastSvnUpdateFile));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (lastMod > lastUpdate) {
                    Main.copyResource(workspace, "themes/themes", "themes");
                    Main.copyResource(workspace, "ressourcen/jd", "jd");
                    Main.copyResource(workspace, "ressourcen/tools", "tools");
                    Main.copyResource(workspace, "translations/translations", "translations");
                    File jdJar = Application.getResource((String)"JDownloader.jar");
                    jdJar.delete();
                    IO.copyFile((File)new File(workspace, "dev/JDownloader.jar"), (File)jdJar);
                    lastSvnUpdateFile.delete();
                    lastSvnUpdateFile.getParentFile().mkdirs();
                    IO.writeStringToFile((File)lastSvnUpdateFile, (String)(lastMod + ""));
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static void copyResource(File workspace, String from, String to) throws IOException {
        System.out.println("Copy SVN Resources " + new File(workspace, from) + " to " + Application.getResource((String)to));
        IO.copyFolderRecursive((File)new File(workspace, from), (File)Application.getResource((String)to), (boolean)true, (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.getAbsolutePath().contains(".svn")) {
                    return false;
                }
                System.out.println("Copy " + pathname);
                return true;
            }
        }, (IO.SYNC)IO.SYNC.NONE);
    }

    public static void main(String[] args) {
        Main.loadJXBrowser(Main.class.getClassLoader());
        JSonStorage.getMapper().putSerializer(JsonFactoryInterface.class, new JsonSerializer(){

            public String toJSonString(Object object, Object mapper) {
                return ((JsonFactoryInterface)object).toJsonString();
            }
        });
        MyJDJsonMapper.HANDLER = new JSonHandler<Type>(){
            final SimpleMapper mapper = new SimpleMapper(){

                protected JSonFactory newJsonFactory(String jsonString) {
                    return new JSonFactory(jsonString){

                        protected String dedupeString(String string) {
                            return string;
                        }
                    };
                }

                protected void initMapper() {
                    super.initMapper();
                    this.putSerializer(JsonFactoryInterface.class, new JsonSerializer(){

                        public String toJSonString(Object object, Object mapper) {
                            return ((JsonFactoryInterface)object).toJsonString();
                        }
                    });
                }

                public boolean isPrettyPrintEnabled() {
                    return false;
                }
            };

            @Override
            public String objectToJSon(Object payload) {
                return this.mapper.objectToString(payload);
            }

            @Override
            public <T> T jsonToObject(String dec, Type clazz) {
                if (dec == null || "".equals(dec)) {
                    return null;
                }
                return (T)this.mapper.stringToObject(dec, new TypeRef<T>(clazz){});
            }
        };
        Main.checkLanguageSwitch(args);
        try {
            if (CrossSystem.isWindows() && System.getProperty("sun.java2d.d3d") == null) {
                if (((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).isUseD3D()) {
                    System.setProperty("sun.java2d.d3d", "true");
                } else {
                    System.setProperty("sun.java2d.d3d", "false");
                    System.setProperty("sun.awt.nopixfmt", "true");
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        PARAMETER_HANDLER = new ParameterHandler();
        PARAMETER_HANDLER.onStartup(args);
        ExtensionController.getInstance().invalidateCacheIfRequired();
        SecondLevelLaunch.mainStart(args);
    }

    public static void loadJXBrowser(ClassLoader cl) {
        try {
            if (DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
                File lib;
                switch (CrossSystem.getOSFamily()) {
                    case LINUX: {
                        if (Application.is64BitJvm()) {
                            lib = Application.getResource((String)"libs/jxbrowser/jxbrowser-linux64.jar");
                            break;
                        }
                        lib = Application.getResource((String)"libs/jxbrowser/jxbrowser-linux32.jar");
                        break;
                    }
                    case WINDOWS: {
                        lib = Application.getResource((String)"libs/jxbrowser/jxbrowser-win.jar");
                        break;
                    }
                    case MAC: {
                        lib = Application.getResource((String)"libs/jxbrowser/jxbrowser-mac.jar");
                        break;
                    }
                    default: {
                        lib = null;
                    }
                }
                File jar = Application.getResource((String)"libs/jxbrowser/license.jar");
                if (jar.isFile()) {
                    Application.addUrlToClassPath((URL)jar.toURI().toURL(), (ClassLoader)cl);
                    if (lib != null && lib.isFile()) {
                        Application.addUrlToClassPath((URL)lib.toURI().toURL(), (ClassLoader)cl);
                    }
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static {
        if (System.getProperty("org.appwork.LoggerFactory") == null) {
            System.setProperty("org.appwork.LoggerFactory", LogSourceRedirector.class.getName());
        }
        if (System.getProperty("java.net.preferIPv6Addresses") == null) {
            System.setProperty("java.net.preferIPv6Addresses", "system");
        }
        Application.setApplication((String)".jd_home");
        String root = Application.getRoot(SecondLevelLaunch.class);
        LogV3.info((String)("Application Root: " + root));
        System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
        try {
            Security.setProperty("networkaddress.cache.negative.ttl", "0");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Main.copySVNtoHome();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        Dialog.getInstance().setLafManager((LAFManagerInterface)LookAndFeelController.getInstance());
    }
}

