/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.startup;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import jd.SecondLevelLaunch;
import org.appwork.app.launcher.parameterparser.CommandSwitch;
import org.appwork.app.launcher.parameterparser.ParameterParser;
import org.appwork.utils.Application;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.singleapp.InstanceMessageListener;
import org.appwork.utils.singleapp.Response;
import org.appwork.utils.singleapp.ResponseSender;
import org.jdownloader.logging.LogController;
import org.jdownloader.startup.StartupCommand;
import org.jdownloader.startup.commands.AbstractStartupCommand;
import org.jdownloader.startup.commands.AddContainerCommand;
import org.jdownloader.startup.commands.AddExtractionPasswordsCommand;
import org.jdownloader.startup.commands.AddLinkCommand;
import org.jdownloader.startup.commands.BRDebugCommand;
import org.jdownloader.startup.commands.DisableSysErr;
import org.jdownloader.startup.commands.FileCommand;
import org.jdownloader.startup.commands.GuiFocusCommand;
import org.jdownloader.startup.commands.GuiMinimizeCommand;
import org.jdownloader.startup.commands.HelpCommand;
import org.jdownloader.startup.commands.JACShowCommand;
import org.jdownloader.startup.commands.MyJDownloaderCommand;
import org.jdownloader.startup.commands.ReScanPluginsCommand;
import org.jdownloader.startup.commands.ReconnectCommand;
import org.jdownloader.startup.commands.SetConfigCommand;
import org.jdownloader.startup.commands.ThreadDump;
import org.jdownloader.updatev2.RestartController;

public class ParameterHandler
implements InstanceMessageListener {
    private final HashMap<String, StartupCommand> commandMap;
    private final LogSource logger = LogController.getInstance().getLogger("StartupParameterHandler");
    private final ArrayList<StartupCommand> commands;

    public ParameterHandler() {
        this.commandMap = new HashMap();
        this.commands = new ArrayList();
        this.addCommand(new AddContainerCommand());
        this.addCommand(new AddExtractionPasswordsCommand());
        this.addCommand(new AddLinkCommand());
        this.addCommand(new GuiFocusCommand());
        this.addCommand(new GuiMinimizeCommand());
        this.addCommand(new HelpCommand(this));
        this.addCommand(new JACShowCommand());
        this.addCommand(new ReconnectCommand());
        this.addCommand(new FileCommand());
        this.addCommand(new BRDebugCommand());
        this.addCommand(new ReScanPluginsCommand());
        this.addCommand(new MyJDownloaderCommand());
        this.addCommand(new DisableSysErr());
        this.addCommand(new SetConfigCommand());
        this.addCommand(new ThreadDump());
        this.addCommand(new AbstractStartupCommand(new String[]{"n"}){

            @Override
            public void run(String command, String ... parameters) {
            }

            @Override
            public String getDescription() {
                return "Force a new Instance.";
            }
        });
        this.addCommand(new AbstractStartupCommand(new String[]{"console"}){

            @Override
            public void run(String command, String ... parameters) {
            }

            @Override
            public String getDescription() {
                return "Write all Logs to STDOUt or STDERR";
            }
        });
    }

    private void addCommand(StartupCommand helpCommand) {
        for (String s : helpCommand.getCommandSwitches()) {
            if (this.commandMap.containsKey(s)) {
                throw new IllegalStateException("Command " + s + " already is used");
            }
            this.commandMap.put(s, helpCommand);
        }
        this.commands.add(helpCommand);
    }

    @Deprecated
    public void parseMessage(String[] args) {
        this.onIncommingMessage(null, args);
    }

    protected void execute(ParameterParser pp, boolean startup) {
        for (CommandSwitch cmd : pp.getList()) {
            StartupCommand command = this.commandMap.get(cmd.getSwitchCommand());
            if (command != null && (command.isRunningInstanceEnabled() || startup)) {
                command.run(cmd.getSwitchCommand(), cmd.getParameters());
                continue;
            }
            this.logger.warning("Invalid Command: " + cmd.getSwitchCommand() + " - " + Arrays.toString(cmd.getParameters()));
        }
    }

    public List<StartupCommand> getCommands() {
        return this.commands;
    }

    public void onStartup(String[] args) {
        this.logger.info("Startup: " + Arrays.toString(args));
        ParameterParser startupParameters = RestartController.getInstance().getParameterParser(args);
        try {
            startupParameters.parse((File)null);
        }
        catch (Throwable e) {
            this.logger.log(e);
        }
        this.execute(startupParameters, true);
        if (!startupParameters.hasCommandSwitch("console") && Application.isJared(SecondLevelLaunch.class)) {
            this.logger.info("Remove ConsoleHandler");
            LogController.getInstance().removeConsoleHandler();
        }
    }

    public void onIncommingMessage(ResponseSender callback, String[] message) {
        this.logger.info("Incomming Message: " + Arrays.toString(message));
        ParameterParser pp = new ParameterParser(message);
        try {
            pp.parse((File)null);
        }
        catch (Throwable e) {
            this.logger.log(e);
        }
        this.execute(pp, false);
        if (callback != null) {
            try {
                callback.sendResponse(new Response("PONG", "Received Message"));
            }
            catch (Exception e) {
                this.logger.log((Throwable)e);
            }
        }
    }
}

