/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.startup.commands;

import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.logging.LogController;
import org.jdownloader.startup.StartupCommand;

public abstract class AbstractStartupCommand
implements StartupCommand {
    protected final String[] commands;
    protected final LogSource logger;

    public AbstractStartupCommand(String ... commands) {
        this.commands = commands;
        this.logger = LogController.getFastPluginLogger(this.getClass().getName());
    }

    @Override
    public abstract void run(String var1, String ... var2);

    @Override
    public String[] getCommandSwitches() {
        return this.commands;
    }

    @Override
    public boolean isRunningInstanceEnabled() {
        return true;
    }

    @Override
    public String help() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.getCommandSwitches()) {
            if (sb.length() > 0) {
                sb.append("/");
            }
            if (!StringUtils.isNotEmpty((String)s)) continue;
            sb.append("-").append(s);
        }
        if (this.getParameterHelp() != null) {
            sb.append(" ").append(this.getParameterHelp());
        } else {
            sb.append("\t");
        }
        if (StringUtils.isNotEmpty((String)this.getDescription())) {
            sb.append(" ");
            sb.append(this.getDescription());
        }
        return sb.toString();
    }

    public abstract String getDescription();

    public String getParameterHelp() {
        return null;
    }
}

