/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.startup.commands;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import org.appwork.utils.Application;
import org.appwork.utils.formatter.SizeFormatter;
import org.jdownloader.startup.commands.AbstractStartupCommand;

public class ThreadDump
extends AbstractStartupCommand {
    public ThreadDump() {
        super("threaddump");
    }

    @Override
    public void run(String command, String ... parameters) {
        try {
            MemoryUsage memory = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
            if (memory != null) {
                StringBuilder sb = new StringBuilder();
                sb.append("HeapUsed:" + SizeFormatter.formatBytes((long)memory.getUsed()));
                sb.append("|HeapComitted:" + SizeFormatter.formatBytes((long)memory.getCommitted()));
                sb.append("|HeapMax:" + SizeFormatter.formatBytes((long)memory.getMax()));
                sb.append("\r\n");
                this.logger.severe(sb.toString());
            }
        }
        catch (Throwable e) {
            this.logger.log(e);
        }
        this.logger.severe(Application.getThreadDump());
        this.logger.flush();
    }

    @Override
    public String getDescription() {
        return "prints thread dump";
    }
}

