/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.utils;

import com.sun.jna.platform.mac.MacFileUtils;
import com.sun.jna.platform.win32.W32FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.appwork.utils.Files;
import org.appwork.utils.os.CrossSystem;

public class JDFileUtils
extends Files {
    private static final boolean supported = JDFileUtils.checkTrashSupported();

    private static boolean checkTrashSupported() {
        try {
            if (CrossSystem.isWindows()) {
                return W32FileUtils.getInstance().hasTrash();
            }
            if (CrossSystem.isMac()) {
                return MacFileUtils.getInstance().hasTrash();
            }
            return false;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isTrashSupported() {
        return supported;
    }

    public static void moveToTrash(File ... files) throws IOException {
        try {
            if (JDFileUtils.isTrashSupported()) {
                ArrayList<File> existing = new ArrayList<File>();
                FileNotFoundException exception = null;
                for (File file : files) {
                    if (!file.exists()) {
                        if (exception != null) continue;
                        exception = new FileNotFoundException(file.getAbsolutePath());
                        continue;
                    }
                    existing.add(file);
                }
                if (existing.size() > 0) {
                    if (CrossSystem.isWindows()) {
                        W32FileUtils.getInstance().moveToTrash(existing.toArray(new File[0]));
                    } else if (CrossSystem.isMac()) {
                        MacFileUtils.getInstance().moveToTrash(existing.toArray(new File[0]));
                    }
                }
                if (exception != null) {
                    throw exception;
                }
            }
        }
        catch (UnsatisfiedLinkError e) {
            throw new IOException(e);
        }
    }
}

