/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.webcache;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.StorageException;
import org.appwork.storage.config.MinTimeWeakReference;
import org.appwork.utils.Application;
import org.appwork.utils.Hash;
import org.appwork.utils.IO;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.jdownloader.webcache.CachedRequest;

public class WebCache {
    private File folder;
    private LogInterface logger;
    protected final HashMap<String, MinTimeWeakReference<CachedRequest>> cache;
    private long minLifeTimeForRAMCache = 300000L;

    public WebCache() {
        this("default");
    }

    public WebCache(String cacheID) {
        this.folder = Application.getResource((String)("tmp/webcache/" + cacheID));
        this.folder.mkdirs();
        this.logger = LoggerFactory.getDefaultLogger();
        this.cache = new HashMap();
    }

    public LogInterface getLogger() {
        return this.logger;
    }

    public void setLogger(LogInterface logger) {
        this.logger = logger;
    }

    public synchronized CachedRequest get(String lookUpID) {
        CachedRequest cachedRequest = null;
        MinTimeWeakReference<CachedRequest> ret = this.cache.get(lookUpID);
        if (ret != null && ((cachedRequest = (CachedRequest)ret.get()) == null || cachedRequest._isExpired())) {
            this.cache.remove(lookUpID);
        }
        if (cachedRequest == null) {
            cachedRequest = this.readFormDisk(lookUpID);
        }
        if (cachedRequest != null) {
            this.putToRAM(cachedRequest);
        }
        return cachedRequest;
    }

    private CachedRequest readFormDisk(String lookUpID) {
        File file = new File(this.folder, Hash.getMD5((String)lookUpID) + ".json");
        try {
            if (file.exists()) {
                CachedRequest ret = (CachedRequest)JSonStorage.restoreFromString((String)IO.readFileToString((File)file), CachedRequest.TYPE_REF);
                if (ret == null || ret._isExpired()) {
                    file.delete();
                    return null;
                }
                return ret;
            }
        }
        catch (Throwable e) {
            this.logger.log(e);
            file.delete();
        }
        return null;
    }

    public long getMinLifeTimeForRAMCache() {
        return this.minLifeTimeForRAMCache;
    }

    public void setMinLifeTimeForRAMCache(long minLifeTimeForRAMCache) {
        this.minLifeTimeForRAMCache = minLifeTimeForRAMCache;
    }

    public synchronized void put(CachedRequest cachedRequest) {
        if (cachedRequest._isExpired()) {
            this.logger.info("Do not cache request. ALready expired");
            return;
        }
        System.out.println(JSonStorage.serializeToJson((Object)cachedRequest));
        this.putToRAM(cachedRequest);
        this.putToDisk(cachedRequest);
    }

    protected void putToRAM(CachedRequest cachedRequest) {
        this.cache.put(cachedRequest.getKey(), (MinTimeWeakReference<CachedRequest>)new MinTimeWeakReference((Object)cachedRequest, this.getMinLifeTimeForRAMCache(), cachedRequest.getKey()));
    }

    protected void putToDisk(CachedRequest cachedRequest) {
        File file = new File(this.folder, Hash.getMD5((String)cachedRequest.getKey()) + ".json");
        file.delete();
        try {
            IO.writeStringToFile((File)file, (String)JSonStorage.serializeToJson((Object)cachedRequest), (boolean)false);
        }
        catch (StorageException e) {
            this.logger.log((Throwable)e);
        }
        catch (IOException e) {
            this.logger.log((Throwable)e);
        }
    }
}

