/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.configuration;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import jd.captcha.JAntiCaptcha;
import jd.captcha.pixelgrid.Captcha;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.utils.Utilities;
import jd.nutils.io.JDIO;
import jd.utils.JDUtilities;
import org.appwork.utils.Regex;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.logging.LogController;

public class JACScript {
    private Vector<String[]> captchaPrepareCommands;
    private int color;
    private int[] colorComponents = new int[]{3, 3, 3};
    private int colorFaktor;
    private int[] gaps;
    private Vector<String[]> jacCommands;
    private Vector<String[]> letterCommands;
    private String method;
    private final JAntiCaptcha owner;
    private final Hashtable<String, Object> parameter = new Hashtable();
    private String scriptFile;
    private final LogSource logger = LogController.CL();

    public JACScript(JAntiCaptcha owner, String method) {
        this.init();
        this.owner = owner;
        this.method = method;
        this.scriptFile = "script.jas";
        this.parseScriptFile();
        this.executeParameterCommands();
    }

    public JACScript(JAntiCaptcha owner) {
        this.init();
        this.owner = owner;
    }

    public void executeLetterPrepareCommands(Letter letter) {
        this.logger.fine("Execute Script.jas Letter Prepare scripts");
        try {
            for (int i = 0; i < this.letterCommands.size(); ++i) {
                Letter tmp;
                String[] params;
                String[] cmd = this.letterCommands.elementAt(i);
                this.logger.info("Execute Function: " + cmd[1] + "(" + cmd[2] + ")");
                if (cmd[0].equals("parameter")) {
                    this.logger.severe("Syntax Error in " + this.method + "/+script.jas(letter)");
                    continue;
                }
                if (cmd[0].equals("function") && cmd[2] == null) {
                    if (cmd[1].equalsIgnoreCase("normalize")) {
                        letter.normalize();
                        continue;
                    }
                    if (cmd[1].equalsIgnoreCase("clean")) {
                        letter.clean();
                        continue;
                    }
                    if (cmd[1].equalsIgnoreCase("autoAlign")) {
                        letter.autoAlign();
                        continue;
                    }
                    if (cmd[1].equalsIgnoreCase("invertIfMoreBackground")) {
                        letter.invertIfMoreBackground();
                        continue;
                    }
                    if (cmd[1].equalsIgnoreCase("toBlackAndWhite")) {
                        letter.toBlackAndWhite();
                        continue;
                    }
                    if (cmd[1].equalsIgnoreCase("invert")) {
                        letter.invert();
                        continue;
                    }
                    this.logger.severe("Error in " + this.method + "/+script.jas : Function not valid: " + cmd[1] + "(" + cmd[2] + ")");
                    continue;
                }
                if (cmd[0].equals("function") && (params = cmd[2].split("\\,")).length == 1) {
                    if (cmd[1].equalsIgnoreCase("toBlackAndWhite")) {
                        letter.toBlackAndWhite(Double.parseDouble(params[0].trim()));
                        continue;
                    }
                    if (cmd[1].equalsIgnoreCase("resizetoHeight")) {
                        letter.resizetoHeight(Integer.parseInt(params[0].trim()));
                        continue;
                    }
                    if (cmd[1].equalsIgnoreCase("turn")) {
                        tmp = letter.turn(Integer.parseInt(params[0].trim()));
                        letter.grid = tmp.grid;
                        continue;
                    }
                    if (cmd[1].equalsIgnoreCase("reduceWhiteNoise")) {
                        letter.reduceWhiteNoise(Integer.parseInt(params[0].trim()));
                        continue;
                    }
                    if (cmd[1].equalsIgnoreCase("normalize")) {
                        letter.normalize(Double.parseDouble(params[0].trim()));
                        continue;
                    }
                    if (cmd[1].equalsIgnoreCase("reduceBlackNoise")) {
                        letter.reduceBlackNoise(Integer.parseInt(params[0].trim()));
                        continue;
                    }
                    if (cmd[1].equalsIgnoreCase("blurIt")) {
                        letter.blurIt(Integer.parseInt(params[0].trim()));
                        continue;
                    }
                    if (cmd[1].equalsIgnoreCase("sampleDown")) {
                        letter.sampleDown(Integer.parseInt(params[0].trim()));
                        continue;
                    }
                    if (cmd[1].equalsIgnoreCase("doSpecial")) {
                        String[] ref = params[0].trim().split("\\.");
                        if (ref.length != 2) {
                            this.logger.severe("dpSpecial-Parameter should have the format Class.Method");
                            continue;
                        }
                        String cl = ref[0];
                        String methodname = ref[1];
                        try {
                            Class<?> newClass = Class.forName("jd.captcha.specials." + cl);
                            Class[] parameterTypes = new Class[]{letter.getClass()};
                            Method method = newClass.getMethod(methodname, parameterTypes);
                            Object[] arguments = new Object[]{letter};
                            Object instance = null;
                            method.invoke(instance, arguments);
                        }
                        catch (Exception e) {
                            this.logger.severe("Fehler in doSpecial:" + e.getLocalizedMessage());
                            this.logger.log((Throwable)e);
                        }
                        continue;
                    }
                    if (cmd[1].equalsIgnoreCase("cleanBackgroundByColor")) {
                        letter.cleanBackgroundByColor(Integer.parseInt(params[0].trim()));
                        continue;
                    }
                    this.logger.severe("Error in " + this.method + "/+script.jas : Function not valid: " + cmd[1] + "(" + cmd[2] + ")");
                    continue;
                }
                if (cmd[0].equals("function") && (params = cmd[2].split("\\,")).length == 2) {
                    if (cmd[1].equalsIgnoreCase("reduceWhiteNoise")) {
                        letter.reduceWhiteNoise(Integer.parseInt(params[0].trim()), Double.parseDouble(params[1].trim()));
                        continue;
                    }
                    if (cmd[1].equalsIgnoreCase("resizetoHeight")) {
                        letter.resizetoHeight(Integer.parseInt(params[0].trim()), Double.parseDouble(params[1].trim()));
                        continue;
                    }
                    if (cmd[1].equalsIgnoreCase("reduceBlackNoise")) {
                        letter.reduceBlackNoise(Integer.parseInt(params[0].trim()), Double.parseDouble(params[1].trim()));
                        continue;
                    }
                    if (cmd[1].equalsIgnoreCase("align")) {
                        tmp = letter.align(Integer.parseInt(params[0].trim()), Integer.parseInt(params[1].trim()));
                        letter.grid = tmp.grid;
                        continue;
                    }
                    if (cmd[1].equalsIgnoreCase("betterAlign")) {
                        tmp = letter.betterAlign(Integer.parseInt(params[0].trim()), Integer.parseInt(params[1].trim()));
                        if (tmp == null || tmp.grid == null) continue;
                        letter.grid = tmp.grid;
                        continue;
                    }
                    this.logger.severe("Error in " + this.method + "/+script.jas : Function not valid: " + cmd[1] + "(" + cmd[2] + ")");
                    continue;
                }
                if (cmd[0].equals("function") && (params = cmd[2].split("\\,")).length == 3) {
                    if (cmd[1].equalsIgnoreCase("removeSmallObjects")) {
                        letter.removeSmallObjects(Double.parseDouble(params[0].trim()), Double.parseDouble(params[1].trim()), Integer.parseInt(params[2].trim()));
                        continue;
                    }
                    if (cmd[1].equalsIgnoreCase("align")) {
                        letter.align(Double.parseDouble(params[0].trim()), Integer.parseInt(params[1].trim()), Integer.parseInt(params[2].trim()));
                        continue;
                    }
                    if (cmd[1].equalsIgnoreCase("desinx")) {
                        letter.desinx(Double.parseDouble(params[0].trim()), Double.parseDouble(params[1].trim()), Double.parseDouble(params[2].trim()));
                        continue;
                    }
                    if (cmd[1].equalsIgnoreCase("desiny")) {
                        letter.desiny(Double.parseDouble(params[0].trim()), Double.parseDouble(params[1].trim()), Double.parseDouble(params[2].trim()));
                        continue;
                    }
                    if (cmd[1].equalsIgnoreCase("normalize")) {
                        letter.normalize(Double.parseDouble(params[0].trim()), Double.parseDouble(params[1].trim()), Double.parseDouble(params[2].trim()));
                        continue;
                    }
                    this.logger.severe("Error in " + this.method + "/+script.jas : Function not valid: " + cmd[1] + "(" + cmd[2] + ")");
                    continue;
                }
                if (!(cmd[0].equals("function") && (params = cmd[2].split("\\,")).length == 4 || cmd[0].equals("function") && (params = cmd[2].split("\\,")).length == 5 || !cmd[0].equals("function")) && (params = cmd[2].split("\\,")).length != 6) continue;
            }
        }
        catch (Exception e) {
            this.logger.severe("Syntax Error in " + this.method + "/script.jas");
            this.logger.log((Throwable)e);
        }
    }

    private void executeParameterCommands() {
        if (this.jacCommands == null || this.jacCommands.size() == 0) {
            this.logger.warning("KEINE JAC COMMANDS");
            return;
        }
        this.logger.fine("Execute Script.jas Parameter scripts");
        try {
            for (int i = 0; i < this.jacCommands.size(); ++i) {
                String[] cmd = this.jacCommands.elementAt(i);
                if (cmd[0].equals("parameter")) {
                    if (cmd[1].equalsIgnoreCase("gaps")) {
                        cmd[2] = cmd[2].substring(1, cmd[2].length() - 1);
                        String[] gaps = cmd[2].split("\\,");
                        int[] newGaps = new int[gaps.length];
                        for (int ii = 0; ii < gaps.length; ++ii) {
                            newGaps[ii] = Integer.parseInt(gaps[ii]);
                        }
                        this.setGaps(newGaps);
                        continue;
                    }
                    if (cmd[1].equalsIgnoreCase("colortype")) {
                        this.setColorType(cmd[2]);
                        continue;
                    }
                    this.logger.info(cmd[1] + " - " + cmd[2]);
                    this.set(cmd[1].toLowerCase(), this.toType(cmd[2], cmd[1]));
                    continue;
                }
                this.logger.severe("Syntax Error in " + this.method + "/+script.jas (" + cmd[0] + ")");
            }
        }
        catch (Exception e) {
            this.logger.severe("Syntax Error in " + this.method + "/+script.jas");
            this.logger.log((Throwable)e);
        }
    }

    public void executePrepareCommands(File file, Captcha captcha) {
        if (captcha == null || captcha.isPrepared()) {
            return;
        }
        captcha.setCaptchaFile(file);
        this.logger.fine("Execute Script.jas Prepare scripts");
        captcha.setPrepared(true);
        try {
            if (this.captchaPrepareCommands != null) {
                for (int i = 0; i < this.captchaPrepareCommands.size(); ++i) {
                    String[] params;
                    String[] cmd = this.captchaPrepareCommands.elementAt(i);
                    this.logger.fine("Execute Function: " + cmd[1] + "(" + cmd[2] + ")");
                    if (cmd[0].equals("parameter")) {
                        this.logger.severe("Syntax Error in " + this.method + "/+script.jas");
                        continue;
                    }
                    if (cmd[0].equals("function") && cmd[1].matches("(?is)captchacommand\\..*")) {
                        String[] parm = null;
                        if (cmd[2] != null) {
                            parm = cmd[2].trim().split("[\\s]*\\,[\\s]*");
                        }
                        String methodname = cmd[1].replaceFirst("(?is)captchacommand\\.", "");
                        try {
                            Class<Captcha> newClass = Captcha.class;
                            Method[] methods = newClass.getMethods();
                            Method method = null;
                            for (Method method1 : methods) {
                                if (!method1.getName().equals(methodname) || method1.getParameterTypes().length != parm.length) continue;
                                method = method1;
                            }
                            if (method == null) {
                                this.logger.severe("Fehler in captchacommand: Methode existiert nicht");
                            }
                            Captcha instance = captcha;
                            Object[] paramObj = null;
                            if (parm != null && parm.length > 0) {
                                paramObj = new Object[parm.length];
                                Class<?>[] types = method.getParameterTypes();
                                for (int c = 0; c < types.length; ++c) {
                                    Class<?> class1 = types[c];
                                    parm[c] = parm[c].trim();
                                    Object d = parm[c];
                                    d = class1.getName().equals("String") ? parm[c] : (class1.getName().equals("int") ? Integer.valueOf(Integer.parseInt(parm[c])) : (class1.getName().equals("float") ? Float.valueOf(Float.parseFloat(parm[c])) : (class1.getName().equals("double") ? Double.valueOf(Double.parseDouble(parm[c])) : (class1.getName().equals("long") ? Long.valueOf(Long.parseLong(parm[c])) : (class1.getName().equals("short") ? Short.valueOf(Short.parseShort(parm[c])) : (class1.getName().equals("byte") ? Byte.valueOf(Byte.parseByte(parm[c])) : (class1.getName().equals("boolean") ? (Comparable<Boolean>)Boolean.valueOf(Boolean.parseBoolean(parm[c])) : (Comparable<Boolean>)(class1.getName().equals("char") ? Byte.valueOf(Byte.parseByte(parm[c])) : class1.cast(d)))))))));
                                    paramObj[c] = d;
                                }
                            }
                            method.invoke((Object)instance, paramObj);
                        }
                        catch (Exception e) {
                            this.logger.severe("Fehler in captchacommand: " + e.getMessage());
                            this.logger.log((Throwable)e);
                        }
                        continue;
                    }
                    if (cmd[0].equals("function") && cmd[2] == null) {
                        if (cmd[1].equalsIgnoreCase("invert")) {
                            captcha.invert();
                            continue;
                        }
                        if (cmd[1].equalsIgnoreCase("toBlackAndWhite")) {
                            captcha.toBlackAndWhite();
                            continue;
                        }
                        if (cmd[1].equalsIgnoreCase("normalize")) {
                            captcha.normalize();
                            continue;
                        }
                        if (cmd[1].equalsIgnoreCase("clean")) {
                            captcha.clean();
                            continue;
                        }
                        this.logger.severe("Error in " + this.method + "/+script.jas : Function not valid: " + cmd[1] + "(" + cmd[2] + ")");
                        continue;
                    }
                    if (cmd[0].equals("function") && (params = cmd[2].split("\\,")).length == 1) {
                        if (cmd[1].equalsIgnoreCase("toBlackAndWhite")) {
                            captcha.toBlackAndWhite(Double.parseDouble(params[0].trim()));
                            continue;
                        }
                        if (cmd[1].equalsIgnoreCase("reduceWhiteNoise")) {
                            captcha.reduceWhiteNoise(Integer.parseInt(params[0].trim()));
                            continue;
                        }
                        if (cmd[1].equalsIgnoreCase("normalize")) {
                            captcha.normalize(Double.parseDouble(params[0].trim()));
                            continue;
                        }
                        if (cmd[1].equalsIgnoreCase("convertPixel")) {
                            captcha.convertPixel(params[0].trim());
                            continue;
                        }
                        if (cmd[1].equalsIgnoreCase("reduceBlackNoise")) {
                            captcha.reduceBlackNoise(Integer.parseInt(params[0].trim()));
                            continue;
                        }
                        if (cmd[1].equalsIgnoreCase("blurIt")) {
                            captcha.blurIt(Integer.parseInt(params[0].trim()));
                            continue;
                        }
                        if (cmd[1].equalsIgnoreCase("sampleDown")) {
                            captcha.sampleDown(Integer.parseInt(params[0].trim()));
                            continue;
                        }
                        if (cmd[1].equalsIgnoreCase("cleanBackgroundByColor")) {
                            captcha.cleanBackgroundByColor(Integer.parseInt(params[0].trim()));
                            continue;
                        }
                        if (cmd[1].equalsIgnoreCase("doSpecial")) {
                            String[] ref = params[0].trim().split("\\.");
                            if (ref.length != 2) {
                                this.logger.severe("dpSpecial-Parameter should have the format Class.Method");
                                continue;
                            }
                            String cl = ref[0];
                            String methodname = ref[1];
                            try {
                                Class<?> newClass = Class.forName("jd.captcha.specials." + cl);
                                Class[] parameterTypes = new Class[]{captcha.getClass()};
                                Method method = newClass.getMethod(methodname, parameterTypes);
                                Object[] arguments = new Object[]{captcha};
                                Object instance = null;
                                method.invoke(instance, arguments);
                            }
                            catch (Exception e) {
                                this.logger.severe("Fehler in doSpecial:" + e.getLocalizedMessage());
                                this.logger.log((Throwable)e);
                            }
                            continue;
                        }
                        if (cmd[1].equalsIgnoreCase("saveImageasJpg")) {
                            captcha.saveImageasJpg(new File(params[0].trim()));
                            continue;
                        }
                        this.logger.severe("Error in " + this.method + "/+script.jas : Function not valid: " + cmd[1] + "(" + cmd[2] + ")");
                        continue;
                    }
                    if (cmd[0].equals("function") && (params = cmd[2].split("\\,")).length == 2) {
                        if (cmd[1].equalsIgnoreCase("reduceWhiteNoise")) {
                            captcha.reduceWhiteNoise(Integer.parseInt(params[0].trim()), Double.parseDouble(params[1].trim()));
                            continue;
                        }
                        if (cmd[1].equalsIgnoreCase("reduceBlackNoise")) {
                            captcha.reduceBlackNoise(Integer.parseInt(params[0].trim()), Double.parseDouble(params[1].trim()));
                            continue;
                        }
                        if (cmd[1].equalsIgnoreCase("removeBridges")) {
                            captcha.removeBridges(Integer.parseInt(params[0].trim()), Double.parseDouble(params[1].trim()));
                            continue;
                        }
                        if (cmd[1].equalsIgnoreCase("cleanByRGBDistance")) {
                            captcha.cleanByRGBDistance(Integer.parseInt(params[0].trim()), Integer.parseInt(params[1].trim()));
                            continue;
                        }
                        if (cmd[1].equalsIgnoreCase("cleanWithDetailMask")) {
                            captcha.cleanWithDetailMask(this.owner.createCaptcha(Utilities.loadImage(this.owner.getResourceFile(params[0].trim()))), Integer.parseInt(params[1].trim()));
                            continue;
                        }
                        this.logger.severe("Error in " + this.method + "/+script.jas : Function not valid: " + cmd[1] + "(" + cmd[2] + ")");
                        continue;
                    }
                    if (cmd[0].equals("function") && (params = cmd[2].split("\\,")).length == 3) {
                        if (cmd[1].equalsIgnoreCase("cleanWithMask")) {
                            this.logger.info("" + this.owner.getResourceFile(params[0].trim()));
                            captcha.cleanWithMask(this.owner.createCaptcha(Utilities.loadImage(this.owner.getResourceFile(params[0].trim()))), Integer.parseInt(params[1].trim()), Integer.parseInt(params[2].trim()));
                            continue;
                        }
                        if (cmd[1].equalsIgnoreCase("removeSmallObjects")) {
                            captcha.removeSmallObjects(Double.parseDouble(params[0].trim()), Double.parseDouble(params[1].trim()), Integer.parseInt(params[2].trim()));
                            continue;
                        }
                        if (cmd[1].equalsIgnoreCase("normalize")) {
                            captcha.normalize(Double.parseDouble(params[0].trim()), Double.parseDouble(params[1].trim()), Double.parseDouble(params[2].trim()));
                            continue;
                        }
                        if (cmd[1].equalsIgnoreCase("desinx")) {
                            captcha.desinx(Double.parseDouble(params[0].trim()), Double.parseDouble(params[1].trim()), Double.parseDouble(params[2].trim()));
                            continue;
                        }
                        if (cmd[1].equalsIgnoreCase("desiny")) {
                            captcha.desiny(Double.parseDouble(params[0].trim()), Double.parseDouble(params[1].trim()), Double.parseDouble(params[2].trim()));
                            continue;
                        }
                        this.logger.severe("Error in " + this.method + "/+script.jas : Function not valid: " + cmd[1] + "(" + cmd[2] + ")");
                        continue;
                    }
                    if (cmd[0].equals("function") && (params = cmd[2].split("\\,")).length == 4) {
                        if (cmd[1].equalsIgnoreCase("cleanBackgroundBySample")) {
                            captcha.cleanBackgroundBySample(Integer.parseInt(params[0].trim()), Integer.parseInt(params[1].trim()), Integer.parseInt(params[2].trim()), Integer.parseInt(params[3].trim()));
                            continue;
                        }
                        if (cmd[1].equalsIgnoreCase("crop")) {
                            captcha.crop(Integer.parseInt(params[0].trim()), Integer.parseInt(params[1].trim()), Integer.parseInt(params[2].trim()), Integer.parseInt(params[3].trim()));
                            continue;
                        }
                        if (!cmd[1].equalsIgnoreCase("cleanBackgroundByHorizontalSampleLine")) continue;
                        captcha.cleanBackgroundByHorizontalSampleLine(Integer.parseInt(params[0].trim()), Integer.parseInt(params[1].trim()), Integer.parseInt(params[2].trim()), Integer.parseInt(params[3].trim()));
                        continue;
                    }
                    if (cmd[0].equals("function") && (params = cmd[2].split("\\,")).length != 5) continue;
                }
            }
        }
        catch (Exception e) {
            this.logger.severe("Syntax Error in " + this.method + "/script.jas (captcha)");
            this.logger.log((Throwable)e);
        }
    }

    public Object get(String key) {
        key = key.toLowerCase();
        return this.parameter.get(key);
    }

    public boolean getBoolean(String key) {
        Object ret = this.get(key);
        if (!(ret instanceof Boolean)) {
            this.logger.severe("Kein boolean Parameter f\u00fcr " + key);
            return false;
        }
        return (Boolean)ret;
    }

    public Vector<String[]> getCaptchaPrepareCommands() {
        return this.captchaPrepareCommands;
    }

    public int getColorComponent(int i) {
        return this.colorComponents[i];
    }

    public int getColorFaktor() {
        return this.colorFaktor;
    }

    public int getColorFormat() {
        return this.color;
    }

    public double getDouble(String key) {
        Object ret = this.get(key);
        if (!(ret instanceof Double)) {
            this.logger.severe("Kein double Parameter f\u00fcr " + key);
            return 0.0;
        }
        return (Double)ret;
    }

    public float getFloat(String key) {
        Object ret = this.get(key);
        if (!(ret instanceof Float)) {
            this.logger.severe("Kein float Parameter f\u00fcr " + key);
            return 0.0f;
        }
        return ((Float)ret).floatValue();
    }

    public int[] getGaps() {
        return this.gaps;
    }

    public int getInteger(String key) {
        Object ret = this.get(key);
        if (!(ret instanceof Integer)) {
            this.logger.severe("Kein Integer Parameter f\u00fcr " + key);
            return 0;
        }
        return (Integer)ret;
    }

    public Vector<String[]> getJacCommands() {
        return this.jacCommands;
    }

    public long getLong(String key) {
        Object ret = this.get(key);
        if (ret instanceof Long) {
            return (Long)ret;
        }
        if (ret instanceof Integer) {
            this.logger.severe("Casting Integer to Long");
            return ((Integer)ret).intValue();
        }
        this.logger.severe("No Long,Integer found!");
        return 0L;
    }

    public String getString(String key) {
        Object ret = this.get(key);
        if (!(ret instanceof String)) {
            this.logger.severe("Kein String Parameter f\u00fcr " + key);
            return null;
        }
        return (String)ret;
    }

    private void init() {
        this.set("LetterSearchLimitPerfectPercent", 10.0);
        this.set("objectColorContrast", 0.3);
        this.set("objectDetectionContrast", 0.5);
        this.set("minimumObjectArea", 200);
        this.set("useobjectDetection", false);
        this.set("useColorObjectDetection", false);
        this.set("colorObjectDetectionPercent", 15);
        this.set("colorObjectDetectionRunningAverage", 255);
        this.set("gapWidthPeak", 1);
        this.setColorType("h");
        this.set("gapWidthAverage", 1);
        this.set("gapAndAverageLogic", true);
        this.set("gapDetectionAverageContrast", 1.3);
        this.set("gapDetectionPeakContrast", 0.25);
        this.set("useSpecialGetLetters", "");
        this.set("useLetterFilter", "");
        this.set("useLettercomparatorFilter", "");
        this.set("preValueFilter", "");
        this.set("postValueFilter", "");
        this.set("comparatorExtension", "");
        this.set("LetterSearchLimitFalsePercent", 100);
        this.set("useAverageGapDetection", false);
        this.set("alignAngleSteps", 5);
        this.set("splitGapsOverlap", 4);
        this.set("scanAngleLeft", 0);
        this.set("scanAngleRight", 0);
        this.set("scanAngleSteps", 5);
        this.set("usePeakGapdetection", true);
        this.set("minimumLetterWidth", 0);
        this.set("simplifyFaktor", 1.0);
        this.set("errorAWeight", 1.0);
        this.set("errorBWeight", 1.0);
        this.set("cancelIfObjectDetectionFailed", false);
        this.set("intersectionDimensionWeight", 0.9);
        this.set("overlayNoiseSize", -1);
        this.set("coverageFaktorAWeight", 1.0);
        this.set("coverageFaktorBWeight", 1.0);
        this.set("quickScanReliabilityLimit", 2.0);
        this.set("quickScanValityLimit", 50.0);
        this.set("minCleftSize", 3);
        this.set("cleftFaktor", 0.3);
        this.set("preScanFilter", 100);
        this.set("preScanEmergencyFilter", 0);
        this.set("preScanFaktor", 3);
        this.set("splitPixelObjectsOverlap", 4);
        this.set("relativeContrast", 0.85);
        this.set("backgroundSampleCleanContrast", 0.1);
        this.set("blackPercent", 0.1);
        this.set("trainOnlyUnknown", true);
        this.set("easyCaptchaRemoveSmallObjects", true);
        this.set("easyCaptchaBW", false);
        this.set("followXLines", true);
        this.set("turnDB", false);
        this.set("borderVarianceX", 0);
        this.set("borderVarianceY", 0);
        this.set("rapidshareSpecial", false);
        this.set("autoLetterNum", false);
        this.set("directLetterDetection", false);
        this.set("prescandivider", 4.0);
        this.set("divider", 6.0);
        this.set("scanVarianceX", 0);
        this.set("scanVarianceY", 0);
        this.set("multiplePartMergeMinSize", 0);
        this.set("abortDirectDetectionOnDetectionError", false);
        this.set("inverseFontWeight", 8.0);
        this.set("scanstepx", 1);
        this.set("scanstepy", 1);
        this.set("intersectionAHeightWeight", 0.0);
        this.set("intersectionAWidthWeight", 0.0);
        this.set("minObjectSize", 10);
    }

    private String[] parseCommand(String cmd) {
        String[] ret = new String[3];
        cmd = "#" + cmd + "#";
        String[] matches = new Regex(cmd, "#(.*?)=(.*?)#").getRow(0);
        if (matches != null) {
            ret[0] = "parameter";
            ret[1] = matches[0].trim();
            ret[2] = matches[1].replaceAll("\\\"", "").trim();
        } else {
            matches = new Regex(cmd, "#(.*?)\\((.*?)\\)#").getRow(0);
            if (matches != null) {
                ret[0] = "function";
                ret[1] = matches[0].trim();
                ret[2] = matches[1].replaceAll("\\\"", "").trim();
                if (ret[2].length() == 0) {
                    ret[2] = null;
                }
            } else {
                matches = new Regex(cmd, "#(.*?)\\((.*?)\\)#").getRow(0);
                if (matches != null) {
                    ret[0] = "function";
                    ret[1] = matches[0].trim();
                    ret[2] = null;
                }
            }
        }
        return ret;
    }

    private void parseScriptFile() {
        this.logger.fine("parsing Script.jas");
        File f = JDUtilities.getResourceFile((String)(JDUtilities.getJACMethodsDirectory() + this.method + "/" + this.scriptFile));
        String script = JDIO.readFileToString((File)f);
        this.logger.info("JAC GET: " + f);
        if (script == null || script.length() == 0) {
            this.logger.severe("Keine Script.jas vorhanden  ");
            return;
        }
        String[] lines = Regex.getLines((String)script);
        Vector<String[]> localCaptchaPrepareCommands = new Vector<String[]>();
        Vector<String[]> localJacCommands = new Vector<String[]>();
        Vector<String[]> localLetterCommands = new Vector<String[]>();
        for (int i = 0; i < lines.length; ++i) {
            String[] pcmd;
            lines[i] = lines[i].trim();
            if (lines[i].indexOf("#") == 0 || lines[i].trim().length() < 3) continue;
            if (!lines[i].substring(lines[i].length() - 1).equals(";")) {
                this.logger.severe(this.method + "/script.jas: Syntax error (; missing?) near line " + i + ": " + lines[i]);
                return;
            }
            lines[i] = lines[i].substring(0, lines[i].length() - 1);
            int startAt = lines[i].indexOf("captcha.prepare.");
            if (startAt == 0) {
                pcmd = this.parseCommand(lines[i].substring(startAt + 16));
                localCaptchaPrepareCommands.add(pcmd);
                continue;
            }
            startAt = lines[i].indexOf("param.");
            if (startAt == 0) {
                pcmd = this.parseCommand(lines[i].substring(startAt + 6));
                if (!pcmd[0].equals("parameter")) {
                    this.logger.severe(this.method + "/script.jas: Syntax (parameter1)  error near line " + i + ": " + lines[i]);
                }
                localJacCommands.add(pcmd);
                continue;
            }
            startAt = lines[i].indexOf("letter.prepare.");
            if (startAt == 0) {
                pcmd = this.parseCommand(lines[i].substring(startAt + 15));
                localLetterCommands.add(pcmd);
                continue;
            }
            this.logger.severe(this.method + "/script.jas: Syntax error near line " + i + ": " + lines[i]);
        }
        this.captchaPrepareCommands = localCaptchaPrepareCommands;
        this.jacCommands = localJacCommands;
        this.letterCommands = localLetterCommands;
    }

    public void set(String key, Object value) {
        key = key.toLowerCase();
        this.parameter.put(key, value);
    }

    public void setColorType(String type) {
        this.set("colorType", type);
        int[] components = new int[]{3, 3, 3};
        this.colorFaktor = 1;
        for (int i = type.length() - 1; i >= 0; --i) {
            if (type.charAt(i) == 'h') {
                components[i + 3 - type.length()] = 0;
                this.colorFaktor *= 256;
                this.color = 0;
                continue;
            }
            if (type.charAt(i) == 's') {
                components[i + 3 - type.length()] = 1;
                this.colorFaktor *= 256;
                this.color = 0;
                continue;
            }
            if (type.charAt(i) == 'b') {
                components[i + 3 - type.length()] = 2;
                this.colorFaktor *= 256;
                this.color = 0;
                continue;
            }
            if (type.charAt(i) == 'R') {
                components[i + 3 - type.length()] = 0;
                this.colorFaktor *= 256;
                this.color = 1;
                continue;
            }
            if (type.charAt(i) == 'G') {
                components[i + 3 - type.length()] = 1;
                this.colorFaktor *= 256;
                this.color = 1;
                continue;
            }
            if (type.charAt(i) != 'B') continue;
            components[i + 3 - type.length()] = 2;
            this.colorFaktor *= 256;
            this.color = 1;
        }
        this.colorComponents = components;
    }

    public void setGaps(int[] gaps) {
        this.logger.finer("SET PARAMETER: [gaps] = " + Arrays.toString(gaps));
        this.gaps = gaps;
    }

    private Object toType(String arg, String key) {
        Object current = this.get(key);
        if (current instanceof String) {
            return arg;
        }
        if (current instanceof Integer) {
            return Integer.parseInt(arg);
        }
        if (current instanceof Float) {
            return Float.valueOf(Float.parseFloat(arg));
        }
        if (current instanceof Double) {
            return Double.parseDouble(arg);
        }
        if (current instanceof Boolean) {
            return arg.equalsIgnoreCase("true");
        }
        if (current == null) {
            this.logger.severe("Parameter " + key + " ist nicht initialisiert worden!");
        } else {
            this.logger.severe(current + "Typ " + current.getClass() + " wird nicht unterst\u00fctzt");
        }
        return null;
    }
}

