/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.easy;

import java.awt.Image;
import java.io.File;
import jd.captcha.easy.CPoint;
import jd.captcha.easy.EasyMethodFile;
import jd.captcha.pixelgrid.Captcha;
import jd.captcha.utils.Utilities;
import org.jdownloader.logging.LogController;

public class BackGroundImage
extends CPoint {
    private static final long serialVersionUID = 8700548338559980634L;
    private transient Image image = null;
    private String backgroundImage;

    public String getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(String backgroundImage) {
        this.image = null;
        this.backgroundImage = backgroundImage;
    }

    public Image getImage(EasyMethodFile methode) {
        if (this.image == null) {
            this.image = Utilities.loadImage(new File(methode.file, this.getBackgroundImage()));
        }
        return this.image;
    }

    public void clearCaptcha(Captcha captchaImage) throws InterruptedException {
        EasyMethodFile methode = new EasyMethodFile(captchaImage.owner.getResourceFile("jacinfo.xml").getParentFile());
        Image bImage = this.getImage(methode);
        if (bImage == null || bImage.getWidth(null) != captchaImage.getWidth() || bImage.getHeight(null) != captchaImage.getHeight()) {
            LogController.CL().severe("ERROR Maske und Bild passen nicht zusammmen");
            return;
        }
        Captcha cleanImg = captchaImage.owner.createCaptcha(bImage);
        int color = this.getColor();
        for (int x = 0; x < captchaImage.getWidth(); ++x) {
            for (int y = 0; y < captchaImage.getHeight(); ++y) {
                int pv = captchaImage.getPixelValue(x, y);
                this.setColor(cleanImg.getPixelValue(x, y));
                if (!(this.getColorDifference(pv) < (double)this.getDistance())) continue;
                captchaImage.setPixelValue(x, y, color);
            }
        }
        this.setColor(color);
    }

    @Override
    public BackGroundImage clone() {
        BackGroundImage ret = new BackGroundImage();
        ret.setLocation(this.getLocation());
        ret.setColor(this.getColor());
        ret.setDistance(this.getDistance());
        ret.setColorDistanceMode(this.getColorDistanceMode());
        ret.setForeground(this.isForeground());
        ret.backgroundImage = this.backgroundImage;
        ret.image = this.image;
        return ret;
    }
}

