/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.easy.load;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import jd.captcha.easy.EasyMethodFile;
import jd.captcha.easy.load.LoadImage;
import jd.captcha.easy.load.LoadInfo;
import jd.captcha.translate.T;
import jd.gui.swing.components.JDTextField;
import jd.http.Browser;
import jd.nutils.Screen;
import jd.parser.html.Form;
import jd.parser.html.HTMLParser;
import jd.utils.JDUtilities;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.EDTHelper;
import org.jdownloader.controlling.FileCreationManager;

public class LoadCaptchas {
    private static final long serialVersionUID = 1L;
    public String host;
    public boolean opendir = false;
    private LoadInfo loadinfo;
    private Browser br = new Browser();
    private List<LoadImage> images;
    private LoadImage selectedImage;
    private JFrame owner;
    public int maxHeight;
    public boolean threaded;
    public int maxWeight;
    private String dir;

    public LoadCaptchas(JFrame owner) {
        this(owner, null);
    }

    public LoadCaptchas(JFrame owner, String host) {
        this(owner, host, false);
    }

    public LoadCaptchas(JFrame owner, String host, boolean opendir) {
        this.br.setFollowRedirects(true);
        this.maxHeight = 500;
        this.threaded = false;
        this.maxWeight = 600;
        this.dir = null;
        this.host = host;
        this.opendir = opendir;
        this.owner = owner;
    }

    public boolean start() {
        try {
            this.selectedImage = LoadImage.loadFile(this.host);
            this.loadinfo = this.getLoadInfo(this.selectedImage);
            if (this.loadinfo == null) {
                return false;
            }
            final JDialog dialog = (JDialog)new EDTHelper<JDialog>(){

                public JDialog edtRun() {
                    return new JDialog(LoadCaptchas.this.owner);
                }
            }.getReturnValue();
            dialog.setModal(true);
            dialog.setAlwaysOnTop(true);
            this.br.getPage(this.loadinfo.link);
            if (this.host == null) {
                this.host = this.br.getHost().toLowerCase();
                if (this.host.matches(".*\\..*\\..*")) {
                    this.host = this.host.substring(this.host.indexOf(46) + 1);
                }
            }
            if (this.dir == null) {
                this.dir = JDUtilities.getJDHomeDirectoryFromEnvironment().getAbsolutePath() + "/captchas/" + this.host + "/";
            }
            FileCreationManager.getInstance().mkdir(new File(this.dir));
            if (this.loadDirect()) {
                if (this.opendir) {
                    LoadCaptchas.openDir(this.dir);
                }
                new EasyMethodFile(this.host).copyExampleImage();
                return true;
            }
            if (this.selectedImage != null) {
                this.selectedImage.load(this.host);
            } else {
                dialog.setTitle(T.T.easycaptcha_loadcaptchas_clickoncaptcha());
                this.images = this.getAllImages(this.br);
                this.loadImages();
                dialog.addWindowListener(new WindowListener(){

                    @Override
                    public void windowActivated(WindowEvent e) {
                    }

                    @Override
                    public void windowClosed(WindowEvent e) {
                    }

                    @Override
                    public void windowClosing(WindowEvent e) {
                        for (LoadImage loadImage : LoadCaptchas.this.images) {
                            FileCreationManager.getInstance().delete(loadImage.file, null);
                        }
                        dialog.dispose();
                    }

                    @Override
                    public void windowDeactivated(WindowEvent e) {
                    }

                    @Override
                    public void windowDeiconified(WindowEvent e) {
                    }

                    @Override
                    public void windowIconified(WindowEvent e) {
                    }

                    @Override
                    public void windowOpened(WindowEvent e) {
                    }
                });
                final ArrayList<JButton> bts = new ArrayList<JButton>();
                for (int j = 0; j < this.images.size(); ++j) {
                    final LoadImage f = this.images.get(j);
                    if (f == null || f.file == null || !f.file.exists() || f.file.length() < 100L) continue;
                    final BufferedImage captchaImage = ImageProvider.read((File)f.file);
                    if (captchaImage == null) {
                        FileCreationManager.getInstance().delete(f.file, null);
                        continue;
                    }
                    int area = captchaImage.getHeight(null) * captchaImage.getHeight(null);
                    if (area < 50 || captchaImage.getHeight(null) > this.maxHeight || captchaImage.getWidth(null) > this.maxWeight || captchaImage.getWidth(null) < 10 || captchaImage.getHeight(null) < 5) {
                        FileCreationManager.getInstance().delete(f.file, null);
                        continue;
                    }
                    double faktor = Math.max((double)captchaImage.getWidth(null) / 100.0, (double)captchaImage.getHeight(null) / 100.0);
                    final int width = (int)((double)captchaImage.getWidth(null) / faktor);
                    final int height = (int)((double)captchaImage.getHeight(null) / faktor);
                    try {
                        JButton ic = (JButton)new EDTHelper<JButton>(){

                            public JButton edtRun() {
                                return new JButton(new ImageIcon(captchaImage.getScaledInstance(width, height, 4)));
                            }
                        }.getReturnValue();
                        ic.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                LoadCaptchas.this.selectedImage = f;
                                dialog.dispose();
                            }
                        });
                        bts.add(ic);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                final JPanel panel = (JPanel)new EDTHelper<JPanel>(){

                    public JPanel edtRun() {
                        return new JPanel(new GridLayout((int)Math.ceil((double)bts.size() / 5.0), 5));
                    }
                }.getReturnValue();
                for (JButton button : bts) {
                    panel.add(button);
                }
                new EDTHelper<Object>(){

                    public Object edtRun() {
                        dialog.add(new JScrollPane(panel));
                        dialog.pack();
                        dialog.setLocation(Screen.getCenterOfComponent((Component)LoadCaptchas.this.owner, (Component)dialog));
                        dialog.setAlwaysOnTop(true);
                        dialog.setVisible(true);
                        return null;
                    }
                }.waitForEDT();
            }
            if (this.selectedImage != null && this.selectedImage.file != null) {
                this.loadProcess();
                if (this.opendir) {
                    LoadCaptchas.openDir(this.dir);
                }
                new EasyMethodFile(this.host).copyExampleImage();
                return this.dir.length() > 0;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    static Form[] getForms(Browser browser) {
        Form[] forms;
        ArrayList<Form> retForms = new ArrayList<Form>();
        for (Form form : forms = browser.getForms()) {
            List fi = form.getInputFieldsByType("submit");
            if (fi.size() > 1) {
                for (int i = 1; i < fi.size(); ++i) {
                    Form fo = new Form(form.getHtmlCode());
                    fo.getInputFields().remove(fo.getInputFieldsByType("submit").get(i));
                    if (retForms.contains(fo)) continue;
                    retForms.add(fo);
                }
                form.getInputFields().remove(fi.get(0));
            }
            if (retForms.contains(form)) continue;
            retForms.add(form);
        }
        return retForms.toArray(new Form[0]);
    }

    static String[] getImages(Browser br) throws Exception {
        Pattern[] basePattern;
        ArrayList<String> ret = new ArrayList<String>();
        for (Pattern element : basePattern = new Pattern[]{Pattern.compile("(?is)<[ ]?input[^>]*?src=['|\"]?([^>\\s'\"]*)['|\">\\s][^>]*?type=.?image[^>]*?", 2), Pattern.compile("(?is)<[ ]?input[^>]*?type=.?image[^>]*?src=['|\"]?([^>\\s'\"]*)['|\">\\s]", 2), Pattern.compile("(?is)<[ ]?IMG[^>]*?src=['|\"]?([^>\\s'\"]*)['|\">\\s]", 2)}) {
            Matcher m = element.matcher(br.toString());
            while (m.find()) {
                try {
                    String src = m.group(1);
                    if (!src.startsWith("http")) {
                        src = src.charAt(0) == '/' ? "http://" + br.getHost() + src : (src.charAt(0) == '#' ? "http://" + br.getURL() + src : br.getBaseURL() + src);
                    }
                    if (ret.contains(src)) continue;
                    ret.add(src);
                }
                catch (Exception exception) {}
            }
        }
        return ret.toArray(new String[0]);
    }

    private static void openDir(final String dir) {
        new EDTHelper<Object>(){

            public Object edtRun() {
                if (JOptionPane.showConfirmDialog(null, "Captcha Ordner:" + dir + " jetzt \u00f6ffnen?") == 0) {
                    CrossSystem.openFile((File)new File(dir));
                }
                return null;
            }
        }.waitForEDT();
    }

    private LoadInfo getLoadInfo(final LoadImage loadImage) {
        final JDialog dialog = (JDialog)new EDTHelper<JDialog>(){

            public JDialog edtRun() {
                return new JDialog(LoadCaptchas.this.owner);
            }
        }.getReturnValue();
        dialog.setModal(true);
        dialog.setAlwaysOnTop(true);
        final JPanel p = (JPanel)new EDTHelper<JPanel>(){

            public JPanel edtRun() {
                JPanel ret = new JPanel(new GridLayout(6, 2));
                ret.add(new JLabel(T.T.easycaptcha_loadcaptchas_link() + ":"));
                return ret;
            }
        }.getReturnValue();
        final JDTextField tfl = (JDTextField)new EDTHelper<JDTextField>(){

            public JDTextField edtRun() {
                return new JDTextField();
            }
        }.getReturnValue();
        tfl.setBorder(BorderFactory.createEtchedBorder());
        p.add((Component)tfl);
        JSpinner sm = (JSpinner)new EDTHelper<JSpinner>(){

            public JSpinner edtRun() {
                p.add(new JLabel(T.T.easycaptcha_loadcaptchas_howmuch() + ":"));
                if (loadImage != null) {
                    tfl.setText(loadImage.baseUrl);
                }
                return new JSpinner(new SpinnerNumberModel(100, 1, 4000, 1));
            }
        }.getReturnValue();
        p.add(sm);
        JCheckBox followLinks = (JCheckBox)new EDTHelper<JCheckBox>(){

            public JCheckBox edtRun() {
                p.add(new JLabel(T.T.easycaptcha_loadcaptchas_followlinks() + ":"));
                JCheckBox checkBox = new JCheckBox();
                checkBox.setSelected(false);
                p.add(checkBox);
                return checkBox;
            }
        }.getReturnValue();
        JCheckBox threadedCheck = (JCheckBox)new EDTHelper<JCheckBox>(){

            public JCheckBox edtRun() {
                p.add(new JLabel(T.T.easycaptcha_loadcaptchas_threaded() + ":"));
                JCheckBox checkBox = new JCheckBox();
                checkBox.setSelected(false);
                p.add(checkBox);
                return checkBox;
            }
        }.getReturnValue();
        JCheckBox loadDirect = (JCheckBox)new EDTHelper<JCheckBox>(){

            public JCheckBox edtRun() {
                p.add(new JLabel(T.T.easycaptcha_loadcaptchas_loaddirect() + ":"));
                JCheckBox checkBox = new JCheckBox();
                checkBox.setSelected(true);
                p.add(checkBox);
                return checkBox;
            }
        }.getReturnValue();
        JButton ok = (JButton)new EDTHelper<JButton>(){

            public JButton edtRun() {
                return new JButton(T.T.gui_btn_ok());
            }
        }.getReturnValue();
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        p.add(ok);
        WindowListener l = new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                tfl.setText("");
                dialog.dispose();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        };
        JButton cancel = (JButton)new EDTHelper<JButton>(){

            public JButton edtRun() {
                return new JButton(T.T.gui_btn_cancel());
            }
        }.getReturnValue();
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                tfl.setText("");
                dialog.dispose();
            }
        });
        p.add(cancel);
        dialog.addWindowListener(l);
        dialog.add(p);
        new EDTHelper<Object>(){

            public Object edtRun() {
                dialog.setLocation(Screen.getCenterOfComponent((Component)LoadCaptchas.this.owner, (Component)dialog));
                dialog.pack();
                dialog.setAlwaysOnTop(true);
                dialog.setVisible(true);
                return null;
            }
        }.waitForEDT();
        String link = tfl.getText();
        if (link == null || link.matches("\\s*")) {
            return null;
        }
        int menge = (Integer)sm.getValue();
        dialog.dispose();
        LoadInfo retLI = new LoadInfo(link, menge);
        retLI.followLinks = followLinks.isSelected();
        this.threaded = threadedCheck.isSelected();
        retLI.directLoad = loadDirect.isSelected();
        return retLI;
    }

    private static String getImageExtentionFromHeader(Browser br) {
        String ret = null;
        String contentType = br.getHttpConnection().getContentType();
        if (contentType != null && contentType.toLowerCase().contains("image")) {
            ret = contentType.toLowerCase().equals("image/jpeg") ? ".jpg" : contentType.toLowerCase().replaceFirst("image/", ".");
        }
        return ret;
    }

    private boolean loadDirect() {
        String imageType;
        String i = LoadCaptchas.getImageExtentionFromHeader(this.br);
        if (i.contains(";")) {
            i = i.substring(0, i.indexOf(";"));
        }
        if ((imageType = i) != null) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (!LoadCaptchas.this.threaded) {
                        for (int k = 0; k < ((LoadCaptchas)LoadCaptchas.this).loadinfo.menge; ++k) {
                            try {
                                File f2 = new File(LoadCaptchas.this.dir + System.currentTimeMillis() + imageType);
                                LoadCaptchas.this.br.getDownload(f2, ((LoadCaptchas)LoadCaptchas.this).loadinfo.link);
                                System.out.println("Download " + f2);
                                continue;
                            }
                            catch (Exception ev) {
                                ev.printStackTrace();
                            }
                        }
                    } else {
                        Thread[] ths = new Thread[((LoadCaptchas)LoadCaptchas.this).loadinfo.menge];
                        for (int k = 0; k < ((LoadCaptchas)LoadCaptchas.this).loadinfo.menge; ++k) {
                            ths[k] = new Thread(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    try {
                                        File f2 = new File(LoadCaptchas.this.dir + System.currentTimeMillis() + imageType);
                                        LoadCaptchas.this.br.getDownload(f2, ((LoadCaptchas)LoadCaptchas.this).loadinfo.link);
                                        System.out.println("Download " + f2);
                                    }
                                    catch (Exception ev) {
                                        ev.printStackTrace();
                                    }
                                    1 var1_1 = this;
                                    synchronized (var1_1) {
                                        this.notify();
                                    }
                                }
                            });
                            ths[k].start();
                        }
                        for (Thread thread : ths) {
                            while (thread.isAlive()) {
                                Thread thread2 = thread;
                                synchronized (thread2) {
                                    try {
                                        thread.wait(30000L);
                                    }
                                    catch (InterruptedException e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                        }
                    }
                }
            };
            Thread th = new Thread(runnable);
            th.start();
            return true;
        }
        return false;
    }

    private List<LoadImage> getAllImages(Browser br) {
        LoadImage li;
        Browser brc;
        String[] imagea;
        ArrayList<LoadImage> images = new ArrayList<LoadImage>();
        try {
            imagea = LoadCaptchas.getImages(br);
            int i = 0;
            while (i < imagea.length) {
                LoadImage li2 = new LoadImage(this.loadinfo, imagea[i], br);
                li2.form = -1;
                li2.location = i++;
                images.add(li2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.loadinfo.followLinks) {
            String[] links = HTMLParser.getHttpLinks((String)br.toString(), (String)br.getURL());
            for (int b = 0; b < links.length; ++b) {
                String string = links[b];
                try {
                    brc = br.cloneBrowser();
                    brc.getPage(string);
                    imagea = LoadCaptchas.getImages(brc);
                    int i = 0;
                    while (i < imagea.length) {
                        li = new LoadImage(this.loadinfo, imagea[i], brc);
                        li.form = -1;
                        li.location = i++;
                        li.followUrl = b;
                        images.add(li);
                    }
                    continue;
                }
                catch (Exception brc2) {
                    // empty catch block
                }
            }
        }
        Form[] forms = LoadCaptchas.getForms(br);
        for (int i = 0; i < forms.length; ++i) {
            try {
                Form form = forms[i];
                brc = br.cloneBrowser();
                brc.submitForm(form);
                imagea = LoadCaptchas.getImages(brc);
                for (int b = 0; b < imagea.length; ++b) {
                    li = new LoadImage(this.loadinfo, imagea[b], brc);
                    li.form = i;
                    li.location = b;
                    if (images.contains(li)) continue;
                    images.add(li);
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return images;
    }

    private void loadImages() {
        Thread th = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                final Thread[] jb = new Thread[LoadCaptchas.this.images.size()];
                int j = 0;
                while (j < LoadCaptchas.this.images.size()) {
                    final int i = j++;
                    jb[i] = new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            LoadImage image = (LoadImage)LoadCaptchas.this.images.get(i);
                            image.directCaptchaLoad(LoadCaptchas.this.dir);
                            Thread thread = jb[i];
                            synchronized (thread) {
                                jb[i].notify();
                            }
                        }
                    });
                    jb[i].start();
                }
                for (Thread thread : jb) {
                    while (thread.isAlive()) {
                        Thread thread2 = thread;
                        synchronized (thread2) {
                            try {
                                thread.wait(3000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
        });
        th.start();
    }

    private void loadProcess() {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block25: {
                    try {
                        Thread[] ths;
                        if (LoadCaptchas.this.images != null) {
                            for (LoadImage loadImage : LoadCaptchas.this.images) {
                                if (loadImage.file.equals(((LoadCaptchas)LoadCaptchas.this).selectedImage.file)) continue;
                                FileCreationManager.getInstance().delete(loadImage.file, null);
                            }
                        }
                        boolean direct = LoadCaptchas.this.selectedImage.directCaptchaLoad(LoadCaptchas.this.dir);
                        LoadImage.save(LoadCaptchas.this.selectedImage, LoadCaptchas.this.host);
                        if (direct && ((LoadCaptchas)LoadCaptchas.this).loadinfo.directLoad) {
                            if (!LoadCaptchas.this.threaded) {
                                for (int k = 1; k < ((LoadCaptchas)LoadCaptchas.this).loadinfo.menge - 1; ++k) {
                                    LoadCaptchas.this.selectedImage.directCaptchaLoad(LoadCaptchas.this.dir);
                                }
                                break block25;
                            }
                            ths = new Thread[((LoadCaptchas)LoadCaptchas.this).loadinfo.menge];
                            for (int k = 1; k < ((LoadCaptchas)LoadCaptchas.this).loadinfo.menge - 1; ++k) {
                                ths[k] = new Thread(new Runnable(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void run() {
                                        try {
                                            LoadCaptchas.this.selectedImage.directCaptchaLoad(LoadCaptchas.this.dir);
                                        }
                                        catch (Exception ev) {
                                            ev.printStackTrace();
                                        }
                                        1 var1_2 = this;
                                        synchronized (var1_2) {
                                            this.notify();
                                        }
                                    }
                                });
                                ths[k].start();
                            }
                            for (Thread thread : ths) {
                                while (thread != null && thread.isAlive()) {
                                    Thread thread2 = thread;
                                    synchronized (thread2) {
                                        try {
                                            thread.wait(30000L);
                                        }
                                        catch (InterruptedException e) {
                                            e.printStackTrace();
                                        }
                                    }
                                }
                            }
                            break block25;
                        }
                        FileCreationManager.getInstance().delete(((LoadCaptchas)LoadCaptchas.this).selectedImage.file, null);
                        if (!LoadCaptchas.this.threaded) {
                            for (int k = 1; k < ((LoadCaptchas)LoadCaptchas.this).loadinfo.menge - 1; ++k) {
                                LoadCaptchas.this.selectedImage.load(LoadCaptchas.this.host);
                            }
                            break block25;
                        }
                        ths = new Thread[((LoadCaptchas)LoadCaptchas.this).loadinfo.menge];
                        for (int k = 1; k < ((LoadCaptchas)LoadCaptchas.this).loadinfo.menge - 1; ++k) {
                            ths[k] = new Thread(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    try {
                                        LoadCaptchas.this.selectedImage.load(LoadCaptchas.this.host);
                                    }
                                    catch (Exception ev) {
                                        ev.printStackTrace();
                                    }
                                    2 var1_2 = this;
                                    synchronized (var1_2) {
                                        this.notify();
                                    }
                                }
                            });
                            ths[k].start();
                        }
                        for (Thread thread : ths) {
                            while (thread != null && thread.isAlive()) {
                                Thread thread3 = thread;
                                synchronized (thread3) {
                                    try {
                                        thread.wait(30000L);
                                    }
                                    catch (InterruptedException e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        Thread th2 = new Thread(runnable);
        th2.start();
    }
}

