/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.pixelgrid;

import jd.captcha.pixelgrid.Letter;

public class LevenshteinLetter {
    public boolean[][] horizontal;
    public boolean[][] vertical;
    char value;

    public LevenshteinLetter(boolean[][] horizontal, char value) {
        this.horizontal = horizontal;
        int h = horizontal[0].length;
        int w = horizontal.length;
        this.vertical = new boolean[h][w];
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                this.vertical[y][x] = horizontal[x][y];
            }
        }
        this.value = value;
    }

    public LevenshteinLetter(Letter letter) {
        int w = letter.getWidth();
        int h = letter.getHeight();
        if (w == 0 || h == 0) {
            return;
        }
        this.horizontal = new boolean[w][h];
        int avg = (int)((double)letter.getAverage() * letter.owner.getJas().getDouble("RelativeContrast"));
        for (int x = 0; x < this.horizontal.length; ++x) {
            for (int y = 0; y < this.horizontal[0].length; ++y) {
                this.horizontal[x][y] = letter.grid[x][y] < avg;
            }
        }
        this.vertical = new boolean[h][w];
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                this.vertical[y][x] = this.horizontal[x][y];
            }
        }
        if (letter.getDecodedValue() != null && letter.getDecodedValue().length() > 0) {
            this.value = letter.getDecodedValue().charAt(0);
        }
    }

    public Letter toLetter() {
        Letter let = new Letter();
        let.grid = new int[this.getWidth()][this.getHight()];
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHight(); ++y) {
                let.grid[x][y] = this.horizontal[x][y] ? 0 : 0xFFFFFF;
            }
        }
        let.setDecodedValue("" + this.value);
        return let;
    }

    public int getWidth() {
        return this.horizontal.length;
    }

    public int getHight() {
        return this.vertical.length;
    }
}

