/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.utils;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import jd.nutils.Colors;
import org.appwork.utils.Files;
import org.appwork.utils.IO;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;

public class RecaptchaTypeTester {
    private static final boolean SYSOUT = false;
    private static final boolean DEBUG_IMAGE = false;
    private static double TRESHOLD = 0.6;
    private static int RADIUS = 16;

    public static void main(String[] args) throws IOException {
        File folder = new File("G:\\recaptchas");
        File sub = new File(folder, "null");
        if (sub.exists()) {
            Files.deleteRecursiv((File)sub);
        }
        for (RecaptchaType t : RecaptchaType.values()) {
            sub = new File(folder, t.name());
            if (!sub.exists()) continue;
            Files.deleteRecursiv((File)sub);
        }
        RADIUS = 16;
        TRESHOLD = 0.6;
        int bad = 0;
        int good = 0;
        for (File file : folder.listFiles()) {
            File copyTp;
            if (!file.isFile() || !file.getName().endsWith(".jpg")) continue;
            RecaptchaType type = RecaptchaTypeTester.getType(file);
            if (file.getName().startsWith(type.name())) {
                ++good;
            } else {
                ++bad;
            }
            boolean hasName = false;
            for (RecaptchaType t : RecaptchaType.values()) {
                if (!file.getName().startsWith(t.name())) continue;
                hasName = true;
                break;
            }
            if (!hasName) {
                copyTp = new File(file.getParentFile(), (Object)((Object)type) + "/" + (Object)((Object)type) + "_" + file.getName());
                copyTp.getParentFile().mkdirs();
                IO.copyFile((File)file, (File)copyTp);
                continue;
            }
            copyTp = new File(file.getParentFile(), (Object)((Object)type) + "/" + file.getName());
            copyTp.getParentFile().mkdirs();
            IO.copyFile((File)file, (File)copyTp);
        }
    }

    public static void main22(String[] args) {
        File folder = new File("G:\\recaptchas");
        RADIUS = 16;
        TRESHOLD = 0.6;
        int bad = 0;
        int good = 0;
        for (File file : folder.listFiles()) {
            RecaptchaType type = null;
            for (RecaptchaType tt : RecaptchaType.values()) {
                if (!file.getName().startsWith(tt.name())) continue;
                type = tt;
                break;
            }
            if (type == null || !file.isFile() || !file.getName().endsWith(".jpg") || !file.getName().contains("TWO_")) continue;
            RecaptchaType detectedType = RecaptchaTypeTester.getType(file);
            if (detectedType == type) {
                ++good;
                continue;
            }
            ++bad;
            System.out.println(file);
        }
        double quality = (double)good / (double)(good + bad);
        System.out.println("Run t \t" + TRESHOLD + " r \t" + RADIUS + "  \t" + quality + " \t Bad: " + bad);
    }

    public static void main321(String[] args) throws IOException, DialogClosedException, DialogCanceledException {
        File folder = new File("G:\\recaptchas");
        double bestq = 0.0;
        for (int r = 15; r < 18; ++r) {
            for (int t = 600; t < 1000; t += 25) {
                RADIUS = r;
                TRESHOLD = (double)t / 1000.0;
                int bad = 0;
                int good = 0;
                for (File file : folder.listFiles()) {
                    RecaptchaType type = null;
                    for (RecaptchaType tt : RecaptchaType.values()) {
                        if (!file.getName().startsWith(tt.name())) continue;
                        type = tt;
                        break;
                    }
                    if (type == null || !file.isFile() || !file.getName().endsWith(".jpg") || !file.getName().contains("TWO_")) continue;
                    RecaptchaType detectedType = RecaptchaTypeTester.getType(file);
                    if (detectedType == type) {
                        ++good;
                        continue;
                    }
                    ++bad;
                }
                double quality = (double)good / (double)(good + bad);
                System.out.println("Run t \t" + TRESHOLD + " r \t" + RADIUS + "  \t" + quality);
                if (!(quality > bestq)) continue;
                bestq = quality;
                System.out.println("New Best QUality Bad: " + bad);
            }
        }
    }

    public static RecaptchaType getType(File file) {
        try {
            BufferedImage buf = ImageIO.read(file);
            int width = buf.getWidth();
            int height = buf.getHeight();
            if (buf.getType() == 5) {
                boolean textRight;
                Image newImage = null;
                Graphics g = null;
                int whiteCounterLeft = 0;
                int whiteCounterRight = 0;
                int whiteCounterLeft14 = 0;
                int whiteCounterRight14 = 0;
                int regDistLeft = 0;
                int rgbDistRight = 0;
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        boolean white;
                        boolean bl = white = Colors.getColorDifference((int)buf.getRGB(x, y), (int)0xFFFFFF) < 5.0;
                        if (white) {
                            if (x < width / 4) {
                                ++whiteCounterLeft14;
                            } else if (x > 3 * width / 4) {
                                ++whiteCounterRight14;
                            }
                            if (x < width / 2) {
                                ++whiteCounterLeft;
                            } else {
                                ++whiteCounterRight;
                            }
                            if (g != null) {
                                g.setColor(Color.WHITE);
                                g.drawLine(x, y, x, y);
                            }
                        } else if (g != null) {
                            g.setColor(Color.BLACK);
                            g.drawLine(x, y, x, y);
                        }
                        Color c = new Color(buf.getRGB(x, y));
                        int br = Math.abs(c.getBlue() - c.getRed());
                        int bg = Math.abs(c.getBlue() - c.getGreen());
                        int rg = Math.abs(c.getGreen() - c.getRed());
                        int v = (br + bg + rg) / 3;
                        if (x < width / 2) {
                            regDistLeft += v;
                            continue;
                        }
                        rgbDistRight += v;
                    }
                }
                double whiteLeft14 = (double)whiteCounterLeft14 / (double)(width / 4 * height);
                double whiteRight14 = (double)whiteCounterRight14 / (double)(width / 4 * height);
                double whiteLeft = (double)whiteCounterLeft / (double)(width / 2 * height);
                double whiteRight = (double)whiteCounterRight / (double)(width / 2 * height);
                double rgbLeft = (double)regDistLeft / (double)(width / 2 * height);
                double rgbRight = (double)rgbDistRight / (double)(width / 2 * height);
                if (g != null) {
                    g.drawImage(buf, 0, height, null);
                    g.dispose();
                }
                boolean textLeft = whiteLeft > 0.5 && rgbLeft < 5.0 && whiteLeft14 < 0.95;
                boolean bl = textRight = whiteRight > 0.5 && rgbRight < 5.0 && whiteRight14 < 0.95;
                if (whiteLeft > 0.5 && whiteRight > 0.5) {
                    if (g != null) {
                        Dialog.getInstance().showConfirmDialog(0, "", "", new ImageIcon(newImage), null, null);
                    }
                    return RecaptchaType.NUMBER;
                }
                if (textLeft && !textRight) {
                    if (g != null) {
                        Dialog.getInstance().showConfirmDialog(0, "", "", new ImageIcon(newImage), null, null);
                    }
                    return RecaptchaType.SPLIT_WITH_NUMBER;
                }
                if (textRight && !textLeft) {
                    if (g != null) {
                        Dialog.getInstance().showConfirmDialog(0, "", "", new ImageIcon(newImage), null, null);
                    }
                    return RecaptchaType.SPLIT_WITH_NUMBER;
                }
                if (g != null) {
                    Dialog.getInstance().showConfirmDialog(0, "", "", new ImageIcon(newImage), null, null);
                }
                return RecaptchaType.NUMBER;
            }
            boolean[][] pixel = new boolean[width][height];
            long t = System.currentTimeMillis();
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    pixel[x][y] = Colors.getColorDifference((int)buf.getRGB(x, y), (int)0xFFFFFF) > 20.0;
                }
            }
            t = System.currentTimeMillis();
            boolean isBanned = true;
            for (int x = 0; x < width; ++x) {
                if (pixel[x][15]) {
                    isBanned = false;
                    break;
                }
                if (pixel[x][29]) {
                    isBanned = false;
                    break;
                }
                if (!pixel[x][43]) continue;
                isBanned = false;
                break;
            }
            t = System.currentTimeMillis();
            if (isBanned) {
                return RecaptchaType.BANNED;
            }
            int words = 0;
            int lastBlackColumn = -1;
            boolean isWord = false;
            int blackMin = -1;
            for (int x = 0; x < width; ++x) {
                boolean white = true;
                for (int y = 0; y < height; ++y) {
                    if (!pixel[x][y]) continue;
                    white = false;
                    break;
                }
                if (white) {
                    if (!isWord || lastBlackColumn < 0 || x - lastBlackColumn <= 5) continue;
                    ++words;
                    isWord = false;
                    continue;
                }
                isWord = true;
                if (blackMin < 0) {
                    blackMin = x;
                }
                lastBlackColumn = x;
            }
            if (lastBlackColumn == width - 1) {
                ++words;
            }
            if (words == 1 && width - (lastBlackColumn - blackMin) < width / 5) {
                ++words;
            }
            t = System.currentTimeMillis();
            if (words <= 1) {
                return RecaptchaType.SINGLE_WORD;
            }
            double maxBWRationLeft = 0.0;
            double maxBWRationRight = 0.0;
            double tresh = TRESHOLD;
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    int radius = RADIUS;
                    boolean black = true;
                    int whitePX = 0;
                    int blackPX = 0;
                    int max = (radius * 2 + 1) * (radius * 2 + 1);
                    for (int xx = -radius; xx < radius; ++xx) {
                        for (int yy = -radius; yy < radius; ++yy) {
                            int currentX = x + xx;
                            int currentY = y + yy;
                            if (currentX < 0 || currentY < 0 || currentX > width - 1 || currentY > height - 1) continue;
                            if (!pixel[currentX][currentY]) {
                                ++whitePX;
                                black = false;
                                continue;
                            }
                            ++blackPX;
                        }
                    }
                    double rat = (double)blackPX / (double)max;
                    if (x <= width / 2) {
                        maxBWRationLeft = Math.max(rat, maxBWRationLeft);
                        continue;
                    }
                    maxBWRationRight = Math.max(rat, maxBWRationRight);
                }
            }
            t = System.currentTimeMillis();
            if (maxBWRationLeft > tresh || maxBWRationRight > tresh) {
                return RecaptchaType.DOTS_TWO_WORDS;
            }
            return RecaptchaType.TWO_WORDS;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static enum RecaptchaType {
        DOTS_TWO_WORDS,
        TWO_WORDS,
        NUMBER,
        SPLIT_WITH_NUMBER,
        SINGLE_WORD,
        BANNED;

    }
}

