/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction;

import java.util.List;
import jd.plugins.ExtensionConfigInterface;
import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultBooleanValue;
import org.appwork.storage.config.annotations.DefaultEnumValue;
import org.appwork.storage.config.annotations.DefaultIntValue;
import org.appwork.storage.config.annotations.DefaultJsonObject;
import org.appwork.storage.config.annotations.DefaultStringArrayValue;
import org.appwork.storage.config.annotations.DefaultStringValue;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.jdownloader.controlling.FileCreationManager;
import org.jdownloader.extensions.extraction.CPUPriority;
import org.jdownloader.extensions.extraction.FLUSH_MODE;
import org.jdownloader.extensions.extraction.IO_MODE;
import org.jdownloader.settings.IfFileExistsAction;

public interface ExtractionConfig
extends ExtensionConfigInterface {
    @DefaultStringArrayValue(value={"##Lines with XX are comments", "##Skip deep extraction of archives that contain binary files", ".*\\.exe", ".*\\.msi", ".*\\.bat", ".xbe", ".elf", ".sh"})
    @AboutConfig
    @DescriptionForConfigEntry(value="A list of regular expressions. Use to avoid deep extracting.")
    public String[] getDeepExtractionBlacklistPatterns();

    public void setDeepExtractionBlacklistPatterns(String[] var1);

    @DefaultStringArrayValue(value={"##Lines with ## are comments", "## Use / as path seperator", "##Example to skip extraction of sample folder files", "##.*sample/.*", "##Example to skip extraction of JPEG files", "##.*\\.jpe?g"})
    @AboutConfig
    @DescriptionForConfigEntry(value="A list of regular expressions. Use to avoid extracting certain filetypes.")
    public String[] getBlacklistPatterns();

    @DefaultEnumValue(value="HIGH")
    @AboutConfig
    public CPUPriority getCPUPriority();

    @AboutConfig
    @DescriptionForConfigEntry(value="Absolute path to the folder where all archives should be extracted to")
    public String getCustomExtractionPath();

    @AboutConfig
    @DefaultStringValue(value="%PACKAGENAME%")
    public String getSubPath();

    @DefaultJsonObject(value="[]")
    @AboutConfig
    @DescriptionForConfigEntry(value="A list of passwords for automatic extraction of password protected archives.")
    public List<String> getPasswordList();

    public void setPasswordList(List<String> var1);

    @DescriptionForConfigEntry(value="Only use subfolders if the archive ROOT contains at least *** files")
    @AboutConfig
    @DefaultIntValue(value=0)
    @SpinnerValidator(min=0L, max=30L)
    public int getSubPathMinFilesTreshhold();

    @DescriptionForConfigEntry(value="Only use subfolders if the archive ROOT contains at least *** folders")
    @AboutConfig
    @DefaultIntValue(value=0)
    @SpinnerValidator(min=0L, max=30L)
    public int getSubPathMinFoldersTreshhold();

    @DescriptionForConfigEntry(value="Only use subfolders if the archive ROOT contains at least *** folders or folders")
    @AboutConfig
    @DefaultIntValue(value=2)
    @SpinnerValidator(min=0L, max=30L)
    public int getSubPathMinFilesOrFoldersTreshhold();

    @DefaultBooleanValue(value=true)
    @AboutConfig
    @DescriptionForConfigEntry(value="Shall Extraction Extension ask you for passwords if the correct password has not been found in password cache?")
    public boolean isAskForUnknownPasswordsEnabled();

    @DescriptionForConfigEntry(value="Enabled usage of custom extraction paths")
    @DefaultBooleanValue(value=false)
    @AboutConfig
    public boolean isCustomExtractionPathEnabled();

    @DefaultBooleanValue(value=true)
    @AboutConfig
    @DescriptionForConfigEntry(value="Extraction Extension autoextracts sub-archives. If you do not want this, disable this option.")
    public boolean isDeepExtractionEnabled();

    @DescriptionForConfigEntry(value="Delete archives after successful extraction?")
    @DefaultEnumValue(value="NO_DELETE")
    @AboutConfig
    public FileCreationManager.DeleteOption getDeleteArchiveFilesAfterExtractionAction();

    @DescriptionForConfigEntry(value="Delete archive DownloadLinks after successful extraction?")
    @DefaultBooleanValue(value=false)
    @AboutConfig
    public boolean isDeleteArchiveDownloadlinksAfterExtraction();

    public void setDeleteArchiveDownloadlinksAfterExtraction(boolean var1);

    @DescriptionForConfigEntry(value="Info File Extension is able to create Info files for all downloaded files. Extraction Extension can remove these files")
    @DefaultBooleanValue(value=false)
    @AboutConfig
    public boolean isDeleteInfoFilesAfterExtraction();

    @AboutConfig
    @DefaultBooleanValue(value=false)
    public boolean isSubpathEnabled();

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="Use original filedate if possible")
    public boolean isUseOriginalFileDate();

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="Restore file permissions if possible")
    public boolean isRestoreFilePermissions();

    public void setRestoreFilePermissions(boolean var1);

    public void setAskForUnknownPasswordsEnabled(boolean var1);

    public void setBlacklistPatterns(String[] var1);

    public void setCPUPriority(CPUPriority var1);

    public void setCustomExtractionPath(String var1);

    public void setCustomExtractionPathEnabled(boolean var1);

    public void setDeepExtractionEnabled(boolean var1);

    public void setDeleteInfoFilesAfterExtraction(boolean var1);

    public void setSubPath(String var1);

    public void setSubpathEnabled(boolean var1);

    public void setSubPathMinFilesTreshhold(int var1);

    public void setSubPathMinFoldersTreshhold(int var1);

    public void setSubPathMinFilesOrFoldersTreshhold(int var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="max bytes the extractor may test for finding correct password when no signature is found")
    @SpinnerValidator(min=1024000L, max=0x7FFFFFFFL)
    @DefaultIntValue(value=1024000)
    public int getMaxCheckedFileSizeDuringOptimizedPasswordFindingInBytes();

    public void setMaxCheckedFileSizeDuringOptimizedPasswordFindingInBytes(int var1);

    public void setUseOriginalFileDate(boolean var1);

    @DefaultBooleanValue(value=true)
    @AboutConfig
    @DescriptionForConfigEntry(value="This option improves password find speed a lot, but may result in finding errors.")
    public boolean isPasswordFindOptimizationEnabled();

    public void setPasswordFindOptimizationEnabled(boolean var1);

    @DefaultBooleanValue(value=true)
    @AboutConfig
    @DescriptionForConfigEntry(value="Show Bubbles for Extration Jobs")
    public boolean isBubbleEnabledIfArchiveExtractionIsInProgress();

    public void setBubbleEnabledIfArchiveExtractionIsInProgress(boolean var1);

    @DefaultBooleanValue(value=true)
    @AboutConfig
    public boolean isBubbleContentDurationVisible();

    public void setBubbleContentDurationVisible(boolean var1);

    @DefaultBooleanValue(value=true)
    @AboutConfig
    public boolean isBubbleContentCircleProgressVisible();

    public void setBubbleContentCircleProgressVisible(boolean var1);

    @DefaultBooleanValue(value=true)
    @AboutConfig
    public boolean isBubbleContentStatusVisible();

    public void setBubbleContentStatusVisible(boolean var1);

    @DefaultBooleanValue(value=true)
    @AboutConfig
    public boolean isBubbleContentCurrentFileVisible();

    public void setBubbleContentCurrentFileVisible(boolean var1);

    @DefaultBooleanValue(value=true)
    @AboutConfig
    public boolean isBubbleContentExtractToFolderVisible();

    public void setBubbleContentExtractToFolderVisible(boolean var1);

    @DefaultBooleanValue(value=true)
    @AboutConfig
    public boolean isBubbleContentArchivenameVisible();

    public void setBubbleContentArchivenameVisible(boolean var1);

    public void setDeleteArchiveFilesAfterExtractionAction(FileCreationManager.DeleteOption var1);

    @AboutConfig
    @DefaultEnumValue(value="ASK_FOR_EACH_FILE")
    public IfFileExistsAction getIfFileExistsAction();

    public void setIfFileExistsAction(IfFileExistsAction var1);

    public IfFileExistsAction getLatestIfFileExistsAction();

    public void setLatestIfFileExistsAction(IfFileExistsAction var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Set the timeout for the 'Ask for archive password' dialog")
    @DefaultIntValue(value=600000)
    public int getAskForPasswordDialogTimeoutInMS();

    public void setAskForPasswordDialogTimeoutInMS(int var1);

    @AboutConfig
    public String getLastWorkingLibID();

    public void setLastWorkingLibID(String var1);

    @AboutConfig
    @DefaultEnumValue(value="NORMAL")
    @DescriptionForConfigEntry(value="If Enabled, JDownloader will pause/slow down extracting while crc hashing for downloads is done")
    public IO_MODE getIOModeForCrcHashing();

    public void setIOModeForCrcHashing(IO_MODE var1);

    @AboutConfig
    @DefaultEnumValue(value="NONE")
    @DescriptionForConfigEntry(value="FULL=Flush Meta/Data to disk, DATA=Flush Data only to disk, NONE=OS handles flush")
    public FLUSH_MODE getFlushMode();

    public void setFlushMode(FLUSH_MODE var1);

    @DefaultBooleanValue(value=false)
    @AboutConfig
    @DescriptionForConfigEntry(value="Enabled = Apply 'filenamereplacemap' on extract paths. Disabled = Do not apply 'filenamereplacemap' and only remove basic non-allowed characters and leading dots. As to why: Leading dots will make files and folders invisible under Unix-like systems. If you want leading dots to be removed AND want to apply the replace map, you need to put the removal of leading dots into the replace map.")
    public boolean isApplyFilenameRegexReplaceMapToExtractionPaths();

    public void setApplyFilenameRegexReplaceMapToExtractionPaths(boolean var1);
}

