/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.bindings.file;

import java.awt.Color;
import java.io.File;
import java.util.concurrent.atomic.AtomicReference;
import jd.plugins.LinkInfo;
import org.appwork.utils.StringUtils;
import org.jdownloader.controlling.FileCreationManager;
import org.jdownloader.controlling.FileStateManager;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ArchiveFile;
import org.jdownloader.extensions.extraction.ExtractionController;
import org.jdownloader.extensions.extraction.ExtractionStatus;

public class FileArchiveFile
implements ArchiveFile {
    private final File file;
    private final String name;
    private final String filePath;
    private final int hashCode;
    private final AtomicReference<Boolean> exists = new AtomicReference<Object>(null);
    private String archiveID = null;
    private volatile ExtractionStatus status = null;

    protected FileArchiveFile(File f) {
        this.file = f;
        this.exists.set(Boolean.TRUE);
        this.name = this.file.getName();
        this.filePath = this.file.getAbsolutePath();
        this.hashCode = (this.getClass() + this.name).hashCode();
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public Boolean isComplete() {
        return this.exists();
    }

    @Override
    public String getFilePath() {
        return this.filePath;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public LinkInfo getLinkInfo() {
        return LinkInfo.getLinkInfo((String)this.getName());
    }

    @Override
    public boolean contains(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null) {
            if (obj instanceof String) {
                return this.getFilePath().equals(obj);
            }
            if (obj instanceof ArchiveFile && StringUtils.equals((String)this.getFilePath(), (String)((ArchiveFile)obj).getFilePath())) {
                return true;
            }
            if (obj instanceof FileArchiveFile) {
                return this.getFile().equals(((FileArchiveFile)obj).getFile());
            }
            if (obj instanceof File) {
                return this.getFile().equals(obj);
            }
        }
        return false;
    }

    @Override
    public void deleteFile(FileCreationManager.DeleteOption option) {
        FileCreationManager.getInstance().delete(this.getFile(), option);
        this.invalidateExists();
    }

    public String toString() {
        return "File:" + this.filePath + "|Complete:" + this.isComplete();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setStatus(ExtractionController controller, ExtractionStatus status) {
        this.status = status;
    }

    @Override
    public ExtractionStatus getStatus() {
        ExtractionStatus status = this.status;
        if (status != null) {
            return status;
        }
        return ExtractionStatus.NA;
    }

    @Override
    public void setMessage(ExtractionController controller, String plugins_optional_extraction_status_notenoughspace) {
    }

    @Override
    public void setProgress(ExtractionController controller, long value, long max, Color color) {
    }

    @Override
    public long getFileSize() {
        return this.getFile().length();
    }

    @Override
    public void onCleanedUp(ExtractionController controller) {
    }

    @Override
    public void setArchive(Archive archive) {
        this.archiveID = archive.getArchiveID();
    }

    @Override
    public boolean exists() {
        return this.exists(false);
    }

    @Override
    public boolean exists(boolean ignoreCache) {
        Boolean ret;
        if (FileStateManager.getInstance().hasFileState(this.getFile(), FileStateManager.FILESTATE.WRITE_EXCLUSIVE)) {
            return false;
        }
        Boolean bl = ret = ignoreCache ? null : this.exists.get();
        if (ret == null) {
            ret = this.getFile().isFile();
            this.exists.compareAndSet(null, ret);
        }
        return ret;
    }

    @Override
    public void notifyChanges(Object type) {
    }

    @Override
    public void removePluginProgress(ExtractionController controller) {
    }

    @Override
    public void invalidateExists() {
        this.exists.set(null);
    }

    @Override
    public void setPartOfAnArchive(Boolean b) {
    }

    @Override
    public Boolean isPartOfAnArchive() {
        return null;
    }

    @Override
    public String getArchiveID() {
        return this.archiveID;
    }
}

