/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.contextmenu.downloadlist.action;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import jd.plugins.DownloadLink;
import org.appwork.utils.swing.dialog.Dialog;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ExtractionExtension;
import org.jdownloader.extensions.extraction.contextmenu.downloadlist.AbstractExtractionContextAction;
import org.jdownloader.extensions.extraction.translate.T;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.plugins.FinalLinkState;

public class ExtractArchiveNowAction
extends AbstractExtractionContextAction {
    public ExtractArchiveNowAction() {
        this.setName(T.T.contextmenu_extract());
        this.setIconKey("run");
    }

    @Override
    protected void onActionPerformed(ActionEvent e, final List<Archive> archives, SelectionInfo<?, ?> selectionInfo) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                for (Archive archive : archives) {
                    if (((ExtractionExtension)ExtractArchiveNowAction.this._getExtension()).isComplete(archive)) {
                        ((ExtractionExtension)ExtractArchiveNowAction.this._getExtension()).addToQueue(archive, true);
                        continue;
                    }
                    Dialog.getInstance().showMessageDialog(T.T.cannot_extract_incomplete(archive.getName()));
                }
            }
        };
        thread.setName("Extract Context: extract");
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    protected void onAsyncInitDone(List<Archive> archives, SelectionInfo<?, ?> selectionInfo) {
        this.setEnabled(this.isEnabled(archives, selectionInfo));
    }

    private boolean isEnabled(List<Archive> archives, SelectionInfo<?, ?> selectionInfo) {
        if (selectionInfo == null || selectionInfo.isEmpty()) {
            return false;
        }
        if (archives == null || archives.isEmpty()) {
            return false;
        }
        for (Object o : selectionInfo.getChildren()) {
            DownloadLink dl;
            if (!(o instanceof DownloadLink) || !(dl = (DownloadLink)o).isEnabled()) continue;
            if (FinalLinkState.CheckFinished((FinalLinkState)dl.getFinalLinkState())) {
                return true;
            }
            if (!new File(dl.getFileOutput()).exists()) continue;
            return true;
        }
        return false;
    }
}

