/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.multi;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import net.sf.sevenzipjbinding.ArchiveFormat;
import org.appwork.utils.Hash;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.formatter.HexFormatter;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ArchiveFactory;
import org.jdownloader.extensions.extraction.ArchiveFile;
import org.jdownloader.extensions.extraction.FileSignatures;
import org.jdownloader.extensions.extraction.MissingArchiveFile;
import org.jdownloader.extensions.extraction.multi.ArchiveException;
import org.jdownloader.extensions.extraction.multi.Multi;
import org.jdownloader.logging.LogController;

public enum ArchiveType {
    RAR_MULTI{
        private final Pattern pattern = Pattern.compile("(?i)(.*)\\.(part|p)(\\.?)(\\d{1,3})(\\..*?|)\\.rar$");

        @Override
        public ArchiveFormat getArchiveFormat(Archive archive) throws IOException {
            return ArchiveType.getRARArchiveFormat(archive);
        }

        @Override
        public boolean matches(String filePathOrName) {
            return filePathOrName != null && this.pattern.matcher(filePathOrName).matches();
        }

        @Override
        protected String buildIDPattern(String[] matches, Boolean isMultiPart) {
            if (Boolean.FALSE.equals(isMultiPart)) {
                return null;
            }
            return "\\." + matches[1] + this.escapeRegex(matches[2]) + "\\d{" + matches[3].length() + "}" + this.escapeRegex(matches[4]) + "\\.(?i)rar";
        }

        @Override
        public Pattern buildArchivePattern(String[] matches, Boolean isMultiPart) {
            if (Boolean.FALSE.equals(isMultiPart)) {
                return null;
            }
            String pattern = "^" + this.escapeRegex(matches[0]) + this.buildIDPattern(matches, isMultiPart) + "$";
            return Pattern.compile(pattern);
        }

        @Override
        public String[] getMatches(String filePathOrName) {
            return filePathOrName != null ? new Regex(filePathOrName, this.pattern).getRow(0) : null;
        }

        @Override
        protected String getPartNumberString(String filePathOrName) {
            String[] matches = this.getMatches(filePathOrName);
            return matches != null ? matches[3] : null;
        }

        @Override
        protected int getPartNumber(String partNumberString) {
            return Integer.parseInt(partNumberString);
        }

        @Override
        protected int getFirstPartIndex() {
            return 1;
        }

        @Override
        protected int getMinimumNeededPartIndex() {
            return 2;
        }

        @Override
        protected String buildMissingPart(String[] matches, int partIndex, int partStringLength) {
            return matches[0] + "." + matches[1] + matches[2] + String.format(Locale.US, "%0" + partStringLength + "d", partIndex) + matches[4] + ".rar";
        }

        @Override
        protected Boolean isMultiPart(ArchiveFile archiveFile, boolean verifiedResult) {
            return RAR_SINGLE.isMultiPart(archiveFile, false);
        }

        @Override
        public String getIconExtension() {
            return RAR_SINGLE.getIconExtension();
        }

        @Override
        protected boolean isMultiPartType() {
            return true;
        }
    }
    ,
    RAR_MULTI2{
        private final Pattern pattern = Pattern.compile("(?i)(.*)\\.(\\d{3})\\.rar$");
        private final int multiPartThreshold = 50;

        @Override
        public ArchiveFormat getArchiveFormat(Archive archive) throws IOException {
            return ArchiveType.getRARArchiveFormat(archive);
        }

        @Override
        public boolean matches(String filePathOrName) {
            return filePathOrName != null && this.pattern.matcher(filePathOrName).matches();
        }

        @Override
        protected String buildIDPattern(String[] matches, Boolean isMultiPart) {
            if (Boolean.FALSE.equals(isMultiPart)) {
                return null;
            }
            return "\\.\\d{3}\\.(?i)rar";
        }

        @Override
        public Pattern buildArchivePattern(String[] matches, Boolean isMultiPart) {
            if (Boolean.FALSE.equals(isMultiPart)) {
                return null;
            }
            String pattern = "^" + this.escapeRegex(matches[0]) + this.buildIDPattern(matches, isMultiPart) + "$";
            return Pattern.compile(pattern);
        }

        @Override
        public String[] getMatches(String filePathOrName) {
            return filePathOrName != null ? new Regex(filePathOrName, this.pattern).getRow(0) : null;
        }

        @Override
        protected String getPartNumberString(String filePathOrName) {
            String[] matches = this.getMatches(filePathOrName);
            return matches != null ? matches[1] : null;
        }

        @Override
        protected int getPartNumber(String partNumberString) {
            return Integer.parseInt(partNumberString);
        }

        @Override
        protected int getFirstPartIndex() {
            return 0;
        }

        @Override
        protected int getMinimumNeededPartIndex() {
            return 1;
        }

        @Override
        protected boolean isMultiPartType() {
            return true;
        }

        @Override
        protected boolean looksLikeAnArchive(BitSet bitset, ArchiveFile[] archiveFiles) {
            int setCount = 0;
            for (int index = 0; index < bitset.length(); ++index) {
                if (!bitset.get(index)) continue;
                ++setCount;
            }
            return setCount * 100 / bitset.length() > 50;
        }

        @Override
        protected String buildMissingPart(String[] matches, int partIndex, int partStringLength) {
            return matches[0] + "." + String.format(Locale.US, "%0" + partStringLength + "d", partIndex) + ".rar";
        }

        @Override
        protected Boolean isMultiPart(ArchiveFile archiveFile, boolean verifiedResult) {
            return RAR_SINGLE.isMultiPart(archiveFile, false);
        }

        @Override
        public String getIconExtension() {
            return RAR_SINGLE.getIconExtension();
        }
    }
    ,
    RAR_MULTI3{
        private final Pattern patternPart = Pattern.compile("(?i)(.*)\\.([r-z]\\d{2})$");
        private final Pattern patternStart = Pattern.compile("(?i)(.*)\\.rar$");

        @Override
        public ArchiveFormat getArchiveFormat(Archive archive) throws IOException {
            return ArchiveType.getRARArchiveFormat(archive);
        }

        @Override
        protected boolean isMultiPartType() {
            return true;
        }

        @Override
        public boolean matches(String filePathOrName) {
            return filePathOrName != null && this.patternPart.matcher(filePathOrName).matches() || this.patternStart.matcher(filePathOrName).matches();
        }

        @Override
        protected String buildIDPattern(String[] matches, Boolean isMultiPart) {
            if (Boolean.FALSE.equals(isMultiPart)) {
                return null;
            }
            return "\\.(?i)([r-z]\\d{2}|rar)";
        }

        @Override
        public Pattern buildArchivePattern(String[] matches, Boolean isMultiPart) {
            if (Boolean.FALSE.equals(isMultiPart)) {
                return null;
            }
            String pattern = "^" + this.escapeRegex(matches[0]) + this.buildIDPattern(matches, isMultiPart) + "$";
            return Pattern.compile(pattern);
        }

        @Override
        public String[] getMatches(String filePathOrName) {
            if (filePathOrName != null) {
                String[] matches = new Regex(filePathOrName, this.patternPart).getRow(0);
                if (matches == null) {
                    matches = new Regex(filePathOrName, this.patternStart).getRow(0);
                }
                return matches;
            }
            return null;
        }

        @Override
        protected String getPartNumberString(String filePathOrName) {
            String[] matches = new Regex(filePathOrName, this.patternPart).getRow(0);
            return matches != null ? matches[1] : null;
        }

        @Override
        protected int getPartNumber(String partNumberString) {
            if (partNumberString == null) {
                return 0;
            }
            String number = partNumberString.substring(1);
            int base = partNumberString.charAt(0) - 114;
            return base * 100 + Integer.parseInt(number) + 1;
        }

        @Override
        protected int getFirstPartIndex() {
            return 0;
        }

        @Override
        protected int getMinimumNeededPartIndex() {
            return 0;
        }

        @Override
        protected boolean looksLikeAnArchive(BitSet bitset, ArchiveFile[] archiveFiles) {
            int setCount = 0;
            for (int index = 0; index < bitset.length(); ++index) {
                if (!bitset.get(index)) continue;
                ++setCount;
            }
            return setCount > 1 || bitset.length() > 1;
        }

        @Override
        protected String buildMissingPart(String[] matches, int partIndex, int partStringLength) {
            if (partIndex == 0) {
                return matches[0] + ".rar";
            }
            int start = 114;
            int index = partIndex - 1;
            while (index >= 100) {
                index -= 100;
                ++start;
            }
            return matches[0] + "." + String.valueOf((char)start) + String.format(Locale.US, "%02d", index);
        }

        @Override
        protected Boolean isMultiPart(ArchiveFile archiveFile, boolean verifiedResult) {
            return RAR_SINGLE.isMultiPart(archiveFile, false);
        }

        @Override
        public String getIconExtension() {
            return RAR_SINGLE.getIconExtension();
        }
    }
    ,
    RAR_SINGLE{
        private final Pattern pattern = Pattern.compile("(?i)(.*)\\.rar$");

        @Override
        public ArchiveFormat getArchiveFormat(Archive archive) throws IOException {
            return ArchiveType.getRARArchiveFormat(archive);
        }

        @Override
        protected boolean isMultiPartType() {
            return false;
        }

        @Override
        public boolean matches(String filePathOrName) {
            return filePathOrName != null && this.pattern.matcher(filePathOrName).matches();
        }

        @Override
        protected String buildIDPattern(String[] matches, Boolean isMultiPart) {
            if (Boolean.TRUE.equals(isMultiPart)) {
                return null;
            }
            return "\\.(?i)rar";
        }

        @Override
        public Pattern buildArchivePattern(String[] matches, Boolean isMultiPart) {
            if (Boolean.TRUE.equals(isMultiPart)) {
                return null;
            }
            String pattern = "^" + this.escapeRegex(matches[0]) + this.buildIDPattern(matches, isMultiPart) + "$";
            return Pattern.compile(pattern);
        }

        @Override
        public String[] getMatches(String filePathOrName) {
            return filePathOrName != null ? new Regex(filePathOrName, this.pattern).getRow(0) : null;
        }

        @Override
        protected String getPartNumberString(String filePathOrName) {
            return null;
        }

        @Override
        protected int getPartNumber(String partNumberString) {
            return 0;
        }

        @Override
        protected int getFirstPartIndex() {
            return 0;
        }

        @Override
        protected int getMinimumNeededPartIndex() {
            return 0;
        }

        @Override
        protected String buildMissingPart(String[] matches, int partIndex, int partStringLength) {
            return matches[0] + ".rar";
        }

        @Override
        protected Boolean isValidPart(int partIndex, ArchiveFile archiveFile, boolean verifiedResult) {
            if (archiveFile == null) {
                return false;
            }
            if (partIndex == -1) {
                return null;
            }
            if (archiveFile.exists(verifiedResult)) {
                String signatureString;
                try {
                    signatureString = FileSignatures.readFileSignature(new File(archiveFile.getFilePath()), 4);
                }
                catch (IOException e) {
                    LogController.CL().log((Throwable)e);
                    return false;
                }
                if (signatureString.length() >= 8) {
                    return signatureString.startsWith("52617221");
                }
            }
            return verifiedResult ? Boolean.valueOf(false) : null;
        }

        @Override
        protected Boolean isMultiPart(ArchiveFile archiveFile, boolean verifiedResult) {
            if (archiveFile.exists(verifiedResult)) {
                String signatureString;
                try {
                    signatureString = FileSignatures.readFileSignature(new File(archiveFile.getFilePath()), 32);
                }
                catch (IOException e) {
                    LogController.CL().log((Throwable)e);
                    return false;
                }
                if (signatureString.length() >= 8) {
                    boolean isRAR4x = StringUtils.startsWithCaseInsensitive((String)signatureString, (String)"526172211A0700");
                    boolean isRAR5x = StringUtils.startsWithCaseInsensitive((String)signatureString, (String)"526172211A070100");
                    if (isRAR4x && signatureString.length() >= 24) {
                        boolean archiveHeader = "73".equals(signatureString.substring(18, 20));
                        String flagsBits = signatureString.substring(22, 24) + signatureString.substring(20, 22);
                        int flags = Integer.parseInt(flagsBits, 16);
                        boolean isVolume = (flags & 1) != 0;
                        boolean isComment = (flags & 2) != 0;
                        boolean isLock = (flags & 4) != 0;
                        boolean isSolid = (flags & 8) != 0;
                        boolean isNewVolumeNamingScheme = (flags & 0x10) != 0;
                        boolean isFirstVolume = (flags & 0x100) != 0;
                        boolean isMultiPart = archiveHeader && isVolume;
                        return isMultiPart;
                    }
                    if (isRAR5x && signatureString.length() >= 34) {
                        try {
                            ByteArrayInputStream is = new ByteArrayInputStream(HexFormatter.hexToByteArray((String)signatureString.substring(24)));
                            long headerSize = this.readVarInt(is, true);
                            long headerType = this.readVarInt(is, true);
                            if (headerType == 1L) {
                                long headerFlags = this.readVarInt(is, true);
                                long extraAreaSize = this.readVarInt(is, true);
                                long archiveFlags = this.readVarInt(is, true);
                                boolean isVolume = (archiveFlags & 1L) != 0L;
                                boolean isVolumeNumberPresent = (archiveFlags & 2L) != 0L;
                                boolean isSolidArchive = (archiveFlags & 4L) != 0L;
                                boolean isRecoveryRecordPreset = (archiveFlags & 8L) != 0L;
                                boolean isLockedArchive = (archiveFlags & 0x10L) != 0L;
                                boolean isMultiPart = isVolume;
                                return isMultiPart;
                            }
                            if (headerType == 4L) {
                                return null;
                            }
                        }
                        catch (IOException iOException) {}
                    } else {
                        return null;
                    }
                    return verifiedResult ? Boolean.valueOf(false) : null;
                }
            }
            return verifiedResult ? Boolean.valueOf(false) : null;
        }

        private long readVarInt(InputStream is, boolean alwaysThrowEOF) throws IOException {
            long ret = 0L;
            int shift = 0;
            while (true) {
                int read;
                if ((read = is.read()) == -1) {
                    if (shift > 0 && alwaysThrowEOF) {
                        throw new EOFException();
                    }
                    return -1L;
                }
                long value = read & 0x7F;
                int msb = (read & 0xFF) >> 7;
                ret |= value << shift;
                if (msb == 0) {
                    return ret;
                }
                shift += 7;
            }
        }

        @Override
        public String getIconExtension() {
            return "rar";
        }
    }
    ,
    SEVENZIP_PARTS{
        private final Pattern pattern = Pattern.compile("(?i)(.*)\\.7z\\.(\\d{1,3})$");

        @Override
        public ArchiveFormat getArchiveFormat(Archive archive) throws IOException {
            return ArchiveFormat.SEVEN_ZIP;
        }

        @Override
        public boolean matches(String filePathOrName) {
            return filePathOrName != null && this.pattern.matcher(filePathOrName).matches();
        }

        @Override
        protected String buildIDPattern(String[] matches, Boolean isMultiPart) {
            if (Boolean.FALSE.equals(isMultiPart)) {
                return null;
            }
            return "\\.(?i)7z\\.\\d{" + matches[1].length() + "}";
        }

        @Override
        protected boolean isMultiPartType() {
            return true;
        }

        @Override
        public Pattern buildArchivePattern(String[] matches, Boolean isMultiPart) {
            if (Boolean.FALSE.equals(isMultiPart)) {
                return null;
            }
            String pattern = "^" + this.escapeRegex(matches[0]) + this.buildIDPattern(matches, null) + "$";
            return Pattern.compile(pattern);
        }

        @Override
        public String[] getMatches(String filePathOrName) {
            return filePathOrName != null ? new Regex(filePathOrName, this.pattern).getRow(0) : null;
        }

        @Override
        protected String getPartNumberString(String filePathOrName) {
            String[] matches = this.getMatches(filePathOrName);
            return matches != null ? matches[1] : null;
        }

        @Override
        protected int getPartNumber(String partNumberString) {
            return Integer.parseInt(partNumberString);
        }

        @Override
        protected int getFirstPartIndex() {
            return 1;
        }

        @Override
        protected int getMinimumNeededPartIndex() {
            return 1;
        }

        @Override
        protected String buildMissingPart(String[] matches, int partIndex, int partStringLength) {
            return matches[0] + ".7z." + String.format(Locale.US, "%0" + partStringLength + "d", partIndex);
        }

        @Override
        public String getIconExtension() {
            return SEVENZIP_SINGLE.getIconExtension();
        }
    }
    ,
    ZIP_MULTI2{
        private final Pattern pattern = Pattern.compile("(?i)(.*)\\.z(ip|\\d{1,3})$");

        @Override
        public ArchiveFormat getArchiveFormat(Archive archive) throws IOException {
            return ArchiveFormat.ZIP;
        }

        @Override
        protected boolean isMultiPartType() {
            return true;
        }

        @Override
        public boolean matches(String filePathOrName) {
            return filePathOrName != null && this.pattern.matcher(filePathOrName).matches();
        }

        @Override
        protected String buildIDPattern(String[] matches, Boolean isMultiPart) {
            if (Boolean.FALSE.equals(isMultiPart)) {
                return null;
            }
            return "\\.(?i)z(ip|\\d{" + matches[1].length() + "})";
        }

        @Override
        public Pattern buildArchivePattern(String[] matches, Boolean isMultiPart) {
            if (Boolean.FALSE.equals(isMultiPart)) {
                return null;
            }
            String pattern = "^" + this.escapeRegex(matches[0]) + this.buildIDPattern(matches, null) + "$";
            return Pattern.compile(pattern);
        }

        @Override
        public String[] getMatches(String filePathOrName) {
            return filePathOrName != null ? new Regex(filePathOrName, this.pattern).getRow(0) : null;
        }

        @Override
        protected String getPartNumberString(String filePathOrName) {
            String[] matches = this.getMatches(filePathOrName);
            return matches != null ? matches[1] : null;
        }

        @Override
        protected int getPartNumber(String partNumberString) {
            if ("ip".equals(partNumberString.toLowerCase(Locale.ENGLISH))) {
                return 0;
            }
            return Integer.parseInt(partNumberString);
        }

        @Override
        protected int getFirstPartIndex() {
            return 0;
        }

        @Override
        protected boolean looksLikeAnArchive(BitSet bitset, ArchiveFile[] archiveFiles) {
            for (int index = 0; index < bitset.length(); ++index) {
                if (!bitset.get(index) || index <= 0) continue;
                return true;
            }
            return false;
        }

        @Override
        protected int getMinimumNeededPartIndex() {
            return 0;
        }

        @Override
        protected String buildMissingPart(String[] matches, int partIndex, int partStringLength) {
            if (partIndex == 0) {
                return matches[0] + ".zip";
            }
            return matches[0] + ".z" + String.format(Locale.US, "%0" + partStringLength + "d", partIndex);
        }

        @Override
        public String getIconExtension() {
            return ZIP_SINGLE.getIconExtension();
        }
    }
    ,
    ZIP_MULTI{
        private final Pattern pattern = Pattern.compile("(?i)(.*)\\.zip\\.(\\d{1,3})$");

        @Override
        public ArchiveFormat getArchiveFormat(Archive archive) throws IOException {
            return ArchiveFormat.ZIP;
        }

        @Override
        protected boolean isMultiPartType() {
            return true;
        }

        @Override
        public boolean matches(String filePathOrName) {
            return filePathOrName != null && this.pattern.matcher(filePathOrName).matches();
        }

        @Override
        protected String buildIDPattern(String[] matches, Boolean isMultiPart) {
            if (Boolean.FALSE.equals(isMultiPart)) {
                return null;
            }
            return "\\.(?i)zip\\.\\d{" + matches[1].length() + "}";
        }

        @Override
        public Pattern buildArchivePattern(String[] matches, Boolean isMultiPart) {
            if (Boolean.FALSE.equals(isMultiPart)) {
                return null;
            }
            String pattern = "^" + this.escapeRegex(matches[0]) + this.buildIDPattern(matches, null) + "$";
            return Pattern.compile(pattern);
        }

        @Override
        public String[] getMatches(String filePathOrName) {
            return filePathOrName != null ? new Regex(filePathOrName, this.pattern).getRow(0) : null;
        }

        @Override
        protected String getPartNumberString(String filePathOrName) {
            String[] matches = this.getMatches(filePathOrName);
            return matches != null ? matches[1] : null;
        }

        @Override
        protected int getPartNumber(String partNumberString) {
            return Integer.parseInt(partNumberString);
        }

        @Override
        protected int getFirstPartIndex() {
            return 1;
        }

        @Override
        protected int getMinimumNeededPartIndex() {
            return 2;
        }

        @Override
        protected String buildMissingPart(String[] matches, int partIndex, int partStringLength) {
            return matches[0] + ".zip." + String.format(Locale.US, "%0" + partStringLength + "d", partIndex);
        }

        @Override
        public String getIconExtension() {
            return ZIP_SINGLE.getIconExtension();
        }
    }
    ,
    SEVENZIP_SINGLE{
        private final Pattern pattern = Pattern.compile("(?i)(.*)\\.7z$");

        @Override
        public ArchiveFormat getArchiveFormat(Archive archive) throws IOException {
            return ArchiveFormat.SEVEN_ZIP;
        }

        @Override
        protected boolean isMultiPartType() {
            return false;
        }

        @Override
        public boolean matches(String filePathOrName) {
            return filePathOrName != null && this.pattern.matcher(filePathOrName).matches();
        }

        @Override
        protected String buildIDPattern(String[] matches, Boolean isMultiPart) {
            if (Boolean.TRUE.equals(isMultiPart)) {
                return null;
            }
            return "\\.(?i)7z";
        }

        @Override
        public Pattern buildArchivePattern(String[] matches, Boolean isMultiPart) {
            if (Boolean.TRUE.equals(isMultiPart)) {
                return null;
            }
            String pattern = "^" + this.escapeRegex(matches[0]) + this.buildIDPattern(matches, null) + "$";
            return Pattern.compile(pattern);
        }

        @Override
        public String[] getMatches(String filePathOrName) {
            return filePathOrName != null ? new Regex(filePathOrName, this.pattern).getRow(0) : null;
        }

        @Override
        protected String getPartNumberString(String filePathOrName) {
            return null;
        }

        @Override
        protected int getPartNumber(String partNumberString) {
            return 0;
        }

        @Override
        protected int getFirstPartIndex() {
            return 0;
        }

        @Override
        protected int getMinimumNeededPartIndex() {
            return 0;
        }

        @Override
        protected String buildMissingPart(String[] matches, int partIndex, int partStringLength) {
            return matches[0] + ".7z";
        }

        @Override
        public String getIconExtension() {
            return "7z";
        }
    }
    ,
    ZIP_SINGLE{
        private final Pattern pattern = Pattern.compile("(?i)(.*)\\.zip$");

        @Override
        public ArchiveFormat getArchiveFormat(Archive archive) throws IOException {
            return ArchiveFormat.ZIP;
        }

        @Override
        protected boolean isMultiPartType() {
            return false;
        }

        @Override
        public boolean matches(String filePathOrName) {
            return filePathOrName != null && this.pattern.matcher(filePathOrName).matches();
        }

        @Override
        protected String buildIDPattern(String[] matches, Boolean isMultiPart) {
            if (Boolean.TRUE.equals(isMultiPart)) {
                return null;
            }
            return "\\.(?i)zip";
        }

        @Override
        public Pattern buildArchivePattern(String[] matches, Boolean isMultiPart) {
            if (Boolean.TRUE.equals(isMultiPart)) {
                return null;
            }
            String pattern = "^" + this.escapeRegex(matches[0]) + this.buildIDPattern(matches, null) + "$";
            return Pattern.compile(pattern);
        }

        @Override
        public String[] getMatches(String filePathOrName) {
            return filePathOrName != null ? new Regex(filePathOrName, this.pattern).getRow(0) : null;
        }

        @Override
        protected String getPartNumberString(String filePathOrName) {
            return null;
        }

        @Override
        protected int getPartNumber(String partNumberString) {
            return 0;
        }

        @Override
        protected int getFirstPartIndex() {
            return 0;
        }

        @Override
        protected int getMinimumNeededPartIndex() {
            return 0;
        }

        @Override
        protected String buildMissingPart(String[] matches, int partIndex, int partStringLength) {
            return matches[0] + ".zip";
        }

        @Override
        public String getIconExtension() {
            return "zip";
        }
    }
    ,
    LZH_SINGLE{
        private final Pattern pattern = Pattern.compile("(?i)(.*)\\.(lha|lzh)$");

        @Override
        public ArchiveFormat getArchiveFormat(Archive archive) throws IOException {
            return ArchiveFormat.LZH;
        }

        @Override
        protected boolean isMultiPartType() {
            return false;
        }

        @Override
        public boolean matches(String filePathOrName) {
            return filePathOrName != null && this.pattern.matcher(filePathOrName).matches();
        }

        @Override
        protected String buildIDPattern(String[] matches, Boolean isMultiPart) {
            if (Boolean.TRUE.equals(isMultiPart)) {
                return null;
            }
            return "\\." + matches[1];
        }

        @Override
        public Pattern buildArchivePattern(String[] matches, Boolean isMultiPart) {
            if (Boolean.TRUE.equals(isMultiPart)) {
                return null;
            }
            String pattern = "^" + this.escapeRegex(matches[0]) + this.buildIDPattern(matches, null) + "$";
            return Pattern.compile(pattern);
        }

        @Override
        public String[] getMatches(String filePathOrName) {
            return filePathOrName != null ? new Regex(filePathOrName, this.pattern).getRow(0) : null;
        }

        @Override
        protected String getPartNumberString(String filePathOrName) {
            return null;
        }

        @Override
        protected int getPartNumber(String partNumberString) {
            return 0;
        }

        @Override
        protected int getFirstPartIndex() {
            return 0;
        }

        @Override
        protected int getMinimumNeededPartIndex() {
            return 0;
        }

        @Override
        protected String buildMissingPart(String[] matches, int partIndex, int partStringLength) {
            return matches[0] + "." + matches[1];
        }

        @Override
        public String getIconExtension() {
            return "lzh";
        }
    }
    ,
    TAR_SINGLE{
        private final Pattern pattern = Pattern.compile("(?i)(.*)\\.tar$");

        @Override
        public ArchiveFormat getArchiveFormat(Archive archive) throws IOException {
            return ArchiveFormat.TAR;
        }

        @Override
        protected boolean isMultiPartType() {
            return false;
        }

        @Override
        public boolean matches(String filePathOrName) {
            return filePathOrName != null && this.pattern.matcher(filePathOrName).matches();
        }

        @Override
        protected String buildIDPattern(String[] matches, Boolean isMultiPart) {
            if (Boolean.TRUE.equals(isMultiPart)) {
                return null;
            }
            return "\\.(?i)tar";
        }

        @Override
        public Pattern buildArchivePattern(String[] matches, Boolean isMultiPart) {
            if (Boolean.TRUE.equals(isMultiPart)) {
                return null;
            }
            String pattern = "^" + this.escapeRegex(matches[0]) + this.buildIDPattern(matches, null) + "$";
            return Pattern.compile(pattern);
        }

        @Override
        public String[] getMatches(String filePathOrName) {
            return filePathOrName != null ? new Regex(filePathOrName, this.pattern).getRow(0) : null;
        }

        @Override
        protected String getPartNumberString(String filePathOrName) {
            return null;
        }

        @Override
        protected int getPartNumber(String partNumberString) {
            return 0;
        }

        @Override
        protected int getFirstPartIndex() {
            return 0;
        }

        @Override
        protected int getMinimumNeededPartIndex() {
            return 0;
        }

        @Override
        protected String buildMissingPart(String[] matches, int partIndex, int partStringLength) {
            return matches[0] + ".tar";
        }

        @Override
        public String getIconExtension() {
            return "tar";
        }
    }
    ,
    ARJ_SINGLE{
        private final Pattern pattern = Pattern.compile("(?i)(.*)\\.arj$");

        @Override
        public ArchiveFormat getArchiveFormat(Archive archive) throws IOException {
            return ArchiveFormat.ARJ;
        }

        @Override
        protected boolean isMultiPartType() {
            return false;
        }

        @Override
        public boolean matches(String filePathOrName) {
            return filePathOrName != null && this.pattern.matcher(filePathOrName).matches();
        }

        @Override
        protected String buildIDPattern(String[] matches, Boolean isMultiPart) {
            if (Boolean.TRUE.equals(isMultiPart)) {
                return null;
            }
            return "\\.(?i)arj";
        }

        @Override
        public Pattern buildArchivePattern(String[] matches, Boolean isMultiPart) {
            if (Boolean.TRUE.equals(isMultiPart)) {
                return null;
            }
            String pattern = "^" + this.escapeRegex(matches[0]) + this.buildIDPattern(matches, null) + "$";
            return Pattern.compile(pattern);
        }

        @Override
        public String[] getMatches(String filePathOrName) {
            return filePathOrName != null ? new Regex(filePathOrName, this.pattern).getRow(0) : null;
        }

        @Override
        protected String getPartNumberString(String filePathOrName) {
            return null;
        }

        @Override
        protected int getPartNumber(String partNumberString) {
            return 0;
        }

        @Override
        protected int getFirstPartIndex() {
            return 0;
        }

        @Override
        protected int getMinimumNeededPartIndex() {
            return 0;
        }

        @Override
        protected String buildMissingPart(String[] matches, int partIndex, int partStringLength) {
            return matches[0] + ".arj";
        }

        @Override
        public String getIconExtension() {
            return "arj";
        }
    }
    ,
    CPIO_SINGLE{
        private final Pattern pattern = Pattern.compile("(?i)(.*)\\.cpio$");

        @Override
        public ArchiveFormat getArchiveFormat(Archive archive) throws IOException {
            return ArchiveFormat.CPIO;
        }

        @Override
        protected boolean isMultiPartType() {
            return false;
        }

        @Override
        public boolean matches(String filePathOrName) {
            return filePathOrName != null && this.pattern.matcher(filePathOrName).matches();
        }

        @Override
        protected String buildIDPattern(String[] matches, Boolean isMultiPart) {
            if (Boolean.TRUE.equals(isMultiPart)) {
                return null;
            }
            return "\\.(?i)cpio";
        }

        @Override
        public Pattern buildArchivePattern(String[] matches, Boolean isMultiPart) {
            if (Boolean.TRUE.equals(isMultiPart)) {
                return null;
            }
            String pattern = "^" + this.escapeRegex(matches[0]) + this.buildIDPattern(matches, null) + "$";
            return Pattern.compile(pattern);
        }

        @Override
        public String[] getMatches(String filePathOrName) {
            return filePathOrName != null ? new Regex(filePathOrName, this.pattern).getRow(0) : null;
        }

        @Override
        protected String getPartNumberString(String filePathOrName) {
            return null;
        }

        @Override
        protected int getPartNumber(String partNumberString) {
            return 0;
        }

        @Override
        protected int getFirstPartIndex() {
            return 0;
        }

        @Override
        protected int getMinimumNeededPartIndex() {
            return 0;
        }

        @Override
        protected String buildMissingPart(String[] matches, int partIndex, int partStringLength) {
            return matches[0] + ".cpio";
        }

        @Override
        public String getIconExtension() {
            return "cpio";
        }
    }
    ,
    TGZ_SINGLE{
        private final Pattern pattern = Pattern.compile("(?i)(.*)\\.tgz$");

        @Override
        public ArchiveFormat getArchiveFormat(Archive archive) throws IOException {
            return ArchiveFormat.GZIP;
        }

        @Override
        protected boolean isMultiPartType() {
            return false;
        }

        @Override
        public boolean matches(String filePathOrName) {
            return filePathOrName != null && this.pattern.matcher(filePathOrName).matches();
        }

        @Override
        protected String buildIDPattern(String[] matches, Boolean isMultiPart) {
            if (Boolean.TRUE.equals(isMultiPart)) {
                return null;
            }
            return "\\.(?i)tgz";
        }

        @Override
        public Pattern buildArchivePattern(String[] matches, Boolean isMultiPart) {
            if (Boolean.TRUE.equals(isMultiPart)) {
                return null;
            }
            String pattern = "^" + this.escapeRegex(matches[0]) + this.buildIDPattern(matches, null) + "$";
            return Pattern.compile(pattern);
        }

        @Override
        public String[] getMatches(String filePathOrName) {
            return filePathOrName != null ? new Regex(filePathOrName, this.pattern).getRow(0) : null;
        }

        @Override
        protected String getPartNumberString(String filePathOrName) {
            return null;
        }

        @Override
        protected int getPartNumber(String partNumberString) {
            return 0;
        }

        @Override
        protected int getFirstPartIndex() {
            return 0;
        }

        @Override
        protected int getMinimumNeededPartIndex() {
            return 0;
        }

        @Override
        protected String buildMissingPart(String[] matches, int partIndex, int partStringLength) {
            return matches[0] + ".tgz";
        }

        @Override
        public String getIconExtension() {
            return "tgz";
        }
    }
    ,
    GZIP_SINGLE{
        private final Pattern pattern = Pattern.compile("(?i)(.*)\\.gz$");

        @Override
        public ArchiveFormat getArchiveFormat(Archive archive) throws IOException {
            return ArchiveFormat.GZIP;
        }

        @Override
        protected boolean isMultiPartType() {
            return false;
        }

        @Override
        public boolean matches(String filePathOrName) {
            return filePathOrName != null && this.pattern.matcher(filePathOrName).matches();
        }

        @Override
        protected String buildIDPattern(String[] matches, Boolean isMultiPart) {
            if (Boolean.TRUE.equals(isMultiPart)) {
                return null;
            }
            return "\\.(?i)gz";
        }

        @Override
        public Pattern buildArchivePattern(String[] matches, Boolean isMultiPart) {
            if (Boolean.TRUE.equals(isMultiPart)) {
                return null;
            }
            String pattern = "^" + this.escapeRegex(matches[0]) + this.buildIDPattern(matches, null) + "$";
            return Pattern.compile(pattern);
        }

        @Override
        public String[] getMatches(String filePathOrName) {
            return filePathOrName != null ? new Regex(filePathOrName, this.pattern).getRow(0) : null;
        }

        @Override
        protected String getPartNumberString(String filePathOrName) {
            return null;
        }

        @Override
        protected int getPartNumber(String partNumberString) {
            return 0;
        }

        @Override
        protected int getFirstPartIndex() {
            return 0;
        }

        @Override
        protected int getMinimumNeededPartIndex() {
            return 0;
        }

        @Override
        protected String buildMissingPart(String[] matches, int partIndex, int partStringLength) {
            return matches[0] + ".gz";
        }

        @Override
        public String getIconExtension() {
            return "gz";
        }
    }
    ,
    BZIP2_SINGLE{
        private final Pattern pattern = Pattern.compile("(?i)(.*)\\.bz2$");

        @Override
        public ArchiveFormat getArchiveFormat(Archive archive) throws IOException {
            return ArchiveFormat.BZIP2;
        }

        @Override
        protected boolean isMultiPartType() {
            return false;
        }

        @Override
        public boolean matches(String filePathOrName) {
            return filePathOrName != null && this.pattern.matcher(filePathOrName).matches();
        }

        @Override
        protected String buildIDPattern(String[] matches, Boolean isMultiPart) {
            if (Boolean.TRUE.equals(isMultiPart)) {
                return null;
            }
            return "\\.(?i)bz2";
        }

        @Override
        public Pattern buildArchivePattern(String[] matches, Boolean isMultiPart) {
            if (Boolean.TRUE.equals(isMultiPart)) {
                return null;
            }
            String pattern = "^" + this.escapeRegex(matches[0]) + this.buildIDPattern(matches, null) + "$";
            return Pattern.compile(pattern);
        }

        @Override
        public String[] getMatches(String filePathOrName) {
            return filePathOrName != null ? new Regex(filePathOrName, this.pattern).getRow(0) : null;
        }

        @Override
        protected String getPartNumberString(String filePathOrName) {
            return null;
        }

        @Override
        protected int getPartNumber(String partNumberString) {
            return 0;
        }

        @Override
        protected int getFirstPartIndex() {
            return 0;
        }

        @Override
        protected int getMinimumNeededPartIndex() {
            return 0;
        }

        @Override
        protected String buildMissingPart(String[] matches, int partIndex, int partStringLength) {
            return matches[0] + ".bz2";
        }

        @Override
        public String getIconExtension() {
            return "bz2";
        }
    }
    ,
    RAR_MULTI4{
        private final Pattern pattern = Pattern.compile("(?i)(.*)\\.([0-9]{3})$");

        @Override
        public boolean matches(String filePathOrName) {
            return filePathOrName != null && this.pattern.matcher(filePathOrName).matches();
        }

        @Override
        protected boolean isMultiPartType() {
            return true;
        }

        @Override
        protected String buildIDPattern(String[] matches, Boolean isMultiPart) {
            if (Boolean.FALSE.equals(isMultiPart)) {
                return null;
            }
            return "\\.[0-9]{3}";
        }

        @Override
        public Pattern buildArchivePattern(String[] matches, Boolean isMultiPart) {
            if (Boolean.FALSE.equals(isMultiPart)) {
                return null;
            }
            String pattern = "^" + this.escapeRegex(matches[0]) + this.buildIDPattern(matches, null) + "$";
            return Pattern.compile(pattern);
        }

        @Override
        public String[] getMatches(String filePathOrName) {
            return filePathOrName != null ? new Regex(filePathOrName, this.pattern).getRow(0) : null;
        }

        @Override
        public String getPartNumberString(String filePathOrName) {
            String[] matches = this.getMatches(filePathOrName);
            return matches != null ? matches[1] : null;
        }

        @Override
        public int getPartNumber(String partNumberString) {
            return Integer.parseInt(partNumberString);
        }

        @Override
        protected int getFirstPartIndex() {
            return 1;
        }

        @Override
        protected int getMinimumNeededPartIndex() {
            return 2;
        }

        @Override
        protected String buildMissingPart(String[] matches, int partIndex, int partStringLength) {
            return matches[0] + "." + String.format(Locale.US, "%0" + partStringLength + "d", partIndex);
        }

        @Override
        protected boolean looksLikeAnArchive(BitSet bitset, ArchiveFile[] archiveFiles) {
            int count = 0;
            for (int index = 0; index < bitset.length(); ++index) {
                if (bitset.get(index)) {
                    if (++count != 2) continue;
                    return true;
                }
                count = 0;
            }
            return false;
        }

        @Override
        public ArchiveFormat getArchiveFormat(Archive archive) throws IOException {
            return ArchiveType.getRARArchiveFormat(archive);
        }

        @Override
        protected Boolean isValidPart(int partIndex, ArchiveFile archiveFile, boolean verifiedResult) {
            if (archiveFile == null) {
                return false;
            }
            if (partIndex == -1) {
                return null;
            }
            return RAR_SINGLE.isValidPart(partIndex, archiveFile, false);
        }

        @Override
        public String getIconExtension() {
            return RAR_SINGLE.getIconExtension();
        }
    };


    protected String escapeRegex(String input) {
        if (input.length() == 0) {
            return "";
        }
        return Regex.escape((String)input);
    }

    private static ArchiveFormat getRARArchiveFormat(Archive archive) throws IOException {
        ArchiveFile firstArchiveFile;
        String signatureString;
        if (Multi.isRAR5Supported() && archive != null && archive.getArchiveFiles() != null && archive.getArchiveFiles().size() > 0 && (signatureString = FileSignatures.readFileSignature(new File((firstArchiveFile = archive.getArchiveFiles().get(0)).getFilePath()), 14)).length() >= 16 && StringUtils.startsWithCaseInsensitive((String)signatureString, (String)"526172211a070100")) {
            return ArchiveFormat.valueOf((String)"RAR5");
        }
        return ArchiveFormat.RAR;
    }

    public abstract ArchiveFormat getArchiveFormat(Archive var1) throws IOException;

    public abstract boolean matches(String var1);

    public abstract String[] getMatches(String var1);

    public abstract Pattern buildArchivePattern(String[] var1, Boolean var2);

    protected abstract String buildIDPattern(String[] var1, Boolean var2);

    protected abstract String getPartNumberString(String var1);

    protected abstract int getPartNumber(String var1);

    protected abstract int getFirstPartIndex();

    protected abstract int getMinimumNeededPartIndex();

    protected abstract boolean isMultiPartType();

    protected abstract String buildMissingPart(String[] var1, int var2, int var3);

    protected boolean looksLikeAnArchive(BitSet bitset, ArchiveFile[] archiveFiles) {
        return bitset.size() != 0;
    }

    protected Boolean isValidPart(int partIndex, ArchiveFile archiveFile, boolean verifiedResult) {
        return archiveFile != null;
    }

    protected Boolean isMultiPart(ArchiveFile archiveFile, boolean verifiedResult) {
        return null;
    }

    public abstract String getIconExtension();

    public static ArchiveFile getLastArchiveFile(Archive archive) {
        ArchiveType type = archive.getArchiveType();
        if (type != null) {
            int index = -1;
            ArchiveFile ret = null;
            for (ArchiveFile archiveFile : archive.getArchiveFiles()) {
                int partNum = type.getPartNumber(type.getPartNumberString(archiveFile.getFilePath()));
                if (index != -1 && partNum <= index) continue;
                index = partNum;
                ret = archiveFile;
            }
            return ret;
        }
        return null;
    }

    public ArchiveFile getBestArchiveFileMatch(Archive archive, String fileName) {
        ArchiveType archiveType = archive.getArchiveType();
        if (archiveType == this) {
            String partNumberString = archiveType.getPartNumberString(fileName);
            int partNumber = archiveType.getPartNumber(partNumberString);
            for (ArchiveFile archiveFile : archive.getArchiveFiles()) {
                if (partNumber != archiveType.getPartNumber(archiveType.getPartNumberString(archiveFile.getName()))) continue;
                return archiveFile;
            }
        }
        return null;
    }

    public static List<ArchiveFile> getMissingArchiveFiles(Archive archive, ArchiveType archiveType, int numberOfParts) {
        String linkPath;
        String[] filePathParts;
        ArchiveFile firstArchiveFile;
        ArchiveFile archiveFile = firstArchiveFile = archive.getArchiveFiles().size() > 0 ? archive.getArchiveFiles().get(0) : null;
        if (firstArchiveFile != null && (filePathParts = archiveType.getMatches(linkPath = firstArchiveFile.getFilePath())) != null) {
            BitSet availableParts = new BitSet();
            int partStringLength = 1;
            for (ArchiveFile archiveFile2 : archive.getArchiveFiles()) {
                String fileName = archiveFile2.getName();
                String partNumberString = archiveType.getPartNumberString(fileName);
                int partNumber = archiveType.getPartNumber(partNumberString);
                if (partNumberString != null) {
                    partStringLength = Math.max(partStringLength, partNumberString.length());
                }
                if (partNumber < 0) continue;
                availableParts.set(partNumber);
            }
            ArrayList<ArchiveFile> ret = new ArrayList<ArchiveFile>();
            int minimumParts = Math.max(archiveType.getMinimumNeededPartIndex(), numberOfParts) - (1 - archiveType.getFirstPartIndex());
            for (int partIndex = archiveType.getFirstPartIndex(); partIndex <= minimumParts; ++partIndex) {
                if (availableParts.get(partIndex)) continue;
                File missingFile = new File(archiveType.buildMissingPart(filePathParts, partIndex, partStringLength));
                ret.add(new MissingArchiveFile(missingFile.getName(), missingFile.getAbsolutePath()));
            }
            return ret;
        }
        return null;
    }

    public static Archive createArchive(ArchiveFactory link, boolean allowDeepInspection, ArchiveType ... archiveTypes) throws ArchiveException {
        String linkPath = link.getFilePath();
        Boolean isKnownMultiPart = null;
        block0: for (ArchiveType archiveType : archiveTypes) {
            Pattern pattern;
            Boolean validPart;
            if (isKnownMultiPart != null && archiveType.isMultiPartType() != isKnownMultiPart.booleanValue()) continue;
            String[] filePathParts = archiveType.getMatches(linkPath);
            Boolean bl = validPart = filePathParts != null ? archiveType.isValidPart(-1, link, false) : null;
            if (filePathParts == null || Boolean.FALSE.equals(validPart)) continue;
            Boolean isMultiPart = isKnownMultiPart != null ? isKnownMultiPart : (allowDeepInspection ? archiveType.isMultiPart(link, false) : null);
            if (isKnownMultiPart == null) {
                isKnownMultiPart = isMultiPart;
            }
            if ((pattern = archiveType.buildArchivePattern(filePathParts, isMultiPart)) == null || isMultiPart != null && archiveType.isMultiPartType() != isMultiPart.booleanValue()) continue;
            List<ArchiveFile> foundArchiveFiles = link.createPartFileList(linkPath, pattern.pattern());
            if (foundArchiveFiles == null || foundArchiveFiles.size() == 0) {
                throw new ArchiveException("Broken archive support!ArchiveType:" + archiveType.name() + "|ArchiveFactory:" + link.getClass().getName() + "|Exists:" + link.exists(allowDeepInspection) + "|Path:" + linkPath + "|Pattern:" + pattern.pattern() + "|MultiPart:" + isMultiPart + "|DeepInspection:" + allowDeepInspection);
            }
            BitSet availableParts = new BitSet();
            int lowestPartNumber = Integer.MAX_VALUE;
            int partStringLength = 1;
            int highestPartNumber = Integer.MIN_VALUE;
            int archiveFilesGrow = 128;
            ArchiveFile[] archiveFiles = new ArchiveFile[128];
            for (ArchiveFile archiveFile : foundArchiveFiles) {
                String fileName = archiveFile.getName();
                String partNumberString = archiveType.getPartNumberString(fileName);
                int partNumber = archiveType.getPartNumber(partNumberString);
                if (partNumber < 0) continue;
                if (partNumberString != null) {
                    partStringLength = Math.max(partStringLength, partNumberString.length());
                }
                availableParts.set(partNumber);
                if (partNumber >= archiveFiles.length) {
                    archiveFiles = Arrays.copyOf(archiveFiles, Math.max(archiveFiles.length + 128, partNumber + 1));
                }
                archiveFiles[partNumber] = archiveFile;
                if (partNumber < lowestPartNumber) {
                    lowestPartNumber = partNumber;
                }
                if (partNumber <= highestPartNumber) continue;
                highestPartNumber = partNumber;
            }
            if (!archiveType.looksLikeAnArchive(availableParts, archiveFiles)) continue;
            String[] fileNameParts = archiveType.getMatches(link.getName());
            Archive archive = link.createArchive(archiveType);
            archive.setName(fileNameParts[0]);
            String rawID = archiveType.name() + " |" + fileNameParts[0] + archiveType.buildIDPattern(fileNameParts, isMultiPart);
            String ID2 = Hash.getSHA256((String)rawID);
            String archiveID = Archive.getBestArchiveID(foundArchiveFiles, ID2);
            archive.setArchiveID(archiveID);
            ArrayList<ArchiveFile> sortedArchiveFiles = new ArrayList<ArchiveFile>();
            int minimumParts = Math.max(archiveType.getMinimumNeededPartIndex(), highestPartNumber);
            for (int partIndex = archiveType.getFirstPartIndex(); partIndex <= minimumParts; ++partIndex) {
                if (!availableParts.get(partIndex)) {
                    File missingFile = new File(archiveType.buildMissingPart(filePathParts, partIndex, partStringLength));
                    sortedArchiveFiles.add(new MissingArchiveFile(missingFile.getName(), missingFile.getAbsolutePath()));
                    continue;
                }
                if (allowDeepInspection && Boolean.FALSE.equals(archiveType.isValidPart(partIndex, archiveFiles[partIndex], false))) continue block0;
                sortedArchiveFiles.add(archiveFiles[partIndex]);
            }
            archive.setArchiveFiles(sortedArchiveFiles);
            return archive;
        }
        return null;
    }

    public static Archive createArchive(ArchiveFactory link, boolean allowDeepInspection) throws ArchiveException {
        return ArchiveType.createArchive(link, allowDeepInspection, ArchiveType.values());
    }
}

