/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.multi;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.atomic.AtomicBoolean;
import jd.plugins.download.raf.FileBytesCache;
import jd.plugins.download.raf.FileBytesCacheFlusher;
import net.sf.sevenzipjbinding.SevenZipException;
import org.appwork.utils.IO;
import org.jdownloader.extensions.extraction.CPUPriority;
import org.jdownloader.extensions.extraction.ExtractionConfig;
import org.jdownloader.extensions.extraction.ExtractionController;
import org.jdownloader.extensions.extraction.multi.MultiSevenZipException;

public class FilesBytesCacheWriter
implements FileBytesCacheFlusher {
    protected final RandomAccessFile fos;
    protected final CPUPriority priority;
    protected volatile long fileWritePosition = 0L;
    protected volatile long flushedBytes = 0L;
    protected final File file;
    private final FileBytesCache cache;
    private final AtomicBoolean fileOpen = new AtomicBoolean(true);
    private volatile IOException ioException = null;

    public FilesBytesCacheWriter(File file, ExtractionController con, ExtractionConfig config) throws IOException {
        CPUPriority priority = config.getCPUPriority();
        this.priority = priority == null || CPUPriority.HIGH.equals((Object)priority) ? null : priority;
        this.file = file;
        this.fos = IO.open((File)file, (String)"rw");
        this.cache = con.getFileBytesCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitCPUPriority() throws SevenZipException {
        if (this.priority != null) {
            FilesBytesCacheWriter filesBytesCacheWriter = this;
            synchronized (filesBytesCacheWriter) {
                try {
                    this.wait(this.priority.getTime());
                }
                catch (InterruptedException e) {
                    throw new MultiSevenZipException(e, 2);
                }
            }
        }
    }

    public int write(byte[] data, int length) throws SevenZipException {
        if (this.fileOpen.get()) {
            this.cache.write((FileBytesCacheFlusher)this, this.fileWritePosition, data, length);
            this.fileWritePosition += (long)length;
            this.waitCPUPriority();
            return length;
        }
        IOException lIoException = this.ioException;
        if (lIoException != null) {
            throw new MultiSevenZipException(lIoException, 5);
        }
        throw new MultiSevenZipException(5);
    }

    public File getFile() {
        return this.file;
    }

    public long getWritten() {
        return this.flushedBytes;
    }

    void close() throws IOException {
        try {
            this.cache.execute(new Runnable(){

                @Override
                public void run() {
                    if (FilesBytesCacheWriter.this.fileOpen.get()) {
                        try {
                            FilesBytesCacheWriter.this.cache.flushIfContains((FileBytesCacheFlusher)FilesBytesCacheWriter.this);
                        }
                        finally {
                            FilesBytesCacheWriter.this.fileOpen.set(false);
                        }
                    }
                }
            });
        }
        finally {
            try {
                try {
                    if (this.fos != null) {
                        this.fos.getChannel().force(true);
                    }
                }
                finally {
                    if (this.fos != null) {
                        this.fos.close();
                    }
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public void flush(byte[] writeCache, int writeCachePosition, int length, long fileWritePosition) {
        if (this.fileOpen.get()) {
            try {
                this.fos.seek(fileWritePosition);
                this.fos.write(writeCache, writeCachePosition, length);
                this.flushedBytes += (long)length;
            }
            catch (IOException e) {
                this.ioException = e;
                this.fileOpen.set(false);
            }
        }
    }

    public void flushed() {
    }
}

