/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.multi;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.sevenzipjbinding.IArchiveOpenCallback;
import net.sf.sevenzipjbinding.IArchiveOpenVolumeCallback;
import net.sf.sevenzipjbinding.ICryptoGetTextPassword;
import net.sf.sevenzipjbinding.IInStream;
import net.sf.sevenzipjbinding.PropID;
import net.sf.sevenzipjbinding.SevenZipException;
import net.sf.sevenzipjbinding.impl.RandomAccessFileInStream;
import org.appwork.utils.IO;
import org.appwork.utils.logging2.LogInterface;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ArchiveFile;

class MultiOpener
implements IArchiveOpenVolumeCallback,
IArchiveOpenCallback,
ICryptoGetTextPassword,
Closeable {
    private final Map<String, RandomAcessFileStats> openedRandomAccessFileList = new HashMap<String, RandomAcessFileStats>();
    private final HashMap<String, ArchiveFile> map = new HashMap();
    private final String password;
    private String name = null;
    private final Archive archive;
    private final LogInterface logger;

    MultiOpener(Archive archive, LogInterface logger) {
        this(archive, null, logger);
    }

    MultiOpener(Archive archive, String password, LogInterface logger) {
        if (password == null) {
            password = "";
        }
        this.logger = logger;
        this.password = password;
        this.archive = archive;
    }

    public Object getProperty(PropID propID) throws SevenZipException {
        switch (propID) {
            case NAME: {
                return this.name;
            }
        }
        return null;
    }

    public IInStream getStream(ArchiveFile archiveFile) throws SevenZipException {
        return this.getStream(archiveFile.getFilePath());
    }

    private final String fixInternalName(String name) {
        return name;
    }

    public IInStream getStream(String fileName) throws SevenZipException {
        ArchiveFile af = null;
        try {
            RandomAcessFileStats tracker = this.openedRandomAccessFileList.get(fileName);
            if (tracker == null) {
                af = this.map.get(fileName);
                if (af == null && (af = this.archive.getBestArchiveFileMatch(fileName)) != null) {
                    if (!this.map.values().contains(af)) {
                        this.map.put(fileName, af);
                    } else {
                        throw new FileNotFoundException(fileName);
                    }
                }
                File file = af != null ? new File(af.getFilePath()) : new File(fileName);
                this.logger.info("OpenFile->Filename:" + fileName + "|ArchiveFile:" + af + "|Filename(onDisk)" + file.getAbsolutePath());
                tracker = new RandomAcessFileStats(IO.open((File)file, (String)"r"));
                this.openedRandomAccessFileList.put(fileName, tracker);
            }
            if (this.name == null) {
                this.name = this.fixInternalName(fileName);
            }
            final RandomAcessFileStats finalTracker = tracker;
            finalTracker.raf.seek(0L);
            return new RandomAccessFileInStream(finalTracker.raf){

                public int read(byte[] abyte0) throws SevenZipException {
                    int read = super.read(abyte0);
                    if (read > 0) {
                        finalTracker.bytesRead = finalTracker.bytesRead + (long)read;
                    }
                    return read;
                }

                public synchronized long seek(long arg0, int arg1) throws SevenZipException {
                    long seek = super.seek(arg0, arg1);
                    if (seek > 0L) {
                        finalTracker.bytesSeek = finalTracker.bytesSeek + seek;
                    }
                    return seek;
                }
            };
        }
        catch (FileNotFoundException e) {
            if (af != null) {
                this.logger.log((Throwable)e);
                throw new SevenZipException((Throwable)e);
            }
            return null;
        }
        catch (IOException e) {
            this.logger.log((Throwable)e);
            if (af != null) {
                throw new SevenZipException((Throwable)e);
            }
            return null;
        }
        catch (Exception e) {
            this.logger.log((Throwable)e);
            throw new SevenZipException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Iterator<Map.Entry<String, RandomAcessFileStats>> it = this.openedRandomAccessFileList.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, RandomAcessFileStats> next = it.next();
            try {
                this.logger.info("CloseFile->Filename:" + next.getKey() + "|BytesRead:" + next.getValue().bytesRead + "|BytesSeek:" + next.getValue().bytesSeek);
                next.getValue().raf.close();
            }
            catch (Throwable e) {
                this.logger.log(e);
            }
            finally {
                it.remove();
            }
        }
        this.map.clear();
    }

    public String cryptoGetTextPassword() throws SevenZipException {
        return this.password;
    }

    public void setCompleted(Long arg0, Long arg1) throws SevenZipException {
    }

    public void setTotal(Long arg0, Long arg1) throws SevenZipException {
    }

    private final class RandomAcessFileStats {
        private final RandomAccessFile raf;
        private long bytesRead = 0L;
        private long bytesSeek = 0L;

        private RandomAcessFileStats(RandomAccessFile raf) {
            this.raf = raf;
        }
    }
}

