/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.multi;

import java.util.concurrent.atomic.AtomicReference;
import net.sf.sevenzipjbinding.ExtractAskMode;
import net.sf.sevenzipjbinding.ExtractOperationResult;
import net.sf.sevenzipjbinding.IArchiveExtractCallback;
import net.sf.sevenzipjbinding.ICryptoGetTextPassword;
import net.sf.sevenzipjbinding.ISequentialOutStream;
import net.sf.sevenzipjbinding.SevenZipException;
import org.appwork.utils.ReusableByteArrayOutputStream;
import org.appwork.utils.StringUtils;
import org.jdownloader.extensions.extraction.ExtractionController;
import org.jdownloader.extensions.extraction.FileSignatures;
import org.jdownloader.extensions.extraction.Signature;
import org.jdownloader.extensions.extraction.multi.SevenZipArchiveWrapper;
import org.jdownloader.extensions.extraction.multi.SignatureCheckingOutStream;

public class Seven7PWCallback
implements IArchiveExtractCallback,
ICryptoGetTextPassword {
    private final AtomicReference<Signature> passwordFound;
    private final SevenZipArchiveWrapper archive;
    private final String password;
    private final SignatureCheckingOutStream signatureOutStream;
    protected static final long SLOWDOWNWORKAROUNDTIMEOUT = 150L;
    Boolean skipExtraction = null;

    public Seven7PWCallback(ExtractionController ctrl, SevenZipArchiveWrapper archive, AtomicReference<Signature> passwordFound, String password, ReusableByteArrayOutputStream buffer, long maxPWCheckSize, FileSignatures filesignatures, boolean optimized) {
        this.passwordFound = passwordFound;
        this.archive = archive;
        this.password = StringUtils.isEmpty((String)password) ? "" : password;
        this.signatureOutStream = archive.isSlowDownWorkaroundNeeded() ? new SignatureCheckingOutStream(ctrl, passwordFound, filesignatures, buffer, maxPWCheckSize, optimized){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int write(byte[] data) throws SevenZipException {
                1 var2_2 = this;
                synchronized (var2_2) {
                    try {
                        this.wait(150L);
                    }
                    catch (InterruptedException e) {
                        throw new SevenZipException((Throwable)e);
                    }
                }
                return super.write(data);
            }
        } : new SignatureCheckingOutStream(ctrl, passwordFound, filesignatures, buffer, maxPWCheckSize, optimized);
    }

    public void setTotal(long l) throws SevenZipException {
    }

    public void setCompleted(long l) throws SevenZipException {
    }

    public ISequentialOutStream getStream(int i, ExtractAskMode extractaskmode) throws SevenZipException {
        if (this.passwordFound.get() != null) {
            throw new SevenZipException("Password found");
        }
        if (this.skipExtraction != null && !this.skipExtraction.booleanValue() && this.signatureOutStream.getWritten() == 0L) {
            throw new SevenZipException("Password wrong");
        }
        this.skipExtraction = this.archive.isFolder(i);
        if (this.skipExtraction.booleanValue() || extractaskmode != ExtractAskMode.EXTRACT) {
            this.skipExtraction = true;
            return null;
        }
        String name = this.archive.getPath(i);
        if (StringUtils.isEmpty((String)name)) {
            this.skipExtraction = false;
            return null;
        }
        Boolean itemEncrypted = this.archive.isEncrypted(i);
        if (Boolean.FALSE.equals(itemEncrypted)) {
            this.skipExtraction = true;
            return null;
        }
        this.skipExtraction = false;
        this.signatureOutStream.reset();
        Long size = this.archive.getSize(i);
        this.signatureOutStream.setSignatureLength(name, size);
        return this.signatureOutStream;
    }

    public void prepareOperation(ExtractAskMode extractaskmode) throws SevenZipException {
    }

    public void setOperationResult(ExtractOperationResult extractoperationresult) throws SevenZipException {
    }

    public String cryptoGetTextPassword() throws SevenZipException {
        return this.password;
    }
}

