/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.split;

import java.io.File;
import java.io.IOException;
import java.util.List;
import jd.controlling.linkcrawler.CrawledLink;
import jd.plugins.DownloadLink;
import jd.utils.JDHexUtils;
import org.appwork.utils.Regex;
import org.jdownloader.controlling.filter.CompiledFiletypeFilter;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ArchiveFactory;
import org.jdownloader.extensions.extraction.ArchiveFile;
import org.jdownloader.extensions.extraction.DummyArchive;
import org.jdownloader.extensions.extraction.DummyArchiveFile;
import org.jdownloader.extensions.extraction.ExtractionController;
import org.jdownloader.extensions.extraction.ExtractionControllerException;
import org.jdownloader.extensions.extraction.ExtractionExtension;
import org.jdownloader.extensions.extraction.FileSignatures;
import org.jdownloader.extensions.extraction.IExtraction;
import org.jdownloader.extensions.extraction.bindings.crawledlink.CrawledLinkFactory;
import org.jdownloader.extensions.extraction.bindings.downloadlink.DownloadLinkArchiveFactory;
import org.jdownloader.extensions.extraction.multi.ArchiveException;
import org.jdownloader.extensions.extraction.multi.CheckException;
import org.jdownloader.extensions.extraction.split.SplitType;
import org.jdownloader.extensions.extraction.split.SplitUtil;

public class HJSplit
extends IExtraction {
    private final SplitType splitType = SplitType.HJ_SPLIT;
    private final ExtractionExtension extension;

    @Override
    public Archive buildArchive(ArchiveFactory link, boolean allowDeepInspection) throws ArchiveException {
        return SplitType.createArchive(link, this.splitType, allowDeepInspection);
    }

    @Override
    public boolean findPassword(ExtractionController controller, String password, boolean optimized) {
        return true;
    }

    public HJSplit(ExtractionExtension extension) {
        this.extension = extension;
    }

    @Override
    public void extract(ExtractionController ctrl) {
        Archive archive = this.getExtractionController().getArchive();
        ArchiveFile firstArchiveFile = archive.getArchiveFiles().get(0);
        String[] matches = this.splitType.getMatches(firstArchiveFile.getName());
        if (matches != null) {
            try {
                int skipBytes;
                String fileName;
                String signature = JDHexUtils.toString((String)FileSignatures.readFileSignature(new File(firstArchiveFile.getFilePath())));
                if (new Regex(signature, "^[\\w]{3}  \\d{3}").matches()) {
                    String extension = new Regex(signature, "^([\\w]{3})").getMatch(0);
                    fileName = matches[0] + "." + extension;
                    skipBytes = 8;
                } else {
                    skipBytes = 0;
                    fileName = matches[0];
                }
                if (SplitUtil.merge(this.getExtractionController(), fileName, skipBytes, this.getConfig())) {
                    archive.setExitCode(0);
                } else if (archive.getExitCode() == -1) {
                    archive.setExitCode(2);
                }
                return;
            }
            catch (ExtractionControllerException e) {
                this.setException(e);
                archive.setExitCode(e.getExitCode());
            }
            catch (IOException e) {
                this.setException(e);
                archive.setExitCode(2);
            }
        } else {
            archive.setExitCode(2);
        }
    }

    @Override
    public boolean isAvailable(ExtractionExtension extractionExtension) {
        return true;
    }

    @Override
    public int getCrackProgress() {
        return 100;
    }

    @Override
    public boolean prepare() {
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public DummyArchive checkComplete(Archive archive) throws CheckException {
        if (archive.getSplitType() == this.splitType) {
            try {
                DummyArchive dummyArchive = new DummyArchive(archive, this.splitType);
                for (ArchiveFile archiveFile : archive.getArchiveFiles()) {
                    dummyArchive.add(new DummyArchiveFile(archiveFile));
                }
                if (dummyArchive.isComplete()) {
                    ArchiveFile firstFile = archive.getArchiveFiles().get(0);
                    String firstArchiveFile = firstFile.getFilePath();
                    String partNumberOfFirstArchiveFile = this.splitType.getPartNumberString(firstArchiveFile);
                    if (this.splitType.getFirstPartIndex() != this.splitType.getPartNumber(partNumberOfFirstArchiveFile)) {
                        throw new CheckException("Wrong firstArchiveFile(" + firstArchiveFile + ") for Archive(" + archive.getName() + ")");
                    }
                    if (firstFile.exists()) {
                        String signature = JDHexUtils.toString((String)FileSignatures.readFileSignature(new File(firstArchiveFile)));
                        if (new Regex(signature, "^[\\w]{3}  \\d{3}").matches()) {
                            String numberOfPartsString = new Regex(signature, "^[\\w]{3}  (\\d{3})").getMatch(0);
                            int numberOfParts = Integer.parseInt(numberOfPartsString);
                            List<ArchiveFile> missingArchiveFiles = SplitType.getMissingArchiveFiles(archive, this.splitType, numberOfParts);
                            if (missingArchiveFiles != null) {
                                for (ArchiveFile missingArchiveFile : missingArchiveFiles) {
                                    dummyArchive.add(new DummyArchiveFile(missingArchiveFile));
                                }
                            }
                            if (dummyArchive.getSize() < numberOfParts) {
                                throw new CheckException("Missing archiveParts(" + numberOfParts + "!=" + dummyArchive.getSize() + ") for Archive(" + archive.getName() + ")");
                            }
                            if (dummyArchive.getSize() > numberOfParts) {
                                throw new CheckException("Too many archiveParts(" + numberOfParts + "!=" + dummyArchive.getSize() + ") for Archive(" + archive.getName() + ")");
                            }
                        } else {
                            SplitUtil.checkComplete(this.extension, archive, dummyArchive);
                        }
                    }
                }
                return dummyArchive;
            }
            catch (CheckException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new CheckException("Cannot check Archive(" + archive.getName() + ")", e);
            }
        }
        return null;
    }

    @Override
    public Boolean isSupported(ArchiveFactory factory, boolean allowDeepInspection) {
        if (this.splitType.matches(factory.getFilePath())) {
            if (factory instanceof DownloadLinkArchiveFactory) {
                for (DownloadLink link : ((DownloadLinkArchiveFactory)factory).getDownloadLinks()) {
                    CompiledFiletypeFilter.CompiledFiletypeExtension hint = CompiledFiletypeFilter.getExtensionsFilterInterface((String)link.getMimeHint());
                    if (hint == null || hint.isSameExtensionGroup((CompiledFiletypeFilter.ExtensionsFilterInterface)CompiledFiletypeFilter.ArchiveExtensions.NUM)) continue;
                    return false;
                }
            } else if (factory instanceof CrawledLinkFactory) {
                for (CrawledLink link : ((CrawledLinkFactory)factory).getLinks()) {
                    CompiledFiletypeFilter.CompiledFiletypeExtension hint;
                    DownloadLink dlLink = link.getDownloadLink();
                    if (dlLink == null || (hint = CompiledFiletypeFilter.getExtensionsFilterInterface((String)dlLink.getMimeHint())) == null || hint.isSameExtensionGroup((CompiledFiletypeFilter.ExtensionsFilterInterface)CompiledFiletypeFilter.ArchiveExtensions.NUM)) continue;
                    return false;
                }
            }
            if (allowDeepInspection) {
                try {
                    return SplitType.createArchive(factory, this.splitType, allowDeepInspection) != null;
                }
                catch (ArchiveException e) {
                    this.getLogger().log((Throwable)e);
                }
            } else {
                return true;
            }
        }
        return false;
    }
}

