/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.filechooser;

import de.javasoft.io.FileProperties;
import de.javasoft.io.FileUtils;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.filechooser.FileOperationDialog;
import de.javasoft.plaf.synthetica.filechooser.FilePropertiesDialog;
import de.javasoft.plaf.synthetica.filechooser.GermanCollator;
import de.javasoft.util.JavaVersion;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.AccessControlException;
import java.security.AccessController;
import java.text.Collator;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import sun.awt.shell.ShellFolder;
import sun.security.action.GetPropertyAction;
import sun.swing.plaf.synth.DefaultSynthStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntheticaFileChooserUI
extends BasicFileChooserUI
implements ActionListener {
    private static final int LIST_VIEW = 0;
    private static final int TABLE_VIEW = 1;
    private static final int TREE_VIEW = 2;
    private JButton newFolderButton;
    private JButton upFolderButton;
    private JComboBox directoryComboBox;
    private JLabel lookInLabel;
    private JButton approveButton;
    private JButton cancelButton;
    private JPanel controlButtonPanel;
    private JTextField fileNameTextField;
    private Color comboListBackground;
    private FilePane filePane;
    private boolean readOnly;
    private HashSet<File> cutBuffer = new HashSet();
    private HashSet<File> copyBuffer = new HashSet();
    private boolean useSystemFileIcons = SyntheticaLookAndFeel.getUseSystemFileIcons();
    private boolean directoryChooser = false;
    private boolean treePanelEnabled = false;
    private boolean sortEnabled = true;
    private int xGap = 10;
    private int yGap = 10;

    public SyntheticaFileChooserUI(JFileChooser jFileChooser) {
        super(jFileChooser);
    }

    protected SyntheticaFileChooserUI(JFileChooser jFileChooser, boolean bl) {
        super(jFileChooser);
        this.directoryChooser = bl;
        this.treePanelEnabled = bl;
        if (bl) {
            jFileChooser.setFileSelectionMode(1);
        }
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SyntheticaFileChooserUI((JFileChooser)jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.comboListBackground = SyntheticaLookAndFeel.getColor("Synthetica.fileChooser.comboListBackground", jComponent);
        String string = "Synthetica.extendedFileChooser.sortEnabled";
        this.sortEnabled = SyntheticaLookAndFeel.getBoolean(string, jComponent, true);
        if (SyntheticaLookAndFeel.getRememberFileChooserPreferences() && !this.directoryChooser) {
            final JFileChooser jFileChooser = this.getFileChooser();
            Thread thread = new Thread(){

                public void run() {
                    boolean bl;
                    Window window = null;
                    int n = 200;
                    while (!((window = SyntheticaFileChooserUI.this.getWindow()) != null && window.isShowing() || n <= 0)) {
                        try {
                            1.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        --n;
                    }
                    if (window == null) {
                        return;
                    }
                    String string = "";
                    Object object = Frame.getFrames();
                    int n2 = ((Frame[])object).length;
                    int n3 = 0;
                    while (n3 < n2) {
                        Frame frame = object[n3];
                        if (frame instanceof JFrame && frame.getTitle() != null) {
                            string = frame.getTitle();
                            break;
                        }
                        ++n3;
                    }
                    int n4 = 50;
                    n3 = 7;
                    String string2 = jFileChooser.getClientProperty("Synthetica.fileChooser.id") == null ? "" : "." + (String)jFileChooser.getClientProperty("Synthetica.fileChooser.id");
                    string2 = string2.length() <= n3 ? string2 : string2.substring(0, n3 + 1);
                    object = ".SyntheticaFileChooser";
                    string = string.length() <= n4 ? string : string.substring(0, n4);
                    string = string.replace("//", "/");
                    final Preferences preferences = Preferences.userRoot().node(String.valueOf(string) + string2 + (String)object);
                    int n5 = preferences.getInt("xPos", window.getLocation().x);
                    int n6 = preferences.getInt("yPos", window.getLocation().y);
                    int n7 = preferences.getInt("width", window.getSize().width);
                    int n8 = preferences.getInt("height", window.getSize().height);
                    Rectangle rectangle = SyntheticaLookAndFeel.validateWindowBounds(new Rectangle(n5, n6, n7, n8));
                    window.setBounds(rectangle);
                    final File file = new File(preferences.get("directory" + jFileChooser.getDialogType(), jFileChooser.getCurrentDirectory().getAbsolutePath()));
                    String string3 = "Synthetica.extendedFileChooser.rememberLastDirectory";
                    boolean bl2 = jFileChooser.getFileSystemView().getDefaultDirectory().equals(jFileChooser.getCurrentDirectory());
                    boolean bl3 = bl = SyntheticaLookAndFeel.getBoolean(string3, jFileChooser, true) && bl2;
                    if (bl && file != null && file.exists()) {
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                jFileChooser.setCurrentDirectory(file);
                            }
                        });
                    }
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            SyntheticaFileChooserUI.this.filePane.setView(preferences.getInt("view", SyntheticaFileChooserUI.this.filePane.getView()));
                            SyntheticaFileChooserUI.this.filePane.sortColumn = preferences.getInt("sortColumn", SyntheticaFileChooserUI.this.filePane.sortColumn);
                            SyntheticaFileChooserUI.this.filePane.sortOrder = preferences.getInt("sortOrder", SyntheticaFileChooserUI.this.filePane.sortOrder);
                        }
                    });
                    window.addWindowListener(new WindowAdapter(){

                        public void windowClosed(WindowEvent windowEvent) {
                            Dialog dialog = (Dialog)windowEvent.getWindow();
                            int n = dialog.getLocation().x;
                            int n2 = dialog.getLocation().y;
                            int n3 = dialog.getSize().width;
                            int n4 = dialog.getSize().height;
                            preferences.putInt("xPos", n);
                            preferences.putInt("yPos", n2);
                            preferences.putInt("width", n3);
                            preferences.putInt("height", n4);
                            preferences.putInt("view", SyntheticaFileChooserUI.this.filePane.getView());
                            preferences.putInt("sortColumn", SyntheticaFileChooserUI.this.filePane.sortColumn);
                            preferences.putInt("sortOrder", SyntheticaFileChooserUI.this.filePane.sortOrder);
                            if (bl) {
                                preferences.put("directory" + jFileChooser.getDialogType(), jFileChooser.getCurrentDirectory().getAbsolutePath());
                            }
                        }
                    });
                }
            };
            thread.setDaemon(true);
            thread.setPriority(10);
            thread.start();
        }
    }

    @Override
    public void installComponents(final JFileChooser jFileChooser) {
        Serializable serializable;
        Object object;
        Object object2;
        if (this.directoryChooser) {
            jFileChooser.setDialogTitle(UIManager.getString("DirectoryChooser.title"));
        }
        Locale locale = jFileChooser.getLocale();
        jFileChooser.setLayout(new BorderLayout(0, this.yGap));
        jFileChooser.setBorder(new EmptyBorder(this.yGap, this.xGap, this.yGap, this.xGap));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setName("JFileChooser.NorthPanel");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.lookInLabel = new JLabel(UIManager.getString((Object)"FileChooser.lookInLabelText", locale));
        this.lookInLabel.setDisplayedMnemonic(UIManager.getInt("FileChooser.lookInLabelMnemonic"));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, this.xGap);
        jPanel.add((Component)this.lookInLabel, gridBagConstraints);
        this.directoryComboBox = new JComboBox();
        this.directoryComboBox.setName("JFileChooser.DirectoryComboBox");
        final DirectoryComboBoxModel directoryComboBoxModel = new DirectoryComboBoxModel();
        this.directoryComboBox.setModel(directoryComboBoxModel);
        final ListCellRenderer listCellRenderer = this.directoryComboBox.getRenderer();
        this.directoryComboBox.setRenderer(new DefaultListCellRenderer(){
            IndentIcon ii;
            {
                this.ii = new IndentIcon();
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (SyntheticaFileChooserUI.this.comboListBackground != null && (jList.getBorder() == null || jList.getBorder().getClass().getName().contains("SynthBorder"))) {
                    jList.setBackground(SyntheticaFileChooserUI.this.comboListBackground);
                }
                JLabel jLabel = (JLabel)listCellRenderer.getListCellRendererComponent(jList, object, n, bl, bl2);
                if (object == null) {
                    jLabel.setText("");
                    return this;
                }
                File file = (File)object;
                jLabel.setText(jFileChooser.getName(file));
                if (SyntheticaFileChooserUI.this.useSystemFileIcons) {
                    FileSystemView fileSystemView = jFileChooser.getFileSystemView();
                    this.ii.icon = fileSystemView.getSystemIcon(file);
                }
                if (this.ii.icon == null || !SyntheticaFileChooserUI.this.useSystemFileIcons) {
                    this.ii.icon = SyntheticaFileChooserUI.this.getFileChooser().getIcon(file);
                }
                this.ii.depth = directoryComboBoxModel.getDepth(n);
                jLabel.setIcon(this.ii);
                jLabel.setOpaque(bl);
                return jLabel;
            }
        });
        this.directoryComboBox.addActionListener(this);
        this.directoryComboBox.setActionCommand("directoryComboBox.select");
        this.directoryComboBox.setMaximumRowCount(15);
        this.directoryComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.directoryComboBox, gridBagConstraints);
        Box box = new Box(2);
        box.add(Box.createHorizontalStrut(this.xGap));
        boolean bl = UIManager.getBoolean("Synthetica.extendedFileChooser.actionButtons.paintBorder");
        this.upFolderButton = new JButton(this.upFolderIcon);
        if (SyntheticaLookAndFeel.get("FileChooser.upFolderIcon.disabled", jFileChooser) != null) {
            this.upFolderButton.setDisabledIcon(SyntheticaLookAndFeel.getIcon("FileChooser.upFolderIcon.disabled", jFileChooser));
        } else {
            this.upFolderButton.setDisabledIcon(this.createBrightIcon(this.upFolderIcon));
        }
        this.upFolderButton.setPressedIcon(SyntheticaLookAndFeel.getIcon("FileChooser.upFolderIcon.pressed", jFileChooser));
        this.upFolderButton.setToolTipText(UIManager.getString((Object)"FileChooser.upFolderToolTipText", locale));
        if (UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel) {
            this.upFolderButton.setMargin(new Insets(0, 0, 0, 0));
            if (!bl) {
                this.upFolderButton.setBorderPainted(false);
            }
        } else {
            this.upFolderButton.setMargin(new Insets(2, 2, 2, 2));
        }
        this.upFolderButton.addActionListener(this);
        this.upFolderButton.setActionCommand("upFolderAction");
        box.add(this.upFolderButton);
        JButton jButton = new JButton(this.homeFolderIcon);
        jButton.setDisabledIcon(SyntheticaLookAndFeel.getIcon("FileChooser.homeFolderIcon.disabled", jFileChooser));
        jButton.setPressedIcon(SyntheticaLookAndFeel.getIcon("FileChooser.homeFolderIcon.pressed", jFileChooser));
        jButton.setToolTipText(UIManager.getString((Object)"FileChooser.homeFolderToolTipText", locale));
        if (UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel) {
            jButton.setMargin(new Insets(0, 0, 0, 0));
            if (!bl) {
                jButton.setBorderPainted(false);
            }
        } else {
            jButton.setMargin(new Insets(2, 2, 2, 2));
        }
        jButton.addActionListener(this);
        jButton.setActionCommand("goHomeAction");
        box.add(jButton);
        this.readOnly = UIManager.getBoolean("FileChooser.readOnly");
        if (!this.readOnly) {
            this.newFolderButton = new JButton(this.newFolderIcon);
            if (SyntheticaLookAndFeel.get("FileChooser.newFolderIcon.disabled", jFileChooser) != null) {
                this.newFolderButton.setDisabledIcon(SyntheticaLookAndFeel.getIcon("FileChooser.newFolderIcon.disabled", jFileChooser));
            } else {
                this.newFolderButton.setDisabledIcon(this.createBrightIcon(this.newFolderIcon));
            }
            this.newFolderButton.setPressedIcon(SyntheticaLookAndFeel.getIcon("FileChooser.newFolderIcon.pressed", jFileChooser));
            this.newFolderButton.setToolTipText(UIManager.getString((Object)"FileChooser.newFolderToolTipText", locale));
            if (UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel) {
                this.newFolderButton.setMargin(new Insets(0, 0, 0, 0));
                if (!bl) {
                    this.newFolderButton.setBorderPainted(false);
                }
            } else {
                this.newFolderButton.setMargin(new Insets(2, 2, 2, 2));
            }
            this.newFolderButton.addActionListener(this);
            this.newFolderButton.setActionCommand("newFolderAction");
            box.add(this.newFolderButton);
        }
        if (!this.directoryChooser) {
            box.add(Box.createHorizontalStrut(this.xGap * 2));
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        final JToggleButton jToggleButton = new JToggleButton(this.listViewIcon);
        jToggleButton.setToolTipText(UIManager.getString((Object)"FileChooser.listViewButtonToolTipText", locale));
        if (UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel) {
            jToggleButton.setMargin(new Insets(0, 0, 0, 0));
            if (!bl) {
                jToggleButton.setBorderPainted(false);
            }
        } else {
            jToggleButton.setMargin(new Insets(2, 2, 2, 2));
        }
        jToggleButton.addActionListener(this);
        jToggleButton.setActionCommand("view.listAction");
        buttonGroup.add(jToggleButton);
        if (!this.directoryChooser) {
            box.add(jToggleButton);
        }
        final JToggleButton jToggleButton2 = new JToggleButton(this.detailsViewIcon);
        jToggleButton2.setToolTipText(UIManager.getString((Object)"FileChooser.detailsViewButtonToolTipText", locale));
        if (UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel) {
            jToggleButton2.setMargin(new Insets(0, 0, 0, 0));
            if (!bl) {
                jToggleButton2.setBorderPainted(false);
            }
        } else {
            jToggleButton2.setMargin(new Insets(2, 2, 2, 2));
        }
        jToggleButton2.addActionListener(this);
        jToggleButton2.setActionCommand("view.detailsAction");
        buttonGroup.add(jToggleButton2);
        if (!this.directoryChooser) {
            box.add(jToggleButton2);
        }
        gridBagConstraints.gridx = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)box, gridBagConstraints);
        jFileChooser.add((Component)jPanel, "North");
        this.filePane = this.createFilePane();
        this.filePane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("SET_VIEW")) {
                    int n = (Integer)propertyChangeEvent.getNewValue();
                    if (n == 0) {
                        jToggleButton.setSelected(true);
                    } else if (n == 1) {
                        jToggleButton2.setSelected(true);
                    }
                }
            }
        });
        if (this.directoryChooser) {
            this.filePane.setView(2);
        } else {
            this.filePane.setView(0);
        }
        jFileChooser.addPropertyChangeListener(this.filePane);
        jFileChooser.add((Component)this.filePane, "Center");
        JComponent jComponent = jFileChooser.getAccessory();
        if (jComponent != null) {
            this.getAccessoryPanel().add(jComponent);
        }
        jFileChooser.add((Component)this.getAccessoryPanel(), "After");
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setName("JFileChooser.SouthPanel");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = SyntheticaLookAndFeel.getBoolean("Synthetica.extendedFileChooser.rightLabelAlignment", jFileChooser) ? 13 : 17;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.insets = new Insets(0, 0, this.yGap / 2, this.xGap);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.fill = 0;
        JLabel jLabel = new JLabel(UIManager.getString((Object)"FileChooser.fileNameLabelText", locale));
        if (this.directoryChooser) {
            jLabel.setText(UIManager.getString((Object)"DirectoryChooser.directoryNameLabelText", locale));
        }
        jPanel2.add((Component)jLabel, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 0, this.yGap / 2, 0);
        this.fileNameTextField = new JTextField();
        this.fileNameTextField.setName("JFileChooser.FileNameTextField");
        jPanel2.add((Component)this.fileNameTextField, gridBagConstraints2);
        if (!this.directoryChooser) {
            gridBagConstraints2.insets = new Insets(0, 0, 0, this.xGap);
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 0.0;
            gridBagConstraints2.fill = 0;
            object2 = new JLabel(UIManager.getString((Object)"FileChooser.filesOfTypeLabelText", locale));
            jPanel2.add((Component)object2, gridBagConstraints2);
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            object = new JComboBox<Object>();
            ((Component)object).setName("JFileChooser.FilterComboBox");
            ((JComboBox)object).setRenderer(new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                    if (jList.getFixedCellHeight() != -1) {
                        jList.setFixedCellHeight(-1);
                    }
                    if (SyntheticaFileChooserUI.this.comboListBackground != null && (jList.getBorder() == null || jList.getBorder().getClass().getName().contains("SynthBorder"))) {
                        jList.setBackground(SyntheticaFileChooserUI.this.comboListBackground);
                    }
                    if (object != null && object instanceof FileFilter) {
                        this.setText(((FileFilter)object).getDescription());
                    }
                    this.setOpaque(bl);
                    return this;
                }

                public String getName() {
                    return "ComboBox.listRenderer";
                }
            });
            serializable = new FilterComboBoxModel();
            ((JComboBox)object).setModel(serializable);
            jFileChooser.addPropertyChangeListener((PropertyChangeListener)((Object)serializable));
            jPanel2.add((Component)object, gridBagConstraints2);
        }
        gridBagConstraints2.insets = new Insets(this.yGap * 2, 0, 0, 0);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 2;
        this.approveButton = this.directoryChooser ? new JButton(UIManager.getString("DirectoryChooser.approveButtonText")) : new JButton(this.getApproveButtonText(jFileChooser));
        this.approveButton.setName("JFileChooser.ApproveButton");
        this.cancelButton = new JButton(this.cancelButtonText);
        this.cancelButton.setName("JFileChooser.CancelButton");
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        object2 = new SpringLayout();
        this.controlButtonPanel = new JPanel((LayoutManager)object2);
        this.controlButtonPanel.add(this.approveButton);
        this.controlButtonPanel.add(this.cancelButton);
        ((SpringLayout)object2).putConstraint("East", (Component)this.cancelButton, 0, "East", (Component)this.controlButtonPanel);
        ((SpringLayout)object2).putConstraint("East", (Component)this.approveButton, -this.xGap, "West", (Component)this.cancelButton);
        object = Spring.constant(0);
        Component[] componentArray = this.controlButtonPanel.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            serializable = componentArray[n2];
            object = Spring.max((Spring)object, ((SpringLayout)object2).getConstraints((Component)serializable).getWidth());
            ++n2;
        }
        componentArray = this.controlButtonPanel.getComponents();
        n = componentArray.length;
        n2 = 0;
        while (n2 < n) {
            serializable = componentArray[n2];
            SpringLayout.Constraints constraints = ((SpringLayout)object2).getConstraints((Component)serializable);
            constraints.setWidth((Spring)object);
            ++n2;
        }
        this.controlButtonPanel.setPreferredSize(this.cancelButton.getPreferredSize());
        this.controlButtonPanel.setMinimumSize(this.cancelButton.getPreferredSize());
        jPanel2.add((Component)this.controlButtonPanel, gridBagConstraints2);
        jFileChooser.add((Component)jPanel2, "South");
    }

    protected FilePane createFilePane() {
        return new FilePane();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.startsWith("directoryComboBox.select")) {
            this.directoryComboBox.hidePopup();
            this.getFileChooser().setCurrentDirectory((File)this.directoryComboBox.getSelectedItem());
        } else if (string.startsWith("upFolderAction")) {
            this.getChangeToParentDirectoryAction().actionPerformed(actionEvent);
        } else if (string.startsWith("goHomeAction")) {
            this.getGoHomeAction().actionPerformed(actionEvent);
        } else if (string.startsWith("newFolderAction")) {
            this.filePane.newCreatedFile = true;
            this.getNewFolderAction().actionPerformed(actionEvent);
        } else if (string.startsWith("view.")) {
            if (string.endsWith("listAction")) {
                this.filePane.setView(0);
            } else if (string.endsWith("detailsAction")) {
                this.filePane.setView(1);
            } else if (string.endsWith("treeAction")) {
                this.filePane.setView(2);
            }
        } else if (string.startsWith("approveAction")) {
            this.getApproveSelectionAction().actionPerformed(new ActionEvent(this, 0, ""));
        } else if (string.startsWith("orderBy.")) {
            if (this.filePane == null) {
                return;
            }
            if (string.endsWith("nameAction")) {
                if (this.filePane.sortColumn == 0 && this.filePane.sortOrder == 1) {
                    return;
                }
                this.filePane.sortColumn = 0;
            } else if (string.endsWith("sizeAction")) {
                if (this.filePane.sortColumn == 1 && this.filePane.sortOrder == 1) {
                    return;
                }
                this.filePane.sortColumn = 1;
            } else if (string.endsWith("dateAction")) {
                if (this.filePane.sortColumn == 3 && this.filePane.sortOrder == 1) {
                    return;
                }
                this.filePane.sortColumn = 3;
            }
            this.filePane.sortOrder = 1;
            this.filePane.detailsTableSortModel.sort();
            this.filePane.viewPanel.repaint();
            if (this.filePane.view == 2) {
                this.rescanCurrentDirectory(this.getFileChooser());
            }
        } else if (string.startsWith("refreshAction")) {
            this.rescanCurrentDirectory(this.getFileChooser());
        } else if (string.startsWith("cutAction")) {
            this.fillFileBuffer(this.cutBuffer);
            this.copyBuffer.clear();
            this.filePane.clearSelection();
            this.filePane.repaint();
        } else if (string.startsWith("copyAction")) {
            this.fillFileBuffer(this.copyBuffer);
            if (!this.cutBuffer.isEmpty()) {
                this.cutBuffer.clear();
                this.filePane.repaint();
            }
        } else if (string.startsWith("pasteAction")) {
            HashSet hashSet;
            int n = 0;
            if (!this.cutBuffer.isEmpty()) {
                hashSet = (HashSet)this.cutBuffer.clone();
                n = 2;
            } else {
                hashSet = (HashSet)this.copyBuffer.clone();
                n = 1;
            }
            final File file = this.getFileChooser().getCurrentDirectory();
            Window window = this.getWindow();
            final FileOperationDialog fileOperationDialog = window instanceof Dialog ? new FileOperationDialog((Dialog)window, n) : new FileOperationDialog((Frame)window, n);
            fileOperationDialog.applyComponentOrientation(this.getFileChooser().getComponentOrientation());
            final boolean bl = n == 2;
            fileOperationDialog.setVisible(true);
            new Thread(){

                public void run() {
                    Iterator iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        int n;
                        File file3 = (File)iterator.next();
                        File file2 = new File(file, file3.getName());
                        if (!file3.exists()) {
                            iterator.remove();
                            continue;
                        }
                        if (!SyntheticaFileChooserUI.this.cutBuffer.isEmpty() && file3.equals(file2)) {
                            iterator.remove();
                            continue;
                        }
                        if (file3.equals(file2)) {
                            n = 0;
                            while (file2.exists()) {
                                String string = ++n == 1 ? "" : "(" + n + ") ";
                                String string2 = UIManager.getString((Object)"FileChooser.copyAction.copyFilename", SyntheticaFileChooserUI.this.getFileChooser().getLocale());
                                String string3 = MessageFormat.format(string2, string, file3.getName());
                                file2 = new File(file2.getParentFile(), string3);
                            }
                        }
                        try {
                            int n2 = n = FileUtils.copy(file3, file2, true, true, SyntheticaFileChooserUI.this.copyBuffer.isEmpty(), fileOperationDialog) ? 0 : 1;
                            if (n == 0) continue;
                            break;
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                    fileOperationDialog.dispose();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (SyntheticaFileChooserUI.this.filePane.view == 2 && bl) {
                                HashSet<File> hashSet2 = new HashSet<File>();
                                for (File file : hashSet) {
                                    hashSet2.add(file.getParentFile());
                                }
                                for (File file : hashSet2) {
                                    TreePath treePath = SyntheticaFileChooserUI.this.filePane.getPath(file);
                                    ((FilePane.FileNode)treePath.getLastPathComponent()).prepareForUpdateChildren();
                                    ((DefaultTreeModel)SyntheticaFileChooserUI.this.filePane.tree.getModel()).nodeStructureChanged((TreeNode)treePath.getLastPathComponent());
                                }
                            }
                            SyntheticaFileChooserUI.this.rescanCurrentDirectory(SyntheticaFileChooserUI.this.getFileChooser());
                        }
                    });
                }
            }.start();
            if (!this.cutBuffer.isEmpty()) {
                this.cutBuffer.clear();
            }
        } else if (string.startsWith("deleteAction")) {
            if (this.readOnly || this.filePane.isSelectionEmpty()) {
                return;
            }
            String string2 = UIManager.getString("FileChooser.deleteAction.confirmMessage");
            String string3 = UIManager.getString("FileChooser.deleteAction.confirmDialogTitle");
            JOptionPane jOptionPane = new JOptionPane();
            SynthStyle synthStyle = SynthLookAndFeel.getStyleFactory().getStyle(jOptionPane, Region.OPTION_PANE);
            SynthContext synthContext = new SynthContext(jOptionPane, Region.OPTION_PANE, synthStyle, 0);
            Icon icon = ((DefaultSynthStyle)synthStyle).getIcon(synthContext, "OptionPane.stopIcon");
            int n = JOptionPane.showConfirmDialog(this.getFileChooser(), string2, string3, 2, 3, icon);
            if (n != 0) {
                return;
            }
            final HashSet<File> hashSet = new HashSet<File>();
            this.fillFileBuffer(hashSet);
            Window window = this.getWindow();
            final FileOperationDialog fileOperationDialog = window instanceof Dialog ? new FileOperationDialog((Dialog)window, 3) : new FileOperationDialog((Frame)window, 3);
            fileOperationDialog.applyComponentOrientation(this.getFileChooser().getComponentOrientation());
            fileOperationDialog.setVisible(true);
            new Thread(){

                public void run() {
                    Iterator iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        boolean bl;
                        File file = (File)iterator.next();
                        boolean bl2 = bl = !FileUtils.delete(file, true, fileOperationDialog);
                        if (bl) break;
                        iterator.remove();
                    }
                    fileOperationDialog.dispose();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (SyntheticaFileChooserUI.this.filePane.view == 2 && !SyntheticaFileChooserUI.this.getFileChooser().getCurrentDirectory().exists()) {
                                File file = SyntheticaFileChooserUI.this.getFileChooser().getCurrentDirectory().getParentFile();
                                SyntheticaFileChooserUI.this.getFileChooser().setSelectedFile(file);
                                SyntheticaFileChooserUI.this.getFileChooser().setCurrentDirectory(file);
                            }
                            SyntheticaFileChooserUI.this.rescanCurrentDirectory(SyntheticaFileChooserUI.this.getFileChooser());
                        }
                    });
                }
            }.start();
        } else if (string.startsWith("propertiesAction")) {
            if (this.filePane.isSelectionEmpty()) {
                return;
            }
            final HashSet<File> hashSet = new HashSet<File>();
            this.fillFileBuffer(hashSet);
            Window window = this.getWindow();
            final FilePropertiesDialog filePropertiesDialog = window instanceof Dialog ? new FilePropertiesDialog((Dialog)window) : new FilePropertiesDialog((Frame)window);
            final FileProperties fileProperties = new FileProperties();
            filePropertiesDialog.applyComponentOrientation(this.getFileChooser().getComponentOrientation());
            filePropertiesDialog.setVisible(true);
            new Thread(){

                public void run() {
                    for (File file : hashSet) {
                        boolean bl = false;
                        try {
                            bl = !FileUtils.determineProperties(fileProperties, file, true, filePropertiesDialog);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        if (bl) break;
                    }
                    filePropertiesDialog.refresh();
                }
            }.start();
        } else if (string.startsWith("renameAction")) {
            if (this.filePane.view == 2) {
                this.filePane.tree.startEditingAtPath(this.filePane.tree.getSelectionModel().getSelectionPath());
            }
            this.filePane.editFileName();
        }
    }

    private Window getWindow() {
        Container container = this.getFileChooser().getParent();
        while (container != null) {
            if (container instanceof Window) {
                return (Window)container;
            }
            container = container.getParent();
        }
        return null;
    }

    private synchronized void fillFileBuffer(Collection<File> collection) {
        collection.clear();
        if (this.filePane.view == 2) {
            TreePath[] treePathArray = this.filePane.tree.getSelectionModel().getSelectionPaths();
            int n = treePathArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath treePath = treePathArray[n2];
                FilePane.FileNode fileNode = (FilePane.FileNode)treePath.getLastPathComponent();
                collection.add(fileNode.getFile());
                ++n2;
            }
        } else {
            ListSelectionModel listSelectionModel = this.filePane.list.getSelectionModel();
            FilePane.DetailsTableSortModel detailsTableSortModel = this.filePane.detailsTableSortModel;
            int n = 0;
            while (n < detailsTableSortModel.getRowCount()) {
                File file = (File)detailsTableSortModel.getValueAt(n, 0);
                if (listSelectionModel.isSelectedIndex(n)) {
                    collection.add(file);
                }
                ++n;
            }
        }
    }

    @Override
    public void setFileName(String string) {
        this.fileNameTextField.setText(string);
    }

    @Override
    public String getFileName() {
        return this.fileNameTextField.getText();
    }

    @Override
    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("SelectedFileChangedProperty")) {
                    SyntheticaFileChooserUI.this.doSelectedFileChanged(propertyChangeEvent);
                } else if (string.equals("SelectedFilesChangedProperty")) {
                    SyntheticaFileChooserUI.this.doSelectedFilesChanged(propertyChangeEvent);
                } else if (string.equals("directoryChanged")) {
                    SyntheticaFileChooserUI.this.doDirectoryChanged(propertyChangeEvent);
                } else if (!string.equals("fileFilterChanged")) {
                    if (string.equals("fileSelectionChanged")) {
                        SyntheticaFileChooserUI.this.doFileSelectionModeChanged(propertyChangeEvent);
                    } else if (string.equals("AccessoryChangedProperty")) {
                        SyntheticaFileChooserUI.this.doAccessoryChanged(propertyChangeEvent);
                    } else if (string.equals("ApproveButtonTextChangedProperty") || string.equals("ApproveButtonToolTipTextChangedProperty")) {
                        SyntheticaFileChooserUI.this.doApproveButtonTextChanged(propertyChangeEvent);
                    } else if (string.equals("DialogTypeChangedProperty")) {
                        SyntheticaFileChooserUI.this.doDialogTypeChanged(propertyChangeEvent);
                    } else if (!string.equals("ApproveButtonMnemonicChangedProperty")) {
                        if (string.equals("ControlButtonsAreShownChangedProperty")) {
                            if (SyntheticaFileChooserUI.this.getFileChooser().getControlButtonsAreShown()) {
                                SyntheticaFileChooserUI.this.controlButtonPanel.setVisible(true);
                            } else {
                                SyntheticaFileChooserUI.this.controlButtonPanel.setVisible(false);
                            }
                        } else if (string.equals("componentOrientation")) {
                            ComponentOrientation componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue();
                            JFileChooser jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
                            if (componentOrientation != (ComponentOrientation)propertyChangeEvent.getOldValue()) {
                                jFileChooser.applyComponentOrientation(componentOrientation);
                                SyntheticaFileChooserUI.this.filePane.listPanel.applyComponentOrientation(componentOrientation);
                                SyntheticaFileChooserUI.this.filePane.tablePanel.applyComponentOrientation(componentOrientation);
                                SyntheticaFileChooserUI.this.filePane.table.setIntercellSpacing(new Dimension(0, 0));
                                SpringLayout springLayout = new SpringLayout();
                                if (jFileChooser.getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT) {
                                    springLayout.putConstraint("East", (Component)SyntheticaFileChooserUI.this.cancelButton, 0, "East", (Component)SyntheticaFileChooserUI.this.controlButtonPanel);
                                    springLayout.putConstraint("East", (Component)SyntheticaFileChooserUI.this.approveButton, -SyntheticaFileChooserUI.this.xGap, "West", (Component)SyntheticaFileChooserUI.this.cancelButton);
                                } else {
                                    springLayout.putConstraint("West", (Component)SyntheticaFileChooserUI.this.cancelButton, 0, "West", (Component)SyntheticaFileChooserUI.this.controlButtonPanel);
                                    springLayout.putConstraint("West", (Component)SyntheticaFileChooserUI.this.approveButton, SyntheticaFileChooserUI.this.xGap, "East", (Component)SyntheticaFileChooserUI.this.cancelButton);
                                }
                                SyntheticaFileChooserUI.this.controlButtonPanel.setLayout(springLayout);
                            }
                        } else if (string != "FileChooser.useShellFolder" && string.equals("ancestor") && propertyChangeEvent.getOldValue() == null) {
                            propertyChangeEvent.getNewValue();
                        }
                    }
                }
            }
        };
    }

    private void doSelectedFileChanged(PropertyChangeEvent propertyChangeEvent) {
        File file = (File)propertyChangeEvent.getNewValue();
        if (file != null) {
            ((FilePane.DetailsTableModel)((FilePane)this.filePane).detailsTableSortModel.model).doFileSelection();
            JFileChooser jFileChooser = this.getFileChooser();
            if (this.directoryChooser || jFileChooser.getFileSelectionMode() == 1) {
                if (jFileChooser.getFileSystemView().isFileSystem(file)) {
                    this.setFileName(file.getPath());
                }
            } else if (jFileChooser.isDirectorySelectionEnabled() || !file.isDirectory()) {
                this.setFileName(file.getName());
            }
        } else {
            this.filePane.clearSelection();
        }
    }

    private void doSelectedFilesChanged(PropertyChangeEvent propertyChangeEvent) {
        File[] fileArray = (File[])propertyChangeEvent.getNewValue();
        if (fileArray != null && fileArray.length > 1) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            while (n < fileArray.length) {
                stringBuilder.append("\"");
                stringBuilder.append(fileArray[n].getName());
                stringBuilder.append("\" ");
                ++n;
            }
            this.setFileName(stringBuilder.toString().trim());
        }
    }

    private void doDirectoryChanged(PropertyChangeEvent propertyChangeEvent) {
        Serializable serializable;
        JFileChooser jFileChooser = this.getFileChooser();
        File file = jFileChooser.getCurrentDirectory();
        if (file == null) {
            this.newFolderButton.setEnabled(false);
            return;
        }
        if (!this.readOnly) {
            if (!file.exists() || !file.canWrite()) {
                this.newFolderButton.setEnabled(false);
            } else {
                this.newFolderButton.setEnabled(true);
            }
        }
        ((DirectoryComboBoxModel)this.directoryComboBox.getModel()).addItem(file);
        boolean bl = false;
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            serializable = stackTraceElementArray[n2];
            if (((StackTraceElement)serializable).toString().contains("setSelectedFile")) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (this.treePanelEnabled) {
            serializable = this.filePane.getPath(file);
            if (this.filePane.tree.getSelectionPath() == null || serializable != null && !((TreePath)serializable).equals(this.filePane.tree.getSelectionPath()) && !bl) {
                this.filePane.tree.setSelectionPath((TreePath)serializable);
                this.filePane.tree.scrollPathToVisible((TreePath)serializable);
            }
        }
        if ((this.directoryChooser || jFileChooser.getFileSelectionMode() == 1) && file != null && jFileChooser.getFileSystemView().isFileSystem(file)) {
            this.setFileName(file.getPath());
        }
        this.upFolderButton.setEnabled(!jFileChooser.getFileSystemView().isRoot(file));
    }

    private void doFileSelectionModeChanged(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        File file = jFileChooser.getCurrentDirectory();
        if (file != null && (Integer)propertyChangeEvent.getNewValue() == 1 && jFileChooser.getFileSystemView().isFileSystem(file)) {
            this.setFileName(file.getPath());
        } else {
            this.setFileName(null);
        }
    }

    private void doAccessoryChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getAccessoryPanel() == null) {
            return;
        }
        JComponent jComponent = (JComponent)propertyChangeEvent.getOldValue();
        if (jComponent != null) {
            this.getAccessoryPanel().remove(jComponent);
        }
        if ((jComponent = (JComponent)propertyChangeEvent.getNewValue()) != null) {
            this.getAccessoryPanel().add((Component)jComponent, "Center");
        }
    }

    private void doApproveButtonTextChanged(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(jFileChooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
    }

    private void doDialogTypeChanged(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        this.doApproveButtonTextChanged(propertyChangeEvent);
        if (jFileChooser.getDialogType() == 0) {
            this.lookInLabel.setText(UIManager.getString((Object)"FileChooser.lookInLabelText", jFileChooser.getLocale()));
        } else if (jFileChooser.getDialogType() == 1) {
            this.lookInLabel.setText(UIManager.getString((Object)"FileChooser.saveInLabelText", jFileChooser.getLocale()));
        }
    }

    @Override
    public void rescanCurrentDirectory(JFileChooser jFileChooser) {
        this.getModel().validateFileCache();
        if (this.treePanelEnabled) {
            File file = this.getFileChooser().getCurrentDirectory();
            TreePath treePath = this.filePane.getPath(file);
            ((FilePane.FileNode)treePath.getLastPathComponent()).prepareForUpdateChildren();
            ((DefaultTreeModel)this.filePane.tree.getModel()).nodeStructureChanged((TreeNode)treePath.getLastPathComponent());
        }
    }

    private ImageIcon createBrightIcon(Icon icon) {
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        icon.paintIcon(null, bufferedImage.getGraphics(), 0, 0);
        ImageIcon imageIcon = new ImageIcon(bufferedImage);
        imageIcon = new ImageIcon(new JPanel().createImage(new FilteredImageSource(bufferedImage.getSource(), new RGBImageFilter(){

            public int filterRGB(int n, int n2, int n3) {
                return 0x60FFFFFF & n3;
            }
        })));
        bufferedImage.getGraphics().dispose();
        return imageIcon;
    }

    private class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private ArrayList<File> directories = new ArrayList();
        private ArrayList<Integer> depths = new ArrayList();
        private File selectedDirectory = null;

        public DirectoryComboBoxModel() {
            File file = SyntheticaFileChooserUI.this.getFileChooser().getCurrentDirectory();
            if (file != null) {
                this.addItem(file);
            }
        }

        private void addItem(File file) {
            if (file == null) {
                return;
            }
            this.directories.clear();
            this.depths.clear();
            boolean bl = SyntheticaFileChooserUI.this.getFileChooser().getFileSystemView().equals(FileSystemView.getFileSystemView());
            Boolean bl2 = (Boolean)SyntheticaFileChooserUI.this.getFileChooser().getClientProperty("FileChooser.useShellFolder");
            if (bl2 != null) {
                bl = bl2;
            }
            File[] fileArray = bl ? (File[])ShellFolder.get("fileChooserComboBoxFolders") : SyntheticaFileChooserUI.this.getFileChooser().getFileSystemView().getRoots();
            this.directories.addAll(Arrays.asList(fileArray));
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                file = ShellFolder.getShellFolder(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            File file2 = file;
            ArrayList<File> arrayList = new ArrayList<File>();
            do {
                arrayList.add(file2);
            } while ((file2 = file2.getParentFile()) != null);
            ArrayList<File> arrayList2 = new ArrayList<File>();
            int n = 0;
            while (n < arrayList.size()) {
                file2 = (File)arrayList.get(n);
                if (this.directories.contains(file2)) {
                    for (File file3 : this.directories) {
                        if (file3.equals(file2) && !this.directories.contains(file)) {
                            int n2 = n;
                            while (n2 >= 0) {
                                arrayList2.add((File)arrayList.get(n2));
                                this.depths.add(new Integer(arrayList.size() - 1 - n2));
                                --n2;
                            }
                            continue;
                        }
                        arrayList2.add(file3);
                        File file4 = file3;
                        int n3 = 0;
                        while ((file4 = file4.getParentFile()) != null && arrayList2.contains(file4)) {
                            ++n3;
                        }
                        this.depths.add(new Integer(n3));
                    }
                    break;
                }
                ++n;
            }
            this.directories = arrayList2;
            this.setSelectedItem(file);
        }

        public int getDepth(int n) {
            return n >= 0 && n < this.depths.size() ? this.depths.get(n) : 0;
        }

        public void setSelectedItem(Object object) {
            this.selectedDirectory = (File)object;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        public int getSize() {
            return this.directories.size();
        }

        public Object getElementAt(int n) {
            return this.directories.get(n);
        }
    }

    public class FilePane
    extends JPanel
    implements PropertyChangeListener {
        private static final int LIST_WIDTH = 600;
        private static final int LIST_HEIGHT = 205;
        private static final int COLUMN_FILE = 0;
        private static final int COLUMN_FILESIZE = 1;
        private static final int COLUMN_FILETYPE = 2;
        private static final int COLUMN_FILEDATE = 3;
        private static final int COLUMN_FILEATTR = 4;
        private static final int COLUMN_COLCOUNT = 5;
        private int[] COLUMN_WIDTHS;
        private static final int ASCENDING = 1;
        private static final int DESCENDING = -1;
        private int sortColumn;
        private int sortOrder;
        private int view;
        private JPanel viewPanel;
        private JPanel listPanel;
        private JPanel tablePanel;
        private JPanel treePanel;
        private JPopupMenu fileContextMenu;
        private JList list;
        private JTable table;
        private JTree tree;
        private DetailsTableSortModel detailsTableSortModel;
        private String fileSizeHeaderText;
        private File editFile;
        private JTextField editTextField;
        private boolean newCreatedFile;
        private int editX;
        private int editIndex;
        String[] columnNames;

        public FilePane() {
            super(new BorderLayout());
            this.COLUMN_WIDTHS = new int[]{175, 60, 100, 100, 30};
            this.sortColumn = 0;
            this.sortOrder = 1;
            this.view = -1;
            this.editX = 20;
            this.editIndex = -1;
            this.setName("JFileChooser.FilePanel");
            this.editTextField = new JTextField();
            this.editTextField.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                }

                public void focusLost(FocusEvent focusEvent) {
                    FilePane.this.applyEditFileName();
                }
            });
            this.editTextField.addKeyListener(new KeyListener(){

                public void keyTyped(KeyEvent keyEvent) {
                    if (keyEvent.getKeyChar() == '\u001b') {
                        FilePane.this.cancelEditFileName();
                    } else if (keyEvent.getKeyChar() == '\n') {
                        FilePane.this.applyEditFileName();
                    }
                }

                public void keyPressed(KeyEvent keyEvent) {
                }

                public void keyReleased(KeyEvent keyEvent) {
                }
            });
            this.listPanel = this.createListPanel();
            this.tablePanel = this.createTablePanel();
            if (SyntheticaFileChooserUI.this.treePanelEnabled) {
                this.treePanel = this.createTreePanel();
            }
            this.viewPanel = new JPanel(new BorderLayout());
            this.viewPanel.setName("JFileChooser.ViewPanel");
            this.add(this.viewPanel);
            SyntheticaFileChooserUI.this.getFileChooser().registerKeyboardAction(SyntheticaFileChooserUI.this, "deleteAction", KeyStroke.getKeyStroke(127, 0), 1);
            this.viewPanel.registerKeyboardAction(SyntheticaFileChooserUI.this, "renameAction", KeyStroke.getKeyStroke(113, 0), 2);
            this.table.registerKeyboardAction(SyntheticaFileChooserUI.this, "renameAction", KeyStroke.getKeyStroke(113, 0), 1);
        }

        private void setView(int n) {
            if (this.view == n) {
                return;
            }
            this.firePropertyChange("SET_VIEW", this.view, n);
            this.view = n;
            this.viewPanel.removeAll();
            if (this.view == 0) {
                this.viewPanel.add(this.listPanel);
            } else if (this.view == 1) {
                this.viewPanel.add(this.tablePanel);
            } else if (this.view == 2) {
                this.viewPanel.add(this.treePanel);
            }
            this.setInheritPopupMenu(this.viewPanel, true);
            SyntheticaFileChooserUI.this.actionPerformed(new ActionEvent(this, 0, "orderBy.nameAction"));
            this.revalidate();
            this.viewPanel.repaint();
        }

        private int getView() {
            return this.view;
        }

        private void setInheritPopupMenu(Container container, boolean bl) {
            int n = container.getComponentCount();
            if (container instanceof JComponent) {
                ((JComponent)container).setInheritsPopupMenu(bl);
            }
            int n2 = 0;
            while (n2 < n) {
                this.setInheritPopupMenu((Container)container.getComponent(n2), bl);
                ++n2;
            }
        }

        protected JPanel createListPanel() {
            Object object;
            JPanel jPanel = new JPanel(new BorderLayout());
            JFileChooser jFileChooser = SyntheticaFileChooserUI.this.getFileChooser();
            this.list = new JList();
            this.list.setName("JFileChooser.List");
            this.list.putClientProperty("List.isFileList", Boolean.TRUE);
            this.list.setCellRenderer(new ListRenderer(this.list.getCellRenderer()));
            this.list.setLayoutOrientation(1);
            this.list.setVisibleRowCount(-1);
            this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    File file = (File)FilePane.this.list.getSelectedValue();
                    if (SyntheticaFileChooserUI.this.treePanelEnabled && file != null) {
                        TreePath treePath = FilePane.this.getPath(file);
                        FilePane.this.tree.setSelectionPath(treePath);
                        FilePane.this.tree.scrollPathToVisible(treePath);
                    }
                    if (((ListSelectionModel)listSelectionEvent.getSource()).isSelectionEmpty()) {
                        FilePane.this.editIndex = -1;
                    }
                }
            });
            this.list.setModel(new ListModel(){

                public int getSize() {
                    return FilePane.this.detailsTableSortModel.getRowCount();
                }

                public Object getElementAt(int n) {
                    return FilePane.this.detailsTableSortModel.getValueAt(n, 0);
                }

                public void addListDataListener(ListDataListener listDataListener) {
                    SyntheticaFileChooserUI.this.getModel().addListDataListener(listDataListener);
                }

                public void removeListDataListener(ListDataListener listDataListener) {
                    SyntheticaFileChooserUI.this.getModel().removeListDataListener(listDataListener);
                }
            });
            this.list.addMouseListener(new FilePaneMouseListener(this.list));
            this.list.addListSelectionListener(SyntheticaFileChooserUI.this.createListSelectionListener(jFileChooser));
            this.list.setSelectionMode(0);
            KeyListener[] keyListenerArray = this.list.getKeyListeners();
            int n = keyListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = keyListenerArray[n2];
                this.list.removeKeyListener((KeyListener)object);
                ++n2;
            }
            this.list.addKeyListener(new FileSelectHandler());
            object = new JScrollPane(this.list);
            jPanel.setPreferredSize(new Dimension(600, 205));
            jPanel.add((Component)object, "Center");
            return jPanel;
        }

        protected JPanel createTablePanel() {
            JPanel jPanel = new JPanel(new BorderLayout());
            JFileChooser jFileChooser = SyntheticaFileChooserUI.this.getFileChooser();
            Locale locale = jFileChooser.getLocale();
            String string = UIManager.getString((Object)"FileChooser.fileNameHeaderText", locale);
            this.fileSizeHeaderText = UIManager.getString((Object)"FileChooser.fileSizeHeaderText", locale);
            String string2 = UIManager.getString((Object)"FileChooser.fileTypeHeaderText", locale);
            String string3 = UIManager.getString((Object)"FileChooser.fileDateHeaderText", locale);
            String string4 = UIManager.getString((Object)"FileChooser.fileAttrHeaderText", locale);
            this.columnNames = new String[]{string, this.fileSizeHeaderText, string2, string3, string4};
            this.table = new JTable(){

                public boolean editCellAt(int n, int n2, EventObject eventObject) {
                    if (!JavaVersion.JAVA5 && this.isEditing()) {
                        return true;
                    }
                    return super.editCellAt(n, n2, eventObject);
                }
            };
            this.table.setName("JFileChooser.Table");
            this.table.putClientProperty("Table.isFileList", Boolean.TRUE);
            this.detailsTableSortModel = new DetailsTableSortModel(new DetailsTableModel(jFileChooser));
            this.table.setSelectionModel(this.list.getSelectionModel());
            this.table.setModel(this.detailsTableSortModel);
            this.table.setShowGrid(false);
            this.table.setIntercellSpacing(new Dimension(0, 0));
            int n = this.table.getRowHeight();
            Icon icon = null;
            FileSystemView fileSystemView = jFileChooser.getFileSystemView();
            try {
                icon = fileSystemView.getSystemIcon(fileSystemView.getHomeDirectory());
            }
            catch (Exception exception) {
                try {
                    icon = fileSystemView.getSystemIcon(fileSystemView.getDefaultDirectory());
                }
                catch (Exception exception2) {
                    icon = SyntheticaFileChooserUI.this.homeFolderIcon;
                }
            }
            if (icon == null) {
                icon = SyntheticaFileChooserUI.this.homeFolderIcon;
            }
            if (n <= icon.getIconHeight()) {
                this.table.setRowHeight(icon.getIconHeight() + 1);
            }
            this.table.getTableHeader().setDefaultRenderer(new TableHeaderRenderer(this.table));
            this.table.getTableHeader().addMouseListener(new FilePaneMouseListener(this.table));
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            TableColumn[] tableColumnArray = new TableColumn[5];
            int n2 = 0;
            while (n2 < 5) {
                tableColumnArray[n2] = tableColumnModel.getColumn(n2);
                tableColumnArray[n2].setPreferredWidth(this.COLUMN_WIDTHS[n2]);
                ++n2;
            }
            String string5 = AccessController.doPrivileged(new GetPropertyAction("os.name"));
            if (string5 == null || !string5.startsWith("Windows")) {
                tableColumnModel.removeColumn(tableColumnArray[2]);
                tableColumnModel.removeColumn(tableColumnArray[4]);
            }
            DetailsTableCellRenderer detailsTableCellRenderer = new DetailsTableCellRenderer(jFileChooser);
            this.table.setDefaultRenderer(File.class, detailsTableCellRenderer);
            this.table.setDefaultRenderer(Long.class, detailsTableCellRenderer);
            this.table.setDefaultRenderer(Date.class, detailsTableCellRenderer);
            this.table.setDefaultRenderer(Object.class, detailsTableCellRenderer);
            tableColumnArray[0].setCellEditor(new DefaultCellEditor(this.editTextField));
            this.table.addMouseListener(new FilePaneMouseListener(this.table));
            this.table.addKeyListener(new FileSelectHandler());
            JScrollPane jScrollPane = new JScrollPane(this.table);
            jScrollPane.getViewport().setBackground(this.table.getBackground());
            if (UIManager.get("Table.scrollPaneCornerComponent") == null) {
                jScrollPane.setCorner("UPPER_TRAILING_CORNER", new TableHeaderCorner(this.table));
            }
            jPanel.add((Component)jScrollPane, "Center");
            return jPanel;
        }

        protected JPanel createTreePanel() {
            JPanel jPanel = new JPanel(new BorderLayout());
            final JFileChooser jFileChooser = SyntheticaFileChooserUI.this.getFileChooser();
            this.tree = new JTree();
            this.tree.setName("JFileChooser.Tree");
            this.tree.setEditable(true);
            FileNode fileNode = new FileNode(jFileChooser.getFileSystemView().getRoots()[0]);
            this.tree.setModel(new DefaultTreeModel(fileNode));
            this.tree.setCellRenderer(new TreeRenderer());
            this.tree.setCellEditor(new DefaultTreeCellEditor(this.tree, (DefaultTreeCellRenderer)this.tree.getCellRenderer(), new FileCellEditor(new JTextField())));
            this.tree.getCellEditor().addCellEditorListener(new CellEditorListener(){

                public void editingStopped(ChangeEvent changeEvent) {
                    FileCellEditor fileCellEditor = (FileCellEditor)changeEvent.getSource();
                    String string = fileCellEditor.getDelegateValue();
                    FilePane.this.editTextField.setText(string);
                    FilePane.this.editFile = ((FileNode)FilePane.this.tree.getSelectionPath().getLastPathComponent()).getFile();
                    File file = FilePane.this.applyEditFileName();
                    TreePath treePath = SyntheticaFileChooserUI.this.filePane.getPath(file);
                    ((FileNode)treePath.getLastPathComponent()).prepareForUpdateChildren();
                    ((DefaultTreeModel)SyntheticaFileChooserUI.this.filePane.tree.getModel()).nodeStructureChanged((TreeNode)treePath.getLastPathComponent());
                }

                public void editingCanceled(ChangeEvent changeEvent) {
                }
            });
            this.tree.setVisibleRowCount(-1);
            this.tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    File file;
                    if (FilePane.this.tree.getSelectionPath() == null || FilePane.this.view != 2) {
                        return;
                    }
                    final File file2 = ((FileNode)FilePane.this.tree.getSelectionPath().getLastPathComponent()).getFile().getAbsoluteFile();
                    File file3 = jFileChooser.getCurrentDirectory();
                    File file4 = file = file2.isDirectory() && FilePane.this.view == 2 ? file2 : file2.getParentFile();
                    if (!file3.equals(file)) {
                        jFileChooser.setCurrentDirectory(file);
                    }
                    if (!file2.equals(jFileChooser.getSelectedFile())) {
                        jFileChooser.setSelectedFile(file2);
                        if (!file3.equals(jFileChooser.getCurrentDirectory())) {
                            FilePane.this.detailsTableSortModel.addTableModelListener(new TableModelListener(){

                                public void tableChanged(TableModelEvent tableModelEvent) {
                                    FilePane.this.detailsTableSortModel.removeTableModelListener(this);
                                    SwingUtilities.invokeLater(new Runnable(){

                                        public void run() {
                                            FilePane.this.list.setSelectedValue(file2, true);
                                        }
                                    });
                                }
                            });
                        } else {
                            FilePane.this.list.setSelectedValue(file2, true);
                        }
                    }
                }
            });
            this.tree.addMouseListener(new FilePaneMouseListener(this.list));
            this.tree.getSelectionModel().setSelectionMode(1);
            this.tree.addKeyListener(new FileSelectHandler());
            JScrollPane jScrollPane = new JScrollPane(this.tree);
            jPanel.setPreferredSize(new Dimension(600, 205));
            jPanel.add((Component)jScrollPane, "Center");
            return jPanel;
        }

        private TreePath getPath(File file) {
            FileNode fileNode = (FileNode)this.tree.getModel().getRoot();
            if (fileNode.getFile().equals(file) || file == null) {
                return new TreePath(fileNode);
            }
            TreePath treePath = this.getPath(SyntheticaFileChooserUI.this.getFileChooser().getFileSystemView().getParentDirectory(file));
            FileNode fileNode2 = (FileNode)treePath.getLastPathComponent();
            Enumeration<?> enumeration = fileNode2.children();
            while (enumeration.hasMoreElements()) {
                FileNode fileNode3 = (FileNode)enumeration.nextElement();
                if (!fileNode3.getFile().exists() || !fileNode3.getFile().equals(file)) continue;
                return treePath.pathByAddingChild(fileNode3);
            }
            return treePath;
        }

        public boolean isSelectionEmpty() {
            if (this.view == 2) {
                return this.tree.getSelectionModel().isSelectionEmpty();
            }
            return this.list.getSelectionModel().isSelectionEmpty();
        }

        public void clearSelection() {
            if (SyntheticaFileChooserUI.this.treePanelEnabled) {
                this.tree.getSelectionModel().clearSelection();
            }
            this.list.getSelectionModel().clearSelection();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("MultiSelectionEnabledChangedProperty")) {
                if (SyntheticaFileChooserUI.this.getFileChooser().isMultiSelectionEnabled()) {
                    this.list.setSelectionMode(2);
                    this.table.setSelectionMode(2);
                } else {
                    this.list.setSelectionMode(0);
                    this.table.setSelectionMode(0);
                }
            }
        }

        private void editFileName() {
            this.editIndex = this.list.getSelectedIndex();
            if (this.editIndex < 0 || SyntheticaFileChooserUI.this.directoryChooser) {
                return;
            }
            this.editFile = (File)this.detailsTableSortModel.getValueAt(this.editIndex, 0);
            File file = SyntheticaFileChooserUI.this.getFileChooser().getCurrentDirectory();
            if (!file.canWrite() || !this.editFile.canWrite() || SyntheticaFileChooserUI.this.readOnly || SyntheticaFileChooserUI.this.getFileChooser().getFileSystemView().isFileSystemRoot(this.editFile)) {
                this.cancelEditFileName();
                return;
            }
            Rectangle rectangle = null;
            if (this.view == 0) {
                rectangle = this.list.getCellBounds(this.editIndex, this.editIndex);
                this.list.add(this.editTextField);
            }
            ComponentOrientation componentOrientation = this.list.getComponentOrientation();
            this.editTextField.setComponentOrientation(componentOrientation);
            if (this.view == 0) {
                if (componentOrientation.isLeftToRight()) {
                    this.editTextField.setBounds(this.editX + rectangle.x, rectangle.y, rectangle.width - this.editX, rectangle.height);
                } else {
                    this.editTextField.setBounds(rectangle.x, rectangle.y, rectangle.width - this.editX, rectangle.height);
                }
            } else if (this.view == 1) {
                this.table.editCellAt(this.editIndex, this.table.convertColumnIndexToView(0));
            }
            this.editTextField.setText(this.editFile.getName());
            this.editTextField.requestFocus();
            this.editTextField.selectAll();
            SyntheticaFileChooserUI.this.getFileChooser().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "NO_ACTION");
            this.table.getActionMap().put("NO_ACTION_KEY", new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                }
            });
            this.table.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "NO_ACTION_KEY");
        }

        private File applyEditFileName() {
            String string;
            if (this.editFile == null) {
                return null;
            }
            JFileChooser jFileChooser = SyntheticaFileChooserUI.this.getFileChooser();
            String string2 = jFileChooser.getName(this.editFile);
            String string3 = this.editFile.getName();
            String string4 = string = this.editTextField.getText().trim();
            File file = this.editFile;
            if (!string.equals(string2)) {
                int n;
                int n2 = string3.length();
                if (n2 > (n = string2.length()) && string3.charAt(n) == '.') {
                    string4 = String.valueOf(string) + string3.substring(n);
                }
                FileSystemView fileSystemView = jFileChooser.getFileSystemView();
                file = fileSystemView.createFileObject(this.editFile.getParentFile(), string4);
                TreePath treePath = null;
                if (SyntheticaFileChooserUI.this.treePanelEnabled) {
                    treePath = this.getPath(this.editFile);
                }
                if (file.exists()) {
                    String string5 = UIManager.getString("FileRenameErrorDialog.title");
                    String string6 = String.format(UIManager.getString("FileRenameErrorDialog.message"), file.getName());
                    JOptionPane.showMessageDialog(jFileChooser, string6, string5, 0);
                } else if (!file.exists() && this.editFile.renameTo(file)) {
                    final File file2 = this.editFile.equals(this.list.getSelectedValue()) ? file : this.list.getSelectedValue();
                    SyntheticaFileChooserUI.this.getModel().validateFileCache();
                    if (SyntheticaFileChooserUI.this.treePanelEnabled) {
                        this.tree.getModel().valueForPathChanged(treePath, file);
                    }
                    new Thread(){

                        public void run() {
                            try {
                                Thread.sleep(350L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    FilePane.this.list.setSelectedValue(file2, true);
                                }
                            });
                        }
                    }.start();
                }
            }
            this.cancelEditFileName();
            return file;
        }

        private void cancelEditFileName() {
            this.editIndex = -1;
            if (this.editFile == null) {
                return;
            }
            this.editFile = null;
            if (this.view == 0) {
                this.list.remove(this.editTextField);
            } else {
                this.table.editingCanceled(new ChangeEvent(this.table));
            }
            this.repaint();
            SyntheticaFileChooserUI.this.getFileChooser().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "cancelSelection");
            this.table.getActionMap().remove("NO_ACTION_KEY");
        }

        public JPopupMenu getComponentPopupMenu() {
            JPopupMenu jPopupMenu = SyntheticaFileChooserUI.this.getFileChooser().getComponentPopupMenu();
            if (jPopupMenu != null) {
                return jPopupMenu;
            }
            if (this.fileContextMenu != null && this.fileContextMenu.isVisible()) {
                return this.fileContextMenu;
            }
            Locale locale = SyntheticaFileChooserUI.this.getFileChooser().getLocale();
            JFileChooser jFileChooser = SyntheticaFileChooserUI.this.getFileChooser();
            File file = jFileChooser.getCurrentDirectory();
            String string = "";
            if (jFileChooser.getDialogType() == 0) {
                string = UIManager.getString((Object)"FileChooser.contextMenu.open", locale);
            } else if (jFileChooser.getDialogType() == 1) {
                string = UIManager.getString((Object)"FileChooser.contextMenu.save", locale);
            }
            JMenuItem jMenuItem = new JMenuItem("<html><b>" + string + "</b>");
            jMenuItem.addActionListener(SyntheticaFileChooserUI.this);
            jMenuItem.setActionCommand("approveAction");
            if (jFileChooser.getSelectedFile() == null && !SyntheticaFileChooserUI.this.isDirectorySelected()) {
                jMenuItem.setEnabled(false);
            } else if (jFileChooser.getDialogType() != 0 && SyntheticaFileChooserUI.this.isDirectorySelected()) {
                jMenuItem.setEnabled(false);
            }
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(UIManager.getString((Object)"FileChooser.contextMenu.listView", locale));
            if (this.view == 0) {
                jRadioButtonMenuItem.setSelected(true);
            }
            jRadioButtonMenuItem.addActionListener(SyntheticaFileChooserUI.this);
            jRadioButtonMenuItem.setActionCommand("view.listAction");
            JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(UIManager.getString((Object)"FileChooser.contextMenu.detailsView", locale));
            if (this.view == 1) {
                jRadioButtonMenuItem2.setSelected(true);
            }
            jRadioButtonMenuItem2.addActionListener(SyntheticaFileChooserUI.this);
            jRadioButtonMenuItem2.setActionCommand("view.detailsAction");
            JMenu jMenu = new JMenu(UIManager.getString((Object)"FileChooser.contextMenu.view", locale));
            jMenu.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem2);
            JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem(UIManager.getString((Object)"FileChooser.contextMenu.orderByName", locale));
            jRadioButtonMenuItem3.addActionListener(SyntheticaFileChooserUI.this);
            jRadioButtonMenuItem3.setActionCommand("orderBy.nameAction");
            if (this.sortColumn == 0) {
                jRadioButtonMenuItem3.setSelected(true);
            }
            JRadioButtonMenuItem jRadioButtonMenuItem4 = new JRadioButtonMenuItem(UIManager.getString((Object)"FileChooser.contextMenu.orderBySize", locale));
            jRadioButtonMenuItem4.addActionListener(SyntheticaFileChooserUI.this);
            jRadioButtonMenuItem4.setActionCommand("orderBy.sizeAction");
            if (this.sortColumn == 1) {
                jRadioButtonMenuItem4.setSelected(true);
            }
            JRadioButtonMenuItem jRadioButtonMenuItem5 = new JRadioButtonMenuItem(UIManager.getString((Object)"FileChooser.contextMenu.orderByDate", locale));
            jRadioButtonMenuItem5.addActionListener(SyntheticaFileChooserUI.this);
            jRadioButtonMenuItem5.setActionCommand("orderBy.dateAction");
            if (this.sortColumn == 3) {
                jRadioButtonMenuItem5.setSelected(true);
            }
            JMenu jMenu2 = new JMenu(UIManager.getString((Object)"FileChooser.contextMenu.orderBy", locale));
            jMenu2.add(jRadioButtonMenuItem3);
            jMenu2.add(jRadioButtonMenuItem4);
            jMenu2.add(jRadioButtonMenuItem5);
            JMenuItem jMenuItem2 = new JMenuItem(UIManager.getString((Object)"FileChooser.contextMenu.refresh", locale));
            jMenuItem2.addActionListener(SyntheticaFileChooserUI.this);
            jMenuItem2.setActionCommand("refreshAction");
            JMenuItem jMenuItem3 = new JMenuItem(UIManager.getString((Object)"FileChooser.contextMenu.newFolder", locale));
            jMenuItem3.addActionListener(SyntheticaFileChooserUI.this);
            jMenuItem3.setActionCommand("newFolderAction");
            if (!file.canWrite()) {
                jMenuItem3.setEnabled(false);
            }
            JMenuItem jMenuItem4 = new JMenuItem(UIManager.getString((Object)"FileChooser.contextMenu.cut", locale));
            jMenuItem4.addActionListener(SyntheticaFileChooserUI.this);
            jMenuItem4.setActionCommand("cutAction");
            if (this.isSelectionEmpty()) {
                jMenuItem4.setEnabled(false);
            }
            JMenuItem jMenuItem5 = new JMenuItem(UIManager.getString((Object)"FileChooser.contextMenu.copy", locale));
            jMenuItem5.addActionListener(SyntheticaFileChooserUI.this);
            jMenuItem5.setActionCommand("copyAction");
            if (this.isSelectionEmpty()) {
                jMenuItem5.setEnabled(false);
            }
            JMenuItem jMenuItem6 = new JMenuItem(UIManager.getString((Object)"FileChooser.contextMenu.paste", locale));
            jMenuItem6.addActionListener(SyntheticaFileChooserUI.this);
            jMenuItem6.setActionCommand("pasteAction");
            if (SyntheticaFileChooserUI.this.cutBuffer.isEmpty() && SyntheticaFileChooserUI.this.copyBuffer.isEmpty() || !file.canWrite()) {
                jMenuItem6.setEnabled(false);
            }
            JMenuItem jMenuItem7 = new JMenuItem(UIManager.getString((Object)"FileChooser.contextMenu.delete", locale));
            jMenuItem7.addActionListener(SyntheticaFileChooserUI.this);
            jMenuItem7.setActionCommand("deleteAction");
            if (this.isSelectionEmpty() || !file.canWrite()) {
                jMenuItem7.setEnabled(false);
            }
            JMenuItem jMenuItem8 = new JMenuItem(UIManager.getString((Object)"FileChooser.contextMenu.rename", locale));
            jMenuItem8.addActionListener(SyntheticaFileChooserUI.this);
            jMenuItem8.setActionCommand("renameAction");
            if (this.isSelectionEmpty() || jFileChooser.getSelectedFile() == null && !SyntheticaFileChooserUI.this.isDirectorySelected() || !file.canWrite()) {
                jMenuItem8.setEnabled(false);
            }
            JMenuItem jMenuItem9 = new JMenuItem(UIManager.getString((Object)"FileChooser.contextMenu.properties", locale));
            jMenuItem9.addActionListener(SyntheticaFileChooserUI.this);
            jMenuItem9.setActionCommand("propertiesAction");
            if (this.isSelectionEmpty()) {
                jMenuItem9.setEnabled(false);
            }
            this.fileContextMenu = new JPopupMenu();
            this.fileContextMenu.setName("JFileChooser.FileContextMenu");
            if (jFileChooser.getDialogType() != 2) {
                this.fileContextMenu.add(jMenuItem);
                this.fileContextMenu.addSeparator();
            }
            if (!SyntheticaFileChooserUI.this.directoryChooser) {
                this.fileContextMenu.add(jMenu);
                this.fileContextMenu.addSeparator();
            }
            if (!SyntheticaFileChooserUI.this.directoryChooser && SyntheticaFileChooserUI.this.sortEnabled) {
                this.fileContextMenu.add(jMenu2);
            }
            this.fileContextMenu.add(jMenuItem2);
            this.fileContextMenu.addSeparator();
            if (!SyntheticaFileChooserUI.this.readOnly) {
                this.fileContextMenu.add(jMenuItem3);
                this.fileContextMenu.addSeparator();
                this.fileContextMenu.add(jMenuItem4);
                this.fileContextMenu.add(jMenuItem5);
                this.fileContextMenu.add(jMenuItem6);
                this.fileContextMenu.addSeparator();
                this.fileContextMenu.add(jMenuItem7);
                this.fileContextMenu.add(jMenuItem8);
                this.fileContextMenu.addSeparator();
            }
            this.fileContextMenu.add(jMenuItem9);
            this.fileContextMenu.applyComponentOrientation(jFileChooser.getComponentOrientation());
            ContainerEvent containerEvent = new ContainerEvent(SyntheticaFileChooserUI.this.filePane, 300, this.fileContextMenu);
            ContainerListener[] containerListenerArray = SyntheticaFileChooserUI.this.filePane.getContainerListeners();
            int n = containerListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ContainerListener containerListener = containerListenerArray[n2];
                containerListener.componentAdded(containerEvent);
                ++n2;
            }
            return this.fileContextMenu;
        }

        private Collator getFilenameCollator() {
            Locale locale = SyntheticaFileChooserUI.this.getFileChooser().getLocale();
            if (locale.getLanguage().equals(Locale.GERMAN.getLanguage())) {
                return GermanCollator.getInstance();
            }
            return Collator.getInstance(locale);
        }

        private class DetailsTableCellRenderer
        extends DefaultTableCellRenderer {
            private DateFormat dateFormat;
            private Color sortColor = UIManager.getColor("Synthetica.fileChooser.tableView.sortColumnColor");
            private Color alternateBackground = UIManager.getColor("Table.alternateRowColor");
            private FileSystemView fsv;

            DetailsTableCellRenderer(JFileChooser jFileChooser) {
                this.fsv = SyntheticaFileChooserUI.this.getFileChooser().getFileSystemView();
                this.dateFormat = DateFormat.getDateTimeInstance(3, 3, jFileChooser.getLocale());
            }

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Object object2;
                JComponent jComponent = (JComponent)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (!bl) {
                    Object object3 = object2 = n % 2 == 0 && this.alternateBackground != null ? this.alternateBackground : jTable.getBackground();
                    if (n2 == jTable.convertColumnIndexToView(FilePane.this.sortColumn) && this.sortColor != null) {
                        float f = (float)this.sortColor.getAlpha() / 255.0f;
                        int n3 = (int)((float)this.sortColor.getRed() * f) + (int)((float)((Color)object2).getRed() * (1.0f - f));
                        int n4 = (int)((float)this.sortColor.getGreen() * f) + (int)((float)((Color)object2).getGreen() * (1.0f - f));
                        int n5 = (int)((float)this.sortColor.getBlue() * f) + (int)((float)((Color)object2).getBlue() * (1.0f - f));
                        jComponent.setBackground(new Color(n3, n4, n5));
                    } else {
                        jComponent.setBackground((Color)object2);
                    }
                }
                Object object4 = object2 = jComponent.getBorder() instanceof PaddingBorder ? ((PaddingBorder)this.getBorder()).getOutsideBorder() : jComponent.getBorder();
                if (object2.getBorderInsets((Component)jComponent).left + object2.getBorderInsets((Component)jComponent).right <= 4) {
                    object2 = new PaddingBorder((Border)object2);
                }
                jComponent.setBorder((Border)object2);
                return jComponent;
            }

            public void setValue(Object object) {
                this.setIcon(null);
                this.setHorizontalAlignment(2);
                if (object instanceof File) {
                    File file = (File)object;
                    String string = SyntheticaFileChooserUI.this.getFileChooser().getName(file);
                    this.setText(string);
                    Icon icon = null;
                    icon = SyntheticaFileChooserUI.this.useSystemFileIcons ? this.fsv.getSystemIcon(file) : SyntheticaFileChooserUI.this.getFileChooser().getIcon(file);
                    this.setIcon(icon);
                    if (SyntheticaFileChooserUI.this.cutBuffer.contains(object)) {
                        this.setIcon(SyntheticaFileChooserUI.this.createBrightIcon(icon));
                    }
                } else if (object instanceof Date) {
                    this.setText(object == null ? "" : this.dateFormat.format((Date)object));
                } else if (object instanceof Long) {
                    long l = (Long)object;
                    if (l == -1L) {
                        this.setText("");
                        return;
                    }
                    String string = "0";
                    if ((l /= 1024L) < 1024L) {
                        if (l == 0L) {
                            l = 1L;
                        }
                        NumberFormat numberFormat = NumberFormat.getInstance(SyntheticaFileChooserUI.this.getFileChooser().getLocale());
                        string = String.valueOf(numberFormat.format(l)) + " KB";
                    } else {
                        NumberFormat numberFormat = NumberFormat.getInstance(SyntheticaFileChooserUI.this.getFileChooser().getLocale());
                        string = String.valueOf(numberFormat.format(l /= 1024L)) + " MB";
                    }
                    this.setHorizontalAlignment(4);
                    this.setText(string);
                } else {
                    super.setValue(object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class DetailsTableModel
        extends AbstractTableModel {
            JFileChooser fileChooser;
            File newAddedEntry;
            ListModel listModel;

            DetailsTableModel(JFileChooser jFileChooser) {
                this.fileChooser = jFileChooser;
                this.listModel = SyntheticaFileChooserUI.this.getModel();
                this.listModel.addListDataListener(new ListDataListener(){

                    public void contentsChanged(ListDataEvent listDataEvent) {
                        DetailsTableModel.this.fireTableDataChanged();
                        DetailsTableModel.this.doFileSelection();
                    }

                    public void intervalAdded(ListDataEvent listDataEvent) {
                        DetailsTableModel.this.newAddedEntry = (File)DetailsTableModel.this.listModel.getElementAt(listDataEvent.getIndex0());
                        final boolean bl = FilePane.this.newCreatedFile;
                        DetailsTableModel.this.fireTableDataChanged();
                        if (!SyntheticaFileChooserUI.this.treePanelEnabled) {
                            EventQueue.invokeLater(new Runnable(){

                                public void run() {
                                    DetailsTableModel.this.doFileSelection();
                                    if (bl) {
                                        int n = SyntheticaFileChooserUI.this.getModel().indexOf((this).DetailsTableModel.this.newAddedEntry);
                                        SyntheticaFileChooserUI.this.filePane.editIndex = n;
                                        SyntheticaFileChooserUI.this.filePane.editFileName();
                                    }
                                }
                            });
                        }
                    }

                    public void intervalRemoved(ListDataEvent listDataEvent) {
                        DetailsTableModel.this.fireTableDataChanged();
                    }
                });
            }

            @Override
            public int getRowCount() {
                return this.listModel.getSize();
            }

            @Override
            public int getColumnCount() {
                return 5;
            }

            @Override
            public String getColumnName(int n) {
                return FilePane.this.columnNames[n];
            }

            @Override
            public Class<?> getColumnClass(int n) {
                switch (n) {
                    case 0: {
                        return File.class;
                    }
                    case 3: {
                        return Date.class;
                    }
                    case 1: {
                        return Long.class;
                    }
                }
                return super.getColumnClass(n);
            }

            @Override
            public Object getValueAt(int n, int n2) {
                File file = (File)this.listModel.getElementAt(n);
                switch (n2) {
                    case 0: {
                        return file;
                    }
                    case 1: {
                        if (!file.exists() || file.isDirectory() || this.fileChooser.getFileSystemView().isFileSystemRoot(file)) {
                            return new Long(-1L);
                        }
                        return new Long(file.length());
                    }
                    case 2: {
                        if (!file.exists() || this.fileChooser.getFileSystemView().isFileSystemRoot(file)) {
                            return null;
                        }
                        return this.fileChooser.getFileSystemView().getSystemTypeDescription(file);
                    }
                    case 3: {
                        if (!file.exists() || this.fileChooser.getFileSystemView().isFileSystemRoot(file)) {
                            return null;
                        }
                        long l = file.lastModified();
                        return l == 0L ? null : new Date(l);
                    }
                    case 4: {
                        if (!file.exists() || this.fileChooser.getFileSystemView().isFileSystemRoot(file)) {
                            return null;
                        }
                        String string = "";
                        try {
                            if (!file.canWrite()) {
                                string = String.valueOf(string) + "R";
                            }
                        }
                        catch (AccessControlException accessControlException) {
                            // empty catch block
                        }
                        if (file.isHidden()) {
                            string = String.valueOf(string) + "H";
                        }
                        return string;
                    }
                }
                return null;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 == 0 && FilePane.this.editFile != null;
            }

            public void doFileSelection() {
                File file = SyntheticaFileChooserUI.this.isDirectorySelected() ? SyntheticaFileChooserUI.this.getDirectory() : this.fileChooser.getSelectedFile();
                int n = ((BasicDirectoryModel)this.listModel).indexOf(file);
                if (file != null && n >= 0) {
                    FilePane.this.list.setSelectedValue(file, true);
                } else {
                    FilePane.this.list.clearSelection();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class DetailsTableSortModel
        extends AbstractTableModel
        implements TableModelListener {
            TableModel model;
            Row[] rows;

            DetailsTableSortModel(TableModel tableModel) {
                this.model = tableModel;
                tableModel.addTableModelListener(this);
                this.reinit();
            }

            public void reinit() {
                this.rows = new Row[this.model.getRowCount()];
                int n = 0;
                while (n < this.rows.length) {
                    this.rows[n] = new Row();
                    this.rows[n].index = n;
                    ++n;
                }
                this.sort();
            }

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                this.reinit();
                File file = ((DetailsTableModel)this.model).newAddedEntry;
                if (file != null && FilePane.this.newCreatedFile) {
                    int n = 0;
                    while (n < this.getRowCount()) {
                        if (file.equals(this.getValueAt(n, 0))) {
                            SyntheticaFileChooserUI.this.filePane.editIndex = n;
                            SyntheticaFileChooserUI.this.filePane.editFileName();
                            break;
                        }
                        ++n;
                    }
                    ((DetailsTableModel)this.model).newAddedEntry = null;
                    FilePane.this.newCreatedFile = false;
                }
            }

            public void sort() {
                Cursor cursor = FilePane.this.table.getTableHeader().getCursor();
                FilePane.this.table.getTableHeader().setCursor(null);
                SyntheticaFileChooserUI.this.getFileChooser().setCursor(Cursor.getPredefinedCursor(3));
                Arrays.sort(this.rows);
                this.fireTableDataChanged();
                SyntheticaFileChooserUI.this.getFileChooser().setCursor(Cursor.getPredefinedCursor(0));
                FilePane.this.table.getTableHeader().setCursor(cursor);
            }

            @Override
            public int getRowCount() {
                return this.model.getRowCount();
            }

            @Override
            public int getColumnCount() {
                return this.model.getColumnCount();
            }

            @Override
            public String getColumnName(int n) {
                return this.model.getColumnName(n);
            }

            @Override
            public Class<?> getColumnClass(int n) {
                return this.model.getColumnClass(n);
            }

            @Override
            public Object getValueAt(int n, int n2) {
                if (this.rows.length == 0) {
                    return null;
                }
                return this.model.getValueAt(this.rows[n].index, n2);
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                this.model.setValueAt(object, n, n2);
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.model.isCellEditable(n, n2);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            private class Row
            implements Comparable<Object> {
                public int index;

                private Row() {
                }

                @Override
                public int compareTo(Object object) {
                    if (!SyntheticaFileChooserUI.this.sortEnabled) {
                        return 0;
                    }
                    File file = (File)DetailsTableSortModel.this.model.getValueAt(this.index, 0);
                    File file2 = (File)DetailsTableSortModel.this.model.getValueAt(((Row)object).index, 0);
                    if (file == null || file2 == null) {
                        return 0;
                    }
                    FileSystemView fileSystemView = SyntheticaFileChooserUI.this.getFileChooser().getFileSystemView();
                    if (fileSystemView.isFileSystemRoot(file) || fileSystemView.isFileSystemRoot(file2)) {
                        return file.toString().compareTo(file2.toString()) * FilePane.this.sortOrder;
                    }
                    if (file.isDirectory() && file2.isFile()) {
                        return -1 * FilePane.this.sortOrder;
                    }
                    if (file.isFile() && file2.isDirectory()) {
                        return 1 * FilePane.this.sortOrder;
                    }
                    if (FilePane.this.sortColumn == 0) {
                        Collator collator = FilePane.this.getFilenameCollator();
                        int n = collator.compare(file.getName(), file2.getName());
                        return n * FilePane.this.sortOrder;
                    }
                    if (FilePane.this.sortColumn == 3) {
                        long l = file.lastModified() - file2.lastModified();
                        return (l < 0L ? 1 : (l > 0L ? -1 : 0)) * -FilePane.this.sortOrder;
                    }
                    if (FilePane.this.sortColumn == 1) {
                        long l = file.length() - file2.length();
                        return (l < 0L ? 1 : (l > 0L ? -1 : 0)) * -FilePane.this.sortOrder;
                    }
                    if (FilePane.this.sortColumn == 2) {
                        String string = fileSystemView.getSystemTypeDescription(file);
                        String string2 = fileSystemView.getSystemTypeDescription(file2);
                        return string.compareTo(string2) * FilePane.this.sortOrder;
                    }
                    if (FilePane.this.sortColumn == 4) {
                        String string = "";
                        try {
                            if (!file.canWrite()) {
                                string = String.valueOf(string) + "R";
                            }
                        }
                        catch (AccessControlException accessControlException) {
                            // empty catch block
                        }
                        if (file.isHidden()) {
                            string = String.valueOf(string) + "H";
                        }
                        String string3 = "";
                        try {
                            if (!file2.canWrite()) {
                                string3 = String.valueOf(string3) + "R";
                            }
                        }
                        catch (AccessControlException accessControlException) {
                            // empty catch block
                        }
                        if (file2.isHidden()) {
                            string3 = String.valueOf(string3) + "H";
                        }
                        return string.compareTo(string3) * FilePane.this.sortOrder;
                    }
                    return file.toString().compareTo(file2.toString()) * FilePane.this.sortOrder;
                }
            }
        }

        private class FileCellEditor
        extends DefaultCellEditor {
            public FileCellEditor(JTextField jTextField) {
                super(jTextField);
            }

            public Object getCellEditorValue() {
                return ((FileNode)FilePane.this.tree.getSelectionPath().getLastPathComponent()).getFile();
            }

            public String getDelegateValue() {
                return (String)this.delegate.getCellEditorValue();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class FileNode
        extends DefaultMutableTreeNode {
            boolean refresh;
            boolean updateAllowed;

            FileNode(File file) {
                super(file);
                this.refresh = false;
                this.updateAllowed = true;
            }

            public File getFile() {
                return (File)this.userObject;
            }

            @Override
            public int getChildCount() {
                this.updateChildren();
                return super.getChildCount();
            }

            public Enumeration<?> children() {
                this.updateChildren();
                return super.children();
            }

            @Override
            public boolean isLeaf() {
                return !((File)this.userObject).isDirectory();
            }

            private void prepareForUpdateChildren() {
                this.refresh = true;
            }

            private void updateChildren() {
                if (this.refresh) {
                    this.refresh = false;
                    this.removeAllChildren();
                    this.children = null;
                }
                if (this.children == null && this.updateAllowed) {
                    final FileSystemView fileSystemView = SyntheticaFileChooserUI.this.getFileChooser().getFileSystemView();
                    File[] fileArray = fileSystemView.getFiles(this.getFile(), true);
                    Arrays.sort(fileArray, new Comparator<Object>(){

                        @Override
                        public int compare(Object object, Object object2) {
                            File file = (File)object;
                            File file2 = (File)object2;
                            if (file == null || file2 == null) {
                                return 0;
                            }
                            if (fileSystemView.isFileSystemRoot(file) || fileSystemView.isFileSystemRoot(file2)) {
                                return file.toString().compareTo(file2.toString()) * FilePane.this.sortOrder;
                            }
                            if (file.isDirectory() && file2.isFile()) {
                                return -1 * FilePane.this.sortOrder;
                            }
                            if (file.isFile() && file2.isDirectory()) {
                                return 1 * FilePane.this.sortOrder;
                            }
                            if (FilePane.this.sortColumn == 0) {
                                Collator collator = FilePane.this.getFilenameCollator();
                                int n = collator.compare(file.getName(), file2.getName());
                                return n * FilePane.this.sortOrder;
                            }
                            if (FilePane.this.sortColumn == 3) {
                                long l = file.lastModified() - file2.lastModified();
                                return (l < 0L ? 1 : (l > 0L ? -1 : 0)) * FilePane.this.sortOrder;
                            }
                            if (FilePane.this.sortColumn == 1) {
                                long l = file.length() - file2.length();
                                return (l < 0L ? 1 : (l > 0L ? -1 : 0)) * FilePane.this.sortOrder;
                            }
                            return file.toString().compareTo(file2.toString()) * FilePane.this.sortOrder;
                        }
                    });
                    boolean bl = SyntheticaFileChooserUI.this.getFileChooser().getFileSelectionMode() == 1;
                    File[] fileArray2 = fileArray;
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray2[n2];
                        if (!bl || bl && file.isDirectory()) {
                            this.insert(new FileNode(file), this.children == null ? 0 : this.children.size());
                        }
                        ++n2;
                    }
                }
            }

            @Override
            public String toString() {
                return SyntheticaFileChooserUI.this.getFileChooser().getFileSystemView().getSystemDisplayName(this.getFile());
            }
        }

        private class FilePaneMouseListener
        implements MouseListener {
            private MouseListener doubleClickListener;
            private boolean singleClick;
            private final int EDIT_DELAY = 250;

            public FilePaneMouseListener(JList jList) {
                this.doubleClickListener = SyntheticaFileChooserUI.this.createDoubleClickListener(SyntheticaFileChooserUI.this.getFileChooser(), jList);
            }

            public FilePaneMouseListener(JTable jTable) {
                this.doubleClickListener = SyntheticaFileChooserUI.this.createDoubleClickListener(SyntheticaFileChooserUI.this.getFileChooser(), FilePane.this.list);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                JComponent jComponent = (JComponent)mouseEvent.getSource();
                if (jComponent instanceof JList) {
                    n = this.loc2IndexFileList((JList)jComponent, mouseEvent.getPoint());
                } else if (jComponent instanceof JTable) {
                    n = ((JTable)jComponent).rowAtPoint(mouseEvent.getPoint());
                } else {
                    if (jComponent instanceof JTableHeader) {
                        int n2 = ((JTableHeader)jComponent).columnAtPoint(mouseEvent.getPoint());
                        n2 = FilePane.this.table.convertColumnIndexToModel(n2);
                        if (n2 == FilePane.this.sortColumn) {
                            if (FilePane.this.sortOrder == 1) {
                                FilePane.this.sortOrder = -1;
                            } else {
                                FilePane.this.sortOrder = 1;
                            }
                        } else {
                            FilePane.this.sortOrder = n2 == 1 || n2 == 3 ? -1 : 1;
                            FilePane.this.sortColumn = n2;
                        }
                        FilePane.this.detailsTableSortModel.sort();
                        FilePane.this.viewPanel.repaint();
                        return;
                    }
                    return;
                }
                if (n >= 0 && FilePane.this.list.getSelectionModel().isSelectedIndex(n) && jComponent instanceof JTable) {
                    Rectangle rectangle = FilePane.this.list.getCellBounds(n, n);
                    mouseEvent = new MouseEvent(FilePane.this.list, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), rectangle.x, rectangle.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
                }
                if (n >= 0 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    if (mouseEvent.getClickCount() == 1) {
                        this.singleClick = true;
                        if (FilePane.this.editIndex == n && FilePane.this.editFile == null) {
                            new Thread(){

                                public void run() {
                                    try {
                                        1.sleep(250L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    if (FilePaneMouseListener.this.singleClick) {
                                        SwingUtilities.invokeLater(new Runnable(){

                                            public void run() {
                                                FilePane.this.editFileName();
                                            }
                                        });
                                    }
                                }
                            }.start();
                        } else if (FilePane.this.editFile == null) {
                            FilePane.this.editIndex = n;
                        }
                    } else if (mouseEvent.getClickCount() != 1) {
                        this.singleClick = false;
                        FilePane.this.cancelEditFileName();
                    }
                }
                if (n >= 0) {
                    this.doubleClickListener.mouseClicked(mouseEvent);
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                this.doubleClickListener.mouseEntered(mouseEvent);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                if (mouseEvent.getSource() instanceof JList) {
                    this.doubleClickListener.mouseExited(mouseEvent);
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getSource() instanceof JList) {
                    this.doubleClickListener.mousePressed(mouseEvent);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getSource() instanceof JList) {
                    this.doubleClickListener.mouseReleased(mouseEvent);
                }
            }

            private int loc2IndexFileList(JList jList, Point point) {
                int n = jList.locationToIndex(point);
                if (n != -1 && !this.pointIsInActualBounds(jList, n, point)) {
                    n = -1;
                }
                return n;
            }

            private boolean pointIsInActualBounds(JList jList, int n, Point point) {
                ListCellRenderer listCellRenderer = jList.getCellRenderer();
                ListModel listModel = jList.getModel();
                Object e = listModel.getElementAt(n);
                Component component = listCellRenderer.getListCellRendererComponent(jList, e, n, false, false);
                Dimension dimension = component.getPreferredSize();
                Rectangle rectangle = jList.getCellBounds(n, n);
                if (!component.getComponentOrientation().isLeftToRight()) {
                    rectangle.x += rectangle.width - dimension.width;
                }
                rectangle.width = dimension.width;
                rectangle.height = dimension.height;
                return rectangle.contains(point);
            }
        }

        private class IconBorder
        extends CompoundBorder {
            public IconBorder(Border border, final Icon icon) {
                super(border, new Border(){

                    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                        icon.paintIcon(component, graphics, n + n3 - icon.getIconWidth(), n2 + (n4 - icon.getIconHeight()) / 2);
                    }

                    public Insets getBorderInsets(Component component) {
                        return new Insets(0, 0, 0, icon.getIconWidth());
                    }

                    public boolean isBorderOpaque() {
                        return false;
                    }
                });
            }
        }

        private class ListRenderer
        implements ListCellRenderer {
            private FileSystemView fsv;
            ListCellRenderer delegate;

            public ListRenderer(ListCellRenderer listCellRenderer) {
                this.fsv = SyntheticaFileChooserUI.this.getFileChooser().getFileSystemView();
                this.delegate = listCellRenderer;
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JLabel jLabel = (JLabel)this.delegate.getListCellRendererComponent(jList, object, n, bl, bl2);
                File file = (File)object;
                String string = SyntheticaFileChooserUI.this.getFileChooser().getName(file);
                jLabel.setText(string);
                Icon icon = null;
                icon = SyntheticaFileChooserUI.this.useSystemFileIcons ? this.fsv.getSystemIcon(file) : SyntheticaFileChooserUI.this.getFileChooser().getIcon(file);
                jLabel.setIcon(icon);
                if (SyntheticaFileChooserUI.this.cutBuffer.contains(file)) {
                    jLabel.setIcon(SyntheticaFileChooserUI.this.createBrightIcon(icon));
                }
                return jLabel;
            }
        }

        private class PaddingBorder
        extends CompoundBorder {
            public PaddingBorder(Border border) {
                super(border, new Border(){

                    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                    }

                    public Insets getBorderInsets(Component component) {
                        return new Insets(1, 4, 1, 4);
                    }

                    public boolean isBorderOpaque() {
                        return false;
                    }
                });
            }
        }

        public class TableHeaderRenderer
        implements TableCellRenderer {
            private TableCellRenderer renderer;

            public TableHeaderRenderer(JTable jTable) {
                this.renderer = jTable.getTableHeader().getDefaultRenderer();
            }

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Border border;
                JLabel jLabel = (JLabel)this.renderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                Border border2 = border = jLabel.getBorder() instanceof IconBorder ? ((IconBorder)FilePane.this.getBorder()).getOutsideBorder() : jLabel.getBorder();
                if (border.getBorderInsets((Component)jLabel).left + border.getBorderInsets((Component)jLabel).right <= 4) {
                    border = new EmptyBorder(2, 4, 2, 4);
                }
                if (SyntheticaFileChooserUI.this.sortEnabled && n2 == jTable.convertColumnIndexToView(FilePane.this.sortColumn)) {
                    Icon icon = SyntheticaLookAndFeel.loadIcon(FilePane.this.sortOrder == 1 ? "Synthetica.fileChooser.tableView.arrowUp" : "Synthetica.fileChooser.tableView.arrowDown");
                    jLabel.setBorder(new IconBorder(border, icon));
                } else {
                    jLabel.setBorder(border);
                }
                return jLabel;
            }
        }

        private class TreeRenderer
        extends DefaultTreeCellRenderer {
            private FileSystemView fsv;

            private TreeRenderer() {
                this.fsv = SyntheticaFileChooserUI.this.getFileChooser().getFileSystemView();
            }

            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                File file = ((FileNode)object).getFile();
                this.setText(this.fsv.getSystemDisplayName(file));
                this.setIcon(this.getIcon(file));
                return this;
            }

            public Icon getLeafIcon() {
                if (FilePane.this.tree.getSelectionPath() == null) {
                    return super.getLeafIcon();
                }
                return this.getIcon(((FileNode)FilePane.this.tree.getSelectionPath().getLastPathComponent()).getFile());
            }

            public Icon getOpenIcon() {
                if (FilePane.this.tree.getSelectionPath() == null) {
                    return super.getOpenIcon();
                }
                return this.getIcon(((FileNode)FilePane.this.tree.getSelectionPath().getLastPathComponent()).getFile());
            }

            public Icon getClosedIcon() {
                if (FilePane.this.tree.getSelectionPath() == null) {
                    return super.getClosedIcon();
                }
                return this.getIcon(((FileNode)FilePane.this.tree.getSelectionPath().getLastPathComponent()).getFile());
            }

            private Icon getIcon(File file) {
                Icon icon = null;
                icon = SyntheticaFileChooserUI.this.useSystemFileIcons ? this.fsv.getSystemIcon(file) : SyntheticaFileChooserUI.this.getFileChooser().getIcon(file);
                if (SyntheticaFileChooserUI.this.cutBuffer.contains(file)) {
                    icon = SyntheticaFileChooserUI.this.createBrightIcon(icon);
                }
                return icon;
            }
        }
    }

    protected class FileSelectHandler
    implements KeyListener {
        private String prefix;
        private long lastTime;

        protected FileSelectHandler() {
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.isAltDown() || keyEvent.isControlDown() || keyEvent.isMetaDown()) {
                return;
            }
            char c = keyEvent.getKeyChar();
            JComponent jComponent = (JComponent)keyEvent.getSource();
            int n = -1;
            if (jComponent instanceof JList) {
                n = ((JList)jComponent).getLeadSelectionIndex();
            } else if (jComponent instanceof JTable) {
                n = ((JTable)jComponent).getSelectedRow();
            }
            long l = keyEvent.getWhen();
            if (l - this.lastTime > 1000L) {
                ++n;
                this.prefix = String.valueOf(c);
            } else if (this.prefix.length() == 1 && c == this.prefix.charAt(0)) {
                ++n;
            } else {
                this.prefix = String.valueOf(this.prefix) + c;
            }
            this.lastTime = l;
            int n2 = this.getNextFileIndex(jComponent, this.prefix, n, Position.Bias.Forward);
            if (n2 < 0) {
                n2 = this.getNextFileIndex(jComponent, this.prefix, 0, Position.Bias.Forward);
            }
            if (n2 >= 0) {
                if (jComponent instanceof JList) {
                    ((JList)jComponent).setSelectedIndex(n2);
                    ((JList)jComponent).ensureIndexIsVisible(n2);
                } else if (jComponent instanceof JTable) {
                    ((JTable)jComponent).setRowSelectionInterval(n2, n2);
                    ((JTable)jComponent).scrollRectToVisible(((JTable)jComponent).getCellRect(n2, 0, true));
                }
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        private int getNextFileIndex(JComponent jComponent, String string, int n, Position.Bias bias) {
            int n2 = -1;
            if (jComponent instanceof JList) {
                n2 = ((JList)jComponent).getModel().getSize();
            } else if (jComponent instanceof JTable) {
                n2 = ((JTable)jComponent).getModel().getRowCount();
            }
            if (n < 0 || n >= n2) {
                return -1;
            }
            boolean bl = bias == Position.Bias.Backward;
            int n3 = n;
            while (!(bl ? n3 < 0 : n3 >= n2)) {
                Object object;
                String string2 = null;
                if (jComponent instanceof JList) {
                    object = ((JList)jComponent).getModel();
                    string2 = SyntheticaFileChooserUI.this.getFileChooser().getName((File)object.getElementAt(n3));
                } else if (jComponent instanceof JTable) {
                    object = ((JTable)jComponent).getModel();
                    string2 = SyntheticaFileChooserUI.this.getFileChooser().getName((File)object.getValueAt(n3, 0));
                }
                if (string2.regionMatches(true, 0, string, 0, string.length())) {
                    return n3;
                }
                n3 += bl ? -1 : 1;
            }
            return -1;
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = SyntheticaFileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("ChoosableFileFilterChangedProperty")) {
                this.filters = (FileFilter[])propertyChangeEvent.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (string.equals("fileFilterChanged")) {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void setSelectedItem(Object object) {
            if (object != null) {
                JFileChooser jFileChooser = SyntheticaFileChooserUI.this.getFileChooser();
                jFileChooser.setFileFilter((FileFilter)object);
                if (jFileChooser.getDialogType() != 1) {
                    SyntheticaFileChooserUI.this.setFileName(null);
                }
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            JFileChooser jFileChooser = SyntheticaFileChooserUI.this.getFileChooser();
            FileFilter fileFilter = jFileChooser.getFileFilter();
            if (fileFilter != null && !Arrays.asList(this.filters).contains(fileFilter)) {
                jFileChooser.addChoosableFileFilter(fileFilter);
            }
            return jFileChooser.getFileFilter();
        }

        public int getSize() {
            return this.filters.length;
        }

        public Object getElementAt(int n) {
            if (this.filters.length > 0) {
                return this.filters[n];
            }
            return null;
        }
    }

    private class IndentIcon
    implements Icon {
        private Icon icon = null;
        private int depth = 0;
        private int indent = 10;

        private IndentIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (component.getComponentOrientation().isLeftToRight()) {
                this.icon.paintIcon(component, graphics, n + this.depth * this.indent, n2);
            } else {
                this.icon.paintIcon(component, graphics, n, n2);
            }
        }

        public int getIconWidth() {
            return this.icon.getIconWidth() + this.depth * this.indent;
        }

        public int getIconHeight() {
            return this.icon.getIconHeight();
        }
    }

    private static class TableHeaderCorner
    extends JTableHeader {
        public TableHeaderCorner(JTable jTable) {
            this.setTable(jTable);
        }
    }
}

