/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.interfaces;

import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import jd.gui.swing.jdgui.interfaces.SwitchPanelEvent;
import jd.gui.swing.jdgui.interfaces.SwitchPanelListener;
import org.appwork.utils.event.DefaultEvent;
import org.appwork.utils.event.Eventsender;

public abstract class SwitchPanel
extends JPanel {
    private static final long serialVersionUID = -7856570342778191232L;
    private boolean currentlyVisible = false;
    private Eventsender<SwitchPanelListener, SwitchPanelEvent> broadcaster;

    public SwitchPanel(LayoutManager layout) {
        super(layout);
        this.initBroadcaster();
    }

    public SwitchPanel() {
        this.initBroadcaster();
    }

    private void initBroadcaster() {
        this.broadcaster = new Eventsender<SwitchPanelListener, SwitchPanelEvent>(){

            protected void fireEvent(SwitchPanelListener listener, SwitchPanelEvent event) {
                listener.onPanelEvent(event);
            }
        };
    }

    public Eventsender<SwitchPanelListener, SwitchPanelEvent> getBroadcaster() {
        return this.broadcaster;
    }

    protected abstract void onShow();

    protected abstract void onHide();

    public void setShown() {
        if (this.currentlyVisible) {
            return;
        }
        this.currentlyVisible = true;
        this.onShow();
        this.broadcaster.fireEvent((DefaultEvent)new SwitchPanelEvent(this, 0));
        this.distributeView(this);
    }

    public void setHidden() {
        if (!this.currentlyVisible) {
            return;
        }
        this.currentlyVisible = false;
        this.onHide();
        this.broadcaster.fireEvent((DefaultEvent)new SwitchPanelEvent(this, 1));
        this.distributeHide(this);
    }

    protected void distributeView(JComponent switchPanel) {
        for (Component comp : switchPanel.getComponents()) {
            if (comp == switchPanel) {
                return;
            }
            this.dispatchViewEvent(comp);
        }
    }

    protected void dispatchViewEvent(Component comp) {
        if (!(comp instanceof JComponent)) {
            return;
        }
        if (comp instanceof SwitchPanel) {
            ((SwitchPanel)comp).setShown();
        } else if (comp instanceof JTabbedPane) {
            Component selected = ((JTabbedPane)comp).getSelectedComponent();
            this.dispatchViewEvent(selected);
        } else {
            this.distributeView((JComponent)comp);
        }
    }

    protected void distributeHide(JComponent switchPanel) {
        for (Component comp : switchPanel.getComponents()) {
            if (comp == switchPanel) continue;
            this.dispatchHideEvent(comp);
        }
    }

    protected void dispatchHideEvent(Component comp) {
        if (!(comp instanceof JComponent)) {
            return;
        }
        if (comp instanceof SwitchPanel) {
            ((SwitchPanel)comp).setHidden();
        } else if (comp instanceof JTabbedPane) {
            Component selected = ((JTabbedPane)comp).getSelectedComponent();
            this.dispatchHideEvent(selected);
        } else {
            this.distributeHide((JComponent)comp);
        }
    }

    public boolean isShown() {
        return this.currentlyVisible;
    }
}

