/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.menu;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;
import jd.SecondLevelLaunch;
import jd.gui.swing.jdgui.menu.ExtDonateMenuButton;
import jd.gui.swing.jdgui.menu.ExtMenuButton;
import jd.gui.swing.jdgui.menu.MenuJToggleButton;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.actions.AppAction;
import org.jdownloader.controlling.contextmenu.ContextMenuManager;
import org.jdownloader.controlling.contextmenu.CustomizableAppAction;
import org.jdownloader.controlling.contextmenu.MenuContainer;
import org.jdownloader.controlling.contextmenu.MenuItemData;
import org.jdownloader.controlling.contextmenu.gui.MenuBuilder;
import org.jdownloader.extensions.ExtensionNotLoadedException;
import org.jdownloader.gui.mainmenu.DonateAction;
import org.jdownloader.gui.mainmenu.MenuManagerMainmenu;
import org.jdownloader.gui.views.downloads.bottombar.HorizontalBoxItem;
import org.jdownloader.images.NewTheme;
import org.jdownloader.logging.LogController;
import org.jdownloader.updatev2.gui.LAFOptions;

public class JDMenuBar
extends JMenuBar
implements MouseListener {
    private static final JDMenuBar INSTANCE = new JDMenuBar();
    private static final long serialVersionUID = 6758718947311901334L;
    private LogSource logger;

    public static JDMenuBar getInstance() {
        return INSTANCE;
    }

    private JDMenuBar() {
        SecondLevelLaunch.EXTENSIONS_LOADED.executeWhenReached(new Runnable(){

            @Override
            public void run() {
                new EDTRunner(){

                    protected void runInEDT() {
                        JDMenuBar.this.updateLayout();
                    }
                };
            }
        });
        this.addMouseListener(this);
        this.logger = LogController.getInstance().getLogger(JDMenuBar.class.getName());
        LAFOptions.getInstance().getExtension().customizeMenuBar((JMenuBar)this);
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        super.addImpl(comp, constraints, index);
        comp.addMouseListener(this);
    }

    public void updateLayout() {
        this.removeAll();
        new MenuBuilder((ContextMenuManager)MenuManagerMainmenu.getInstance(), this, (MenuContainer)MenuManagerMainmenu.getInstance().getMenuData()){

            protected void addContainer(JComponent root, MenuItemData inst, int index, int size) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException, ExtensionNotLoadedException {
                if (!inst.isVisible()) {
                    return;
                }
                JMenu submenu = (JMenu)inst.addTo(root, (MenuBuilder)this);
                if (submenu != null) {
                    this.applyMnemonic(root, submenu);
                    if (root == JDMenuBar.this) {
                        submenu.setIcon(null);
                    }
                    this.createLayer(submenu, (MenuContainer)inst);
                }
            }

            protected void addAction(JComponent root, MenuItemData inst, int index, int size) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException, ExtensionNotLoadedException {
                if (!inst.isVisible()) {
                    return;
                }
                try {
                    if (root instanceof JDMenuBar && inst instanceof HorizontalBoxItem) {
                        ((JDMenuBar)root).add(Box.createHorizontalGlue());
                        return;
                    }
                }
                catch (Throwable e) {
                    this.logger.log(e);
                }
                if (root instanceof JMenu) {
                    JComponent comp = inst.addTo(root, (MenuBuilder)this);
                    if (comp == null) {
                        return;
                    }
                    if (comp instanceof AbstractButton) {
                        this.applyMnemonic(root, (AbstractButton)comp);
                    }
                } else {
                    JMenu ret;
                    CustomizableAppAction action = inst.createAction();
                    if (StringUtils.isNotEmpty((String)inst.getShortcut()) && KeyStroke.getKeyStroke(inst.getShortcut()) != null) {
                        action.setAccelerator(KeyStroke.getKeyStroke(inst.getShortcut()));
                    } else if (MenuItemData.isEmptyValue((String)inst.getShortcut())) {
                        action.setAccelerator(null);
                    }
                    if (action.isToggle()) {
                        action.requestUpdate((Object)JDMenuBar.this);
                        ret = new MenuJToggleButton((AppAction)action);
                        Icon icon = NewTheme.I().getCheckBoxImage(action.getIconKey(), false, 18);
                        ret.setIcon(icon);
                        ret.setRolloverIcon(icon);
                        icon = NewTheme.I().getCheckBoxImage(action.getIconKey(), true, 18);
                        ret.setSelectedIcon(icon);
                        ret.setRolloverSelectedIcon(icon);
                    } else {
                        action.requestUpdate((Object)JDMenuBar.this);
                        ret = action instanceof DonateAction && index == size - 1 && !CrossSystem.isMac() ? new ExtDonateMenuButton((AppAction)action) : new ExtMenuButton((AppAction)action);
                        ret.setIcon(NewTheme.I().getIcon(action.getIconKey(), 18));
                    }
                    JMenu bt = ret;
                    action.addVisibilityPropertyChangeListener((JComponent)bt);
                    bt.setBorderPainted(false);
                    bt.setOpaque(false);
                    ((Component)ret).getAccessibleContext().setAccessibleName(action.getName());
                    ((Component)ret).getAccessibleContext().setAccessibleDescription(action.getTooltipText());
                    if (StringUtils.isNotEmpty((String)inst.getName())) {
                        ret.setText(inst.getName());
                    }
                    ret.setIcon(MenuItemData.getIcon((String)inst.getIconKey(), (int)20));
                    if (ret instanceof AbstractButton) {
                        this.applyMnemonic(root, ret);
                    }
                    root.add(ret);
                }
            }
        }.run();
        if (this.getMenuCount() == 0) {
            new MenuBuilder((ContextMenuManager)MenuManagerMainmenu.getInstance(), this, (MenuContainer)MenuManagerMainmenu.getInstance().createDefaultStructure()){

                protected void addContainer(JComponent root, MenuItemData inst, int index, int size) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException, ExtensionNotLoadedException {
                    JMenu submenu = (JMenu)inst.addTo(root, (MenuBuilder)this);
                    if (root == JDMenuBar.this) {
                        submenu.setIcon(null);
                    }
                    this.createLayer(submenu, (MenuContainer)inst);
                }

                protected void addAction(JComponent root, MenuItemData inst, int index, int size) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException, ExtensionNotLoadedException {
                    inst.addTo(root, (MenuBuilder)this);
                }
            }.run();
        }
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger() || e.getButton() == 3) {
            MenuManagerMainmenu.getInstance().openGui();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

