/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.EventListenerList;
import jd.gui.swing.jdgui.interfaces.DroppedPanel;
import net.miginfocom.swing.MigLayout;
import org.jdownloader.images.NewTheme;

public abstract class InfoPanel
extends DroppedPanel {
    private static final long serialVersionUID = 5465564955866972884L;
    protected EventListenerList listenerList = new EventListenerList();
    protected final Color valueColor;
    protected final Color titleColor;
    private final HashMap<String, JComponent> map = new HashMap();

    public InfoPanel(String iconKey) {
        this.valueColor = this.getBackground().darker().darker().darker().darker().darker();
        this.titleColor = this.getBackground().darker().darker();
        this.setLayout((LayoutManager)new MigLayout("ins 5", "[]5[]", "[][]"));
        this.add((Component)new JLabel(NewTheme.I().getIcon(iconKey, 32)), "spany 2,cell 0 0,gapleft 1");
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    public void broadcastEvent(ActionEvent e) {
        for (ActionListener listener : (ActionListener[])this.listenerList.getListeners(ActionListener.class)) {
            listener.actionPerformed(e);
        }
    }

    protected void updateInfo(String key, Object value) {
        JComponent c = this.map.get(key);
        if (c != null && c instanceof JLabel) {
            ((JLabel)c).setText(value.toString());
        }
    }

    protected void addInfoEntry(String title, String value, int x, int y) {
        JLabel myValue = new JLabel(value);
        myValue.setForeground(this.valueColor);
        this.addComponent(title, myValue, x, y);
    }

    protected void addComponent(JComponent myComponent, int x, int y) {
        x *= 2;
        myComponent.setForeground(this.valueColor);
        this.add((Component)myComponent, "gapleft 20,cell " + ++x + " " + y + ",spanx 2,growx");
        this.map.put(myComponent.getName(), myComponent);
    }

    protected void addComponent(String title, JComponent myComponent, int x, int y) {
        x *= 2;
        JLabel myTitle = new JLabel(title != null && title.length() > 0 ? title + ":" : "");
        myTitle.setForeground(this.titleColor);
        myComponent.setForeground(this.valueColor);
        this.add((Component)myTitle, "gapleft 20,alignx right,cell " + ++x + " " + y);
        this.add((Component)myComponent, "cell " + (x + 1) + " " + y);
        this.map.put(title, myComponent);
    }

    protected JComponent getComponent(String key) {
        return this.map.get(key);
    }

    @Override
    public void onHide() {
    }

    @Override
    public void onShow() {
    }
}

