/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.myjd;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jd.gui.swing.jdgui.interfaces.SwitchPanel;
import jd.gui.swing.jdgui.views.myjd.SidebarModel;
import jd.gui.swing.jdgui.views.myjd.TreeRenderer;
import jd.gui.swing.jdgui.views.settings.sidebar.CheckBoxedEntry;
import net.miginfocom.swing.MigLayout;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.ConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.api.myjdownloader.MyJDownloaderConnectionStatus;
import org.jdownloader.api.myjdownloader.MyJDownloaderController;
import org.jdownloader.api.myjdownloader.event.MyJDownloaderListener;
import org.jdownloader.extensions.ExtensionController;
import org.jdownloader.extensions.LazyExtension;
import org.jdownloader.extensions.StartException;
import org.jdownloader.extensions.StopException;
import org.jdownloader.translate._JDT;
import org.jdownloader.updatev2.gui.LAFOptions;

public class MyJDSidebar
extends JPanel
implements MouseMotionListener,
MouseListener,
ConfigEventListener,
MyJDownloaderListener {
    private static final long serialVersionUID = 6456662020047832983L;
    private JList list = new JList(){
        private static final long serialVersionUID = 1L;

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Point lmouse = MyJDSidebar.this.mouse;
            if (lmouse != null) {
                Graphics2D g2 = (Graphics2D)g;
                AlphaComposite ac5 = AlphaComposite.getInstance(3, 0.1f);
                g2.setComposite(ac5);
                int index = this.locationToIndex(lmouse);
                Point p = this.indexToLocation(index);
                if (p != null) {
                    g2.fillRect(0, p.y, this.getWidth(), TreeRenderer.DIMENSION.height);
                    g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
                }
            }
            MyJDSidebar.this.revalidate();
        }
    };
    private Point mouse;
    private SidebarModel treemodel = null;

    public MyJDSidebar(SidebarModel model) {
        super((LayoutManager)new MigLayout("ins 0", "[grow,fill]", "[grow,fill]"));
        this.list.addMouseMotionListener(this);
        this.list.addMouseListener(this);
        this.treemodel = model;
        this.list.setModel(this.treemodel);
        this.list.setCellRenderer(new TreeRenderer());
        this.list.setOpaque(false);
        this.list.setBackground(null);
        this.list.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int index = MyJDSidebar.this.list.locationToIndex(e.getPoint());
                try {
                    if (MyJDSidebar.this.list.getModel().getElementAt(index) instanceof CheckBoxedEntry) {
                        Point point = MyJDSidebar.this.list.indexToLocation(index);
                        int x = 0;
                        int y = 0;
                        if (point != null) {
                            x = e.getPoint().x - point.x;
                            y = e.getPoint().y - point.y;
                        }
                        if (x > 3 && x < 18 && y > 3 && y < 18) {
                            MyJDSidebar.this.list.setCursor(Cursor.getPredefinedCursor(12));
                            MyJDSidebar.this.list.setToolTipText(_JDT.T.settings_sidebar_tooltip_enable_extension());
                        } else {
                            MyJDSidebar.this.list.setCursor(Cursor.getPredefinedCursor(0));
                            if (MyJDSidebar.this.list.getModel().getElementAt(index) instanceof CheckBoxedEntry) {
                                MyJDSidebar.this.list.setToolTipText(((CheckBoxedEntry)MyJDSidebar.this.list.getModel().getElementAt(index)).getDescription());
                            } else {
                                MyJDSidebar.this.list.setToolTipText(null);
                            }
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        });
        this.setBackground(null);
        this.setOpaque(false);
        JScrollPane sp = new JScrollPane(this.list){

            @Override
            public Dimension getPreferredSize() {
                Dimension ret = super.getPreferredSize();
                ret.width = Math.max(TreeRenderer.DIMENSION.width, TreeRenderer.SMALL_DIMENSION.width) + this.getVerticalScrollBar().getPreferredSize().width;
                return ret;
            }

            @Override
            public Dimension getMinimumSize() {
                Dimension pref = this.getPreferredSize();
                if (pref.height == 0) {
                    return pref;
                }
                pref = new Dimension(pref);
                pref.height = 0;
                super.setMinimumSize(pref);
                return pref;
            }
        };
        this.add(sp);
        LAFOptions.getInstance();
        LAFOptions.applyBackground((Color)LAFOptions.getInstance().getColorForPanelBackground(), (JComponent)this.list);
        sp.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, LAFOptions.getInstance().getColorForPanelBorders()));
        sp.setHorizontalScrollBarPolicy(31);
        this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
            private String lastE;

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (this.lastE != null && this.lastE.equals(e.toString())) {
                    return;
                }
                this.lastE = e.toString();
            }
        });
        MyJDownloaderController.getInstance().getEventSender().addListener((EventListener)this, true);
    }

    public void addListener(ListSelectionListener x) {
        this.list.getSelectionModel().addListSelectionListener(x);
    }

    public <T> T getTreeEntry(Class<T> class1) {
        for (int i = 0; i < this.list.getModel().getSize(); ++i) {
            Object el = this.list.getModel().getElementAt(i);
            Class<?> cl = el.getClass();
            if (class1 != cl) continue;
            return (T)this.list.getModel().getElementAt(i);
        }
        return null;
    }

    public void setSelectedTreeEntry(Class<?> class1) {
        for (int i = 0; i < this.list.getModel().getSize(); ++i) {
            Object el = this.list.getModel().getElementAt(i);
            Class<?> cl = el.getClass();
            if (class1 != cl) continue;
            this.list.setSelectedIndex(i);
            return;
        }
        this.list.setSelectedIndex(0);
    }

    public boolean treeInitiated() {
        return this.treemodel.getSize() > 0;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouse = e.getPoint();
        this.list.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouse = e.getPoint();
        this.list.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int index = this.list.locationToIndex(e.getPoint());
        if (this.list.getModel().getElementAt(index) instanceof CheckBoxedEntry) {
            Point point = this.list.indexToLocation(index);
            int x = e.getPoint().x - point.x;
            int y = e.getPoint().y - point.y;
            if (x > 3 && x < 18 && y > 3 && y < 18) {
                boolean value;
                CheckBoxedEntry object = (CheckBoxedEntry)this.list.getModel().getElementAt(index);
                boolean bl = value = !((CheckBoxedEntry)this.list.getModel().getElementAt(index))._isEnabled();
                if (value == object._isEnabled()) {
                    return;
                }
                if (object instanceof LazyExtension) {
                    ExtensionController.getInstance().setEnabled((LazyExtension)object, value);
                } else {
                    try {
                        object._setEnabled(value);
                    }
                    catch (StartException e1) {
                        e1.printStackTrace();
                    }
                    catch (StopException e1) {
                        e1.printStackTrace();
                    }
                }
                this.list.repaint();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouse = null;
        this.list.repaint();
    }

    public synchronized SwitchPanel getSelectedPanel() {
        Object selectedValue = this.list.getSelectedValue();
        if (selectedValue instanceof SwitchPanel) {
            return (SwitchPanel)selectedValue;
        }
        return null;
    }

    public void onConfigValueModified(KeyHandler<Object> keyHandler, Object newValue) {
        new EDTRunner(){

            protected void runInEDT() {
                MyJDSidebar.this.repaint();
            }
        };
    }

    public void onConfigValidatorError(KeyHandler<Object> keyHandler, Object invalidValue, ValidationException validateException) {
    }

    public void onMyJDownloaderConnectionStatusChanged(MyJDownloaderConnectionStatus status, int connections) {
        new EDTRunner(){

            protected void runInEDT() {
                MyJDSidebar.this.repaint();
            }
        };
    }
}

