/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.settings.components;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import jd.gui.swing.jdgui.views.settings.components.SettingsComponent;
import jd.gui.swing.jdgui.views.settings.components.StateUpdateEvent;
import jd.gui.swing.jdgui.views.settings.components.StateUpdateEventSender;
import jd.gui.swing.jdgui.views.settings.components.StateUpdateListener;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.annotations.EnumLabel;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.event.DefaultEvent;

public class ComboBox<ContentType>
extends JComboBox
implements SettingsComponent,
GenericConfigEventListener<ContentType> {
    private static final long serialVersionUID = -1580999899097054630L;
    private ListCellRenderer orgRenderer;
    private String[] translations;
    private StateUpdateEventSender<ComboBox<ContentType>> eventSender = new StateUpdateEventSender();
    private boolean setting;
    private KeyHandler<ContentType> keyHandler;

    public ComboBox(ContentType ... options) {
        super(options);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ComboBox.this.setting) {
                    ComboBox.this.eventSender.fireEvent((DefaultEvent)new StateUpdateEvent<ComboBox>(ComboBox.this));
                    if (ComboBox.this.keyHandler != null) {
                        ComboBox.this.keyHandler.setValue(ComboBox.this.getSelectedItem());
                    }
                }
            }
        });
        this.orgRenderer = this.getRenderer();
        this.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (index == -1) {
                    index = ComboBox.this.getSelectedIndex();
                }
                if (index == -1) {
                    return ComboBox.this.orgRenderer.getListCellRendererComponent(list, null, index, isSelected, cellHasFocus);
                }
                Component ret = ComboBox.this.orgRenderer.getListCellRendererComponent(list, ComboBox.this.getLabel(index, value), index, isSelected, cellHasFocus);
                ComboBox.this.renderComponent(ret, list, value, index, isSelected, cellHasFocus);
                return ret;
            }
        });
    }

    public ContentType getValue() {
        return this.getSelectedItem();
    }

    public void setValue(ContentType selected) {
        this.setting = true;
        try {
            this.setSelectedItem(selected);
        }
        finally {
            this.setting = false;
        }
    }

    public ContentType getSelectedItem() {
        return (ContentType)super.getSelectedItem();
    }

    public ComboBox(ContentType[] values, String[] names) {
        this(values);
        this.translations = names;
    }

    protected String getLabel(int index, ContentType value) {
        if (this.translations == null) {
            if (value instanceof Enum) {
                try {
                    EnumLabel ann;
                    Field field = value.getClass().getField(value.toString());
                    if (field != null && (ann = field.getAnnotation(EnumLabel.class)) != null) {
                        return ann.value();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (value instanceof LabelInterface) {
                return ((LabelInterface)value).getLabel();
            }
            return value + "";
        }
        return this.translations[index];
    }

    protected void renderComponent(Component component, JList list, ContentType value, int index, boolean isSelected, boolean cellHasFocus) {
    }

    public ComboBox(KeyHandler<ContentType> keyHandler, ContentType[] values, String[] strings) {
        this(values, strings);
        this.keyHandler = keyHandler;
        keyHandler.getEventSender().addListener(this, true);
        this.setSelectedItem(keyHandler.getValue());
    }

    public KeyHandler<ContentType> getKeyHandler() {
        return this.keyHandler;
    }

    @Override
    public String getConstraints() {
        return "sgy LINE";
    }

    @Override
    public boolean isMultiline() {
        return false;
    }

    public void addStateUpdateListener(StateUpdateListener listener) {
        this.eventSender.addListener(listener);
    }

    public void onConfigValidatorError(KeyHandler<ContentType> keyHandler, ContentType invalidValue, ValidationException validateException) {
    }

    public void onConfigValueModified(KeyHandler<ContentType> keyHandler, ContentType newValue) {
        this.setSelectedItem(keyHandler.getValue());
    }

    public void setModel(ContentType[] array) {
        super.setModel(new DefaultComboBoxModel<ContentType>(array));
    }
}

