/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.settings.components;

import java.util.EventListener;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jd.gui.swing.jdgui.views.settings.components.SettingsComponent;
import jd.gui.swing.jdgui.views.settings.components.StateUpdateEvent;
import jd.gui.swing.jdgui.views.settings.components.StateUpdateEventSender;
import jd.gui.swing.jdgui.views.settings.components.StateUpdateListener;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.storage.config.handler.StringKeyHandler;
import org.appwork.swing.components.ExtTextField;
import org.appwork.utils.event.DefaultEvent;

public class TextInput
extends ExtTextField
implements SettingsComponent,
GenericConfigEventListener<String> {
    private static final long serialVersionUID = 1L;
    protected final StateUpdateEventSender<TextInput> eventSender;
    protected final AtomicBoolean settings = new AtomicBoolean(false);
    protected final StringKeyHandler keyHandler;

    public void setText(String t) {
        if (!this.settings.compareAndSet(false, true)) {
            return;
        }
        try {
            super.setText(t);
        }
        finally {
            this.settings.set(false);
        }
    }

    public TextInput() {
        this(null);
    }

    public void onChanged() {
        super.onChanged();
        if (!this.settings.compareAndSet(false, true)) {
            return;
        }
        try {
            this.setKeyHandlerValue(this.getText());
        }
        finally {
            this.settings.set(false);
        }
    }

    public TextInput(StringKeyHandler keyhandler) {
        this.eventSender = new StateUpdateEventSender();
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!TextInput.this.settings.get()) {
                    TextInput.this.eventSender.fireEvent((DefaultEvent)new StateUpdateEvent<TextInput>(TextInput.this));
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!TextInput.this.settings.get()) {
                    TextInput.this.eventSender.fireEvent((DefaultEvent)new StateUpdateEvent<TextInput>(TextInput.this));
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!TextInput.this.settings.get()) {
                    TextInput.this.eventSender.fireEvent((DefaultEvent)new StateUpdateEvent<TextInput>(TextInput.this));
                }
            }
        });
        this.keyHandler = keyhandler;
        if (keyhandler != null) {
            this.setText(keyhandler.getValue());
            keyhandler.getEventSender().addListener((EventListener)((Object)this), true);
        }
    }

    protected void setKeyHandlerValue(String text) {
        StringKeyHandler keyHandler = this.getKeyhandler();
        if (keyHandler != null) {
            keyHandler.setValue((Object)this.getText());
        }
    }

    protected String getKeyHandlerValue() {
        StringKeyHandler keyHandler = this.getKeyhandler();
        if (keyHandler == null) {
            return null;
        }
        return keyHandler.getValue();
    }

    public StringKeyHandler getKeyhandler() {
        return this.keyHandler;
    }

    @Override
    public String getConstraints() {
        return "sgy LINE";
    }

    @Override
    public boolean isMultiline() {
        return false;
    }

    public void addStateUpdateListener(StateUpdateListener listener) {
        this.eventSender.addListener(listener);
    }

    public void onConfigValidatorError(KeyHandler<String> keyHandler, String invalidValue, ValidationException validateException) {
    }

    public void onConfigValueModified(KeyHandler<String> keyHandler, String newValue) {
        if (!this.settings.get()) {
            this.setText(this.getKeyHandlerValue());
        }
    }
}

