/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.settings.panels.advanced;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import org.appwork.storage.JSonStorage;
import org.appwork.swing.components.tooltips.ExtTooltip;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.components.MergedIcon;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.NewTheme;
import org.jdownloader.settings.advanced.AdvancedConfigEntry;

public class EditColumn
extends ExtTextColumn<AdvancedConfigEntry> {
    private static final long serialVersionUID = 1L;
    public static final int SIZE = 16;
    private InfoAction editorInfo;
    private InfoAction rendererInfo;
    private MergedIcon iconDD = new MergedIcon(new Icon[]{NewTheme.I().getDisabledIcon((Icon)new AbstractIcon("help", 16)), NewTheme.I().getDisabledIcon((Icon)new AbstractIcon("reset", 16))});
    private MergedIcon iconED = new MergedIcon(new Icon[]{new AbstractIcon("help", 16), NewTheme.I().getDisabledIcon((Icon)new AbstractIcon("reset", 16))});
    private MergedIcon iconDE = new MergedIcon(new Icon[]{NewTheme.I().getDisabledIcon((Icon)new AbstractIcon("help", 16)), new AbstractIcon("reset", 16)});
    private MergedIcon iconEE = new MergedIcon(new Icon[]{new AbstractIcon("help", 16), new AbstractIcon("reset", 16)});
    private InfoAction info = new InfoAction();
    private ResetAction reset = new ResetAction(this);

    public EditColumn() {
        super("Actions");
        this.setRowSorter((ExtDefaultRowSorter)new ExtDefaultRowSorter<AdvancedConfigEntry>(){

            public int compare(AdvancedConfigEntry o1, AdvancedConfigEntry o2) {
                int h2;
                Icon ic1 = EditColumn.this.getIcon(o1);
                Icon ic2 = EditColumn.this.getIcon(o2);
                int h1 = ic1 == null ? 0 : this.getIconID(ic1);
                int n = h2 = ic2 == null ? 0 : this.getIconID(ic2);
                if (h1 == h2) {
                    return 0;
                }
                if (this.getSortOrderIdentifier() == "ASC") {
                    return h1 > h2 ? -1 : 1;
                }
                return h2 > h1 ? -1 : 1;
            }

            private int getIconID(Icon ic) {
                if (ic == EditColumn.this.iconDE) {
                    return 1;
                }
                if (ic == EditColumn.this.iconEE) {
                    return 2;
                }
                if (ic == EditColumn.this.iconED) {
                    return 3;
                }
                if (ic == EditColumn.this.iconDD) {
                    return 4;
                }
                return 0;
            }
        });
    }

    public JPopupMenu createHeaderPopup() {
        JPopupMenu ret = new JPopupMenu();
        final JCheckBoxMenuItem cb = new JCheckBoxMenuItem(_GUI.T.AdvancedTableModel_initColumns_modifiedonly_checkboxaction_());
        cb.setSelected(this.isResetOnlyFilterEnabled());
        cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditColumn.this.setResetOnlyFilterEnabled(cb.isSelected());
            }
        });
        ret.add(cb);
        return ret;
    }

    public int getMaxWidth() {
        return this.getMinWidth();
    }

    public boolean isSortable(AdvancedConfigEntry obj) {
        return true;
    }

    public int getMinWidth() {
        return 45;
    }

    public ExtTooltip createToolTip(Point p, AdvancedConfigEntry obj) {
        if (p.x - this.getBounds().x < this.getWidth() / 2) {
            this.tooltip.setTipText("Click to Open an infopanel");
        } else {
            this.tooltip.setTipText("Click to reset to " + obj.getDefault());
            System.out.println("RIGHT");
        }
        return this.tooltip;
    }

    protected boolean isResetOnlyFilterEnabled() {
        return false;
    }

    protected void setResetOnlyFilterEnabled(boolean enabled) {
    }

    public boolean onSingleClick(MouseEvent e, AdvancedConfigEntry obj) {
        if (e.getPoint().x - this.getBounds().x < this.getWidth() / 2) {
            InfoAction info = new InfoAction();
            info.setEntry(obj);
            info.actionPerformed(null);
        } else {
            ResetAction reset = new ResetAction(this);
            reset.setEntry(obj);
            reset.actionPerformed(null);
        }
        return super.onSingleClick(e, (Object)obj);
    }

    protected String getTooltipText(AdvancedConfigEntry obj) {
        return null;
    }

    public String getStringValue(AdvancedConfigEntry value) {
        return null;
    }

    protected Icon getIcon(AdvancedConfigEntry value) {
        this.info.setEntry(value);
        this.reset.setEntry(value);
        boolean resetable = this.reset.isEnabled();
        boolean info = this.info.isEnabled();
        if (resetable && info) {
            return this.iconEE;
        }
        if (!resetable && info) {
            return this.iconED;
        }
        if (!resetable && !info) {
            return this.iconDD;
        }
        return this.iconDE;
    }

    public static class ResetAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private AdvancedConfigEntry value;
        private final Icon reset_no = NewTheme.I().getIcon("reset", 16);
        private final Icon reset_yes = NewTheme.I().getDisabledIcon(this.reset_no);
        private boolean resetable = false;
        private final EditColumn editColumn;

        public ResetAction(EditColumn editcolumn) {
            super("Reset to Default");
            this.setEnabledIntern(true);
            this.editColumn = editcolumn;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.resetable) {
                return;
            }
            if (this.editColumn != null) {
                this.editColumn.stopCellEditing();
            }
            new EDTHelper<Void>(){

                public Void edtRun() {
                    try {
                        Object defaultValue = ResetAction.this.value.getDefault();
                        Dialog.getInstance().showConfirmDialog(0, "Reset to default?", "Really reset " + ResetAction.this.value.getKey() + " to " + defaultValue);
                        ResetAction.this.value.setValue(defaultValue);
                        if (ResetAction.this.editColumn != null) {
                            ResetAction.this.editColumn.getModel().getTable().repaint();
                        }
                    }
                    catch (DialogClosedException e1) {
                        e1.printStackTrace();
                    }
                    catch (DialogCanceledException e1) {
                        e1.printStackTrace();
                    }
                    return null;
                }
            }.start(true);
        }

        public void setEntry(AdvancedConfigEntry value) {
            Object currentValue = value.getValue();
            if (currentValue == null) {
                this.setEnabledIntern(value.hasDefaultValue());
            } else {
                Object defaultValue = value.getDefault();
                boolean isDefault = AdvancedConfigEntry.equals((Object)currentValue, (Object)defaultValue);
                this.setEnabledIntern(!isDefault);
            }
            this.value = value;
        }

        public void setEnabledIntern(boolean b) {
            if (b) {
                this.putValue("SmallIcon", this.reset_no);
            } else {
                this.putValue("SmallIcon", this.reset_yes);
            }
            this.resetable = b;
            super.setEnabled(b);
        }
    }

    static class InfoAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private AdvancedConfigEntry value;
        private Icon iconEnabled = new AbstractIcon("help", 16);
        private Icon iconDisabled = NewTheme.I().getDisabledIcon((Icon)new AbstractIcon("help", 16));

        public InfoAction() {
            super("Help", (Icon)new AbstractIcon("help", 16));
        }

        @Override
        public boolean isEnabled() {
            if (this.value == null) {
                return false;
            }
            if (this.value.hasDescription()) {
                return true;
            }
            if (this.value.hasValidator()) {
                return true;
            }
            return this.value.hasDefaultValue();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object defaultValue;
            if (!this.isEnabled()) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            if (this.value.getDescription() != null) {
                sb.append(this.value.getDescription());
            }
            if ((defaultValue = this.value.getDefault()) != null) {
                if (sb.length() > 0) {
                    sb.append("\r\n");
                }
                sb.append("Defaultvalue: " + JSonStorage.toString((Object)defaultValue));
            }
            if (this.value.getValidator() != null) {
                if (sb.length() > 0) {
                    sb.append("\r\n\r\n");
                }
                sb.append(this.value.getValidator());
            }
            Dialog.getInstance().showMessageDialog(64, this.value.getKey(), sb.toString());
        }

        public void setEntry(AdvancedConfigEntry value) {
            this.value = value;
            if (this.isEnabled()) {
                this.putValue("SmallIcon", this.iconEnabled);
            } else {
                this.putValue("SmallIcon", this.iconDisabled);
            }
        }
    }
}

